/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service.operation;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.operation.AddAppFileOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.AppFileFlowLockOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.ArchiveOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.ArrangeIntvOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.BackgroundSurveyOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.ChangeStageStatusOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.DownloadOrPrintOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.EliminateOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.ExamOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.ExaminationOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.HireOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.RecommendFilterOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.RecoverOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.SendMsgOperate;
import kd.tsc.tsirm.business.domain.appfile.operation.TransferPositionOperate;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileOperateService {
    private static AppFileOperateService singleInstance = new AppFileOperateService();
    private final List<AppFileOperate> beforeItemClickOperateList = Lists.newArrayList();
    private final List<AppFileOperate> itemClickOperateList = Lists.newArrayList();
    private final List<AppFileOperate> beforeOperateList = Lists.newArrayList();
    private final List<AppFileOperate> afterOperateList = Lists.newArrayList();
    private final List<AppFileOperate> closeCallBackOperateList = Lists.newArrayList();

    private AppFileOperateService() {
    }

    public static AppFileOperateService getInstance() {
        return singleInstance;
    }

    public void handleBeforeItemClick(AbstractFormPlugin plugin, BeforeItemClickEvent evt) {
        for (AppFileOperate appFileOperate : this.beforeItemClickOperateList) {
            if (!appFileOperate.supportBeforeItemClick(evt)) continue;
            appFileOperate.handleBeforeItemClick(plugin, evt);
            break;
        }
        String operationKey = evt.getOperationKey();
        if (AppFileOperateEnum.PRINTFILE.getOpKey().equals(operationKey)) {
            return;
        }
        if (AppFileOperateEnum.UNLOCK.getOpKey().equals(operationKey) || AppFileOperateEnum.UNLOCK.getOpRightKey().equals(operationKey)) {
            operationKey = AppFileOperateEnum.LOCK.getOpKey();
        }
        for (AppFileOperateEnum value : AppFileOperateEnum.values()) {
            if (!operationKey.equals(value.getOpKey()) && !operationKey.equals(value.getOpRightKey())) continue;
            DynamicObject dataEntity = plugin.getView().getModel().getDataEntity();
            long procId = dataEntity.getLong("recruproc.id");
            long stgId = dataEntity.getLong("recrustg.id");
            Pair operationVisibleTuple = Pair.of((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
            AppFileListHelper.handleOperateVisible(procId, stgId, (Pair<Collection<String>, Collection<String>>)operationVisibleTuple);
            if (!((Collection)operationVisibleTuple.getLeft()).stream().noneMatch(ctrlKey -> value.getCtrlKey().equals(ctrlKey))) break;
            plugin.getView().showTipNotification(AppFileResManagerHelper.getDataChangedTip());
            evt.setCancel(true);
            break;
        }
    }

    public void handleItemClick(AbstractFormPlugin plugin, ItemClickEvent itemClickEvent) {
        for (AppFileOperate appFileOperate : this.itemClickOperateList) {
            if (!appFileOperate.supportItemClick(itemClickEvent)) continue;
            appFileOperate.handleItemClick(plugin, itemClickEvent);
            break;
        }
    }

    public void handleOperateBefore(AbstractFormPlugin plugin, BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        for (AppFileOperate appFileOperate : this.beforeOperateList) {
            if (!appFileOperate.supportBefore(beforeDoOperationEventArgs)) continue;
            appFileOperate.handleBefore(plugin, beforeDoOperationEventArgs);
            break;
        }
    }

    public void handleOperateAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        for (AppFileOperate appFileOperate : this.afterOperateList) {
            if (!appFileOperate.supportAfter(afterDoOperationEventArgs)) continue;
            appFileOperate.handleAfter(plugin, afterDoOperationEventArgs);
        }
    }

    public void handleOperateCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        for (AppFileOperate appFileOperate : this.closeCallBackOperateList) {
            if (!appFileOperate.supportCloseCallBack(closeCallBack)) continue;
            appFileOperate.handleCloseCallBack(plugin, closeCallBack);
        }
    }

    static {
        AppFileOperateService.singleInstance.beforeItemClickOperateList.add(new RecoverOperate());
        AppFileOperateService.singleInstance.beforeItemClickOperateList.add(new AppFileFlowLockOperate());
        AppFileOperateService.singleInstance.beforeItemClickOperateList.add(new ArchiveOperate());
        AppFileOperateService.singleInstance.beforeOperateList.add(new RecommendFilterOperate());
        AppFileOperateService.singleInstance.beforeOperateList.add(new ArrangeIntvOperate());
        AppFileOperateService.singleInstance.beforeOperateList.add(new SendMsgOperate());
        AppFileOperateService.singleInstance.beforeOperateList.add(new HireOperate());
        AppFileOperateService.singleInstance.beforeOperateList.add(new ExamOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new EliminateOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new TransferPositionOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new ChangeStageStatusOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new RecoverOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new RecommendFilterOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new ArrangeIntvOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new SendMsgOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new AddAppFileOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new HireOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new ExamOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new ExaminationOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new BackgroundSurveyOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new AppFileFlowLockOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new DownloadOrPrintOperate());
        AppFileOperateService.singleInstance.afterOperateList.add(new ArchiveOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new EliminateOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new ChangeStageStatusOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new ExamOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new ExaminationOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new BackgroundSurveyOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new ArrangeIntvOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new RecommendFilterOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new HireOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new TransferPositionOperate());
        AppFileOperateService.singleInstance.closeCallBackOperateList.add(new SendMsgOperate());
    }
}

