/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.cert;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.tsc.tsirm.business.application.external.ExtHRPIEmployeeService;
import kd.tsc.tsirm.business.domain.pc.helper.PersonInfoHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsrbd.business.domain.common.service.HRUserService;
import org.apache.commons.lang3.ObjectUtils;

public class CertService {
    private static final Log logger = LogFactory.getLog(CertService.class);
    private static final CertService certService = new CertService();

    public static CertService getInstance() {
        return certService;
    }

    public String getVerifyCertResult(Long userId) {
        Long personId = PersonInfoHelper.getPersonId(userId);
        Map<String, Object> verifyCertMap = TSIRMCertCommonHelper.verifyCertByPid("2+TXFE9NU13A", "tsirm_stdrsm", HRUserService.getPersonPid((List)ImmutableList.of((Object)personId)));
        logger.info("CertService.getVerifyCertResult.verifyCertMap->{}", verifyCertMap);
        String state = (String)verifyCertMap.get("STATE");
        return state;
    }

    public String getCertTips() {
        String tips = "";
        DynamicObject[] operateEmployeeDys = HRBaseServiceHelper.create((String)"tsirm_operateemployee").loadDynamicObjectArray(null);
        if (ObjectUtils.isNotEmpty((Object)operateEmployeeDys)) {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < operateEmployeeDys.length && index != 3; ++index) {
                DynamicObject operateEmployeeDy = operateEmployeeDys[index];
                String name = operateEmployeeDy.getString("employee.person.name");
                String number = operateEmployeeDy.getString("employee.person.number");
                sb.append(name).append(number);
                if (index == 2 || index == operateEmployeeDys.length - 1) continue;
                sb.append("\u3001");
            }
            tips = sb.toString();
        }
        return tips;
    }

    public boolean verifyCertByPid(Long stdRsmId, IFormView formView) {
        boolean result = true;
        Long empId = StandardResumeDataHelper.queryOne(stdRsmId).getLong("empid");
        Map<String, Object> employee = ExtHRPIEmployeeService.getEmployee(empId);
        if (null == employee) {
            employee = new HashMap<String, Object>();
        }
        Long personId = employee.get("person_id") instanceof Long ? (Long)employee.get("person_id") : Long.parseLong(employee.get("person_id").toString());
        Map<String, Object> verifyCertMap = TSIRMCertCommonHelper.verifyCertByPersonId("2+TXFE9NU13A", "tsirm_stdrsm", (List<Long>)ImmutableList.of((Object)personId));
        logger.info("CertService.getVerifyCertResult.verifyCertByPid->{}", verifyCertMap);
        String state = (String)verifyCertMap.get("STATE");
        Map data = (Map)verifyCertMap.get("DATA");
        String infoType = (String)data.get("infoType");
        if (HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(infoType)) {
            result = false;
            formView.showErrorNotification(ResManager.loadKDString((String)"\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"CandidateDetailPagePlugin_18", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else if ("FAIL".equals(state)) {
            result = false;
            String name = StandardResumeDataHelper.queryOne(stdRsmId).getString("fullname");
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"CandidateDetailPagePlugin_19", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), name));
        }
        return result;
    }
}

