/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.exam.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileDomainService;
import kd.tsc.tsirm.common.enums.exam.ExamTypeEnum;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class ExamDomainService {
    public static void saveSync(DynamicObject[] dataEntities, ExamTypeEnum examTypeEnum) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject appFile = dataEntity.getDynamicObject("appfile");
            if (appFile == null) continue;
            Long appFileId = appFile.getLong("id");
            appFileIds.add(appFileId);
        }
        ExamDomainService.saveSync(appFileIds, examTypeEnum);
    }

    public static void saveSync(List<Long> appFileIds, ExamTypeEnum examTypeEnum) {
        if (examTypeEnum == ExamTypeEnum.DIC_EXAMTYPE_WRITTEN) {
            Map<Long, DynamicObject> dynamicExamMap = ExamDomainService.getLatestDynamicExam(appFileIds, ExamTypeEnum.DIC_EXAMTYPE_WRITTEN.getCode());
            AppFileDomainService.updateAppFileExamWritten(dynamicExamMap);
        }
    }

    public static void deleteSync(DynamicObject[] dataEntities, ExamTypeEnum examTypeEnum) {
        ArrayList examIds = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long examId = dataEntity.getLong("id");
            examIds.add(examId);
        }
        ExamDomainService.deleteSync(examIds, examTypeEnum);
    }

    public static void deleteSync(List<Long> examIds, ExamTypeEnum examTypeEnum) {
        List<Long> appFileIdList = ExamDomainService.getAppFileIdsByExamIds(examIds);
        ExamDomainService.saveSync(appFileIdList, examTypeEnum);
    }

    public static Map<Long, DynamicObject> getLatestDynamicExam(List<Long> appFileIds, String examCode) {
        if (appFileIds != null) {
            HashMap appFileIdAndExamDynamic = Maps.newHashMapWithExpectedSize((int)appFileIds.size());
            DynamicObject[] examDynamicDB = ExamDomainService.getLatestExamDynamicByAppFileIds(appFileIds, examCode);
            if (examDynamicDB != null) {
                for (DynamicObject examDynamic : examDynamicDB) {
                    if (examDynamic == null) continue;
                    Long appFileId = examDynamic.getLong("appfile.id");
                    if (examDynamic != null) {
                        appFileIdAndExamDynamic.put(appFileId, examDynamic);
                    }
                    appFileIds.remove(appFileId);
                }
            }
            if (appFileIds != null) {
                for (Long appFileid : appFileIds) {
                    appFileIdAndExamDynamic.put(appFileid, null);
                }
            }
            return appFileIdAndExamDynamic;
        }
        return null;
    }

    public static DynamicObject[] getLatestExamDynamicByAppFileIds(List<Long> appFileIds, String examCode) {
        QFilter qFilter = new QFilter("examtype", "=", (Object)examCode);
        if (appFileIds == null) {
            return null;
        }
        HashSet selectColumn = Sets.newHashSetWithExpectedSize((int)5);
        selectColumn.add("id");
        selectColumn.add("examtime");
        selectColumn.add("name");
        selectColumn.add("score");
        selectColumn.add("result");
        selectColumn.add("appfile");
        String queryColumn = String.join((CharSequence)",", selectColumn);
        String orderBy = "appfile DESC,examtime DESC,createtime DESC";
        QFilter appFileFilter = new QFilter("appfile", "in", appFileIds);
        appFileFilter.and(new QFilter("isdeleted", "=", (Object)Boolean.FALSE));
        appFileFilter.and(qFilter);
        HRBaseServiceHelper dbServiceExam = new HRBaseServiceHelper("tsirm_examwritten");
        DynamicObject[] examDynamic = dbServiceExam.query(queryColumn, appFileFilter.toArray(), orderBy);
        Long lastAppFileId = 0L;
        if (examDynamic != null) {
            for (int i = 0; i < examDynamic.length; ++i) {
                Long currentAppFileId = examDynamic[i].getLong("appfile.id");
                if (currentAppFileId.equals(lastAppFileId)) {
                    examDynamic[i] = null;
                }
                lastAppFileId = currentAppFileId;
            }
        }
        return examDynamic;
    }

    public static List<Long> getAppFileIdsByExamIds(List<Long> examIdList) {
        ArrayList appFileIdList = null;
        if (examIdList != null) {
            appFileIdList = Lists.newArrayListWithCapacity((int)examIdList.size());
            HashSet selectColumn = Sets.newHashSetWithExpectedSize((int)5);
            selectColumn.add("id");
            selectColumn.add("appfile");
            String queryColumn = String.join((CharSequence)",", selectColumn);
            QFilter examQFilter = new QFilter("id", "in", examIdList);
            HRBaseServiceHelper dbServiceExam = new HRBaseServiceHelper("tsirm_examwritten");
            DynamicObject[] examListDynamic = dbServiceExam.query(queryColumn, examQFilter.toArray());
            if (examListDynamic != null) {
                for (int i = 0; i < examListDynamic.length; ++i) {
                    DynamicObject exam = examListDynamic[i].getDynamicObject("appfile");
                    appFileIdList.add(exam.getLong("id"));
                }
            }
        }
        return appFileIdList;
    }

    public static boolean existExaminationDataByAppFileId(Long appFileId) {
        return ExamDomainService.existDataByAppFileId(appFileId, ExamTypeEnum.DIC_EXAMTYPE_EXAMINATION);
    }

    public static boolean existWrittenDataByAppFileId(Long appFileId) {
        return ExamDomainService.existDataByAppFileId(appFileId, ExamTypeEnum.DIC_EXAMTYPE_WRITTEN);
    }

    public static boolean existDataByAppFileId(Long appFileId, ExamTypeEnum examTypeEnum) {
        QFilter appFileFilter = new QFilter("appfile", "=", (Object)appFileId);
        QFilter examTypeFilter = new QFilter("examtype", "=", (Object)examTypeEnum.getCode());
        QFilter deleteFilter = new QFilter("isdeleted", "=", (Object)Boolean.FALSE);
        DynamicObject dynamicObject = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_examwritten").queryOne("id", new QFilter[]{appFileFilter, examTypeFilter, deleteFilter});
        return dynamicObject != null;
    }
}

