/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.genedatautil;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.tsc.tsirm.business.domain.genedatautil.GenerateCandidateJob;
import kd.tsc.tsirm.business.domain.genedatautil.GenerateDataJob;

public class DataGenerateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DataGenerateTask.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"TscDataGenerateTask");

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String accountId = RequestContext.getOrCreate().getAccountId();
        ArrayList accountIdList = Lists.newArrayList((Object[])new String[]{"1743620526296796160", "1743651961875466240", "1744258971658618880", "1744868091503839232", "1757181178021939200", "1775519997548824576", "1793627883093100544", "1905741561468029952"});
        if (!accountIdList.contains(accountId)) {
            logger.info("accountId:{} cannot generate data", (Object)accountId);
            return;
        }
        int number = Integer.parseInt(map.get("number").toString());
        int jobCount = Integer.parseInt(map.get("jobCount").toString());
        String entityKey = map.get("entityKey").toString();
        String positionStr = map.get("positionStr").toString();
        int batchSize = number / jobCount;
        if ("tsirm_position".equals(entityKey)) {
            this.generatePositionData(number, jobCount);
        } else if ("tsirm_appfile_viewm".equals(entityKey)) {
            this.generateCandidateData(number, jobCount, positionStr);
        }
    }

    private void generateCandidateData(int number, int jobCount, String positionIdStr) {
        String[] split = positionIdStr.split(",");
        int batchSize = number / jobCount;
        int length = split.length;
        for (int i = 0; i < jobCount; ++i) {
            try {
                int j = i % length;
                GenerateCandidateJob job = new GenerateCandidateJob(batchSize, split[j]);
                THREAD_POOL.execute((Runnable)job);
            }
            catch (Exception exception) {
                logger.error((Throwable)exception);
            }
            logger.info("i:{}", (Object)i);
        }
    }

    public void generatePositionData(int number, int jobCount) {
        int batchSize = number / jobCount;
        for (int i = 0; i < jobCount; ++i) {
            GenerateDataJob job = new GenerateDataJob(i * batchSize, (i + 1) * batchSize);
            THREAD_POOL.execute((Runnable)job);
        }
    }
}

