/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.genedatautil;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.tsc.common.vo.KResumeBO;
import kd.tsc.tsirm.business.domain.operationmanage.CreateOperationManageService;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.PositionMService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tsirm.business.domain.stdrsm.util.ResumeUtil;
import kd.tsc.tsirm.common.enums.RsmTypeEnum;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;

public class GenerateCandidateJob
implements Runnable {
    private static final Log logger = LogFactory.getLog(GenerateCandidateJob.class);
    private static HRBaseServiceHelper EMPCVREL_SERVICEHELPER = new HRBaseServiceHelper("tsirm_empcvrel");
    private static HRBaseServiceHelper EMPCV_SERVICEHELPER = new HRBaseServiceHelper("tsirm_empcv");
    private int number;
    private String positionIdStr;
    private static Date birthDay = ResumeUtil.getSpecifyDate(1996, 11, 11);
    private static Date startDate = ResumeUtil.getSpecifyDate(2010, 1, 1);
    private static Date endDate = ResumeUtil.getSpecifyDate(2011, 2, 1);
    private long currentTimeMillis;
    private HRBaseServiceHelper rsmHelper = new HRBaseServiceHelper("tsirm_srrsm");
    private HRBaseServiceHelper rsmEduHelper = new HRBaseServiceHelper("tsirm_srrsmeduexp");
    private HRBaseServiceHelper rsmPosOrgRelHelper = new HRBaseServiceHelper("tsirm_srrsmposorgrel");
    private static DynamicObject posTypeDy = HRBaseServiceHelper.create((String)"hbss_postype").loadSingle((Object)1010L);
    private List<Long> employeeIds;

    public GenerateCandidateJob(int number, String positionIdStr) {
        this.number = number;
        this.positionIdStr = positionIdStr;
    }

    public GenerateCandidateJob(int number, String positionIdStr, List<Long> employeeIds) {
        this.number = number;
        this.positionIdStr = positionIdStr;
        this.employeeIds = employeeIds;
    }

    @Override
    public void run() {
        logger.info("GenerateCandidateJob start run ");
        long positionId = Long.parseLong(this.positionIdStr);
        DynamicObject positionDy = PositionMService.queryOneByPositionId(positionId);
        Map<Long, Long> employeeIdAndAccountId = !this.employeeIds.isEmpty() ? this.getEmployeeIdAndAccountId(this.employeeIds) : this.getEmployeeIdAndAccountId();
        logger.info("GenerateCandidateJob user mapping employee   {0}", employeeIdAndAccountId);
        this.currentTimeMillis = System.currentTimeMillis();
        for (int i = 0; i < this.number; ++i) {
            try {
                int finalI = i;
                employeeIdAndAccountId.forEach((userId, employeeId) -> {
                    CreateOperationManageService.Singleton.INSTANCE.getInstance().addOperationManage((Long)employeeId);
                    DynamicObject relDy = this.assambleAccountRel((Long)userId, (Long)employeeId);
                    KResumeBO KResumeBO2 = this.assambleEmpCVBO(relDy);
                    this.syncEmpCV2Rel(relDy, KResumeBO2);
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_employee");
                    DynamicObject dynamicObject = serviceHelper.queryOne("empnumber", new QFilter[]{new QFilter("id", "=", employeeId)});
                    KResumeBO2.getData().set("employeenum", (Object)dynamicObject.getString("empnumber"));
                    this.saveAccountRel(relDy);
                    this.saveEmpCv(KResumeBO2);
                    AppResumeBo appResumeBo = this.getAppResumeBo(finalI);
                    appResumeBo.setEmpId(Long.valueOf(relDy.getLong("empid")));
                    SaveCandidateResult handle = AddResumeHandleService.getInstance().handle(appResumeBo, positionDy, false, ResumeTypeEnum.FROM);
                    logger.info("GenerateCandidateJob handle result : {0}", (Object)(handle == null ? null : SerializationUtils.toJsonString((Object)handle)));
                });
                continue;
            }
            catch (Exception exception) {
                logger.error((Throwable)exception);
            }
        }
        logger.info("number:{}, positionId:{}", (Object)this.number, (Object)positionId);
    }

    private Map<Long, Long> getEmployeeIdAndAccountId(List<Long> employeeIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrpi_personuserrel");
        DynamicObject[] employees = hrBaseServiceHelper.query("user,employee", new QFilter[]{new QFilter("employee", "in", employeeIds), new QFilter("enable", "=", (Object)true)});
        if (null == employees || employees.length == 0) {
            return new HashMap<Long, Long>();
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        Arrays.stream(employees).forEach(dynamicObject -> {
            long userId = dynamicObject.getLong("user");
            long employeeId = dynamicObject.getLong("employee");
            result.put(userId, employeeId);
        });
        return result;
    }

    private AppResumeBo getAppResumeBo(int i) {
        AppResumeBo appResumeBo = new AppResumeBo();
        Long media = 1050L;
        Long appmthd = 1010L;
        Long resacqMthd = 1050L;
        Long recruchnlnm = 1160L;
        DynamicObject deliveryDy = AddResumeService.generateDeliveryDt(media, appmthd, resacqMthd, recruchnlnm);
        DynamicObject rsmDy = this.rsmHelper.generateEmptyDynamicObject();
        long rsmId = ID.genLongId();
        rsmDy.set("id", (Object)rsmId);
        rsmDy.set("fullname", (Object)ResManager.loadKDString((String)"{0}\u5de5\u5177\u751f\u6210{1}", (String)"GenerateCandidateJob_0", (String)"tsc-tsirm-business", (Object[])new Object[]{this.currentTimeMillis, i}));
        rsmDy.set("birthday", (Object)birthDay);
        rsmDy.set("age", (Object)27);
        rsmDy.set("type", (Object)"A");
        appResumeBo.setRsm(rsmDy);
        this.initEduExp(appResumeBo, rsmId);
        this.initPosOrgRelExp(appResumeBo, rsmId);
        appResumeBo.setDelivery(deliveryDy);
        appResumeBo.setRsmPubScope("A");
        appResumeBo.setCurrDepartment(Long.valueOf(0L));
        return appResumeBo;
    }

    private void initPosOrgRelExp(AppResumeBo appResumeBo, long rsmId) {
        DynamicObject posOrgRelDy = this.rsmPosOrgRelHelper.generateEmptyDynamicObject();
        posOrgRelDy.set("startdate", (Object)startDate);
        posOrgRelDy.set("endingdate", (Object)endDate);
        posOrgRelDy.set("company", (Object)100000L);
        posOrgRelDy.set("adminorg", (Object)100000L);
        posOrgRelDy.set("postype", (Object)posTypeDy);
        posOrgRelDy.set("duration", (Object)13);
        posOrgRelDy.set("rsm", (Object)rsmId);
        posOrgRelDy.set("isrecent", (Object)true);
        posOrgRelDy.set("isprimary", (Object)1);
        appResumeBo.setEntry("tsirm_srrsmposorgrel", (List)ImmutableList.of((Object)posOrgRelDy));
    }

    private void initEduExp(AppResumeBo appResumeBo, long rsmId) {
        DynamicObject rsmEduDy = this.rsmEduHelper.generateEmptyDynamicObject();
        rsmEduDy.set("startdate", (Object)startDate);
        rsmEduDy.set("endingdate", (Object)endDate);
        rsmEduDy.set("othschname", (Object)ResManager.loadKDString((String)"\u4e2d\u5317\u5927\u5b66", (String)"GenerateCandidateJob_1", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        rsmEduDy.set("education", (Object)1010L);
        rsmEduDy.set("educationform", (Object)1010L);
        rsmEduDy.set("lengthofstudy", (Object)13);
        rsmEduDy.set("rsm", (Object)rsmId);
        rsmEduDy.set("ishighestedu", (Object)true);
        rsmEduDy.set("specialtyname", (Object)ResManager.loadKDString((String)"\u8ba1\u7b97\u673a\u79d1\u5b66\u4e0e\u6280\u672f", (String)"GenerateCandidateJob_2", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        appResumeBo.setEntry("tsirm_srrsmeduexp", (List)ImmutableList.of((Object)rsmEduDy));
    }

    protected Map<Long, Long> getEmployeeIdAndAccountId() {
        HRBaseServiceHelper stdRsmHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        DynamicObject[] stdRsmArray = stdRsmHelper.query("id,empid", new QFilter[0]);
        List<Object> empIdList = new ArrayList();
        if (null != stdRsmArray && stdRsmArray.length != 0) {
            empIdList = Arrays.stream(stdRsmArray).map(dynamicObject -> dynamicObject.getLong("empid")).collect(Collectors.toList());
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_employee");
        QFilter qFilter = new QFilter("islatestrecord", "=", (Object)true);
        qFilter.and(new QFilter("laborrelstatus.id", "in", (Object)Lists.newArrayList((Object[])new Long[]{1020L})));
        qFilter.and("iscurrentversion", "=", (Object)true);
        qFilter.and("datastatus", "=", (Object)"1");
        qFilter.and("createtime", "!=", null);
        qFilter.and("id", "not in", empIdList);
        DynamicObject[] dynamicObjects = serviceHelper.query("id", new QFilter[]{qFilter}, "createtime desc", this.number);
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return new HashMap<Long, Long>();
        }
        ArrayList employeeIdList = new ArrayList();
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> employeeIdList.add(dynamicObject.getLong("id")));
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrpi_personuserrel");
        DynamicObject[] employees = hrBaseServiceHelper.query("user,employee", new QFilter[]{new QFilter("employee", "in", employeeIdList), new QFilter("enable", "=", (Object)true)});
        if (null == employees || employees.length == 0) {
            return new HashMap<Long, Long>();
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        Arrays.stream(employees).forEach(dynamicObject -> {
            long userId = dynamicObject.getLong("user");
            long employeeId = dynamicObject.getLong("employee");
            result.put(userId, employeeId);
        });
        return result;
    }

    protected DynamicObject assambleAccountRel(Long userId, Long employeeId) {
        DynamicObject relDyn = EMPCVREL_SERVICEHELPER.generateEmptyDynamicObject();
        relDyn.set("account", (Object)userId);
        relDyn.set("empid", (Object)employeeId);
        relDyn.set("isopen", (Object)true);
        relDyn.set("createtime", (Object)new Date());
        EmpCVHelper.setBaseFields(relDyn);
        return relDyn;
    }

    protected KResumeBO assambleEmpCVBO(DynamicObject rel) {
        KResumeBO empCVBo = new KResumeBO();
        DynamicObject empCV = EMPCV_SERVICEHELPER.generateEmptyDynamicObject();
        empCV.set("id", (Object)ORM.create().genLongId("tsirm_empcv"));
        empCV.set("type", (Object)RsmTypeEnum.TYPE_EMPCV.getType());
        empCV.set("rsmpubscope", (Object)"A");
        empCV.set("isshldctorg", (Object)Boolean.FALSE);
        empCV.set("rsmupdatetime", (Object)new Date());
        EmpCVHelper.setBaseFields(empCV);
        empCVBo.setData(empCV);
        return empCVBo;
    }

    private void saveAccountRel(DynamicObject rel) {
        EMPCVREL_SERVICEHELPER.saveOne(rel);
    }

    private Long saveEmpCv(KResumeBO KResumeBO2) {
        return EmpCVHelper.saveEmpCV(KResumeBO2);
    }

    private void syncEmpCV2Rel(DynamicObject rel, KResumeBO KResumeBO2) {
        DynamicObject empCV = KResumeBO2.getData();
        Long cvid = empCV.getLong("id");
        DynamicObjectCollection entryentity = rel.getDynamicObjectCollection("entryentity");
        DynamicObject dynamicObject = entryentity.addNew();
        dynamicObject.set("cvid", (Object)cvid);
    }
}

