/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.genedatautil;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.constants.api.QueryObject;
import org.apache.commons.collections.CollectionUtils;

public class UpgradeHistoryDataTask
extends AbstractTask {
    private static final int MAX_ROW = 10000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String countSql = "select fid from t_tsirm_stdrsm_a;";
        String pageSql = "select fid,fiscurrentversion, fdatastatus from t_tsirm_stdrsm_a;";
        this.execute(countSql, Lists.newArrayList((Object[])new String[]{pageSql}), "tsirm_stdrsm");
        countSql = "select a.fid from t_tsirm_appfiletask a ;";
        pageSql = "select fid,fargintvid from t_tsirm_appfiletask";
        String leftJoinSql = "select fid,finterviewarrangerid from t_tsirm_argintv";
        this.execute(countSql, Lists.newArrayList((Object[])new String[]{pageSql, leftJoinSql}), "tsirm_appfiletask");
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    private void execute(String countSql, List<String> pageSql, String flex) {
        try (DataSet countDataSet = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getSimpleName() + "count"), (DBRoute)DBRoute.of((String)"tsci"), (String)countSql);){
            int count = countDataSet.count("fid", true);
            if (count > 10000) {
                int allPage = count / 10000 + (count % 10000 == 0 ? 0 : 1);
                for (int i = 1; i <= allPage; ++i) {
                    int start = (i - 1) * 10000;
                    QueryObject queryObject = new QueryObject();
                    DataSet dataSet = this.getPage(start, pageSql, flex);
                    if (null == dataSet) continue;
                    queryObject.setRows(dataSet, 10000);
                    this.updateData(flex, queryObject);
                }
            } else {
                QueryObject queryObject = new QueryObject();
                DataSet dataSet = this.getPage(0, pageSql, flex);
                if (null == dataSet) {
                    return;
                }
                queryObject.setRows(dataSet, 10000);
                this.updateData(flex, queryObject);
            }
        }
    }

    private DataSet getPage(int start, List<String> pageSql, String flex) {
        if ("tsirm_stdrsm".equals(flex)) {
            return this.getStdRsmPage(start, pageSql.get(0));
        }
        if ("tsirm_appfiletask".equals(flex)) {
            return this.getAppFileTaskPage(start, pageSql);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private DataSet getAppFileTaskPage(int start, List<String> pageSql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateData(String flex, QueryObject queryObject) {
        if ("tsirm_appfiletask".equals(flex)) {
            this.updateDataForAppFileTask(queryObject);
        } else if ("tsirm_stdrsm".equals(flex)) {
            this.updateDataForStdRsm(queryObject);
        }
    }

    private DataSet getStdRsmPage(int start, String pageSql) {
        try (DataSet rows = DB.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (DBRoute)DBRoute.of((String)"tsci"), (String)pageSql);){
            DataSet dataSet = rows.limit(start, 10000);
            return dataSet;
        }
    }

    private void updateDataForAppFileTask(QueryObject queryObject) {
        if (CollectionUtils.isEmpty((Collection)queryObject.getRows())) {
            return;
        }
        List idList = queryObject.getRows().stream().map(object -> {
            LinkedHashMap rowMap = (LinkedHashMap)object;
            return (Long)rowMap.get("fid");
        }).collect(Collectors.toList());
        Map<Long, LinkedHashMap<String, Object>> tableMap = this.queryObjectToMap(queryObject);
        List<DynamicObject> dynamicObjects = TsrbsHelper.selectByFilter("id,interviewarranger", new QFilter[]{new QFilter("id", "in", idList)}, "tsirm_appfiletask");
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return;
        }
        dynamicObjects.forEach(dynamicObject -> {
            long fId = dynamicObject.getLong("id");
            LinkedHashMap aMap = (LinkedHashMap)tableMap.get(fId);
            if (null != aMap && dynamicObject.getDynamicObject("interviewarranger") == null) {
                dynamicObject.set("interviewarranger", aMap.get("finterviewarrangerid"));
            }
        });
        TsrbsHelper.update(dynamicObjects.toArray(new DynamicObject[0]), "tsirm_appfiletask");
    }

    private void updateDataForStdRsm(QueryObject queryObjectA) {
        List rows = queryObjectA.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        List idList = rows.stream().map(object -> {
            LinkedHashMap rowMap = (LinkedHashMap)object;
            return (Long)rowMap.get("fid");
        }).collect(Collectors.toList());
        Map<Long, LinkedHashMap<String, Object>> aTableMap = this.queryObjectToMap(queryObjectA);
        List<DynamicObject> dynamicObjects = TsrbsHelper.selectByFilter("id,status, labrelstatuscls, rsmpubscope,companyhr,positionhr,employeenum,iscurrentversion,datastatus", new QFilter[]{new QFilter("id", "in", idList)}, "tsirm_stdrsm");
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fstatus, flabrelstatusclsid, frsmpubscope,fcompanyhrid,fpositionhrid,femployeenum from t_tsirm_stdrsm_b where", new Object[0]);
        sqlBuilder.appendIn("fid", idList.toArray());
        QueryObject queryObject = new QueryObject();
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (DBRoute)DBRoute.of((String)"tsci"), (SqlBuilder)sqlBuilder);){
            queryObject.setRows(dataSet, 10000);
        }
        Map<Long, LinkedHashMap<String, Object>> bTableMap = this.queryObjectToMap(queryObject);
        dynamicObjects.forEach(dynamicObject -> {
            LinkedHashMap bMap;
            long fId = dynamicObject.getLong("id");
            LinkedHashMap aMap = (LinkedHashMap)aTableMap.get(fId);
            if (null != aMap && HRStringUtils.isBlank((CharSequence)dynamicObject.getString("datastatus"))) {
                dynamicObject.set("datastatus", aMap.get("fdatastatus"));
                dynamicObject.set("iscurrentversion", (Object)"1".equals(aMap.get("fiscurrentversion")));
            }
            if (null != (bMap = (LinkedHashMap)bTableMap.get(fId))) {
                if (HRStringUtils.isBlank((CharSequence)dynamicObject.getString("status"))) {
                    dynamicObject.set("status", bMap.get("fstatus"));
                }
                if (dynamicObject.getLong("labrelstatuscls.id") != 0L) {
                    dynamicObject.set("labrelstatuscls", bMap.get("flabrelstatusclsid"));
                }
                if (HRStringUtils.isBlank((CharSequence)dynamicObject.getString("rsmpubscope"))) {
                    dynamicObject.set("rsmpubscope", bMap.get("frsmpubscope"));
                }
                if (dynamicObject.getLong("companyhr.id") != 0L) {
                    dynamicObject.set("companyhr", bMap.get("fcompanyhrid"));
                }
                if (dynamicObject.getLong("positionhr.id") != 0L) {
                    dynamicObject.set("positionhr", bMap.get("fpositionhrid"));
                }
                if (HRStringUtils.isBlank((CharSequence)dynamicObject.getString("employeenum"))) {
                    dynamicObject.set("employeenum", bMap.get("femployeenum"));
                }
            }
        });
        TsrbsHelper.update(dynamicObjects.toArray(new DynamicObject[0]), "tsirm_stdrsm");
    }

    private Map<Long, LinkedHashMap<String, Object>> queryObjectToMap(QueryObject queryObject) {
        List rows = queryObject.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return Maps.newHashMapWithExpectedSize((int)2);
        }
        return rows.stream().collect(Collectors.toMap(object -> {
            LinkedHashMap rowMap = (LinkedHashMap)object;
            return (Long)rowMap.get("fid");
        }, object -> (LinkedHashMap)object, (v1, v2) -> v1));
    }
}

