/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.genedatautil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.common.constants.api.QueryObject;

public class UpgradeStdRsmTalentPoolTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(UpgradeStdRsmTalentPoolTask.class);
    private static final int MAX_PAGE = 5000;
    private static final HRBaseServiceHelper POSITION_HELPER = new HRBaseServiceHelper("tsirm_positiontpl");
    private static final HRBaseServiceHelper JOB_SCM_HELPER = new HRBaseServiceHelper("hbjm_jobscmhr");
    private static final HRBaseServiceHelper RESERVE_HELPER = new HRBaseServiceHelper("tsirm_reservere");
    private static final HRBaseServiceHelper STD_RSM_HELPER = new HRBaseServiceHelper("tsirm_stdrsm");
    private static final HRBaseServiceHelper TALENT_POOL_HELPER = new HRBaseServiceHelper("tsirm_talentpoolmgt");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long start = System.currentTimeMillis();
        LOG.info("UpgradeStdRsmTalentPoolTask start  ");
        this.positionUpgrade();
        this.stdRsmUpgrade();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
        LOG.info("UpgradeStdRsmTalentPoolTask end  by cost:   " + (System.currentTimeMillis() - start));
    }

    private void positionUpgrade() {
        QFilter qFilter = new QFilter("jobscm", "!=", (Object)0L);
        QFilter[] qFilters = new QFilter[]{qFilter};
        int count = POSITION_HELPER.count("tsirm_positiontpl", qFilters);
        if (count > 5000) {
            int allPage = count / 5000 + (count % 5000 == 0 ? 0 : 1);
            for (int i = 1; i <= allPage; ++i) {
                QueryObject queryObject = new QueryObject();
                DataSet dataSet = this.getDataSet(qFilters, i);
                int size = 5000;
                if (i == allPage) {
                    size = count % 5000;
                }
                queryObject.setRows(dataSet, size);
                this.dealPositionPageDataSet(queryObject);
            }
        } else {
            DynamicObject[] dynamicObjects = POSITION_HELPER.query("id,jobscm.id,joborg", qFilters);
            List<Long> jobScmIdList = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("jobscm_id")).collect(Collectors.toList());
            this.commonDeal(jobScmIdList, dynamicObjects);
        }
    }

    private void commonDeal(List<Long> jobScmIdList, DynamicObject[] positions) {
        if (null == positions || positions.length == 0) {
            LOG.error("UpgradePositionTask query position org is empty!!!");
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", jobScmIdList).and("status", "=", (Object)"C").and("ctrlstrategy", "=", (Object)"7").and("enable", "=", (Object)"1")};
        DynamicObject[] jobScmDynamics = JOB_SCM_HELPER.query("id,createorg", qFilters);
        if (null == jobScmDynamics || jobScmDynamics.length == 0) {
            LOG.error("UpgradePositionTask query hbjm_jobscmhr is empty ");
            return;
        }
        Map<Long, DynamicObject> jobScmIdOrgMap = Arrays.stream(jobScmDynamics).collect(Collectors.toMap(jobScm -> jobScm.getLong("id"), jobScm -> jobScm.getDynamicObject("createorg")));
        ArrayList result = new ArrayList();
        Arrays.stream(positions).forEach(position -> {
            long jobScmId = position.getLong("jobscm.id");
            DynamicObject org = (DynamicObject)jobScmIdOrgMap.get(jobScmId);
            if (null == org) {
                return;
            }
            position.set("joborg", (Object)org);
            result.add(position);
        });
        POSITION_HELPER.update(result.toArray(new DynamicObject[0]));
    }

    private void dealPositionPageDataSet(QueryObject queryObject) {
        List rows = queryObject.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            LOG.error("UpgradePositionTask query position empty!!!");
            return;
        }
        ArrayList listMap = new ArrayList();
        rows.forEach(row -> {
            Map map = (Map)row;
            listMap.add(map);
        });
        List<Long> jobScmIdList = listMap.stream().map(map -> (Long)map.get("jobscm")).collect(Collectors.toList());
        List positionList = listMap.stream().map(map -> (Long)map.get("id")).collect(Collectors.toList());
        DynamicObject[] positions = POSITION_HELPER.query("jobscm.id,joborg", new QFilter[]{new QFilter("id", "in", positionList)});
        this.commonDeal(jobScmIdList, positions);
    }

    private DataSet getDataSet(QFilter[] qFilters, int pageNo) {
        int start = pageNo <= 1 ? 0 : (pageNo - 1) * 5000;
        return ORM.create().queryDataSet("UpgradePositionTask.getDataSet", "tsirm_positiontpl", "id,jobscm", qFilters, "createtime", start, 5000, (Distinctable)WithEntityEntryDistinctable.get());
    }

    private void stdRsmUpgrade() {
        QFilter[] qFilters = new QFilter[]{QFilter.of((String)"1=?", (Object[])new Object[]{1})};
        int count = RESERVE_HELPER.count("tsirm_reservere", qFilters);
        if (count > 5000) {
            int pageNum = count / 5000 + (count % 5000 == 0 ? 0 : 1);
            for (int i = 1; i <= pageNum; ++i) {
                QueryObject queryObject = new QueryObject();
                DataSet dataSet = this.getDataSet(qFilters, true, i);
                int size = 5000;
                if (i == pageNum) {
                    size = count % 5000;
                }
                queryObject.setRows(dataSet, size);
                this.dealQueryRow(queryObject);
            }
        } else {
            QueryObject queryObject = new QueryObject();
            DataSet dataSet = this.getDataSet(qFilters, false, 0);
            queryObject.setRows(dataSet, count);
            this.dealQueryRow(queryObject);
        }
    }

    private void dealQueryRow(QueryObject queryObject) {
        List rows = queryObject.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            LOG.error("UpgradeStdRsmTalentPoolTask query tsirm_reservere is empty !!!");
            return;
        }
        ArrayList reserveList = new ArrayList();
        rows.forEach(row -> {
            Map map = (Map)row;
            reserveList.add(map);
        });
        List stdRsmIdList = reserveList.stream().map(reserve -> (Long)reserve.get("stdrsm")).collect(Collectors.toList());
        DynamicObject[] stdRsms = STD_RSM_HELPER.query("talentpool", new QFilter[]{new QFilter("id", "in", stdRsmIdList)});
        if (null == stdRsms || stdRsms.length == 0) {
            LOG.error("UpgradeStdRsmTalentPoolTask query std_rsm is empty!!!");
            return;
        }
        Map<Long, DynamicObject> stdMap = Arrays.stream(stdRsms).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        List talentPoolIdList = reserveList.stream().map(reserve -> (Long)reserve.get("talentpool")).collect(Collectors.toList());
        DynamicObject[] talentPoolArrays = TALENT_POOL_HELPER.query(new QFilter[]{new QFilter("id", "in", talentPoolIdList)});
        if (null == talentPoolArrays || talentPoolArrays.length == 0) {
            LOG.error("UpgradeStdRsmTalentPoolTask query tsirm_talentpoolmgt is empty!!!");
            return;
        }
        Map<Long, DynamicObject> talentIdMap = Arrays.stream(talentPoolArrays).collect(Collectors.toMap(talentPool -> talentPool.getLong("id"), talentPool -> talentPool));
        Map<Long, List<Map>> stdRsmMap = reserveList.stream().collect(Collectors.groupingBy(reserve -> (Long)reserve.get("stdrsm")));
        stdRsmMap.forEach((stdRsmId, list) -> {
            DynamicObject dynamicObject = (DynamicObject)stdMap.get(stdRsmId);
            if (null == dynamicObject) {
                return;
            }
            List<Long> talentPoolList = list.stream().map(map -> (Long)map.get("talentpool")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)talentPoolIdList)) {
                return;
            }
            ArrayList talentList = new ArrayList();
            talentPoolList.forEach(talentPoolId -> {
                DynamicObject talentPool = (DynamicObject)talentIdMap.get(talentPoolId);
                if (null == talentPool) {
                    return;
                }
                talentList.add(talentPool);
            });
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("talentpool");
            talentList.forEach(talent -> {
                List oldRowIdList;
                if (!dynamicObjectCollection.isEmpty() && (oldRowIdList = dynamicObjectCollection.stream().map(oldRow -> oldRow.getLong("fbasedataid.id")).collect(Collectors.toList())).contains(talent.getLong("id"))) {
                    return;
                }
                DynamicObject row = dynamicObjectCollection.addNew();
                row.set("fbasedataid", talent);
            });
        });
        STD_RSM_HELPER.update(stdRsms);
    }

    private DataSet getDataSet(QFilter[] qFilters, boolean isPage, int pageNo) {
        if (isPage) {
            int start = pageNo <= 1 ? 0 : (pageNo - 1) * 5000;
            return ORM.create().queryDataSet("UpgradeStdRsmTalentPoolTask.getDataSet", "tsirm_reservere", "id,talentpool,stdrsm", qFilters, "createtime", start, 5000, (Distinctable)WithEntityEntryDistinctable.get());
        }
        return ORM.create().queryDataSet("UpgradeStdRsmTalentPoolTask.getDataSet", "tsirm_reservere", "id,talentpool,stdrsm", qFilters, "createtime");
    }
}

