/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.genedatautil;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;
import kd.tsc.tsirm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tsirm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;

public class UpgradeStdRsmTask
extends AbstractTask {
    private static final AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();
    private static final Log logger = LogFactory.getLog(UpgradeStdRsmTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int number = Integer.parseInt(map.get("number").toString());
        logger.info("UpgradeStdRsmTask.execute.number->{}", (Object)number);
        QFilter qFilter = new QFilter("status", "=", (Object)"");
        qFilter.and("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper stdRsmHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        DynamicObject[] stdRsmDys = stdRsmHelper.query("", new QFilter[]{qFilter}, "", number);
        List<Long> stdRsmIdList = Arrays.stream(stdRsmDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        logger.info("UpgradeStdRsmTask.execute.stdRsmIdList->{}", stdRsmIdList);
        HashMap<String, Object> stdRsmMap = new HashMap<String, Object>(16);
        stdRsmMap.put("status", "A");
        Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
        resumeService.updateStdRsmWithNoHistory(stdRsmIdList, stdRsmMap);
        Long userId = 0L;
        for (Long stdRsmId : stdRsmIdList) {
            userId = StdRsmCommonService.getInstance().getUserIdByStdRsmId(stdRsmId);
            empCVService.bindAccount(userId);
        }
    }
}

