/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hire.approval;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileService;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalService;
import kd.tsc.tsirm.business.domain.hire.approval.HireOpRecordService;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class HireApprovalAppFileService {
    private static final String CLICKNUMBER = "clicknumber";
    private static final String SKIPFORMID = "skipFormId";
    private static final String SKIPPKID = "skipPkId";
    private static final String HAVEEDIT = "haveEdit";

    public static void updateAppFileAndLockByApprovalId(Long[] approvalIds) {
        DynamicObject[] approvalDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray((Object[])approvalIds);
        HireApprovalAppFileService.updateAppFileByApproval(HireApprovalService.getAppFileByApprovalEntryField(approvalDys));
        HireApprovalAppFileService.lockAppFiles(approvalDys);
    }

    public static void updateAppFileByApprovalPkIds(List<Long> approvalPkIds) {
        List<Long> appFileIds = HireApprovalService.getAppFileIdsByApprovalPkIds(approvalPkIds);
        HireApprovalAppFileService.updateAppFileByApproval(appFileIds);
        HireApprovalAppFileService.resetAppfileStatus(appFileIds);
    }

    public static void updateAppFileByApproval(List<Long> appFileIds) {
        HireApprovalAppFileService service = new HireApprovalAppFileService();
        Map<Long, LatestAppFileApproval> appFileIdAndApprovalMsg = service.getLatestApprovalSingleDynByAppFileId(appFileIds);
        DynamicObject[] appFileDyns = AppFileDataHelper.queryHireInfoAppFile(appFileIds);
        if (appFileDyns.length == 0) {
            return;
        }
        for (DynamicObject appFileDyn : appFileDyns) {
            Long appFileId = appFileDyn.getLong("id");
            LatestAppFileApproval latestAppFileApproval = appFileIdAndApprovalMsg.get(appFileId);
            appFileDyn.set("employapprlnewesttime", (Object)latestAppFileApproval.getApprovalCreateTime());
            appFileDyn.set("employapprlsatatus", (Object)latestAppFileApproval.getAuditStatus());
        }
        AppFileDataHelper.updateHireInfoAppFile(appFileDyns);
    }

    public static void resetAppfileStatus(List<Long> appFileIds) {
        ArrayList<Map<Long, AppFileStatusEnum>> changeList = new ArrayList<Map<Long, AppFileStatusEnum>>(appFileIds.size());
        for (Long appFileId : appFileIds) {
            HashMap<Long, AppFileStatusEnum> row = new HashMap<Long, AppFileStatusEnum>(1);
            row.put(appFileId, AppFileStatusEnum.IN_PROCESS);
            changeList.add(row);
        }
        AppFileStatusHelper.changeAppFileStatusByEmp(changeList);
    }

    public static void lockAppFiles(DynamicObject[] approvalModelDys) {
        AppFileService.getInstance().lockAppFiles(HireApprovalService.getAppFileByApprovalEntryField(approvalModelDys), TSCRequestContext.getUserId(), AppFileOperateEnum.HIREAPPROVAL, false);
    }

    public static void approvalOpRecord(DynamicObject[] approvalArr, OpDefEnum opDefEnum, boolean haveJumpPage) {
        HireApprovalAppFileService.approvalOpRecord(approvalArr, opDefEnum, null, haveJumpPage, false);
    }

    public static void approvalOpRecord(DynamicObject[] approvalArr, OpDefEnum opDefEnum, Map<Long, String> supplementMap, boolean haveJumpPage) {
        HireApprovalAppFileService.approvalOpRecord(approvalArr, opDefEnum, supplementMap, haveJumpPage, false);
    }

    public static void approvalOpRecord(DynamicObject[] approvalArr, OpDefEnum opDefEnum, Map<Long, String> supplementMap, boolean haveJumpPage, boolean haveEdit) {
        ArrayList appFileIdList = Lists.newArrayListWithExpectedSize((int)approvalArr.length);
        HashMap params = Maps.newHashMapWithExpectedSize((int)approvalArr.length);
        for (DynamicObject dy : approvalArr) {
            DynamicObject appFileDy = dy.getDynamicObject("appfile");
            if (appFileDy == null) continue;
            appFileIdList.add((Long)appFileDy.getPkValue());
            if (!haveJumpPage) continue;
            HashMap pageMap = Maps.newHashMapWithExpectedSize((int)4);
            pageMap.put(CLICKNUMBER, dy.getString("billno"));
            pageMap.put(SKIPFORMID, "tsirm_hireapprovalsg");
            pageMap.put(SKIPPKID, dy.getString("id"));
            pageMap.put(HAVEEDIT, haveEdit);
            params.put(appFileDy.getString("id"), pageMap);
        }
        HireOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), opDefEnum, appFileIdList, supplementMap, params);
    }

    public Map<Long, LatestAppFileApproval> getLatestApprovalSingleDynByAppFileId(List<Long> appFileIds) {
        if (appFileIds == null) {
            return Collections.emptyMap();
        }
        QFilter appFileFilter = new QFilter("appfile", "in", appFileIds);
        HRBaseServiceHelper dbServiceHire = new HRBaseServiceHelper("tsirm_hireapprovalsg");
        DynamicObject[] approvalDys = dbServiceHire.loadDynamicObjectArray(appFileFilter.toArray());
        HashMap appFileIdAndApprovalMsg = Maps.newHashMap();
        for (DynamicObject approvalDy : approvalDys) {
            Date approvalCreateTime = approvalDy.getDate("createtime");
            String auditStatus = approvalDy.getString("billstatus");
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)approvalDy, (String)"appfile");
            if (!appFileIds.contains(appFileId)) continue;
            LatestAppFileApproval msg = new LatestAppFileApproval();
            msg.setAppFileId(appFileId);
            msg.setApprovalCreateTime(approvalCreateTime);
            msg.setAuditStatus(auditStatus);
            HireApprovalAppFileService.handleLatestAppFileApproval(msg, appFileIdAndApprovalMsg);
        }
        for (Long appFileId : appFileIds) {
            LatestAppFileApproval msg = (LatestAppFileApproval)appFileIdAndApprovalMsg.get(appFileId);
            if (msg != null) continue;
            appFileIdAndApprovalMsg.put(appFileId, new LatestAppFileApproval());
        }
        return appFileIdAndApprovalMsg;
    }

    private static void handleLatestAppFileApproval(LatestAppFileApproval msg, Map<Long, LatestAppFileApproval> appFileIdAndApprovalMsg) {
        Long appFileId = msg.getAppFileId();
        LatestAppFileApproval msgFormMap = appFileIdAndApprovalMsg.get(appFileId);
        if (msgFormMap == null) {
            appFileIdAndApprovalMsg.put(appFileId, msg);
            return;
        }
        Date msgTime = msg.getApprovalCreateTime();
        Date msgFromMapTime = msgFormMap.getApprovalCreateTime();
        if (msgTime != null && msgFromMapTime != null && msgTime.after(msgFromMapTime)) {
            appFileIdAndApprovalMsg.put(appFileId, msg);
        }
    }

    public static class LatestAppFileApproval {
        private Long appFileId;
        private Date approvalCreateTime;
        private String auditStatus;

        public Long getAppFileId() {
            return this.appFileId;
        }

        public void setAppFileId(Long appFileId) {
            this.appFileId = appFileId;
        }

        public Date getApprovalCreateTime() {
            return this.approvalCreateTime;
        }

        public void setApprovalCreateTime(Date approvalCreateTime) {
            this.approvalCreateTime = approvalCreateTime;
        }

        public String getAuditStatus() {
            return this.auditStatus;
        }

        public void setAuditStatus(String auditStatus) {
            this.auditStatus = auditStatus;
        }
    }
}

