/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hire.approval;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.application.external.ExtHRPIEmployeeService;
import kd.tsc.tsirm.business.application.external.ExtHRPIPersonService;
import kd.tsc.tsirm.business.application.external.ExtHSPMService;
import kd.tsc.tsirm.business.application.external.ExtTransferService;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsirm.common.enums.hire.HireChangeCatEnum;
import kd.tsc.tsirm.common.enums.hire.HireChangeStatusEnum;

public class HireApprovalDomainService {
    private static HRBaseServiceHelper APPROVAL_SERVICE = new HRBaseServiceHelper("tsirm_hireapprovalsg");
    private static Log logger = LogFactory.getLog(HireApprovalDomainService.class);

    public static DynamicObject[] getHireBill(Long appFileId) {
        QFilter qFilter = new QFilter("appfile", "=", (Object)appFileId);
        HRBaseServiceHelper dbService = new HRBaseServiceHelper("tsirm_hireapprovalsg");
        return dbService.query(qFilter.toArray());
    }

    public static boolean existHireBill(Long appFileId) {
        DynamicObject[] hireBillArray = HireApprovalDomainService.getHireBill(appFileId);
        return hireBillArray != null && hireBillArray.length > 0;
    }

    public static String getPersonImgUrl(Long appFileId) {
        Map<String, Object> employeeMap = HireApprovalDomainService.getEmpByAppFile(appFileId);
        Long personId = (Long)employeeMap.get("person_id");
        Map<String, Object> personMap = ExtHRPIPersonService.getPersonBaseInfo(personId);
        return (String)personMap.get("headsculpture");
    }

    public static Map<String, Object> getEmpByAppFile(Long appFileId) {
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tsirm_appfilemdl");
        DynamicObject appFileDyn = dbServiceAppFile.loadSingle((Object)appFileId);
        Object stdRsmId = appFileDyn.getDynamicObject("stdrsm").getPkValue();
        HRBaseServiceHelper dbServiceStdRsm = new HRBaseServiceHelper("tsirm_stdrsm");
        DynamicObject stdRsmDy = dbServiceStdRsm.loadSingle(stdRsmId);
        Long employeeId = stdRsmDy.getLong("empid");
        Map<String, Object> employeeMap = ExtHRPIEmployeeService.getEmployee(employeeId);
        return employeeMap;
    }

    /*
     * WARNING - void declaration
     */
    public static void batchSyncTransferStatus(DynamicObject[] hireDyArray) {
        block8: {
            void var10_17;
            Map data;
            if (hireDyArray == null || hireDyArray.length <= 0) break block8;
            HashMap lastTransferMap = new HashMap();
            HRBaseServiceHelper dbService = new HRBaseServiceHelper("tsirm_hireapprovalsg");
            List hirePkList = Arrays.stream(hireDyArray).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] hireDynamicObj = dbService.loadDynamicObjectArray(hirePkList.toArray());
            ArrayList<Long> deEmpIdList = new ArrayList<Long>(hireDynamicObj.length);
            for (DynamicObject row : hireDynamicObj) {
                DynamicObject dynamicObject = row.getDynamicObject("depemp");
                if (dynamicObject == null) continue;
                deEmpIdList.add((Long)dynamicObject.getPkValue());
            }
            if (deEmpIdList.isEmpty()) break block8;
            Map<String, Object> transferData = ExtTransferService.queryTransferBillInfoByBdepempIds(deEmpIdList, new String[]{"0", "1", "2", "3", "4"});
            Boolean success = (Boolean)transferData.get("success");
            if (success.booleanValue() && (data = (Map)transferData.get("data")) != null && data.size() > 0) {
                for (Map.Entry entry : data.entrySet()) {
                    Map<String, Object> transferRow = HireApprovalDomainService.getLastCreateTransfer((List)entry.getValue());
                    lastTransferMap.put(entry.getKey(), transferRow);
                }
            }
            ArrayList<Map<String, Object>> changeList = new ArrayList<Map<String, Object>>(hireDynamicObj.length);
            HashMap<Long, String> changeCategoryMap = new HashMap<Long, String>(hireDynamicObj.length);
            boolean bl = false;
            while (var10_17 < hireDynamicObj.length) {
                block10: {
                    Long appFileId;
                    HashMap row;
                    DynamicObject hdo;
                    block11: {
                        String dbChangeStatus;
                        block9: {
                            hdo = hireDynamicObj[var10_17];
                            Long key = (Long)hdo.getDynamicObject("depemp").getPkValue();
                            row = new HashMap(3);
                            appFileId = hdo.getDynamicObject("appfile").getLong("id");
                            dbChangeStatus = hdo.getString("cbochgstatus");
                            if (!lastTransferMap.containsKey(key)) break block9;
                            Map transferRow = (Map)lastTransferMap.get(key);
                            if (HRStringUtils.isNotEmpty((String)dbChangeStatus) && dbChangeStatus.equals(HireApprovalDomainService.mappingTransferStatus((String)transferRow.get("transferstatus")))) break block10;
                            hdo.set("cbochgcategory", (Object)HireChangeCatEnum.TRANSFER.getCode());
                            hdo.set("cbochgstatus", (Object)HireApprovalDomainService.mappingTransferStatus((String)transferRow.get("transferstatus")));
                            hdo.set("txtchgbillno", transferRow.get("billno"));
                            row.put("changedate", transferRow.get("realitydate"));
                            break block11;
                        }
                        if (HireChangeStatusEnum.WAIT.getCode().equals(dbChangeStatus)) break block10;
                        hdo.set("cbochgcategory", (Object)HireChangeCatEnum.TRANSFER.getCode());
                        hdo.set("cbochgstatus", (Object)HireChangeStatusEnum.WAIT.getCode());
                        hdo.set("txtchgbillno", (Object)"");
                    }
                    row.put("id", appFileId);
                    row.put("filestatus", HireApprovalDomainService.mappingAppFileStatus(hdo.getString("cbochgstatus")));
                    changeList.add(row);
                    changeCategoryMap.put(appFileId, hdo.getString("cbochgcategory"));
                }
                ++var10_17;
            }
            dbService.update(hireDynamicObj);
            if (!changeList.isEmpty()) {
                AppFileStatusHelper.changeAppFileStatusByID(changeList);
                AppFileHelper.changeAppFilePersonType(changeCategoryMap);
            }
        }
    }

    private static Map<String, Object> getLastCreateTransfer(List<Map<String, Object>> list) {
        Map<String, Object> transfer = list.get(0);
        for (Map<String, Object> map : list) {
            Date transferDate;
            Date currentCreateTime = (Date)map.get("createtime");
            if (!currentCreateTime.after(transferDate = (Date)transfer.get("createtime"))) continue;
            transfer = map;
        }
        return transfer;
    }

    private static AppFileStatusEnum mappingAppFileStatus(String changeStatus) {
        return AppFileStatusEnum.getEnum((String)changeStatus);
    }

    private static String mappingTransferStatus(String transferStatus) {
        String status = HireChangeStatusEnum.WAIT.getCode();
        switch (transferStatus) {
            case "0": {
                status = HireChangeStatusEnum.INPC.getCode();
                break;
            }
            case "1": {
                status = HireChangeStatusEnum.INPC.getCode();
                break;
            }
            case "2": {
                status = HireChangeStatusEnum.CHGD.getCode();
                break;
            }
            case "3": {
                status = HireChangeStatusEnum.STOP.getCode();
                break;
            }
            case "4": {
                status = HireChangeStatusEnum.INPC.getCode();
                break;
            }
            default: {
                status = HireChangeStatusEnum.WAIT.getCode();
            }
        }
        return status;
    }

    public static String getHireApprovalData(String startTime, String endTime) {
        DynamicObject[] dynamicObjects = APPROVAL_SERVICE.queryOriginalArray("id", HireApprovalHelper.getHireDataFilter(startTime, endTime).toArray());
        return String.valueOf(dynamicObjects.length);
    }

    public static Long getJobScmIdFromJobId(Long jobId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        DynamicObject jobDyn = serviceHelper.queryOne("jobscm", (Object)jobId);
        if (jobDyn == null) {
            return null;
        }
        return HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)jobDyn, (String)"jobscm");
    }

    public static Map<String, Object> getOrgLeaderAndSuperior(Long personId) {
        Map<String, Object> data = null;
        DynamicObject empMfile = ExtHSPMService.getPrimaryErmanfFile(personId);
        if (empMfile != null) {
            Long empfileId = empMfile.getLong("id");
            List<Map<String, Object>> empfileList = ExtHSPMService.getCardFields(Lists.newArrayList((Object[])new Long[]{empfileId}));
            if (!empfileList.isEmpty()) {
                data = empfileList.get(0);
            }
        }
        return data;
    }
}

