/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hire.approval;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class HireApprovalHelper {
    protected static final List<String> AUDIT_STATUSQUERY = Arrays.asList("G", "B", "D");

    public static void updateSubmit(DynamicObject[] dynamicObjects, String status) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        Long userId = TSCRequestContext.getUserId();
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (status != null && status.equals("C")) {
                dynamicObject.set("auditor", (Object)userId);
                dynamicObject.set("auditdate", (Object)now);
            }
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("modifytime", (Object)now);
        }
    }

    public static QFilter getHireDataFilter(String startTime, String endTime) {
        long userId = TSCRequestContext.getUserId();
        QFilter qFilter = new QFilter("submitor", "=", (Object)userId);
        qFilter.and(new QFilter("billstatus", "in", AUDIT_STATUSQUERY));
        if (HRStringUtils.isNotEmpty((String)startTime)) {
            qFilter.and(new QFilter("submittime", ">=", (Object)LocalDateTime.parse(startTime, DateFormatConstants.NORM_DATETIME_FORM)));
        }
        if (HRStringUtils.isNotEmpty((String)endTime)) {
            qFilter.and(new QFilter("submittime", "<=", (Object)LocalDateTime.parse(endTime, DateFormatConstants.NORM_DATETIME_FORM)));
        }
        return qFilter;
    }
}

