/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hire.approval;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileHireHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tsirm.business.domain.hire.approval.common.HireCommonKDStringHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsirm.common.dto.hire.HireVerifyResult;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class HireApprovalService {
    Log logger = LogFactory.getLog(HireApprovalService.class);
    public static final String EVENT_HIRE_APPROVAL = "hireApproval";
    protected static final List<String> AUDIT_STATUSLIST = Arrays.asList("B", "C", "D", "E");
    protected static final List<String> AUDIT_STATUSADD = Arrays.asList("A", "G", "B", "C", "D", "E");

    public static QFilter verifyAddDataEdit() {
        QFilter qFilter = new QFilter("employapprlsatatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"F", " "}));
        qFilter.and("jobrankstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"W", "S", "A", " "}));
        qFilter.and("setsalarystatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"W", "S", "A", " "}));
        qFilter.and(AppFileListHelper.getFlowLockQFilter());
        qFilter.and(AppFileListHelper.getIsInProcessQFilter());
        qFilter.and(HireApprovalService.getBlackListQFilter());
        return qFilter;
    }

    public static HireVerifyResult verifyAddData(List<Long> idList) {
        HireVerifyResult hireVerifyAdd = HireApprovalService.verifyHireAdd(idList);
        HireVerifyResult hireVerifyResult = new HireVerifyResult();
        return HireApprovalService.mergeVerifyAppFileConditionResult(hireVerifyAdd, hireVerifyResult);
    }

    public static HireVerifyResult verifySubmitList(List<Long> idList) {
        QFilter qFilter = new QFilter("appfile", "in", idList);
        qFilter.and("billstatus", "in", AUDIT_STATUSLIST);
        ArrayList msg = Lists.newArrayList((Object[])new String[]{HireCommonKDStringHelper.verifySubmitListForError()});
        return HireApprovalService.verifyHire(idList, qFilter, msg);
    }

    public static HireVerifyResult verifyHireAdd(List<Long> idList) {
        QFilter qFilter = new QFilter("appfile", "in", idList);
        qFilter.and("billstatus", "in", AUDIT_STATUSADD);
        ArrayList msg = Lists.newArrayList((Object[])new String[]{HireCommonKDStringHelper.verifyAddForError()});
        return HireApprovalService.verifyHire(idList, qFilter, msg);
    }

    public static HireVerifyResult verifyHireSave(List<Long> idList, List<Long> hireIdList) {
        QFilter qFilter = new QFilter("appfile", "in", idList);
        if (CollectionUtils.isNotEmpty(hireIdList)) {
            qFilter.and(new QFilter("id", "not in", hireIdList));
        }
        qFilter.and(new QFilter("billstatus", "in", AUDIT_STATUSADD));
        ArrayList msg = Lists.newArrayList((Object[])new String[]{HireCommonKDStringHelper.verifyAddForError()});
        return HireApprovalService.verifyHire(idList, qFilter, msg);
    }

    public static HireVerifyResult verifyHire(List<Long> idList, QFilter qFilter, ArrayList<String> msg) {
        DynamicObject[] hireApprovalSingleDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray(qFilter.toArray());
        List hireList = Arrays.stream(hireApprovalSingleDys).map(dyn -> dyn.getDynamicObject("appfile").getLong("id")).collect(Collectors.toList());
        HireVerifyResult hireVerifyResult = new HireVerifyResult();
        for (Long aLong : idList) {
            if (hireList.contains(aLong)) {
                if (hireVerifyResult.getFailAppFileId().contains(aLong)) {
                    List strList = (List)hireVerifyResult.getFailReason().get(aLong);
                    strList.addAll(msg);
                    hireVerifyResult.getFailReason().put(aLong, strList);
                }
                hireVerifyResult.getFailAppFileId().add(aLong);
                hireVerifyResult.getFailReason().put(aLong, msg);
                continue;
            }
            hireVerifyResult.getSuccessAppFileId().add(aLong);
        }
        return hireVerifyResult;
    }

    public static List<Long> getAppFileIdsByApprovalPkIds(List<Long> approvalPkIds) {
        return HireApprovalService.getAppFileByApprovalEntryField(ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray(new QFilter("id", "in", approvalPkIds).toArray()));
    }

    public static List<Long> getAppFileByApprovalEntryField(DynamicObject[] approvalSingleDys) {
        ArrayList<Long> appFileIds = new ArrayList<Long>(approvalSingleDys.length);
        for (DynamicObject approvalDy : approvalSingleDys) {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)approvalDy, (String)"appfile");
            appFileIds.add(appFileId);
        }
        return appFileIds;
    }

    public static HireVerifyResult verifyPositionAndJob(List<DynamicObject> jobRankDyns) {
        HireVerifyResult appFileResult = new HireVerifyResult();
        for (DynamicObject jobRankDyn : jobRankDyns) {
            DynamicObject position = jobRankDyn.getDynamicObject("position");
            DynamicObject job = jobRankDyn.getDynamicObject("job");
            Long appFileId = jobRankDyn.getLong("appfile.id");
            DynamicObject deptDy = jobRankDyn.getDynamicObject("org");
            ArrayList failReasons = Lists.newArrayList();
            boolean passCheck = true;
            if (!passCheck) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, failReasons);
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static ValidateResult filterAppFileByEvent(String event, List<Long> appFileIds) {
        switch (event) {
            case "hireApproval": {
                return HireApprovalService.handleApproval(appFileIds);
            }
        }
        return new ValidateResult();
    }

    private static ValidateResult handleApproval(List<Long> appFileIds) {
        Object[] appFileDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_appfilemdl").loadDynamicObjectArray(appFileIds.toArray());
        ArrayList appFileList = Lists.newArrayList((Object[])appFileDys);
        HireVerifyResult allVerify = HireApprovalService.verifyAddData(appFileIds);
        return HireApprovalService.convertHireVerifyResultToValidateResult(allVerify, appFileList);
    }

    public static HireVerifyResult mergeVerifyAppFileConditionResult(HireVerifyResult ... hireVerifyResults) {
        HireVerifyResult[] resultsArr = hireVerifyResults;
        HireVerifyResult allVerify = new HireVerifyResult();
        HashSet successAppFileIds = Sets.newHashSetWithExpectedSize((int)resultsArr.length);
        HashSet failAppFileIds = Sets.newHashSetWithExpectedSize((int)resultsArr.length);
        HashMap failReason = Maps.newHashMapWithExpectedSize((int)resultsArr.length);
        for (HireVerifyResult eachVerify : hireVerifyResults) {
            successAppFileIds.addAll(eachVerify.getSuccessAppFileId());
        }
        for (HireVerifyResult eachVerify : hireVerifyResults) {
            successAppFileIds.removeAll(eachVerify.getFailAppFileId());
            failAppFileIds.addAll(eachVerify.getFailAppFileId());
            Map eachVerifyFailReason = eachVerify.getFailReason();
            for (Map.Entry entry : eachVerifyFailReason.entrySet()) {
                Long appFileId = (Long)entry.getKey();
                List reason = (List)entry.getValue();
                List allReason = (List)failReason.get(appFileId);
                if (allReason != null) {
                    allReason.addAll(reason);
                    failReason.put(appFileId, allReason);
                    continue;
                }
                failReason.put(appFileId, reason);
            }
        }
        allVerify.setSuccessAppFileId((Set)successAppFileIds);
        allVerify.setFailAppFileId((Set)failAppFileIds);
        allVerify.setFailReason((Map)failReason);
        return allVerify;
    }

    public static ValidateResult convertHireVerifyResultToValidateResult(HireVerifyResult appFileVerify, List<DynamicObject> appFileList) {
        HashMap appFileIdAndNo = Maps.newHashMapWithExpectedSize((int)appFileList.size());
        for (DynamicObject appFileDy : appFileList) {
            appFileIdAndNo.put(appFileDy.getLong("id"), appFileDy.getString("number"));
        }
        ValidateResult validateResult = new ValidateResult();
        ArrayList successPkId = Lists.newArrayListWithExpectedSize((int)appFileVerify.getSuccessAppFileId().size());
        successPkId.addAll(appFileVerify.getSuccessAppFileId());
        validateResult.setSuccessPkIds((List)successPkId);
        ArrayList operateErrorInfos = Lists.newArrayListWithExpectedSize((int)appFileVerify.getFailAppFileId().size());
        Map failReason = appFileVerify.getFailReason();
        failReason.forEach((appFileId, reasonDetails) -> reasonDetails.forEach(reasonDetail -> {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setPkValue(appFileId);
            errorInfo.setMessage((String)appFileIdAndNo.get(appFileId) + ":" + reasonDetail);
            errorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfos.add(errorInfo);
        }));
        validateResult.setAllErrorInfo((List)operateErrorInfos);
        return validateResult;
    }

    public static boolean checkAppFileStatusOfPro(List<Long> appFileIds) {
        Map<Long, String> statusMap = AppFileHireHelper.returnAppFileStatus(appFileIds);
        Collection<String> values = statusMap.values();
        List<AppFileStatusEnum> status = Collections.singletonList(AppFileStatusEnum.IN_PROCESS);
        List statusStr = status.stream().map(AppFileStatusEnum::getValue).collect(Collectors.toList());
        for (String str : statusStr) {
            if (!values.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, Boolean> checkBlackList(List<Long> appFileIds) {
        return AppFileStdRsmHelper.getBlackListMap(appFileIds);
    }

    public static QFilter getBlackListQFilter() {
        return AppFileHireHelper.isNotInBlackList("");
    }
}

