/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hire.approval;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.application.external.ExtHRPIEmployeeService;
import kd.tsc.tsirm.business.application.external.ExtHRPIPersonService;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalDomainService;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalService;
import kd.tsc.tsirm.business.domain.hire.approval.HireQFilterService;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.common.dto.hire.HireVerifyResult;
import kd.tsc.tsirm.common.enums.hire.PositiontypeEnum;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class HireApprovalViewService {
    private static final String KEY_EMPLOYEENUM = "employeenum";
    private static final String KEY_COMPANY = "company";
    private static final String KEY_DURATION = "duration";
    private static final String KEY_POSTYPE = "postype";
    public static final String KEY_PROBATIONFLEX = "probationflex";
    public static final String KEY_SINGLESELECTFLEX = "singleselectflex";
    public static final String RADIO_YES = "1";
    public static Long ID_LABRELSTATUSCLS_YES = 1010L;
    public static Long ID_LABRELSTATUSCLS_NO = 1020L;
    private static Log logger = LogFactory.getLog(HireApprovalViewService.class);

    @Deprecated
    public static void setHireInfoForFinishedData(IFormView formView, IDataModel dataModel) {
        DynamicObject approvalSingleDy = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadSingle(dataModel.getValue("id"));
        HireApprovalViewService.initHeadAppFileMsg(approvalSingleDy.getDynamicObject("appfile"), formView);
    }

    public static void setHireInfo(IFormView formView, IDataModel dataModel) {
        HireApprovalViewService.setHeadInfo(formView, dataModel);
        if (dataModel.getValue(KEY_DURATION) != null) {
            Integer duration = (Integer)dataModel.getValue(KEY_DURATION);
            dataModel.setValue("servicelength", (Object)ResumeAnalysisHelper.getWorkYearShow(duration));
        }
        HireApprovalViewService.setComparePanel(formView, dataModel);
        HireApprovalViewService.setVisible(formView, dataModel);
    }

    private static void setComparePanel(IFormView formView, IDataModel dataModel) {
        DynamicObject hireDy = dataModel.getDataEntity();
        HireApprovalViewService.setLabelText(formView, "lblcompany", hireDy.getDynamicObject(KEY_COMPANY));
        HireApprovalViewService.setLabelText(formView, "lbladminorg", hireDy.getDynamicObject("org"));
        String stdPostionType = hireDy.getString("postpattern");
        HireApprovalViewService.setLabelText(formView, "lblpostpattern", PositiontypeEnum.getNameByCode((String)stdPostionType));
        HireApprovalViewService.setLabelText(formView, "lblposition", hireDy.getDynamicObject("position"));
        HireApprovalViewService.setLabelText(formView, "lblstposition", hireDy.getDynamicObject("stposition"));
        HireApprovalViewService.setLabelText(formView, "lbljob", hireDy.getDynamicObject("job"));
        HireApprovalViewService.setLabelText(formView, "lbljobgrade", hireDy.getDynamicObject("jobgrade"));
        HireApprovalViewService.setLabelText(formView, "lbljoblevel", hireDy.getDynamicObject("joblevel"));
        HireApprovalViewService.setLblMultiBaseDataText(formView, dataModel, "lblsuperior", "realitysuperior");
        HireApprovalViewService.setLblMultiBaseDataText(formView, dataModel, "lblleader", "realityorgleader");
        HireApprovalViewService.setLabelText(formView, "lblposttype", hireDy.getDynamicObject("posttype"));
        HireApprovalViewService.setLabelText(formView, "lbllocation", hireDy.getDynamicObject("location"));
        HireApprovalViewService.setLabelText(formView, "lblcurcompany", hireDy.getDynamicObject("curcompany"));
        HireApprovalViewService.setLabelText(formView, "lblcuradminorg", hireDy.getDynamicObject("curorg"));
        String curPositionType = hireDy.getString("curpostpattern");
        HireApprovalViewService.setLabelText(formView, "lblcurpostpattern", PositiontypeEnum.getNameByCode((String)curPositionType));
        HireApprovalViewService.setLabelText(formView, "lblcurposition", hireDy.getDynamicObject("curposition"));
        HireApprovalViewService.setLabelText(formView, "lblcurstposition", hireDy.getDynamicObject("curstposition"));
        HireApprovalViewService.setLabelText(formView, "lblcurjob", hireDy.getDynamicObject("curjob"));
        HireApprovalViewService.setLabelText(formView, "lblcurjobgrade", hireDy.getDynamicObject("curjobgrade"));
        HireApprovalViewService.setLabelText(formView, "lblcurjoblevel", hireDy.getDynamicObject("curjoblevel"));
        HireApprovalViewService.setLblMultiBaseDataText(formView, dataModel, "lblcursuperior", "cursuperior");
        HireApprovalViewService.setLblMultiBaseDataText(formView, dataModel, "lblcurleader", "curorgleader");
        HireApprovalViewService.setLabelText(formView, "lblcurposttype", hireDy.getDynamicObject("curposttype"));
        HireApprovalViewService.setLabelText(formView, "lblcurlocation", hireDy.getDynamicObject("curlocation"));
        Integer duration = (Integer)dataModel.getValue(KEY_DURATION);
        String durationStr = ResumeAnalysisHelper.getWorkYearShow(duration);
        HireApprovalViewService.setLabelText(formView, "lblduration", durationStr);
        Date planDate = hireDy.getDate("plandate");
        String planDateStr = HRInteDateTimeUtil.formatDate((String)"tsirm_hireapprovalsg", (String)"plandate", (Date)planDate);
        HireApprovalViewService.setLabelText(formView, "lblplandate", planDateStr);
    }

    private static void setHeadInfo(IFormView formView, IDataModel dataModel) {
        DynamicObject hireDy = dataModel.getDataEntity();
        HireApprovalViewService.setLabelText(formView, "lbleditbillno", hireDy.getString("billno"));
        HireApprovalViewService.setLabelText(formView, "lbleditcreateorg", hireDy.getDynamicObject("createorg"));
        Date createDate = hireDy.getDate("createtime");
        String applyTime = HRInteDateTimeUtil.formatDate((String)"tsirm_hireapprovalsg", (String)"createtime", (Date)createDate);
        HireApprovalViewService.setLabelText(formView, "lbleditapplytime", applyTime);
        String headsculpture = HireApprovalDomainService.getPersonImgUrl(hireDy.getLong("appfile.id"));
        Image image = (Image)formView.getControl("avatarhead");
        if (StringUtils.isNotEmpty((String)headsculpture)) {
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)headsculpture));
        }
        dataModel.setValue("createuser2", (Object)hireDy.getDynamicObject("creator"));
        dataModel.setValue("txtfullname", (Object)hireDy.getString("fullname"));
        HireApprovalViewService.setLabelText(formView, "lbleditemployeenum", hireDy.getString(KEY_EMPLOYEENUM));
        HireApprovalViewService.setLabelText(formView, "lbleditlaborreltype", hireDy.getDynamicObject("curlaborreltype"));
        HireApprovalViewService.setLabelText(formView, "lbleditlaborrelstatus", hireDy.getDynamicObject("curlaborrelstatus"));
        HireApprovalViewService.setLabelText(formView, "lbledithposttype", hireDy.getDynamicObject("curposttype"));
        dataModel.setValue("bdappfilesex", (Object)hireDy.getDynamicObject("appfilesex"));
        dataModel.setValue("txtappfileage", (Object)hireDy.getString("appfileage"));
        dataModel.setValue("txtappfilemajor", (Object)hireDy.getString("appfilemajor"));
        dataModel.setValue("txtphone", (Object)hireDy.getString("phone"));
    }

    public static void initHireApprovalData(IFormView formView, IDataModel hireDataModel) {
        Long appFileId = (Long)formView.getFormShowParameter().getCustomParam("appFileId");
        if (appFileId != null && !appFileId.equals(0L)) {
            hireDataModel.setValue("appfile", (Object)appFileId);
            formView.setEnable(Boolean.FALSE, new String[]{"appfile"});
        } else {
            String appFileIdStr = formView.getPageCache().get("appFileSelect");
            if (HRStringUtils.isNotEmpty((String)appFileIdStr)) {
                hireDataModel.setValue("appfile", (Object)Long.valueOf(appFileIdStr));
            }
        }
        DynamicObject appFileDy = (DynamicObject)hireDataModel.getValue("appfile");
        if (appFileDy != null && !appFileDy.getPkValue().equals(0L)) {
            formView.setVisible(Boolean.FALSE, new String[]{"flexblank"});
            HireApprovalViewService.initSetFlexPanel(formView, Boolean.TRUE);
            Map<String, Object> employeeMap = HireApprovalDomainService.getEmpByAppFile(appFileDy.getLong("id"));
            HireApprovalViewService.initNewHeadFromAppFile(formView, hireDataModel, appFileDy);
            HireApprovalViewService.initNewHeadFormHRPI(formView, hireDataModel, employeeMap);
            HireApprovalViewService.initNewEmpPosorgRelFromHRPI(hireDataModel, employeeMap);
            HireApprovalViewService.initSetDefaultPosorgRel(hireDataModel);
            HireApprovalViewService.initCurOrgLeaderAndSuperior(hireDataModel, employeeMap);
            HireApprovalViewService.initJobLevelAndGrade(hireDataModel, employeeMap);
            HireApprovalViewService.setVisible(formView, hireDataModel);
        } else {
            HireApprovalViewService.clearInitData(formView, hireDataModel);
            HireApprovalViewService.initSetFlexPanel(formView, Boolean.FALSE);
            formView.setVisible(Boolean.TRUE, new String[]{"flexblank"});
        }
    }

    private static void initSetDefaultPosorgRel(IDataModel model) {
        model.setValue("postpattern", model.getValue("curpostpattern"));
    }

    private static void initNewHeadFormHRPI(IFormView formView, IDataModel hireDataModel, Map<String, Object> employeeMap) {
        Object laborrelstatus;
        Object laborreltype = employeeMap.get("laborreltype_id");
        if (laborreltype != null) {
            hireDataModel.setValue("curlaborreltype", laborreltype);
        }
        if ((laborrelstatus = employeeMap.get("laborrelstatus_id")) != null) {
            hireDataModel.setValue("curlaborrelstatus", laborrelstatus);
        }
        Long personId = (Long)employeeMap.get("person_id");
        Map<String, Object> personMap = ExtHRPIPersonService.getPersonBaseInfo(personId);
        String headsculpture = (String)personMap.get("headsculpture");
        Image image = (Image)formView.getControl("avatar");
        if (StringUtils.isNotBlank((String)headsculpture)) {
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)headsculpture));
        }
    }

    private static void initNewHeadFromAppFile(IFormView formView, IDataModel dataModel, DynamicObject appFileDy) {
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tsirm_appfilemdl");
        DynamicObject appFileDyn = dbServiceAppFile.loadSingle(appFileDy.getPkValue());
        dataModel.setValue("createorg", (Object)appFileDyn.getDynamicObject("createorg"));
        dataModel.setValue("fullname", (Object)appFileDyn.getString("appres.fullname"));
        dataModel.setValue(KEY_EMPLOYEENUM, (Object)appFileDyn.getString(KEY_EMPLOYEENUM));
        dataModel.setValue("appfilesex", (Object)appFileDyn.getDynamicObject("appres.gender"));
        dataModel.setValue("appfileage", (Object)appFileDyn.getString("appres.age"));
        dataModel.setValue("phone", (Object)appFileDyn.getString("appres.phone"));
        dataModel.setValue("appfilemajor", (Object)appFileDyn.getString("highestspecialty"));
        Label orgNameLabel = (Label)formView.getControl("orgname");
        DynamicObject org = (DynamicObject)dataModel.getValue("createorg");
        if (org != null) {
            orgNameLabel.setText(org.getString("name"));
        } else {
            orgNameLabel.setText("");
        }
        HireApprovalViewService.initNewHeadPostType(formView, dataModel, appFileDyn);
    }

    private static void initNewHeadPostType(IFormView formView, IDataModel dataModel, DynamicObject appFileDyn) {
        Object resumeId = appFileDyn.getDynamicObject("appres").getPkValue();
        HRBaseServiceHelper srrsmposorgrelHelper = new HRBaseServiceHelper("tsirm_srrsmposorgrel");
        HashSet selectColumn = Sets.newHashSetWithExpectedSize((int)5);
        selectColumn.add("id");
        selectColumn.add(KEY_COMPANY);
        selectColumn.add("position");
        selectColumn.add("startdate");
        selectColumn.add("endingdate");
        selectColumn.add(KEY_POSTYPE);
        selectColumn.add(KEY_DURATION);
        selectColumn.add("isprimary");
        String queryColumn = String.join((CharSequence)",", selectColumn);
        QFilter srrsmposorgrelQFilter = new QFilter("rsm", "=", resumeId);
        String orderBy = "startdate DESC";
        DynamicObject[] ssmdy = srrsmposorgrelHelper.query(queryColumn, srrsmposorgrelQFilter.toArray(), orderBy);
        if (ssmdy != null && ssmdy.length > 0) {
            int i = 0;
            for (i = 0; i < ssmdy.length; ++i) {
                DynamicObject ssmitem = ssmdy[i];
                if (!ssmitem.getBoolean("isprimary")) continue;
                Label hposttype = (Label)formView.getControl("hposttype");
                hposttype.setText(ssmitem.getDynamicObject(KEY_POSTYPE).getString("name"));
                break;
            }
        }
    }

    private static void initNewEmpPosorgRelFromHRPI(IDataModel dataModel, Map<String, Object> employeeMap) {
        Long personId = (Long)employeeMap.get("person_id");
        Map<String, Object> map = ExtHRPIPersonService.getPrimaryEmpposorgrel(personId);
        Object apositiontype = map.get("apositiontype");
        dataModel.setValue("curpostpattern", apositiontype);
        dataModel.setValue("curposition", map.get("position_id"));
        dataModel.setValue("curjob", map.get("job_id"));
        dataModel.setValue("curcompany", map.get("company_id"));
        dataModel.setValue("curorg", map.get("adminorg_id"));
        dataModel.setValue("curposttype", map.get("postype_id"));
        dataModel.setValue("depemp", map.get("depemp_id"));
        dataModel.setValue("employee", employeeMap.get("id"));
        Date startDate = (Date)map.get("startdate");
        if (startDate != null) {
            int duration = ResumeAnalysisHelper.calMonthByStartDate(startDate, new Date());
            String workYearShow = ResumeAnalysisHelper.getWorkYearShow(duration);
            dataModel.setValue(KEY_DURATION, (Object)duration);
            dataModel.setValue("servicelength", (Object)workYearShow);
        }
    }

    private static void initCurOrgLeaderAndSuperior(IDataModel dataModel, Map<String, Object> employeeMap) {
        Long personId = (Long)employeeMap.get("person_id");
        Map<String, Object> empFileMap = HireApprovalDomainService.getOrgLeaderAndSuperior(personId);
        if (empFileMap != null) {
            Object jobId;
            Object locationId;
            List superiorinfo;
            List chargeinfo = (List)empFileMap.get("chargeinfo");
            if (null != chargeinfo && chargeinfo.size() > 0) {
                ArrayList leaderIds = new ArrayList(chargeinfo.size());
                for (Object temp : chargeinfo) {
                    Object idTemp = temp.get("id");
                    if (idTemp == null) continue;
                    leaderIds.add(idTemp);
                }
                if (leaderIds != null && leaderIds.size() > 0) {
                    logger.info("initOrgLeaderAndSuperior-1>{}", (Object)JSON.toJSONString(leaderIds));
                    dataModel.setValue("curorgleader", (Object)leaderIds.toArray());
                }
            }
            if (null != (superiorinfo = (List)empFileMap.get("superiorinfo")) && superiorinfo.size() > 0) {
                ArrayList superiorIds = new ArrayList(superiorinfo.size());
                for (Map temp : superiorinfo) {
                    Object idTemp = temp.get("id");
                    if (idTemp == null) continue;
                    superiorIds.add(idTemp);
                }
                if (superiorIds != null && superiorIds.size() > 0) {
                    logger.info("initOrgLeaderAndSuperior-2>{}", (Object)JSON.toJSONString(superiorIds));
                    dataModel.setValue("cursuperior", (Object)superiorIds.toArray());
                }
            }
            if ((locationId = empFileMap.get("location_id")) != null) {
                dataModel.setValue("curlocation", locationId);
            }
            if ((jobId = empFileMap.get("job_id")) != null) {
                dataModel.setValue("curjob", jobId);
            }
        }
    }

    private static void initJobLevelAndGrade(IDataModel dataModel, Map<String, Object> employeeMap) {
        List<Map<String, Object>> list;
        Long empId = (Long)employeeMap.get("id");
        if (empId != null && (list = ExtHRPIEmployeeService.getEmpJobRelObj(empId)) != null && list.size() > 0) {
            Map<String, Object> empJobRelMap = list.get(0);
            for (Map<String, Object> row : list) {
                Boolean iscurrentversion = (Boolean)row.get("iscurrentversion");
                if (!iscurrentversion.booleanValue()) continue;
                empJobRelMap = row;
                break;
            }
            if (empJobRelMap.get("joblevel_id") != null) {
                dataModel.setValue("curjoblevel", empJobRelMap.get("joblevel_id"));
            }
            if (empJobRelMap.get("jobgrade_id") != null) {
                dataModel.setValue("curjobgrade", empJobRelMap.get("jobgrade_id"));
            }
        }
    }

    @Deprecated
    private static void initHeadAppFileMsg(DynamicObject appFileDy, IFormView formView) {
        Label orgNameLabel = (Label)formView.getControl("orgname");
        DynamicObject org = (DynamicObject)formView.getModel().getValue("createorg");
        if (org != null) {
            orgNameLabel.setText(org.getString("name"));
        } else {
            orgNameLabel.setText("");
        }
    }

    private static void clearInitData(IFormView formView, IDataModel dataModel) {
        dataModel.setValue("appfilesex", (Object)"");
        dataModel.setValue("appfileage", (Object)"");
        Label orgNameLabel = (Label)formView.getControl("orgname");
        orgNameLabel.setText("");
        dataModel.setValue("createorg", null);
        dataModel.setValue("fullname", null);
        dataModel.setValue(KEY_EMPLOYEENUM, null);
        dataModel.setValue("appfilesex", null);
        dataModel.setValue("appfileage", null);
        dataModel.setValue("phone", null);
        dataModel.setValue("appfilemajor", null);
        dataModel.setValue("curpostpattern", null);
        dataModel.setValue("curposition", null);
        dataModel.setValue("curjob", null);
        dataModel.setValue("curcompany", null);
        dataModel.setValue("curorg", null);
        dataModel.setValue("curposttype", null);
        dataModel.setValue("postpattern", null);
        dataModel.setValue("position", null);
        dataModel.setValue("stposition", null);
        dataModel.setValue("job", null);
        dataModel.setValue("org", null);
        dataModel.setValue(KEY_COMPANY, null);
        dataModel.setValue("posttype", null);
    }

    private static void initSetFlexPanel(IFormView formView, Boolean visible) {
        formView.setVisible(visible, new String[]{"flexnewhead"});
        formView.setVisible(visible, new String[]{"curjobrankflex", "jobrankflex", "billremark", "billattach"});
    }

    private static void setLabelText(IFormView formView, String key, Object value) {
        Label label = (Label)formView.getControl(key);
        String text = "-";
        if (value != null) {
            if (value instanceof DynamicObject) {
                String targetValue = ((DynamicObject)value).getString("name");
                if (StringUtils.isNotEmpty((String)targetValue)) {
                    text = targetValue;
                }
            } else if (value instanceof String) {
                text = (String)value;
            }
        }
        label.setText(text);
    }

    private static void setLblMultiBaseDataText(IFormView view, IDataModel model, String labelName, String propertyName) {
        Label lblsource = (Label)view.getControl(labelName);
        DynamicObjectCollection dy = (DynamicObjectCollection)model.getValue(propertyName);
        if (!HireApprovalViewService.isEmpty(dy)) {
            DynamicObjectCollection value = (DynamicObjectCollection)model.getValue(propertyName);
            List collect = value.stream().filter(item -> item.get("fbasedataid") != null).map(temp -> ((DynamicObject)temp.get("fbasedataid")).getString("name")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                String join = StringUtils.join((Object[])collect.toArray(), (String)"\uff0c");
                lblsource.setText(join);
            } else {
                lblsource.setText("-");
            }
        } else {
            lblsource.setText("-");
        }
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty() || collection.size() == 0;
    }

    public static boolean verifyPositionAndJob(IFormView formView, IDataModel dataModel) {
        HireVerifyResult verifyResult;
        List fails;
        DynamicObject appFileDy = (DynamicObject)dataModel.getValue("appfile");
        if (appFileDy != null && (fails = (List)(verifyResult = HireApprovalService.verifyPositionAndJob(Collections.singletonList(dataModel.getDataEntity()))).getFailReason().get(appFileDy.getLong("id"))) != null) {
            formView.showTipNotification(String.join((CharSequence)",", fails));
            return false;
        }
        return true;
    }

    public static List<QFilter> handleSocAreaF7(Long appFileId) {
        return HireQFilterService.getSocAreaFilter(appFileId);
    }

    public static List<QFilter> handleJobScmF7(Long appFileId) {
        return HireQFilterService.getJobScmFilter(appFileId);
    }

    public static List<QFilter> handleJobLevelF7(IDataModel dataModel) {
        DynamicObject job = (DynamicObject)dataModel.getValue("job");
        if (job != null) {
            return HireQFilterService.getLevelFilter(job);
        }
        return Collections.emptyList();
    }

    public static List<QFilter> handleJobGradeF7(IDataModel dataModel) {
        DynamicObject job = (DynamicObject)dataModel.getValue("job");
        if (job != null) {
            return HireQFilterService.getGradeFilter(job);
        }
        return Collections.emptyList();
    }

    public static List<QFilter> handlePosttypeF7Select() {
        return HireQFilterService.getPosttypeFilter();
    }

    @Deprecated
    public static List<QFilter> handleJobRankAdminOrgF7(String appId, String entityNumber) {
        return HireQFilterService.getJobRankAdminOrgFilter(appId, entityNumber, "org");
    }

    public static void handelPositionJobInfoVisibleAndEnableForAdd(IFormView formView, IDataModel dataModel) {
        Long jobId;
        DynamicObject positionDyn = (DynamicObject)dataModel.getValue("position");
        Long l = jobId = positionDyn == null ? Long.valueOf(0L) : HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionDyn, (String)"job");
        if (!jobId.equals(0L)) {
            formView.setEnable(Boolean.FALSE, new String[]{"jobscm", "job", "jobclass", "jobfamily", "jobseq"});
            formView.setEnable(Boolean.TRUE, new String[]{"joblevel", "jobgrade"});
        } else {
            formView.setEnable(Boolean.TRUE, new String[]{"job"});
            DynamicObject job = (DynamicObject)dataModel.getValue("job");
            formView.setEnable(Boolean.valueOf(job != null), new String[]{"joblevel", "jobgrade"});
            formView.setEnable(Boolean.FALSE, new String[]{"jobscm"});
        }
        formView.setEnable(Boolean.valueOf(positionDyn == null), new String[]{"org"});
    }

    @Deprecated
    public static void initEmployInfoModel(IDataModel dataModel, DynamicObject appFileDyn) {
        String posttype = "position.holdofftyp";
        DynamicObject postTypeDy = appFileDyn.getDynamicObject(posttype);
        if (postTypeDy != null) {
            dataModel.setValue("posttype", (Object)postTypeDy);
        }
    }

    public static void handlePositionChange(IFormView formView, IDataModel dataModel, Integer rowIndex, Object newVal, Object oldVal) {
        DynamicObject positionDynNew = (DynamicObject)newVal;
        Long jobIdNew = positionDynNew == null ? Long.valueOf(0L) : HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionDynNew, (String)"job");
        DynamicObject positionDynOld = (DynamicObject)oldVal;
        Long jobIdOld = positionDynOld == null ? Long.valueOf(0L) : HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionDynOld, (String)"job");
        HireApprovalViewService.setEnable(formView, "jobscm", Boolean.TRUE, rowIndex);
        HireApprovalViewService.setEnable(formView, "job", Boolean.TRUE, rowIndex);
        if (!jobIdNew.equals(0L)) {
            Long jobScmId = HireApprovalDomainService.getJobScmIdFromJobId(jobIdNew);
            HireApprovalViewService.setDataModel(dataModel, "jobscm", jobScmId, rowIndex);
            HireApprovalViewService.setDataModel(dataModel, "job", jobIdNew, rowIndex);
            HireApprovalViewService.lockJobInfo(true, true, rowIndex, formView);
        } else {
            DynamicObject jobScm = (DynamicObject)HireApprovalViewService.getVal(dataModel, "jobscm", rowIndex);
            HireApprovalViewService.lockJobInfo(false, jobScm == null, rowIndex, formView);
        }
        HireApprovalViewService.handleCleanJobInfo(jobIdOld, jobIdNew, rowIndex, formView, dataModel);
    }

    public static void handlePositionChangeForAdminOrg(IFormView formView, IDataModel dataModel, Object newVal, Object oldVal) {
        DynamicObject positionDynNew = (DynamicObject)newVal;
        DynamicObject positionDynOld = (DynamicObject)oldVal;
        if (positionDynOld != null && positionDynNew == null) {
            dataModel.setValue("org", null);
            formView.setEnable(Boolean.TRUE, new String[]{"org"});
        }
        if (positionDynNew != null) {
            dataModel.setValue("org", (Object)positionDynNew.getDynamicObject("adminorg"));
            formView.setEnable(Boolean.FALSE, new String[]{"org"});
        }
    }

    public static void handleJobChange(IFormView formView, IDataModel dataModel, Integer rowIndex, Object newVal, Object oldVal) {
        DynamicObject jobNew = (DynamicObject)newVal;
        HireApprovalViewService.setEnable(formView, "joblevel", jobNew != null, rowIndex);
        HireApprovalViewService.setEnable(formView, "jobgrade", jobNew != null, rowIndex);
        HireApprovalViewService.setEnable(formView, "job", Boolean.TRUE, rowIndex);
        HireApprovalViewService.setEnable(formView, "org", Boolean.TRUE, rowIndex);
        HireApprovalViewService.setDataModel(dataModel, "joblevel", null, rowIndex);
        HireApprovalViewService.setDataModel(dataModel, "jobgrade", null, rowIndex);
    }

    public static void handelJobChangeForClassFamilySeq(IFormView formView, IDataModel dataModel, Object newVal, Object oldVal) {
        DynamicObject jobNew = (DynamicObject)newVal;
        DynamicObject jobOld = (DynamicObject)oldVal;
        if (jobOld != null && jobNew == null) {
            dataModel.setValue("jobclass", null);
            dataModel.setValue("jobfamily", null);
            dataModel.setValue("jobseq", null);
            dataModel.setValue("jobscm", null);
        }
        if (jobNew != null) {
            dataModel.setValue("jobclass", (Object)jobNew.getDynamicObject("jobclass"));
            dataModel.setValue("jobfamily", (Object)jobNew.getDynamicObject("jobfamily"));
            dataModel.setValue("jobseq", (Object)jobNew.getDynamicObject("jobseq"));
            dataModel.setValue("jobscm", (Object)jobNew.getDynamicObject("jobscm"));
        }
    }

    private static void lockJobInfo(boolean lockScm, boolean lockJob, Integer rowIndex, IFormView formView) {
        HireApprovalViewService.setEnable(formView, "jobscm", !lockScm, rowIndex);
        HireApprovalViewService.setEnable(formView, "job", !lockJob, rowIndex);
    }

    private static void handleCleanJobInfo(Long jobIdOld, Long jobIdNew, Integer rowIndex, IFormView formView, IDataModel dataModel) {
        if (!jobIdOld.equals(0L) && jobIdNew.equals(0L)) {
            HireApprovalViewService.setDataModel(dataModel, "jobscm", null, rowIndex);
            HireApprovalViewService.setDataModel(dataModel, "job", null, rowIndex);
            HireApprovalViewService.lockJobInfo(false, true, rowIndex, formView);
        }
    }

    private static void setDataModel(IDataModel dataModel, String key, Object val, Integer rowIndex) {
        if (rowIndex != null) {
            dataModel.setValue(key, val, rowIndex.intValue());
        } else {
            dataModel.setValue(key, val);
        }
    }

    private static void setEnable(IFormView formView, String key, Boolean enable, Integer rowIndex) {
        if (rowIndex != null) {
            formView.setEnable(enable, rowIndex.intValue(), new String[]{key});
        } else {
            formView.setEnable(enable, new String[]{key});
        }
    }

    private static Object getVal(IDataModel dataModel, String key, Integer rowIndex) {
        if (rowIndex != null) {
            return dataModel.getValue(key, rowIndex.intValue());
        }
        return dataModel.getValue(key);
    }

    private static void setVisible(IFormView formView, IDataModel dataModel) {
        Boolean sexFlag = dataModel.getValue("appfilesex") != null;
        formView.setVisible(sexFlag, new String[]{"iconsex1", "appfilesex", "iconsex2", "bdappfilesex"});
        Integer age = (Integer)dataModel.getValue("appfileage");
        Boolean ageFlag = age != null && age > 0;
        formView.setVisible(ageFlag, new String[]{"iconage1", "appfileage", "iconage2", "txtappfileage"});
        Boolean majorFlag = StringUtils.isNotBlank((String)((String)dataModel.getValue("appfilemajor")));
        formView.setVisible(majorFlag, new String[]{"iconmajor1", "appfilemajor", "iconmajor2", "txtappfilemajor"});
        Boolean phoneFlag = StringUtils.isNotBlank((String)((String)dataModel.getValue("phone")));
        formView.setVisible(phoneFlag, new String[]{"iconphone1", "phone", "iconphone2", "txtphone"});
    }
}

