/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hire.approval;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.hire.approval.common.HireCommonKDStringHelper;

public class HireHandleKeyFieldChangeService {
    private static final String DELIMITER = "\u3001";
    public static final String BASE_DATA_DIRTY_FIX = "_id";
    private static final Map<String, String> JOBRANKMAP = Maps.newHashMap();
    private static final Map<String, String> APPROVALMAP = Maps.newHashMap();

    public static Map<Long, String> approvalHandleKeyFieldChange(DynamicObject[] dyArr) {
        HashMap supplementMap = Maps.newHashMapWithExpectedSize((int)dyArr.length);
        for (DynamicObject dy : dyArr) {
            DynamicObject appFileDy = dy.getDynamicObject("appfile");
            if (appFileDy == null) continue;
            String auditStatus = dy.getString("billstatus");
            if (HRStringUtils.equals((String)auditStatus, (String)"G") || HRStringUtils.equals((String)auditStatus, (String)"A")) {
                supplementMap.put(appFileDy.getLong("id"), HireHandleKeyFieldChangeService.handleKeyFieldChange(dy, APPROVALMAP));
                continue;
            }
            supplementMap.put(appFileDy.getLong("id"), null);
        }
        return supplementMap;
    }

    private static String handleKeyFieldChange(DynamicObject dy, Map<String, String> map) {
        Iterable bizChangedProperties = dy.getDataEntityState().getBizChangedProperties();
        Iterator bizChangeProps = bizChangedProperties.iterator();
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        while (bizChangeProps.hasNext()) {
            IDataEntityProperty next = (IDataEntityProperty)bizChangeProps.next();
            String key = next.getName();
            if (!map.containsKey(key)) continue;
            list.add(map.get(key));
        }
        return list.size() > 0 ? String.join((CharSequence)DELIMITER, list) : null;
    }

    static {
        JOBRANKMAP.put("position_id", HireCommonKDStringHelper.position());
        JOBRANKMAP.put("org_id", HireCommonKDStringHelper.dept());
        JOBRANKMAP.put("jobscm_id", HireCommonKDStringHelper.jobScm());
        JOBRANKMAP.put("job_id", HireCommonKDStringHelper.job());
        JOBRANKMAP.put("joblevel_id", HireCommonKDStringHelper.jobLevel());
        JOBRANKMAP.put("jobgrade_id", HireCommonKDStringHelper.jobGradle());
        JOBRANKMAP.put("workaddr_id", HireCommonKDStringHelper.workAddr());
        JOBRANKMAP.put("posttype_id", HireCommonKDStringHelper.postType());
        JOBRANKMAP.put("labrelstatuscls_id", HireCommonKDStringHelper.labRelStatusCls());
        JOBRANKMAP.put("isprobation", HireCommonKDStringHelper.isProbation());
        JOBRANKMAP.put("probationnum", HireCommonKDStringHelper.proBationNum());
        APPROVALMAP.putAll(JOBRANKMAP);
    }
}

