/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hire.approval;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.hire.approval.common.HireOpRecordKDStringHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;
import org.jetbrains.annotations.NotNull;

public class HireOpRecordService {
    private static final Log LOG = LogFactory.getLog(HireOpRecordService.class);
    private static final String CLICKNUMBER = "clicknumber";
    private static final String SKIPFORMID = "skipFormId";
    private static final String SKIPPKID = "skipPKId";
    private static final String HAVEEDIT = "haveEdit";
    private static final HireOpRecordService INSTANCE = new HireOpRecordService();
    private final Map<OpDefEnum, OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>>> consumerMap = Maps.newHashMap();
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> hireRecInitiate = this::hireRecInitiateOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> recommendFeedBack = this::recommendFeedBackOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> hireJobRankInit = this::hireJobRankInitOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> jobRankTaskFeedBack = this::jobRankTaskFeedBackOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> directHireJobRank = this::directHireJobRankOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> editHireJobRank = this::editHireJobRankOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> cancelJobRank = this::cancelJobRankOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> directSalary = this::directSalaryOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> hireSalaryTask = this::hireSalaryTaskOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> salaryTaskFeedBack = this::salaryTaskFeedBackOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> editSalary = this::editSalaryOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> revokeSalaryTask = this::revokeSalaryTaskOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> editEmployAppForm = this::editEmployAppFormOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> hireApproval = this::hireApprovalOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> revokeEmployAppForm = this::revokeEmployAppFormOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> subEffEmpAppForm = this::subEffEmpAppFormOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> abandonEmpAppForm = this::abandonEmpAppFormOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> deleteEmpAppForm = this::deleteEmpAppFormOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> extEmpAppForm = this::extEmpAppFormOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> agreeEmpExamine = this::agreeEmpExamineOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> disagreeEmpExamine = this::disagreeEmpExamineOpRecord;

    public static HireOpRecordService getInstance() {
        return INSTANCE;
    }

    private HireOpRecordService() {
    }

    public void sendOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        OpRecordFunction<String, OpDefEnum, List<Long>, Map<Long, String>, Map<String, Object>> opRecConsumer = this.consumerMap.get(opDefEnum);
        if (opRecConsumer != null) {
            List<OprecordMessageModel> msgList = opRecConsumer.getOpRecordList(roleName, opDefEnum, appFileIdList, supplementMap, params);
            try {
                OprecordMQ.sendOpRecordChangeMessage(msgList);
            }
            catch (KDException ex) {
                LOG.error("OprecordMQ.sendOpRecordChangeMessage.error:", (Throwable)ex);
            }
        }
    }

    private List<OprecordMessageModel> hireRecInitiateOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        String descFmt = HireOpRecordKDStringHelper.hireRecInitiateOpRecordDesc();
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> recommendFeedBackOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        String descFmt = HireOpRecordKDStringHelper.getHireRecommendOpRecordDesc();
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> hireJobRankInitOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        String descFmt = HireOpRecordKDStringHelper.hireJobRankInitOpRecordDesc();
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> jobRankTaskFeedBackOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        String descFmt = HireOpRecordKDStringHelper.jobRankTaskFeedBackOpRecordDesc();
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> directHireJobRankOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, HireOpRecordKDStringHelper.directHireJobRankOpRecordDesc());
    }

    private List<OprecordMessageModel> editHireJobRankOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        String eliminateOpRecordDesc = HireOpRecordKDStringHelper.editHireJobRankOpRecordDesc();
        String eliminateOpRecordDescWithField = HireOpRecordKDStringHelper.editHireJobRankWithFieldOpRecordDesc();
        return this.getOpRecordMessageModelWithOPField(roleName, opDefEnum, HireOpRecordKDStringHelper.editStr(), appFileIdList, eliminateOpRecordDesc, eliminateOpRecordDescWithField, supplementMap, params);
    }

    private List<OprecordMessageModel> cancelJobRankOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, HireOpRecordKDStringHelper.cancelJobRankOpRecordDesc());
    }

    private List<OprecordMessageModel> directSalaryOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, HireOpRecordKDStringHelper.directSalaryOpRecordDesc());
    }

    private List<OprecordMessageModel> hireSalaryTaskOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, HireOpRecordKDStringHelper.hireSalaryTaskOpRecordDesc());
    }

    private List<OprecordMessageModel> salaryTaskFeedBackOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModel(roleName, opDefEnum, appFileIdList, HireOpRecordKDStringHelper.salaryTaskFeedBackOpRecordDesc());
    }

    private List<OprecordMessageModel> editSalaryOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        String eliminateOpRecordDesc = HireOpRecordKDStringHelper.editSalaryOpRecordDesc();
        String eliminateOpRecordDescWithField = HireOpRecordKDStringHelper.editSalaryWithFieldOpRecordDesc();
        return this.getOpRecordMessageModelWithOPField(roleName, opDefEnum, HireOpRecordKDStringHelper.editStr(), appFileIdList, eliminateOpRecordDesc, eliminateOpRecordDescWithField, supplementMap, params);
    }

    private List<OprecordMessageModel> revokeSalaryTaskOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModelWithApprovalOP(roleName, opDefEnum, HireOpRecordKDStringHelper.revokeStr(), appFileIdList, HireOpRecordKDStringHelper.revokeSalaryTaskOpRecordDesc(), params);
    }

    private List<OprecordMessageModel> editEmployAppFormOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        String editDesc = HireOpRecordKDStringHelper.editEmployAppFormOpRecordDesc();
        String editDescWithField = HireOpRecordKDStringHelper.editEmployAppFormWithFieldOpRecordDesc();
        return this.getOpRecordMessageModelWithOPField(roleName, opDefEnum, HireOpRecordKDStringHelper.editStr(), appFileIdList, editDesc, editDescWithField, supplementMap, params);
    }

    private List<OprecordMessageModel> hireApprovalOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        for (DynamicObject appFile : appFiles) {
            this.editOpRecordMessage(roleName, supplementMap, params, msgList, appFile);
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile, params);
            String oprText = String.format(HireOpRecordKDStringHelper.hireApprovalOpRecordDesc(), message.getOperatorname(), appFile.getString("position.name"), message.getBizobjname());
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private void editOpRecordMessage(String roleName, Map<Long, String> supplementMap, Map<String, Object> params, List<OprecordMessageModel> msgList, DynamicObject appFile) {
        Map pageMap;
        Boolean haveEdit;
        long appFileId = appFile.getLong("id");
        String editDesc = HireOpRecordKDStringHelper.editEmployAppFormOpRecordDesc();
        String editDescWithField = HireOpRecordKDStringHelper.editEmployAppFormWithFieldOpRecordDesc();
        if (params != null && (haveEdit = (Boolean)(pageMap = (Map)params.get(String.valueOf(appFileId))).get(HAVEEDIT)) != null && haveEdit.booleanValue()) {
            OprecordMessageModel message = this.getEditOpRecordMessage(roleName, OpDefEnum.TSIRM_EDIT_EMPLOY_APPFORM, HireOpRecordKDStringHelper.editStr(), editDesc, editDescWithField, supplementMap, params, appFile);
            msgList.add(message);
        }
    }

    private List<OprecordMessageModel> revokeEmployAppFormOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModelWithApprovalOP(roleName, opDefEnum, HireOpRecordKDStringHelper.revokeStr(), appFileIdList, HireOpRecordKDStringHelper.revokeEmployAppFormOpRecordDesc(), params);
    }

    private List<OprecordMessageModel> subEffEmpAppFormOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        for (DynamicObject appFile : appFiles) {
            this.editOpRecordMessage(roleName, supplementMap, params, msgList, appFile);
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile, params);
            String oprText = String.format(HireOpRecordKDStringHelper.subEffEmpAppFormOpRecordDesc(), message.getOperatorname(), HireOpRecordKDStringHelper.subEffStr(), appFile.getString("position.name"), message.getBizobjname());
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private List<OprecordMessageModel> abandonEmpAppFormOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModelWithApprovalOP(roleName, opDefEnum, HireOpRecordKDStringHelper.abandonStr(), appFileIdList, HireOpRecordKDStringHelper.abandonEmpAppFormOpRecordDesc(), params);
    }

    private List<OprecordMessageModel> deleteEmpAppFormOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModelWithApprovalOP(roleName, opDefEnum, HireOpRecordKDStringHelper.deleteStr(), appFileIdList, HireOpRecordKDStringHelper.deleteEmpAppFormOpRecordDesc(), params);
    }

    private List<OprecordMessageModel> extEmpAppFormOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModelWithApprovalOP(roleName, opDefEnum, HireOpRecordKDStringHelper.extStr(), appFileIdList, HireOpRecordKDStringHelper.extEmpAppFormOpRecordDesc(), params);
    }

    private List<OprecordMessageModel> agreeEmpExamineOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModelWithApprovalOP(roleName, opDefEnum, HireOpRecordKDStringHelper.agreeStr(), appFileIdList, HireOpRecordKDStringHelper.agreeEmpExamineOpRecordDesc(), params);
    }

    private List<OprecordMessageModel> disagreeEmpExamineOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap, Map<String, Object> params) {
        return this.getOpRecordMessageModelWithApprovalOP(roleName, opDefEnum, HireOpRecordKDStringHelper.disagreeStr(), appFileIdList, HireOpRecordKDStringHelper.disagreeEmpExamineOpRecordDesc(), params);
    }

    private List<OprecordMessageModel> getOpRecordMessageModel(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, String eliminateOpRecordDesc) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        for (DynamicObject appFile : appFiles) {
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile);
            String oprText = String.format(eliminateOpRecordDesc, message.getOperatorname(), appFile.getString("position.name"), message.getBizobjname());
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private List<OprecordMessageModel> getOpRecordMessageModelWithOPField(String roleName, OpDefEnum opDefEnum, String op, List<Long> appFileIdList, String editDesc, String editDescWithField, Map<Long, String> supplementMap, Map<String, Object> params) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        for (DynamicObject appFile : appFiles) {
            OprecordMessageModel message = this.getEditOpRecordMessage(roleName, opDefEnum, op, editDesc, editDescWithField, supplementMap, params, appFile);
            msgList.add(message);
        }
        return msgList;
    }

    @NotNull
    private OprecordMessageModel getEditOpRecordMessage(String roleName, OpDefEnum opDefEnum, String op, String editDesc, String editDescWithField, Map<Long, String> supplementMap, Map<String, Object> params, DynamicObject appFile) {
        OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile, params);
        long appFileId = appFile.getLong("id");
        String oprText = supplementMap != null && supplementMap.get(appFileId) != null ? String.format(editDescWithField, message.getOperatorname(), op, appFile.getString("position.name"), message.getBizobjname(), supplementMap.get(appFileId)) : String.format(editDesc, message.getOperatorname(), op, appFile.getString("position.name"), message.getBizobjname());
        message.setOprtext(oprText);
        return message;
    }

    private List<OprecordMessageModel> getOpRecordMessageModelWithApprovalOP(String roleName, OpDefEnum opDefEnum, String op, List<Long> appFileIdList, String desc, Map<String, Object> params) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        for (DynamicObject appFile : appFiles) {
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile, params);
            String oprText = String.format(desc, message.getOperatorname(), op, appFile.getString("position.name"), message.getBizobjname());
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private OprecordMessageModel getOpRecordMessageModel(String roleName, OpDefEnum opDefEnum, DynamicObject appFile, Map<String, Object> params) {
        long appFileId;
        Map pageMap;
        OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile);
        if (params != null && params.size() > 0 && (pageMap = (Map)params.get(String.valueOf(appFileId = appFile.getLong("id")))) != null) {
            message.setClicknumber((String)pageMap.get(CLICKNUMBER));
            message.setSkipFormId((String)pageMap.get(SKIPFORMID));
            message.setSkipPKId((String)pageMap.get(SKIPPKID));
        }
        return message;
    }

    private OprecordMessageModel getOpRecordMessageModel(String roleName, OpDefEnum opDefEnum, DynamicObject appFile) {
        OprecordMessageModel message = new OprecordMessageModel();
        message.setBizentry("tsirm_appfilemdl");
        message.setOperatorrole(roleName);
        message.setOperator(Long.valueOf(TSCRequestContext.getUserId()));
        message.setOperatorname(RequestContext.get().getUserName());
        message.setBizobj(appFile.getLong("id"));
        message.setBizobjname(appFile.getString("name"));
        message.setBizobjrole("\u5019\u9009\u4eba");
        message.setOptime(HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        message.setOpnumber(opDefEnum.getCode());
        return message;
    }

    private DynamicObject[] getAppFiles(List<Long> appFileIdList) {
        String selectProps = TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"name", "position"});
        return AppFileHelper.queryAppFiles(appFileIdList, selectProps);
    }

    static {
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_HIRE_REC_INITIATE, HireOpRecordService.INSTANCE.hireRecInitiate);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.EMPLOY_CONFIRM_FEEDBACK, HireOpRecordService.INSTANCE.recommendFeedBack);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.HIRE_JOB_RANK_INIT, HireOpRecordService.INSTANCE.hireJobRankInit);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.HIRE_JOB_RANK_INTSING_FEEDBACK, HireOpRecordService.INSTANCE.jobRankTaskFeedBack);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.HIRE_JOB_RANK_INITSING, HireOpRecordService.INSTANCE.directHireJobRank);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.EDIT_HIRE_JOB_RANK_INTS, HireOpRecordService.INSTANCE.editHireJobRank);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.REVOKE_HIRE_JOB_RANK_INTS, HireOpRecordService.INSTANCE.cancelJobRank);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.DIRECT_SALARY, HireOpRecordService.INSTANCE.directSalary);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.HIRE_SALARY_TASK, HireOpRecordService.INSTANCE.hireSalaryTask);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.SALARY_TASK_FEEDBACK, HireOpRecordService.INSTANCE.salaryTaskFeedBack);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.EDIT_SALARY, HireOpRecordService.INSTANCE.editSalary);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.REVOKE_SALARY_TASK, HireOpRecordService.INSTANCE.revokeSalaryTask);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_EDIT_EMPLOY_APPFORM, HireOpRecordService.INSTANCE.editEmployAppForm);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_HIRE_APPROVAL, HireOpRecordService.INSTANCE.hireApproval);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_REVOKE_EMPLOY_APPFORM, HireOpRecordService.INSTANCE.revokeEmployAppForm);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_SUB_EFF_EMP_APPFORM, HireOpRecordService.INSTANCE.subEffEmpAppForm);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_ABANDON_EMP_APPFORM, HireOpRecordService.INSTANCE.abandonEmpAppForm);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_DELETE_EMP_APPFORM, HireOpRecordService.INSTANCE.deleteEmpAppForm);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_EXT_EMP_APPFORM, HireOpRecordService.INSTANCE.extEmpAppForm);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_AGREE_EMP_EXAMINE, HireOpRecordService.INSTANCE.agreeEmpExamine);
        HireOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_DISAGREE_EMP_EXAMINE, HireOpRecordService.INSTANCE.disagreeEmpExamine);
    }

    @FunctionalInterface
    private static interface OpRecordFunction<A, B, C, D, E> {
        public List<OprecordMessageModel> getOpRecordList(A var1, B var2, C var3, D var4, E var5);
    }
}

