/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hire.approval;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.HbssJobAdapter;
import kd.tsc.tsirm.common.enums.TSIRMPreDataEnum;
import kd.tsc.tsrbs.business.domain.common.service.AdminAndOrgHelper;
import kd.tsc.tsrbs.business.domain.common.service.ControlledDataCommonHelper;

public class HireQFilterService {
    public static List<QFilter> getPosttypeFilter() {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)1);
        filters.add(new QFilter("postcategory", "in", (Object)Lists.newArrayList((Object[])new Long[]{TSIRMPreDataEnum.POSTCATEGORY_FULLTIME.getId(), TSIRMPreDataEnum.POSTCATEGORY_PARTTIME.getId()})));
        return filters;
    }

    public static List<QFilter> getLaborrelTypeClsFilter() {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)3);
        QFilter syspresetQfilter = new QFilter("enable", "=", (Object)"1");
        filters.add(syspresetQfilter);
        return filters;
    }

    public static List<QFilter> getGradeFilter(DynamicObject job) {
        ArrayList returnQFilters = Lists.newArrayList();
        Long low = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)job, (String)"lowjobgrade");
        Long height = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)job, (String)"highjobgrade");
        if (low.equals(0L) || height.equals(0L)) {
            long jobscmId = job.getLong("jobscm.id");
            long jobfamilyId = job.getLong("jobfamily.id");
            QFilter jobGradeFilter = HireQFilterService.getJobGradeFilterByJobScmIdsAndJobFamilyIds(Collections.singletonList(jobscmId), Collections.singletonList(jobfamilyId));
            if (jobGradeFilter != null) {
                returnQFilters.add(jobGradeFilter);
            } else {
                returnQFilters.add(new QFilter("id", "=", (Object)0L));
            }
            return returnQFilters;
        }
        List<Long> gradeRangeByGradeId = HbssJobAdapter.getJobGradeRangeByGradeId(low, height);
        if (gradeRangeByGradeId != null && !gradeRangeByGradeId.isEmpty()) {
            returnQFilters.add(new QFilter("id", "in", gradeRangeByGradeId));
        } else {
            returnQFilters.add(new QFilter("id", "=", (Object)0L));
        }
        return returnQFilters;
    }

    public static List<QFilter> getLevelFilter(DynamicObject job) {
        ArrayList returnQFilters = Lists.newArrayList();
        Long low = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)job, (String)"lowjoblevel");
        Long height = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)job, (String)"highjoblevel");
        if (low.equals(0L) || height.equals(0L)) {
            long jobscmId = job.getLong("jobscm.id");
            long jobfamilyId = job.getLong("jobfamily.id");
            QFilter jobLevelFilter = HireQFilterService.getJobLevelFilterByJobScmIdsAndJobFamilyIds(Collections.singletonList(jobscmId), Collections.singletonList(jobfamilyId));
            if (jobLevelFilter != null) {
                returnQFilters.add(jobLevelFilter);
            } else {
                returnQFilters.add(new QFilter("id", "=", (Object)0L));
            }
            return returnQFilters;
        }
        List<Long> jobLevelRangeByLevelId = HbssJobAdapter.getJobLevelRangeByLevelId(low, height);
        if (jobLevelRangeByLevelId != null && !jobLevelRangeByLevelId.isEmpty()) {
            returnQFilters.add(new QFilter("id", "in", jobLevelRangeByLevelId));
        } else {
            returnQFilters.add(new QFilter("id", "=", (Object)0L));
        }
        return returnQFilters;
    }

    public static QFilter getJobLevelFilterByJobScmIdsAndJobFamilyIds(List<Long> jobScmIds, List<Long> jobFamilyIds) {
        DynamicObject[] dynamicObjects = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMService", (String)"getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds", (Object[])new Object[]{jobScmIds, jobFamilyIds});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject scmDynamicObj = dynamicObjects[0];
            DynamicObject joblevelscmObj = scmDynamicObj.getDynamicObject("joblevelscm");
            if (joblevelscmObj == null) {
                return null;
            }
            DynamicObjectCollection collection = joblevelscmObj.getDynamicObjectCollection("entryentity");
            List list = collection.stream().map(entry -> entry.getLong("id")).collect(Collectors.toList());
            return new QFilter("id", "in", list);
        }
        return null;
    }

    public static QFilter getJobGradeFilterByJobScmIdsAndJobFamilyIds(List<Long> jobScmIds, List<Long> jobFamilyIds) {
        DynamicObject[] dynamicObjects = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMService", (String)"getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds", (Object[])new Object[]{jobScmIds, jobFamilyIds});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject scmDynamicObj = dynamicObjects[0];
            DynamicObject jobgradescmObj = scmDynamicObj.getDynamicObject("jobgradescm");
            if (jobgradescmObj == null) {
                return null;
            }
            DynamicObjectCollection collection = jobgradescmObj.getDynamicObjectCollection("entryentity");
            List list = collection.stream().map(entry -> entry.getLong("id")).collect(Collectors.toList());
            return new QFilter("id", "in", list);
        }
        return null;
    }

    public static List<QFilter> getSocAreaFilter(Long appFileId) {
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tsirm_appfilemdl");
        DynamicObject appFileDyn = appFileService.queryOne("createorg", (Object)appFileId);
        if (appFileDyn != null) {
            return ControlledDataCommonHelper.getEnableAndPassStatusQFilter((String)"hbpm", (String)"hbss_socarea", (Long)appFileDyn.getLong("createorg.id"));
        }
        return Collections.singletonList(new QFilter("id", "=", (Object)0));
    }

    public static List<QFilter> getJobScmFilter(Long appFileId) {
        return Collections.emptyList();
    }

    public static List<QFilter> getJobRankAdminOrgFilter(String appId, String entityNumber, String propKey) {
        return Collections.singletonList(new QFilter("id", "in", (Object)AdminAndOrgHelper.getUserAdminOrgsF7((String)appId, (String)entityNumber, (String)propKey)));
    }
}

