/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.hr.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.hr.IBizHandleService;
import kd.tsc.tsirm.business.domain.stdrsm.rule.StdRsmBuildParamService;
import kd.tsc.tsirm.business.domain.stdrsm.service.laborrel.impl.LaborRelStatusServiceImpl;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.domain.rule.service.AutoRuleFactory;
import kd.tsc.tsrbs.common.constants.rpc.HrmpConstants;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Triple;

public class HtmHandleServiceImpl
implements IBizHandleService {
    private static final Log log = LogFactory.getLog(HtmHandleServiceImpl.class);
    private static final List<Long> labRelStatusClsIdList = new ArrayList<Long>();

    public HtmHandleServiceImpl() {
        labRelStatusClsIdList.add(HrmpConstants.HAVE_LEFT_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.RETIRE_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_LEFT_DIE_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_LEFT_RETIRE_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_RE_INDUCTION_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_RE_EMPLOY_NUMBER);
    }

    @Override
    public void handle(DynamicObject dynamicObject) {
        Long recordId = this.getRecordIdHandle(dynamicObject);
        log.info("HtmHandleServiceImpl.handle.recordId -> {}", (Object)recordId);
        Triple employeeTriple = hrService.getEmployeeTriple(recordId);
        if (Objects.isNull(employeeTriple)) {
            return;
        }
        log.info("HtmHandleServiceImpl.handle.employeePair billId -> {}, employeeId -> {}, personId -> {}", new Object[]{employeeTriple.getLeft(), employeeTriple.getMiddle(), employeeTriple.getRight()});
        Map employeeMap = hrmpService.getEmployeeMap((Long)employeeTriple.getMiddle());
        if (MapUtils.isEmpty((Map)employeeMap)) {
            return;
        }
        log.info("HtmHandleServiceImpl.handle.candidateId -> {}, laborRelStatusId -> {}", employeeMap.get("candidate_id"), employeeMap.get("laborrelstatus_id"));
        DynamicObject laborRelStatus = hrmpService.getEmployeeLaborRelStatus((Long)employeeTriple.getMiddle());
        if (Objects.isNull(laborRelStatus)) {
            return;
        }
        Long labRelStatusClsId = laborRelStatus.getLong("labrelstatuscls.id");
        log.info("HtmHandleServiceImpl.handle.labRelStatusClsId -> {}", (Object)labRelStatusClsId);
        if (!labRelStatusClsIdList.contains(labRelStatusClsId)) {
            return;
        }
        Map htmQuitBillMap = hrService.getHtmQuitBill((Long)employeeTriple.getLeft());
        if (MapUtils.isEmpty((Map)htmQuitBillMap)) {
            return;
        }
        log.info("HtmHandleServiceImpl.handle.endDate -> {}", htmQuitBillMap.get("contractenddate"));
        Map primaryEmpPosOrgRelMap = hrService.getPrimaryEmpPosOrgRel((Long)employeeTriple.getRight());
        Map<String, Object> map = this.employeeMapHandle(employeeMap);
        this.htmMapHandle(employeeMap, map, htmQuitBillMap, (Triple<Long, Long, Long>)employeeTriple, labRelStatusClsId, primaryEmpPosOrgRelMap);
        map.put("personId", employeeTriple.getRight());
        this.laborRelStatusHandle(map);
    }

    private void laborRelStatusHandle(Map<String, Object> map) {
        LaborRelStatusServiceImpl service = new LaborRelStatusServiceImpl();
        DynamicObject stdRsm = service.laborRelStatusHandle(map);
        if (Objects.isNull(stdRsm)) {
            return;
        }
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)stdRsm);
        Map<String, DynamicObjectCollection> param = StdRsmBuildParamService.buildStdRsmParam(collection);
        List<Map<String, Object>> ruleEngineParam = StdRsmBuildParamService.buildRuleEngineParam(param, "tsirm_stdrsm");
        ArrayList<String> buNumberList = new ArrayList<String>(16);
        HRBaseServiceHelper talentHelper = new HRBaseServiceHelper("tsirm_talentpoolmgt");
        DynamicObject talentPoolDy = talentHelper.loadSingle((Object)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED);
        buNumberList.add(talentPoolDy.getString("org.number"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("stdrsm", "=", (Object)stdRsm.getLong("id"))});
        for (String buNumber : buNumberList) {
            HashMap baseRequestMap = Maps.newHashMapWithExpectedSize((int)8);
            baseRequestMap.put("bizApp", "tsirm");
            baseRequestMap.put("sceneNumber", "TSC_1020");
            baseRequestMap.put("buNumber", buNumber);
            boolean isHandleSucess = AutoRuleFactory.getDefaultAutoRuleService().executeBatch((Map)baseRequestMap, ruleEngineParam);
            if (isHandleSucess) continue;
            TalentListFunService.saveOneReserveRecord(stdRsm.getLong("id"), TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED);
        }
    }

    private void htmMapHandle(Map<String, Object> employeeMap, Map<String, Object> map, Map<String, Object> htmQuitBillMap, Triple<Long, Long, Long> employeeTriple, Long labRelStatusClsId, Map<String, Object> primaryEmpPosOrgRelMap) {
        map.put("laborreltime", employeeMap.get("enddate"));
        map.put("htmQuitBillMap", htmQuitBillMap);
        map.put("labRelType", "htm");
        map.put("employeeId", employeeTriple.getMiddle());
        map.put("labRelStatusClsId", labRelStatusClsId);
        map.put("posstatus_id", MapUtils.isEmpty(primaryEmpPosOrgRelMap) ? null : primaryEmpPosOrgRelMap.get("posstatus_id"));
        map.put("changetype", "D");
    }
}

