/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intreco.service;

import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public final class IntrecoBusinessHelper {
    private static final Log LOGGER = LogFactory.getLog(IntrecoBusinessHelper.class);
    private static HRBaseServiceHelper intrecoAdvDao = new HRBaseServiceHelper("tsirm_advertdetailex");
    private static HRBaseServiceHelper recommendRecordHelper = new HRBaseServiceHelper("tsirm_intreco_record");

    private IntrecoBusinessHelper() {
    }

    public static String getDistinctWorkName(String fieldKey, DynamicObject rowData) {
        DynamicObjectCollection docs;
        if (HRStringUtils.isEmpty((String)fieldKey)) {
            return "";
        }
        if (fieldKey.contains(".")) {
            fieldKey = fieldKey.substring(fieldKey.indexOf(".") + 1, fieldKey.lastIndexOf("."));
        }
        if (HRObjectUtils.isEmpty((Object)(docs = rowData.getDynamicObjectCollection("workaddr")))) {
            return "";
        }
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        for (DynamicObject doc : docs) {
            DynamicObject baseData = doc.getDynamicObject("fbasedataid");
            if (HRObjectUtils.isEmpty((Object)baseData)) continue;
            String result = baseData.getDynamicObject(fieldKey).getString("name");
            Long id = baseData.getDynamicObject(fieldKey).getLong("id");
            map.putIfAbsent(id, result);
        }
        return String.join((CharSequence)";", map.values());
    }

    public static DynamicObject queryById(Long advertId) {
        return intrecoAdvDao.queryOne((Object)advertId);
    }

    public static FormShowParameter openIntrecoDetail(Long advertPk, String pageId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("tsirp_intrecoadvdetail");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("id", (Object)advertPk.toString());
        DynamicObject intrecoAdv = intrecoAdvDao.queryOne((Object)advertPk);
        parameter.setCustomParam("name", (Object)intrecoAdv.getString("fullname"));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPageId(pageId);
        return parameter;
    }
}

