/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intreco.service;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.operate.MutexHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public final class IntrecoPageHelper {
    public static final String MODULE = IntrecoPageHelper.class.getName();

    private IntrecoPageHelper() {
    }

    public static void asyncUpdateCustomStyle(IFormView formView, String customStyle, String ... controlIds) {
        HashMap<String, String> ctrl = new HashMap<String, String>(16);
        ctrl.put("cstyles", customStyle);
        for (String controlId : controlIds) {
            formView.updateControlMetadata(controlId, ctrl);
        }
    }

    public static OperationStatus getPageStatus(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        return formShowParameter.getStatus();
    }

    public static <T> void setObjData2Cache(T dynamicObject, String cacheId, IPageCache pageCache) {
        String cacheString = SerializationUtils.serializeToBase64(dynamicObject);
        pageCache.put(cacheId, cacheString);
    }

    public static <T> T getPageCache(String cacheId, IPageCache pageCache) {
        String cacheString = pageCache.get(cacheId);
        if (HRStringUtils.isEmpty((String)cacheString)) {
            return null;
        }
        return (T)SerializationUtils.deSerializeFromBase64((String)cacheString);
    }

    public static boolean isTakeViewLock(IFormView formView, String opNumber) {
        BillShowParameter parameter = (BillShowParameter)formView.getFormShowParameter();
        StringBuilder errMsg = new StringBuilder();
        boolean isLock = MutexHelper.require((IFormView)formView, (String)formView.getEntityId(), (Object)parameter.getPkId(), (String)opNumber, (boolean)true, (StringBuilder)errMsg);
        if (!isLock) {
            formView.showTipNotification(errMsg.toString());
        }
        return isLock;
    }

    public static void isShowElement(IFormView view, String booleanEle, String ... pageEle) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        Object isShow = dataEntity.get(booleanEle);
        if (isShow instanceof Boolean) {
            Boolean flag = (Boolean)isShow;
            if (flag.booleanValue()) {
                view.setVisible(Boolean.TRUE, pageEle);
            } else {
                view.setVisible(Boolean.FALSE, pageEle);
            }
        } else if (isShow instanceof Long) {
            long flag = (Long)isShow;
            if (flag > 0L) {
                view.setVisible(Boolean.TRUE, pageEle);
            } else {
                view.setVisible(Boolean.FALSE, pageEle);
            }
        } else if (isShow instanceof Integer) {
            int flag = (Integer)isShow;
            if (flag > 0) {
                view.setVisible(Boolean.TRUE, pageEle);
            } else {
                view.setVisible(Boolean.FALSE, pageEle);
            }
        } else if (isShow instanceof BigDecimal) {
            BigDecimal flag = (BigDecimal)isShow;
            if (flag.compareTo(BigDecimal.ZERO) > 0) {
                view.setVisible(Boolean.TRUE, pageEle);
            } else {
                view.setVisible(Boolean.FALSE, pageEle);
            }
        }
    }

    public static String getRewardTpl(DynamicObject advertDetail) {
        String sign = advertDetail.getString("rewardcurrency.sign");
        String text = sign == null ? "%s" : sign + "%s";
        return ResManager.loadKDString((String)"\u60ac\u8d4f{0}", (String)(MODULE + "_0"), (String)"tsc-tsirm-business", (Object[])new Object[]{text});
    }

    public static String getRewardPointTpl(DynamicObject advertDetail) {
        long rewardPoint = advertDetail.getLong("rewardpoint");
        return ResManager.loadKDString((String)"\u79ef\u5206{0}", (String)(MODULE + "_2"), (String)"tsc-tsirm-business", (Object[])new Object[]{rewardPoint});
    }

    public static String getSomeNum() {
        return ResManager.loadKDString((String)"\u82e5\u5e72", (String)(MODULE + "_1"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
    }
}

