/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intreco.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExDataHelper;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoBusinessHelper;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbs.business.domain.common.service.HRStructureTreeOrgHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class RecommendRecordHelper {
    private static final String MODULE = RecommendRecordHelper.class.getName();
    private static HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("tsirp_intreco_record");

    private RecommendRecordHelper() {
    }

    public static FormShowParameter getParamForHyperLinkClick(String fieldName, HyperLinkClickArgs args, IFormView view) {
        BillList source = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = source.getFocusRowPkId();
        DynamicObject recommendRecord = SERVICE_HELPER.queryOne(pkId);
        Long advertPk = recommendRecord.getDynamicObject("advertId").getLong("id");
        BaseShowParameter showParameter = null;
        if (HRStringUtils.equals((String)fieldName, (String)"name")) {
            showParameter = new BaseShowParameter();
            showParameter.setFormId("tsirp_intreco_record");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId(pkId);
            String msg = ResManager.loadKDString((String)"\u5019\u9009\u4eba-", (String)(MODULE + "_0"), (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(msg + recommendRecord.getString("name"));
            showParameter.setCustomParam("advertId", (Object)advertPk);
            DynamicObject pos = recommendRecord.getDynamicObject("position");
            showParameter.setCustomParam("positionid", (Object)pos);
        } else if (HRStringUtils.equals((String)fieldName, (String)"advertid_fullname")) {
            showParameter = IntrecoBusinessHelper.openIntrecoDetail(advertPk, view.getPageId() + advertPk);
            showParameter.setCustomParam("from", (Object)"intreco_rr_list");
        }
        return showParameter;
    }

    public static QFilter getPosPrinByUser(QFilter filter) {
        Object userIds = filter.getValue();
        HRBaseServiceHelper posManageHelper = new HRBaseServiceHelper("tsirm_positionmanage");
        QFilter qFilter = new QFilter("posprin.fbasedataid", filter.getCP(), userIds);
        Object[] positions = posManageHelper.query("position", qFilter.toArray());
        if (ArrayUtils.isEmpty((Object[])positions)) {
            return new QFilter("position", filter.getCP(), null);
        }
        List posIdList = Arrays.stream(positions).map(pos -> pos.getLong("position.id")).collect(Collectors.toList());
        return new QFilter("position", filter.getCP(), posIdList);
    }

    public static List<Long> getAllPermOrgIds(String entityId) {
        Pair hrStructureOrgAndAllPermOrgs = HRStructureTreeOrgHelper.getIntHROrgStrucViewAndUserPermOrg((String)"tsirm", (String)entityId, (String)"47150e89000000ac");
        List value = (List)hrStructureOrgAndAllPermOrgs.getValue();
        return value;
    }

    public static void setComboItems(FilterContainerInitArgs filterContainerInitArgs, List<Map<String, String>> nameAndVals, String fieldName, String captionName, int index, String defaultVal, boolean mustInput, boolean multi) {
        List filterColumnList = filterContainerInitArgs.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn commonFilterColumn = new CommonFilterColumn();
        commonFilterColumn.setFieldName(fieldName);
        commonFilterColumn.setCaption(new LocaleString(captionName));
        commonFilterColumn.setMustInput(mustInput);
        commonFilterColumn.setEntityField(true);
        commonFilterColumn.setMulti(multi);
        commonFilterColumn.setDefaultValue(defaultVal);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        if (nameAndVals != null && !nameAndVals.isEmpty()) {
            for (Map<String, String> nameAndVal : nameAndVals) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(nameAndVal.get("name")));
                item.setValue(nameAndVal.get("value"));
                combos.add(item);
            }
        }
        commonFilterColumn.setComboItems(combos);
        commonFilterColumn.setType("enum");
        filterColumnList.add(index, commonFilterColumn);
    }

    public static QFilter getDefaultDataQFilter() {
        AuthorizedOrgResult authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac", (String)"adminorg", null);
        QFilter defaultFilter = new QFilter("1", "=", (Object)1);
        boolean isSuperMan = AdvertTplExDataHelper.getAdvertOrgPerm();
        if (isSuperMan) {
            return defaultFilter;
        }
        List<Long> allPermOrgIds = RecommendRecordHelper.getAllPermOrgIds("tsirm_position");
        QFilter busUnitQFilter = new QFilter("posbizid", "in", allPermOrgIds);
        defaultFilter = defaultFilter.and(busUnitQFilter);
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            QFilter adminOrgFilter = new QFilter("posorgid", "in", (Object)authorizedOrgResult.getHasPermOrgs());
            defaultFilter = defaultFilter.and(adminOrgFilter);
        }
        return defaultFilter;
    }

    public static List<Map<String, String>> getNameValues(DynamicObject[] dynamicObjects) {
        ArrayList<Map<String, String>> nameAndVals = new ArrayList<Map<String, String>>(dynamicObjects.length);
        if (null != dynamicObjects && dynamicObjects.length > 0) {
            Arrays.sort(dynamicObjects, (o1, o2) -> {
                long diff = o1.getLong("id") - o2.getLong("id");
                if (diff > 0L) {
                    return 1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return -1;
            });
            for (int i = 0; i < dynamicObjects.length; ++i) {
                HashMap nameAndVal = Maps.newHashMapWithExpectedSize((int)2);
                nameAndVal.put("name", dynamicObjects[i].getString("name"));
                nameAndVal.put("value", dynamicObjects[i].getString("id"));
                nameAndVals.add(nameAndVal);
            }
        }
        return nameAndVals;
    }

    public static DynamicObject[] queryByAppfileId(DynamicObject[] appfiles) {
        List appfileIds = Arrays.stream(appfiles).map(af -> af.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("canappfile", "in", appfileIds);
        return SERVICE_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public static void save(List<DynamicObject> recommendRecordList) {
        if (CollectionUtils.isEmpty(recommendRecordList)) {
            return;
        }
        SERVICE_HELPER.save(recommendRecordList.toArray(new DynamicObject[recommendRecordList.size()]));
    }
}

