/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intreco.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsirm.business.domain.intreco.service.RRecordDetailHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsrbd.business.domain.rewardrule.RewardRuleDataHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RewardRuleService {
    private static final String MODULE = RewardRuleService.class.getName();
    private RewardRuleDataHelper rewardRuleDataService = RewardRuleDataHelper.getInstance();
    private RRecordDetailHelper rRecordDetailHelper = RRecordDetailHelper.getInstance();

    private RewardRuleService() {
    }

    public static RewardRuleService getInstance() {
        return RewardRuleServiceHolder.REWARD_RULE_SERVICE;
    }

    public Pair<Long, DynamicObject> getRewardResultByPos(DynamicObject position) {
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo(position.getLong("id"));
        if (HRObjectUtils.isEmpty((Object)manageInfo)) {
            return null;
        }
        DynamicObject rewardRule = manageInfo.getDynamicObject("rewardrule");
        if (!HRObjectUtils.isEmpty((Object)rewardRule)) {
            DynamicObjectCollection rewardResults = rewardRule.getDynamicObjectCollection("entryentity2");
            long posRecProcId = manageInfo.getLong("recruproc.id");
            for (DynamicObject rewardResult : rewardResults) {
                long recProcId = rewardResult.getLong("rqmtproc.id");
                if (recProcId != posRecProcId) continue;
                return Pair.of((Object)rewardRule.getLong("id"), (Object)rewardResult);
            }
        }
        return null;
    }

    private static class RewardRuleServiceHolder {
        private static final RewardRuleService REWARD_RULE_SERVICE = new RewardRuleService();

        private RewardRuleServiceHolder() {
        }
    }
}

