/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class IntvAppfileTaskHelper {
    private static final String ARGINTV_ARRANGER = "argintv.interviewarranger";
    private static final String ARGINTV_CREATETIME = "argintv.createtime";
    private static final QFilter ENABLE_FILTER = new QFilter("enable", "=", (Object)"1");
    private static final HRBaseServiceHelper HR_BASE_SERVICE_HELPER = new HRBaseServiceHelper("tsirm_appfiletask");
    private static IntvAppfileTaskHelper intvTaskHelper = null;
    Comparator<DynamicObject> comparator = (o1, o2) -> {
        Date o1Date = o1.getDate("intvTime");
        Date o2Date = o2.getDate("intvTime");
        if (Objects.isNull(o1Date) && Objects.isNull(o2Date)) {
            return 0;
        }
        if (Objects.isNull(o1Date)) {
            return -1;
        }
        if (Objects.isNull(o2Date)) {
            return 1;
        }
        return o2Date.compareTo(o1Date);
    };

    private IntvAppfileTaskHelper() {
    }

    public static IntvAppfileTaskHelper getInstance() {
        if (HRObjectUtils.isEmpty((Object)intvTaskHelper)) {
            return new IntvAppfileTaskHelper();
        }
        return intvTaskHelper;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return HR_BASE_SERVICE_HELPER.generateEmptyDynamicObject();
    }

    public void save(List<DynamicObject> dynamicObjects) {
        HR_BASE_SERVICE_HELPER.save(dynamicObjects.toArray(new DynamicObject[0]));
    }

    public DynamicObject queryAppfileTaskById(Long appfileTaskId) {
        return this.queryAppfileTaskById(appfileTaskId, "application,argintv,intvgroup");
    }

    public DynamicObject queryAppfileTaskById(Long appfileTaskId, String selectProperties) {
        return HR_BASE_SERVICE_HELPER.queryOne(selectProperties, new QFilter("id", "=", (Object)appfileTaskId));
    }

    public DynamicObject queryAppTaskInfo(Long appfileTaskId) {
        return HR_BASE_SERVICE_HELPER.queryOne("application,argintv,applicationanswer,recrursn,refusalcause", new QFilter("id", "=", (Object)appfileTaskId));
    }

    public DynamicObject[] getAppfileTasks(List<Long> appfiletaskIds) {
        QFilter qFilter = new QFilter("id", "in", appfiletaskIds);
        return HR_BASE_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{ENABLE_FILTER, qFilter});
    }

    public DynamicObject[] getAppfileTasks(String properties, List<Long> appfiletaskIds) {
        QFilter qFilter = new QFilter("id", "in", appfiletaskIds);
        return HR_BASE_SERVICE_HELPER.query(properties, new QFilter[]{ENABLE_FILTER, qFilter});
    }

    public DynamicObject[] getAppfileTasks(QFilter qFilter) {
        return HR_BASE_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{ENABLE_FILTER, qFilter});
    }

    public DynamicObject[] getAppfileTasks(String selectProperties, QFilter qFilter) {
        return HR_BASE_SERVICE_HELPER.query(selectProperties, new QFilter[]{ENABLE_FILTER, qFilter});
    }

    public DynamicObject[] findCandidateTaskByArgIntvId(Long argIntvId) {
        return HR_BASE_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{ENABLE_FILTER, new QFilter("argintv", "=", (Object)argIntvId)});
    }

    public DynamicObject[] getPositions(List<Long> positionIds) {
        QFilter qFilter = new QFilter("id", "in", positionIds);
        return new HRBaseServiceHelper("tsirm_position").loadDynamicObjectArray(new QFilter[]{ENABLE_FILTER, qFilter});
    }

    public Object[] updateTasks(DynamicObject[] dynamicObjects) {
        return HR_BASE_SERVICE_HELPER.update(dynamicObjects);
    }

    public void updateAppfileTaskAndAppfile(DynamicObject[] appfileTasks) {
        List<Long> appfileIds = Arrays.stream(appfileTasks).map(task -> task.getDynamicObject("application").getLong("id")).collect(Collectors.toList());
        HR_BASE_SERVICE_HELPER.update(appfileTasks);
        this.updateAppfileIntvInfo(appfileIds, appfileTasks);
    }

    public void updateTasks(DynamicObject dynamicObject) {
        HR_BASE_SERVICE_HELPER.updateOne(dynamicObject);
    }

    public int getTraceNum(String startTime, String endTime) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ARGINTV_ARRANGER, "=", (Object)TSCRequestContext.getUserId()));
        qFilters.add(new QFilter("taskstatus", "=", (Object)"A"));
        if (HRStringUtils.isNotEmpty((String)startTime)) {
            qFilters.add(new QFilter(ARGINTV_CREATETIME, ">=", (Object)LocalDateTime.parse(startTime, DateFormatConstants.NORM_DATETIME_FORM)));
        }
        if (HRStringUtils.isNotEmpty((String)endTime)) {
            qFilters.add(new QFilter(ARGINTV_CREATETIME, "<=", (Object)LocalDateTime.parse(endTime, DateFormatConstants.NORM_DATETIME_FORM)));
        }
        qFilters.add(ENABLE_FILTER);
        DynamicObject[] dynamicObjects = HR_BASE_SERVICE_HELPER.query("id", qFilters.toArray(new QFilter[0]));
        StringBuilder ids = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects) {
            ids.append(dynamicObject.getString("id"));
            ids.append('-');
        }
        return dynamicObjects.length;
    }

    public DynamicObject[] getAppfileTaskIntvTimeByGroupIdAndAppfileId(List<Long> appfileIds, long gounpId) {
        QFilter qFilter = new QFilter("application", "in", appfileIds).and("intvgroup", "=", (Object)gounpId).and(ENABLE_FILTER);
        return HR_BASE_SERVICE_HELPER.query("id,application,intvtime,taskstatus,intvevlstatus", new QFilter[]{qFilter});
    }

    public List<DynamicObject> getLeastIntvAppfileTaskOrderByIntvTime(List<Long> appfileIds, DynamicObject[] appfileTasks) {
        QFilter qFilter = new QFilter("application", "in", appfileIds).and("intvTime", "!=", null).and(ENABLE_FILTER);
        DynamicObject[] appfileTask = HR_BASE_SERVICE_HELPER.query("id,application,intvtime,taskstatus,intvevlstatus", new QFilter[]{qFilter});
        ArrayList allAppfileTasks = Lists.newArrayListWithExpectedSize((int)(appfileTask.length + appfileTasks.length));
        for (DynamicObject newAppfileTask : appfileTasks) {
            DynamicObject newAppfile = this.generateEmptyDynamicObject();
            newAppfile.set("id", (Object)newAppfileTask.getLong("id"));
            newAppfile.set("application", (Object)newAppfileTask.getDynamicObject("application"));
            newAppfile.set("intvTime", (Object)newAppfileTask.getDate("intvTime"));
            newAppfile.set("taskstatus", (Object)newAppfileTask.getString("taskstatus"));
            newAppfile.set("intvevlstatus", (Object)newAppfileTask.getString("intvevlstatus"));
            allAppfileTasks.add(newAppfile);
        }
        allAppfileTasks.addAll(Arrays.asList(appfileTask));
        return allAppfileTasks;
    }

    public String getIntvProgress(List<DynamicObject> allAppfileTasks, long appfileId) {
        int inProgress = 0;
        int canceled = 0;
        int completed = 0;
        for (DynamicObject appfileTask : allAppfileTasks) {
            long taskId = appfileTask.getLong("application.id");
            if (appfileId != taskId) continue;
            String taskStatus = appfileTask.getString("taskstatus");
            if ("A".equals(taskStatus)) {
                ++inProgress;
                continue;
            }
            if ("B".equals(taskStatus)) {
                ++canceled;
                continue;
            }
            if (!"C".equals(taskStatus)) continue;
            ++completed;
        }
        if (inProgress > 0) {
            return "A";
        }
        if (canceled > 0 && completed == 0) {
            return "B";
        }
        if (completed > 0) {
            return "C";
        }
        return "";
    }

    public void updateAppfileIntvInfo(List<Long> appfileIds, DynamicObject[] appfileTasks) {
        ArrayList appfileNeedUpdate = Lists.newArrayListWithCapacity((int)appfileIds.size());
        List<DynamicObject> allAppfileTasks = this.getLeastIntvAppfileTaskOrderByIntvTime(appfileIds, appfileTasks);
        LinkedHashMap leastIntvAppfileTaskOrderByIntvTime = Maps.newLinkedHashMapWithExpectedSize((int)appfileIds.size());
        allAppfileTasks.stream().sorted(this.comparator).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getDynamicObject("application").getLong("id"))).forEach((key, val) -> {
            DynamicObject cfr_ignored_0 = (DynamicObject)leastIntvAppfileTaskOrderByIntvTime.put(key, val.get(0));
        });
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appfileIds, "id,interviewtime,intvprogress,intvevalresult");
        Arrays.stream(appFiles).forEach(appFile -> {
            long appfileId = appFile.getLong("id");
            leastIntvAppfileTaskOrderByIntvTime.forEach((key, value) -> {
                String intvProgress;
                AppfileIntvInfo appfileIntvInfoOfTask;
                AppfileIntvInfo appfileIntvInfo;
                if (appfileId == key && !(appfileIntvInfo = new AppfileIntvInfo((DynamicObject)appFile)).equals(appfileIntvInfoOfTask = new AppfileIntvInfo((DynamicObject)value, intvProgress = this.getIntvProgress(allAppfileTasks, appfileId)))) {
                    appFile.set("interviewtime", (Object)appfileIntvInfoOfTask.getIntvTime());
                    appFile.set("intvevalresult", (Object)appfileIntvInfoOfTask.getIntvevlStatus());
                    appFile.set("intvprogress", (Object)appfileIntvInfoOfTask.getTaskStatus());
                    appfileNeedUpdate.add(appFile);
                }
            });
        });
        AppFileHelper.update(appfileNeedUpdate.toArray(new DynamicObject[0]));
    }

    static class AppfileIntvInfo {
        private Date intvTime;
        private String taskStatus;
        private String intvevlStatus;

        public AppfileIntvInfo() {
        }

        public AppfileIntvInfo(DynamicObject appfile) {
            this.intvTime = appfile.getDate("interviewtime");
            this.taskStatus = appfile.getString("intvprogress");
            this.intvevlStatus = appfile.getString("intvevalresult");
        }

        public AppfileIntvInfo(DynamicObject appfileTask, String intvProgress) {
            this.intvTime = appfileTask.getDate("intvTime");
            this.taskStatus = intvProgress;
            this.intvevlStatus = appfileTask.getString("intvevlstatus");
        }

        public Date getIntvTime() {
            return this.intvTime;
        }

        public void setIntvTime(Date intvTime) {
            this.intvTime = intvTime;
        }

        public String getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public String getIntvevlStatus() {
            return this.intvevlStatus;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AppfileIntvInfo that = (AppfileIntvInfo)obj;
            return Objects.equals(this.intvTime, that.intvTime) && Objects.equals(this.taskStatus, that.taskStatus) && Objects.equals(this.intvevlStatus, that.intvevlStatus);
        }

        public int hashCode() {
            return Objects.hash(this.intvTime, this.taskStatus, this.intvevlStatus);
        }
    }
}

