/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsirm.common.entity.intv.calendar.IntvCalendar;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class IntvTaskHelper {
    private final QFilter ENABLE_FILTER = new QFilter("enable", "=", (Object)"1");
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("tsirm_intvtasktpl");
    private static IntvTaskHelper intvTaskHelper = null;
    private static final String INTVTIME = "intvtime";

    private IntvTaskHelper() {
    }

    public static IntvTaskHelper getInstance() {
        if (HRObjectUtils.isEmpty((Object)intvTaskHelper)) {
            return new IntvTaskHelper();
        }
        return intvTaskHelper;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return SERVICE_HELPER.generateEmptyDynamicObject();
    }

    public DynamicObject getIntvTask(QFilter qFilter) {
        return SERVICE_HELPER.loadDynamicObject(this.ENABLE_FILTER.and(qFilter));
    }

    public DynamicObject getIntvTaskObj(QFilter qFilter) {
        return SERVICE_HELPER.loadDynamicObject(qFilter);
    }

    public DynamicObject[] getIntvTaskObjs(QFilter qFilter) {
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getIntvTasks(QFilter qFilter) {
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{this.ENABLE_FILTER, qFilter});
    }

    public DynamicObject[] getDisIntvTasks(QFilter qFilter) {
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("enable", "=", (Object)"0"), qFilter});
    }

    public DynamicObject[] getIntvTasksNoEnableFilter(QFilter qFilter) {
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public Object[] updateTasks(DynamicObject[] dynamicObjects) {
        return SERVICE_HELPER.update(dynamicObjects);
    }

    public Object save(List<DynamicObject> dynamicObjects) {
        return SERVICE_HELPER.save(dynamicObjects.toArray(new DynamicObject[0]));
    }

    public DynamicObject[] getIntvTasks(String selectProperties, QFilter qFilter) {
        return SERVICE_HELPER.query(selectProperties, new QFilter[]{this.ENABLE_FILTER, qFilter});
    }

    public List<Object> getIntvCalendarLists(Date startDate, Date endDate) {
        ArrayList intvCalendars = Lists.newArrayList();
        if (startDate.compareTo(endDate) >= 0) {
            return intvCalendars;
        }
        long currentUserId = TSCRequestContext.getUserId();
        QFilter qFilter = new QFilter("intvgroup.intvdate", ">=", (Object)startDate).and("intvgroup.intvdate", "<", (Object)endDate).and("interviewer", "=", (Object)currentUserId).and(new QFilter("taskstatus", "=", (Object)"A").or(new QFilter("taskstatus", "=", (Object)"B"))).and(this.ENABLE_FILTER);
        DynamicObject[] intvTasks = this.getIntvTasks("id,argintv.interviewtitle,round.interviewtheme,intvgroup.intvdate,intvgroup.intvstarttime,intvgroup.intvendtime,taskstatus,intvgroup.addressdetail,intvgroupinterviewroom", qFilter);
        return Arrays.stream(intvTasks).map(IntvCalendar::new).sorted(Comparator.comparingLong(IntvCalendar::getStartTimeLong)).collect(Collectors.toList());
    }

    public DynamicObject[] getIntverTaskGroupByTime(Date startTime, Date endTime, List<Long> interviewerIds) {
        QFilter qFilter = new QFilter("interviewer", "in", interviewerIds);
        QFilter qFilter1 = new QFilter("intvgroup.intvdate", ">=", (Object)startTime);
        QFilter qFilter2 = new QFilter("intvgroup.intvdate", "<=", (Object)endTime);
        QFilter qFilter3 = new QFilter("taskstatus", "=", (Object)"A");
        QFilter selQFilter = qFilter.and(qFilter1).and(qFilter2).and(qFilter3).and(this.ENABLE_FILTER);
        return SERVICE_HELPER.query("id,intvgroup,interviewer", new QFilter[]{selQFilter});
    }
}

