/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.ai;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.application.external.ExtGptService;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.ai.AiConfigHelper;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;

public class InterviewAiService {
    private static final Log LOG = LogFactory.getLog(InterviewAiService.class);
    private static final long DEFAULT_INTERVIEWER_AI_ID = 1931855223941261312L;
    private static final long DEFAULT_RESUME_CONCERN_ID = 1931975421386055680L;
    private static final long DEFAULT_RESUME_HIGHLIGHT_ID = 1931972459435680768L;
    private static final long DEFAULT_RESUME_CONCERN_LABEL_ID = 1936305933302905856L;
    private static final long DEFAULT_RESUME_HIGHLIGHT_LABEL_ID = 1936198096581058560L;
    private static final InterviewAiService INTERVIEW_AI_SERVICE = new InterviewAiService();

    private InterviewAiService() {
    }

    public static InterviewAiService getInstance() {
        return INTERVIEW_AI_SERVICE;
    }

    public Map<String, String> getAIConcernAndHighLightParam(DynamicObject appFIle) {
        HashMap<String, String> param = new HashMap<String, String>(4);
        Optional.ofNullable(appFIle).filter(file -> appFIle.getDynamicObject("position") != null).ifPresent(a -> {
            DynamicObject position = appFIle.getDynamicObject("position");
            DynamicObject resume = appFIle.get("appres") instanceof Long ? TsrbsHelper.selectById(appFIle.getLong("appres"), "tsirm_rsm") : appFIle.getDynamicObject("appres");
            Optional.ofNullable(resume).ifPresent(rs -> {
                DynamicObject resumeDynamicObject = ResumeBoHelper.getOne(rs.getPkValue());
                StringBuilder personInfo = new StringBuilder();
                Optional.ofNullable(resumeDynamicObject).ifPresent(dynamicObject -> this.appendPersonInfo((DynamicObject)dynamicObject, personInfo));
                if (HRStringUtils.isNotEmpty((String)personInfo.toString())) {
                    param.put("var001", personInfo.toString());
                }
            });
            String positionName = position.getString("name");
            param.put("var002", ResManager.loadKDString((String)"\u5de5\u4f5c\u804c\u8d23\uff1a{0}\uff1b", (String)"InterviewAiService_8", (String)"tsc-tsirm-business", (Object[])new Object[]{position.getString("posrespon")}));
            param.put("var003", ResManager.loadKDString((String)"\u4efb\u804c\u8981\u6c42\uff1a{0}\uff1b", (String)"InterviewAiService_9", (String)"tsc-tsirm-business", (Object[])new Object[]{position.getString("anoposrequirement")}));
            param.put("var004", positionName);
        });
        return param;
    }

    public Map<String, String> getAIConcernAndHighLightLabelParam(DynamicObject appFIle) {
        HashMap<String, String> param = new HashMap<String, String>(4);
        Optional.ofNullable(appFIle).filter(file -> appFIle.getDynamicObject("position") != null).ifPresent(a -> {
            DynamicObject position = appFIle.getDynamicObject("position");
            DynamicObject resume = appFIle.get("appres") instanceof Long ? TsrbsHelper.selectById(appFIle.getLong("appres"), "tsirm_rsm") : appFIle.getDynamicObject("appres");
            Optional.ofNullable(resume).ifPresent(rs -> {
                DynamicObject resumeDynamicObject = ResumeBoHelper.getOne(rs.getPkValue());
                StringBuilder personInfo = new StringBuilder();
                Optional.ofNullable(resumeDynamicObject).ifPresent(dynamicObject -> this.appendPersonInfo((DynamicObject)dynamicObject, personInfo));
                if (HRStringUtils.isNotEmpty((String)personInfo.toString())) {
                    param.put("var001", personInfo.toString());
                }
            });
            param.put("var002", position.getString("posrespon"));
            param.put("var003", position.getString("anoposrequirement"));
            param.put("var004", position.getString("name"));
        });
        return param;
    }

    public Map<String, String> getAIQuestionParam(DynamicObject appFIle) {
        HashMap<String, String> param = new HashMap<String, String>(8);
        Optional.ofNullable(appFIle).filter(file -> appFIle.getDynamicObject("position") != null).ifPresent(a -> {
            DynamicObject position = appFIle.getDynamicObject("position");
            if (position.containsProperty("posrespon") && position.containsProperty("lowjobgrade") && position.containsProperty("highjobgrade") && position.containsProperty("anoposrequirement") && position.containsProperty("appres")) {
                position = PositionHelper.queryOne(position.getPkValue());
            }
            String positionName = position.getString("name");
            param.put("var001", positionName);
            DynamicObject createOrg = position.getDynamicObject("createorg");
            Optional.ofNullable(createOrg).ifPresent(org -> param.put("var002", org.getString("name")));
            param.put("var003", PositionDataHelper.positionJobGradeDesc(position));
            param.put("var004", position.getString("posrespon"));
            param.put("var005", position.getString("anoposrequirement"));
            DynamicObject resume = appFIle.get("appres") instanceof Long ? TsrbsHelper.selectById(appFIle.getLong("appres"), "tsirm_rsm") : appFIle.getDynamicObject("appres");
            Optional.ofNullable(resume).ifPresent(rs -> {
                DynamicObject resumeDynamicObject = ResumeBoHelper.getOne(rs.getPkValue());
                StringBuilder personInfo = new StringBuilder();
                Optional.ofNullable(resumeDynamicObject).ifPresent(dynamicObject -> this.appendPersonInfo((DynamicObject)dynamicObject, personInfo));
                if (HRStringUtils.isNotEmpty((String)personInfo.toString())) {
                    param.put("var006", personInfo.toString());
                }
            });
        });
        return param;
    }

    private void appendPersonInfo(DynamicObject resume, StringBuilder personInfo) {
        Object resumePkId = resume.getPkValue();
        DynamicObject[] posOrgRelArray = RsmHelper.getPosorgrelByRsmId(resumePkId);
        Optional.ofNullable(posOrgRelArray).ifPresent(pos -> Arrays.stream(pos).forEach(dynamicObject -> {
            if (null == dynamicObject) {
                return;
            }
            try {
                Date startDate = dynamicObject.getDate("startdate");
                Date endDate = dynamicObject.getDate("endingdate");
                Date maxDate = HRDateTimeUtils.parseDate((String)"2100-12-31 00:00:00", (String)"yyyy-MM-dd");
                DynamicObject company = dynamicObject.getDynamicObject("company");
                DynamicObject adminOrg = dynamicObject.getDynamicObject("adminorg");
                DynamicObject position = dynamicObject.getDynamicObject("position");
                Object[] objectArray = new Object[5];
                Object object = objectArray[0] = startDate == null ? "" : HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM");
                objectArray[1] = endDate == null ? "" : (endDate.after(maxDate) ? ResManager.loadKDString((String)"\u81f3\u4eca", (String)"InterviewAiService_12", (String)"tsc-tsirm-business", (Object[])new Object[0]) : HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM"));
                objectArray[2] = company == null ? "" : company.getString("name");
                objectArray[3] = adminOrg == null ? "" : adminOrg.getString("name");
                objectArray[4] = position == null ? "" : position.getString("name");
                personInfo.append(ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\uff1a{0}\u81f3{1}  \u5728{2} {3} \u4efb\u804c\uff1a {4} ", (String)"InterviewAiService_1", (String)"tsc-tsirm-business", (Object[])objectArray)).append(";");
            }
            catch (ParseException e) {
                LOG.error("parse date error", (Throwable)e);
            }
        }));
        BigDecimal workYears = resume.getBigDecimal("workingyears");
        if (null != workYears) {
            workYears = workYears.divide(new BigDecimal(12), 1, RoundingMode.HALF_UP);
            String workYearDesc = ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650\uff1a{0} \u5e74\uff1b", (String)"InterviewAiService_0", (String)"tsc-tsirm-business", (Object[])new Object[]{workYears.toString()});
            personInfo.append(workYearDesc);
        }
        DynamicObject[] educationArray = RsmHelper.queryEducationByRsmId(resumePkId);
        Optional.ofNullable(educationArray).ifPresent(array -> Arrays.stream(array).forEach(dynamicObject -> {
            if (null == dynamicObject) {
                return;
            }
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("endingdate");
            DynamicObject school = dynamicObject.getDynamicObject("schoolname");
            String otherSchoolName = dynamicObject.getString("othschname");
            String specialtyName = dynamicObject.getString("specialtyname");
            DynamicObject education = dynamicObject.getDynamicObject("education");
            DynamicObject educationForm = dynamicObject.getDynamicObject("educationform");
            Object[] objectArray = new Object[6];
            objectArray[0] = startDate == null ? "" : HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM");
            Object object = objectArray[1] = endDate == null ? "" : HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM");
            objectArray[2] = HRStringUtils.isNotEmpty((String)otherSchoolName) ? otherSchoolName : (school == null ? "" : school.getString("name"));
            objectArray[3] = HRStringUtils.isBlank((CharSequence)specialtyName) ? "" : specialtyName;
            objectArray[4] = education == null ? "" : education.getString("name");
            objectArray[5] = educationForm == null ? "" : educationForm.getString("name");
            personInfo.append(ResManager.loadKDString((String)"\u6559\u80b2\u7ecf\u5386\uff1a{0}\u81f3{1}  \u5728{2}  {3}  \u5b66\u4e60\uff0c \u5b66\u5386\uff1a{4}\uff0c\u5b66\u5386\u6027\u8d28\uff1a{5} ", (String)"InterviewAiService_2", (String)"tsc-tsirm-business", (Object[])objectArray)).append(";");
        }));
    }

    public String getAiQuestion(DynamicObject appFile) {
        String input = ResManager.loadKDString((String)"\u751f\u6210\u9762\u8bd5\u95ee\u9898", (String)"InterviewAiService_3", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String syncGPTResult = ExtGptService.getInstance().getSyncGPTResult(1931855223941261312L, input, this.getAIQuestionParam(appFile));
        if ("ai.gai.10009".equals(syncGPTResult)) {
            LOG.error(input + " error by  promote id {0} deleted ", (Object)1931855223941261312L);
            return "";
        }
        syncGPTResult = syncGPTResult.replaceAll("```", "");
        return syncGPTResult;
    }

    public String getAIResumeConcert(DynamicObject appFile) {
        String input = ResManager.loadKDString((String)"\u751f\u6210\u7b80\u5386\u5173\u6ce8\u70b9", (String)"InterviewAiService_13", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String syncGPTResult = ExtGptService.getInstance().getSyncGPTResult(1931975421386055680L, input, this.getAIConcernAndHighLightParam(appFile));
        if ("ai.gai.10009".equals(syncGPTResult)) {
            LOG.error(input + " error by  promote id {0} deleted ", (Object)1931975421386055680L);
            return "";
        }
        syncGPTResult = this.formatResult(syncGPTResult, false);
        return syncGPTResult;
    }

    public String getAIResumeConcertLabel(DynamicObject appFile) {
        String input = ResManager.loadKDString((String)"\u751f\u6210\u7b80\u5386\u5173\u6ce8\u70b9\u6807\u7b7e", (String)"InterviewAiService_10", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String syncGPTResult = ExtGptService.getInstance().getSyncGPTResult(1936305933302905856L, input, this.getAIConcernAndHighLightLabelParam(appFile));
        if ("ai.gai.10009".equals(syncGPTResult)) {
            LOG.error(input + " error by  promote id {0} deleted ", (Object)1931975421386055680L);
            return "";
        }
        syncGPTResult = this.formatResult(syncGPTResult, false);
        return syncGPTResult;
    }

    public String getAIResumeHighLight(DynamicObject appFile) {
        String input = ResManager.loadKDString((String)"\u751f\u6210\u7b80\u5386\u4eae\u70b9", (String)"InterviewAiService_4", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String syncGPTResult = ExtGptService.getInstance().getSyncGPTResult(1931972459435680768L, input, this.getAIConcernAndHighLightParam(appFile));
        if ("ai.gai.10009".equals(syncGPTResult)) {
            LOG.error(input + " error by  promote id {0} deleted ", (Object)1931972459435680768L);
            return "";
        }
        syncGPTResult = this.formatResult(syncGPTResult, false);
        return syncGPTResult;
    }

    public String getAIResumeHighLightLabel(DynamicObject appFile) {
        String input = ResManager.loadKDString((String)"\u751f\u6210\u7b80\u5386\u4eae\u70b9\u6807\u7b7e", (String)"InterviewAiService_11", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String syncGPTResult = ExtGptService.getInstance().getSyncGPTResult(1936198096581058560L, input, this.getAIConcernAndHighLightLabelParam(appFile));
        if ("ai.gai.10009".equals(syncGPTResult)) {
            LOG.error(input + " error by  promote id {0} deleted ", (Object)1931972459435680768L);
            return "";
        }
        syncGPTResult = this.formatResult(syncGPTResult, false);
        return syncGPTResult;
    }

    public void updateAllAppFileAi(DynamicObject appFile) {
        if (!AiConfigHelper.getInstance().getIfOpen("interviewerairesume")) {
            return;
        }
        ThreadPools.executeOnce((String)"updateAllAppFileAi", () -> {
            try {
                String aiResumeConcert = this.getAIResumeConcert(appFile);
                String aiResumeConcertLabel = this.getAIResumeConcertLabel(appFile);
                List<String> aiResumeConcertLabelList = this.formatLabel(aiResumeConcertLabel);
                String aiResumeHighLight = this.getAIResumeHighLight(appFile);
                String aiResumeHighLightLabel = this.getAIResumeHighLightLabel(appFile);
                List<String> aiResumeHighLightLabelList = this.formatLabel(aiResumeHighLightLabel);
                AppFileHelper.updateAiHighLightAndConcern(appFile, aiResumeHighLight, aiResumeHighLightLabelList, aiResumeConcert, aiResumeConcertLabelList);
            }
            catch (Exception e) {
                LOG.error("AppFileHelper.updateAiHighLightAndConcern fail", (Throwable)e);
            }
        });
    }

    public List<String> formatLabel(String label) {
        List<String> list = Arrays.asList(label.split("\n"));
        ArrayList<String> labelList = new ArrayList<String>(list.size());
        list.forEach(strLabel -> {
            if (HRStringUtils.isBlank((CharSequence)strLabel)) {
                return;
            }
            labelList.add((String)strLabel);
        });
        return labelList;
    }

    public String formatResult(String result, boolean needBr) {
        if (HRStringUtils.isBlank((CharSequence)result)) {
            return result;
        }
        String[] split = (result = result.replace("\\", "").replace("\"", "")).split("```");
        if (split.length == 1) {
            if (needBr) {
                return result.replaceAll("\n", "</br>");
            }
            return result;
        }
        if (split.length == 2) {
            String string = result = HRStringUtils.isBlank((CharSequence)split[0]) ? split[1] : split[0];
        }
        if (split.length == 3) {
            result = split[1];
        }
        result = result.replaceAll("\"", "");
        if (needBr) {
            return result.replaceAll("\n", "</br>");
        }
        return result;
    }
}

