/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.calendar;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.tsc.tsirm.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.calendar.SetAbleInterviewTimeHelper;
import kd.tsc.tsirm.common.entity.intv.ableintvtime.AbleInterviewTimeResultEntity;
import kd.tsc.tsirm.common.entity.intv.ableintvtime.InterIntersectionTime;
import kd.tsc.tsirm.common.entity.intv.ableintvtime.InterviewerTimes;
import kd.tsc.tsirm.common.entity.intv.ableintvtime.Interviewers;
import kd.tsc.tsirm.common.entity.intv.ableintvtime.TimePeriod;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsirm.common.util.TimePeriodCalcUtils;

public class GetAbleInterviewTimeHelper {
    public static final Log log = LogFactory.getLog(GetAbleInterviewTimeHelper.class);
    public static final String DEFAULT_DATE_PATTERN_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PICTUREFIELD = "picturefield";

    public static AbleInterviewTimeResultEntity getAbleInterviewTime(DynamicObjectCollection intvers, String indexDate) {
        List<Interviewers> interviewers = GetAbleInterviewTimeHelper.getInterviewers(intvers);
        AbleInterviewTimeResultEntity ableInterviewTimeObj = GetAbleInterviewTimeHelper.ableInterviewTimeResult(interviewers, indexDate);
        return ableInterviewTimeObj;
    }

    public static AbleInterviewTimeResultEntity getAbleInterviewTime(DynamicObjectCollection intvers, Date indexDate) {
        List<Interviewers> interviewers = GetAbleInterviewTimeHelper.getInterviewers(intvers);
        return GetAbleInterviewTimeHelper.ableInterviewTimeResult(interviewers, indexDate);
    }

    public static String getAbleInterviewTimeByJsonObjStr(String jsonObjectStr) {
        String ableInterviewTimeResultEntityJsonObjStr = "";
        AbleInterviewTimeResultEntity ableInterviewTimeObj = (AbleInterviewTimeResultEntity)JSON.parseObject((String)jsonObjectStr, AbleInterviewTimeResultEntity.class);
        List<Long> interviewerIds = GetAbleInterviewTimeHelper.getInterviewIds(ableInterviewTimeObj);
        List<Interviewers> interviewers = GetAbleInterviewTimeHelper.getInterviewers(interviewerIds);
        ableInterviewTimeObj.setDayTime(IntvDateUtil.stampToTime((String)ableInterviewTimeObj.getDayTime(), (String)DEFAULT_DATE_PATTERN_TIME));
        AbleInterviewTimeResultEntity ableInterviewTimeChangeTime = GetAbleInterviewTimeHelper.ableInterviewTimeResult(interviewers, ableInterviewTimeObj.getDayTime());
        ableInterviewTimeResultEntityJsonObjStr = JSON.toJSONString((Object)ableInterviewTimeChangeTime);
        return ableInterviewTimeResultEntityJsonObjStr;
    }

    private static List<Long> getInterviewIds(AbleInterviewTimeResultEntity ableInterviewTimeParam) {
        ArrayList<Long> interviewerIds = new ArrayList<Long>();
        List interviewers = ableInterviewTimeParam.getInterviewers();
        for (Interviewers interviewer : interviewers) {
            if (interviewer.getId() == null) continue;
            interviewerIds.add(Long.parseLong(interviewer.getId()));
        }
        return interviewerIds;
    }

    public static List<Interviewers> getInterviewers(List<Long> interviewerIds) {
        List interviewerMaps = UserServiceHelper.get(interviewerIds);
        ArrayList<Interviewers> interviewers = new ArrayList<Interviewers>(interviewerMaps.size());
        for (Map interviewerMap : interviewerMaps) {
            String interviewerId = interviewerMap.get("id").toString();
            String interviewerName = interviewerMap.get("name").toString();
            String interviewerNumber = interviewerMap.get("number").toString();
            String interviewerHeadImg = HRImageUrlUtil.getImageFullUrl((String)interviewerMap.get(PICTUREFIELD).toString());
            Interviewers interviewer = new Interviewers();
            interviewer.setId(interviewerId);
            interviewer.setName(interviewerName);
            interviewer.setJobnumber(interviewerNumber);
            interviewer.setHeadImg(interviewerHeadImg);
            interviewers.add(interviewer);
        }
        return interviewers;
    }

    private static AbleInterviewTimeResultEntity ableInterviewTimeResult(List<Interviewers> interviewers, String indexDate) {
        AbleInterviewTimeResultEntity ableInterviewTimeResult = new AbleInterviewTimeResultEntity();
        ableInterviewTimeResult.setDayTime(String.valueOf(IntvDateUtil.parseDateStr((String)indexDate, (String)DEFAULT_DATE_PATTERN_TIME).getTime()));
        ableInterviewTimeResult.setInterviewers(interviewers);
        ableInterviewTimeResult.setInterIntersectionTime(GetAbleInterviewTimeHelper.getInterIntersectionTimes(interviewers, indexDate));
        return ableInterviewTimeResult;
    }

    private static AbleInterviewTimeResultEntity ableInterviewTimeResult(List<Interviewers> interviewers, Date indexDate) {
        AbleInterviewTimeResultEntity ableInterviewTimeResult = new AbleInterviewTimeResultEntity();
        ableInterviewTimeResult.setDayTime(String.valueOf(indexDate.getTime()));
        ableInterviewTimeResult.setInterviewers(interviewers);
        ableInterviewTimeResult.setInterIntersectionTime(GetAbleInterviewTimeHelper.getInterIntersectionTimes(interviewers, indexDate));
        return ableInterviewTimeResult;
    }

    private static List<Interviewers> getInterviewers(DynamicObjectCollection intvers) {
        ArrayList<Interviewers> interviewers = new ArrayList<Interviewers>(intvers.size());
        for (DynamicObject interviewerDO : intvers) {
            String interviewerId = interviewerDO.getDynamicObject("fbasedataid").getString("id");
            String interviewerName = interviewerDO.getDynamicObject("fbasedataid").getString("name");
            String interviewerNumber = interviewerDO.getDynamicObject("fbasedataid").getString("number");
            String interviewerHeadImg = HRImageUrlUtil.getImageFullUrl((String)interviewerDO.getDynamicObject("fbasedataid").getString(PICTUREFIELD));
            Interviewers interviewer = new Interviewers();
            interviewer.setId(interviewerId);
            interviewer.setName(interviewerName);
            interviewer.setJobnumber(interviewerNumber);
            interviewer.setHeadImg(interviewerHeadImg);
            interviewers.add(interviewer);
        }
        return interviewers;
    }

    private static List<InterIntersectionTime> getInterIntersectionTimes(List<Interviewers> intvers, String indexDate) {
        ArrayList<InterIntersectionTime> interIntersectionTimes = new ArrayList<InterIntersectionTime>();
        InterIntersectionTime interIntersectionTime = new InterIntersectionTime();
        interIntersectionTime.setTimeZone(ResManager.loadKDString((String)"\u5317\u4eac", (String)"SetTimeZone_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        interIntersectionTime.setInterseTime(GetAbleInterviewTimeHelper.getInterseTimes(intvers, indexDate));
        interIntersectionTimes.add(interIntersectionTime);
        return interIntersectionTimes;
    }

    private static List<InterIntersectionTime> getInterIntersectionTimes(List<Interviewers> intvers, Date indexDate) {
        ArrayList<InterIntersectionTime> interIntersectionTimes = new ArrayList<InterIntersectionTime>();
        InterIntersectionTime interIntersectionTime = new InterIntersectionTime();
        interIntersectionTime.setTimeZone(ResManager.loadKDString((String)"\u5317\u4eac", (String)"SetTimeZone_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        interIntersectionTime.setInterseTime(GetAbleInterviewTimeHelper.getInterseTimes(intvers, indexDate));
        interIntersectionTimes.add(interIntersectionTime);
        return interIntersectionTimes;
    }

    private static List<TimePeriod> getInterseTimes(List<Interviewers> intvers, Date dateIndex) {
        List<TimePeriod> interseTimes = new ArrayList<TimePeriod>();
        ArrayList<TimePeriod> handleTimePeriods = new ArrayList();
        List<Long> intversIds = GetAbleInterviewTimeHelper.getIntversIds(intvers);
        DynamicObject[] getIntvCanDOs = SetAbleInterviewTimeHelper.getInterviewerTime(intversIds, dateIndex);
        if (intvers.size() > getIntvCanDOs.length || intvers.size() == 0) {
            return interseTimes;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateIndex);
        ((Calendar)calendar).add(5, 1);
        DynamicObject[] intvTask = GetAbleInterviewTimeHelper.getIntvTaskByDateIndex(dateIndex, calendar.getTime(), intversIds);
        List<InterviewerTimes> interviewerTimes = GetAbleInterviewTimeHelper.getInterviewerTimes(getIntvCanDOs, intvers, dateIndex, intvTask);
        interseTimes = GetAbleInterviewTimeHelper.getIntverAbleIntvTimesIntersection(interviewerTimes);
        handleTimePeriods = GetAbleInterviewTimeHelper.handleTimeBeforeNow(interseTimes);
        return handleTimePeriods;
    }

    private static List<TimePeriod> getInterseTimes(List<Interviewers> intvers, String indexDate) {
        List<TimePeriod> interseTimes = new ArrayList<TimePeriod>();
        ArrayList<TimePeriod> handleTimePeriods = new ArrayList();
        List<Long> intversIds = GetAbleInterviewTimeHelper.getIntversIds(intvers);
        Date dateIndex = IntvDateUtil.parseDateStr((String)indexDate, (String)DEFAULT_DATE_PATTERN_TIME);
        DynamicObject[] getIntvCanDOs = SetAbleInterviewTimeHelper.getInterviewerTime(intversIds, dateIndex);
        if (intvers.size() > getIntvCanDOs.length || intvers.size() == 0) {
            return interseTimes;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateIndex);
        ((Calendar)calendar).add(5, 1);
        DynamicObject[] intvTask = GetAbleInterviewTimeHelper.getIntvTaskByDateIndex(dateIndex, calendar.getTime(), intversIds);
        List<InterviewerTimes> interviewerTimes = GetAbleInterviewTimeHelper.getInterviewerTimes(getIntvCanDOs, intvers, dateIndex, intvTask);
        interseTimes = GetAbleInterviewTimeHelper.getIntverAbleIntvTimesIntersection(interviewerTimes);
        handleTimePeriods = GetAbleInterviewTimeHelper.handleTimeBeforeNow(interseTimes);
        return handleTimePeriods;
    }

    private static List<TimePeriod> handleTimeBeforeNow(List<TimePeriod> timePeriods) {
        ArrayList<TimePeriod> handleTimePeriods = new ArrayList<TimePeriod>();
        Date now = new Date();
        for (int i = 0; i < timePeriods.size(); ++i) {
            Date startTime = timePeriods.get(i).getStartTime();
            Date endTime = timePeriods.get(i).getEndTime();
            if (startTime.compareTo(now) < 0 && endTime.compareTo(now) > 0) {
                timePeriods.get(i).setStartTime(now);
                handleTimePeriods.add(timePeriods.get(i));
                continue;
            }
            if (startTime.compareTo(now) <= 0) continue;
            handleTimePeriods.add(timePeriods.get(i));
        }
        return handleTimePeriods;
    }

    private static List<TimePeriod> getIntverAbleIntvTimesIntersection(List<InterviewerTimes> interviewerTimes) {
        List intertUnAbleIntvTimes = interviewerTimes.get(0).getAbleIntvTime();
        for (int i = 1; i < interviewerTimes.size(); ++i) {
            List intverB = interviewerTimes.get(i).getAbleIntvTime();
            intertUnAbleIntvTimes = TimePeriodCalcUtils.getTimePeriodListIntersection((List)intertUnAbleIntvTimes, (List)intverB);
        }
        List intertUnAbleIntvTimesUnion = TimePeriodCalcUtils.unionTimePeriod((List)intertUnAbleIntvTimes);
        return intertUnAbleIntvTimesUnion;
    }

    private static List<Long> getIntversIds(List<Interviewers> intvers) {
        ArrayList<Long> intversIds = new ArrayList<Long>(intvers.size());
        for (int i = 0; i < intvers.size(); ++i) {
            Long interviewerId = Long.parseLong(intvers.get(i).getId());
            intversIds.add(interviewerId);
        }
        return intversIds;
    }

    private static List<InterviewerTimes> getInterviewerTimes(DynamicObject[] getIntvCanDOs, List<Interviewers> intvers, Date dateIndex, DynamicObject[] intvTask) {
        ArrayList<InterviewerTimes> interviewerTimes = new ArrayList<InterviewerTimes>(intvers.size());
        for (int i = 0; i < intvers.size(); ++i) {
            InterviewerTimes intverTime = new InterviewerTimes();
            String interviewerId = intvers.get(i).getId();
            String interviewerName = intvers.get(i).getName();
            List<TimePeriod> interSetAbleIntvTimes = GetAbleInterviewTimeHelper.getSetAbleIntvTimes(getIntvCanDOs, interviewerId, dateIndex);
            List<TimePeriod> unAbleIntvTimes = GetAbleInterviewTimeHelper.getUnAbleIntvTimes(getIntvCanDOs, interviewerId, dateIndex, intvTask);
            intverTime.setId(interviewerId);
            intverTime.setName(interviewerName);
            intverTime.setSetAbleIntvTimes(interSetAbleIntvTimes);
            intverTime.setUnableIntvTime(unAbleIntvTimes);
            intverTime.setAbleIntvTime(GetAbleInterviewTimeHelper.getAbleIntvTime(interSetAbleIntvTimes, unAbleIntvTimes));
            interviewerTimes.add(intverTime);
        }
        return interviewerTimes;
    }

    private static List<TimePeriod> getSetAbleIntvTimes(DynamicObject[] getIntvCanDOs, String interviewerId, Date dateIndex) {
        DynamicObjectCollection canintventryDOC = GetAbleInterviewTimeHelper.getCanintventry(getIntvCanDOs, interviewerId, "tsirm_canintventry");
        List<TimePeriod> intertSetAbleIntvTimes = GetAbleInterviewTimeHelper.getintertSetAbleIntvTimes(canintventryDOC, dateIndex);
        return intertSetAbleIntvTimes;
    }

    private static DynamicObjectCollection getCanintventry(DynamicObject[] getIntvCanDOs, String interviewerId, String entryName) {
        DynamicObjectCollection dynamicObjClt = new DynamicObjectCollection();
        for (int i = 0; i < getIntvCanDOs.length; ++i) {
            String getIntvCanDOsInterId = getIntvCanDOs[i].getDynamicObject("interviewer").getString("id");
            if (!getIntvCanDOsInterId.equals(interviewerId)) continue;
            dynamicObjClt = getIntvCanDOs[i].getDynamicObjectCollection(entryName);
        }
        return dynamicObjClt;
    }

    private static List<TimePeriod> getintertSetAbleIntvTimes(DynamicObjectCollection canintventryDOC, Date dateIndex) {
        ArrayList<TimePeriod> intertSetAbleIntvTimes = new ArrayList<TimePeriod>();
        for (int i = 0; i < canintventryDOC.size(); ++i) {
            Date canintventryDOIndexTime = ((DynamicObject)canintventryDOC.get(i)).getDate("indexdate");
            if (!dateIndex.toInstant().equals(canintventryDOIndexTime.toInstant())) continue;
            TimePeriod timePeriod = new TimePeriod();
            Date starttime = ((DynamicObject)canintventryDOC.get(i)).getDate("starttime");
            Date endtime = ((DynamicObject)canintventryDOC.get(i)).getDate("endtime");
            timePeriod.setStartTime(starttime);
            timePeriod.setEndTime(endtime);
            intertSetAbleIntvTimes.add(timePeriod);
        }
        return intertSetAbleIntvTimes;
    }

    public static List<TimePeriod> getUnAbleIntvTimes(DynamicObject[] getIntvCanDOs, String interviewerId, Date dateIndex, DynamicObject[] intvTask) {
        ArrayList<TimePeriod> unableIntvTimes = new ArrayList<TimePeriod>();
        DynamicObjectCollection canNotintventryDOC = GetAbleInterviewTimeHelper.getCanintventry(getIntvCanDOs, interviewerId, "tsirm_cannotintventry");
        unableIntvTimes.addAll(GetAbleInterviewTimeHelper.getintertUnAbleIntvTimes(canNotintventryDOC, dateIndex));
        unableIntvTimes.addAll(GetAbleInterviewTimeHelper.getIntvTaskTimes(interviewerId, intvTask));
        return unableIntvTimes;
    }

    public static List<TimePeriod> getIntvTaskTimes(String interviewerId, DynamicObject[] intvTask) {
        ArrayList<TimePeriod> unableIntvTimes = new ArrayList<TimePeriod>();
        for (int i = 0; i < intvTask.length; ++i) {
            DynamicObject taskInterviewer = intvTask[i].getDynamicObject("interviewer");
            String taskInterviewerId = taskInterviewer.getString("id");
            if (!taskInterviewerId.equals(interviewerId)) continue;
            DynamicObject group = intvTask[i].getDynamicObject("intvgroup");
            unableIntvTimes.add(GetAbleInterviewTimeHelper.getGroupTimePeriod(group));
        }
        return unableIntvTimes;
    }

    public static TimePeriod getGroupTimePeriod(DynamicObject group) {
        TimePeriod timePeriod = new TimePeriod();
        if (group != null) {
            String startTime = IntvDateUtil.getIntvDate((Date)group.getDate("intvdate")) + " " + IntvDateUtil.formatTime((Long)group.getLong("intvstarttime"), (String)"HH:mm") + ":00";
            long intvendtime = group.getLong("intvendtime");
            String endTime = IntvDateUtil.getIntvDate((Date)group.getDate("intvdate")) + " " + IntvDateUtil.formatTime((Long)(intvendtime > (long)IntvDateUtil.MAX_SECOND_OF_DAY.intValue() ? (long)IntvDateUtil.MAX_SECOND_OF_DAY.intValue() : intvendtime), (String)"HH:mm") + ":00";
            timePeriod.setStartTime(IntvDateUtil.parseDateStr((String)startTime, (String)DEFAULT_DATE_PATTERN_TIME));
            timePeriod.setEndTime(IntvDateUtil.parseDateStr((String)endTime, (String)DEFAULT_DATE_PATTERN_TIME));
            timePeriod.setTimeType(0);
        }
        return timePeriod;
    }

    public static DynamicObject[] getIntvTaskByDateIndex(Date startTime, Date endTime, List<Long> intversIds) {
        DynamicObject[] intverTask = IntvTaskHelper.getInstance().getIntverTaskGroupByTime(startTime, endTime, intversIds);
        return intverTask;
    }

    private static List<TimePeriod> getintertUnAbleIntvTimes(DynamicObjectCollection cannotintvEntryDOC, Date dateIndex) {
        ArrayList<TimePeriod> intertUnAbleIntvTimes = new ArrayList<TimePeriod>();
        for (DynamicObject dynamicObject : cannotintvEntryDOC) {
            String dateIndexStr;
            Date canintventryDOIndexTime = dynamicObject.getDate("uindexdate");
            String canintventryDOIndexTimeStr = HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)canintventryDOIndexTime);
            if (!canintventryDOIndexTimeStr.equals(dateIndexStr = HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)dateIndex))) continue;
            TimePeriod timePeriod = new TimePeriod();
            Date starttime = dynamicObject.getDate("ustarttime");
            Date endtime = dynamicObject.getDate("uendtime");
            timePeriod.setStartTime(starttime);
            timePeriod.setEndTime(endtime);
            timePeriod.setTimeType(1);
            intertUnAbleIntvTimes.add(timePeriod);
        }
        return intertUnAbleIntvTimes;
    }

    private static List<TimePeriod> getAbleIntvTime(List<TimePeriod> interSetAbleIntvTimes, List<TimePeriod> unAbleIntvTimes) {
        List ableIntvTimes = TimePeriodCalcUtils.getTimePeriodListSubtract(interSetAbleIntvTimes, unAbleIntvTimes);
        return ableIntvTimes;
    }
}

