/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.calendar;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.calendar.GetAbleInterviewTimeHelper;
import kd.tsc.tsirm.business.domain.intv.service.calendar.SetAbleInterviewTimeHelper;
import kd.tsc.tsirm.common.entity.intv.ableintvtime.TimePeriod;
import kd.tsc.tsirm.common.entity.intv.calendar.AbleInterviewTimeBean;
import kd.tsc.tsirm.common.entity.intv.calendar.AbleInterviewTimePeriod;
import kd.tsc.tsirm.common.entity.intv.calendar.AbleInterviewTimeRootBean;
import kd.tsc.tsirm.common.entity.intv.calendar.SetAbleInterviewTimeReqParam;
import kd.tsc.tsirm.common.enums.intv.InterviewTimeEntranceEnum;
import kd.tsc.tsirm.common.util.TimePeriodCalcUtils;
import kd.tsc.tsrbd.common.enums.InterviewTimeWayEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetAbleInterviewTimeFormHelper {
    private static final SetAbleInterviewTimeHelper HELPER = new SetAbleInterviewTimeHelper();
    public static final int INT_TWENTY_TWO = 22;
    public static final int INT_TWENTY_THREE = 23;
    public static final int INT_FIFTY_NINE = 59;
    public static final Log log = LogFactory.getLog(SetAbleInterviewTimeFormHelper.class);

    public static void openSetInterviewTimePage(IFormView view, String formId, InterviewTimeWayEnum viewState, Long interviewId, Long candidateId) {
        SetAbleInterviewTimeFormHelper.openSetInterviewTimePage(view, formId, viewState, interviewId, candidateId, null);
    }

    public static void openSetInterviewTimePage(IFormView view, String formId, InterviewTimeWayEnum interviewTimeWay, Long interviewId, Long candidateId, CloseCallBack closeCallBack) {
        BaseShowParameter formShowParameter = SetAbleInterviewTimeFormHelper.getSetInterviewTimePage(formId, interviewTimeWay, interviewId, candidateId, closeCallBack);
        view.showForm((FormShowParameter)formShowParameter);
    }

    public static BaseShowParameter getSetInterviewTimePage(String formId, InterviewTimeWayEnum interviewTimeWay, Long interviewId, Long candidateId, CloseCallBack closeCallBack) {
        String title;
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
        formShowParameter.setCustomParam("interviewId", (Object)interviewId);
        formShowParameter.setCustomParam("pageState", (Object)interviewTimeWay.getPageStatus());
        String entrance = interviewTimeWay == InterviewTimeWayEnum.ENTRANCE_SELECTED ? "B" : "A";
        formShowParameter.setCustomParam("sourceFormId", (Object)entrance);
        formShowParameter.setCustomParam("appFileId", (Object)Lists.newArrayList((Object[])new Long[]{candidateId}));
        if (interviewTimeWay == InterviewTimeWayEnum.ENTRANCE_HOMPAGE) {
            title = ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u53ef\u9762\u8bd5\u65f6\u95f4\u3002", (String)"SetAbleInterviewTimeFormHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            formShowParameter.setStatus(OperationStatus.EDIT);
        } else if (interviewTimeWay == InterviewTimeWayEnum.ENTRANCE_SELECTED) {
            title = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u901a\u8fc7\u7b5b\u9009\uff0c\u8bf7\u8bbe\u7f6e\u53ef\u9762\u8bd5\u65f6\u95f4\u3002", (String)"SetAbleInterviewTimeFormHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            formShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            Map userInfoByID = UserServiceHelper.getUserInfoByID((long)interviewId);
            String name = userInfoByID.getOrDefault("name", "");
            title = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9762\u8bd5\u5b98\u3010%s\u3011\u53ef\u9762\u8bd5\u65f6\u95f4", (String)"SetAbleInterviewTimeFormHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), name);
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        formShowParameter.setCustomParam("page_caption", (Object)title);
        long basePkId = SetAbleInterviewTimeHelper.getAbleInterviewTimePagePkId(interviewId);
        formShowParameter.setPkId((Object)basePkId);
        if (!HRObjectUtils.isEmpty((Object)closeCallBack)) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        return formShowParameter;
    }

    public static void openSetInterviewTimePage(IFormView view, String formId, InterviewTimeWayEnum viewState, CloseCallBack closeCallBack) {
        SetAbleInterviewTimeFormHelper.openSetInterviewTimePage(view, formId, viewState, TSCRequestContext.getUserId(), null, closeCallBack);
    }

    public static boolean isShowInterviewTimePage(Long interviewId) {
        DynamicObject interviewTimeMainData = HELPER.getInterviewTimeMainData(interviewId);
        if (HRObjectUtils.isEmpty((Object)interviewTimeMainData)) {
            SetAbleInterviewTimeHelper.getAbleInterviewTimePagePkId(interviewId);
            return true;
        }
        Date date = interviewTimeMainData.getDate("tipendtime");
        LocalDateTime tipDate = DateUtils.getLocalDateTimeByDate((Date)date);
        return tipDate.isBefore(LocalDateTime.now());
    }

    public void saveOpenParamToCache(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object interviewId = customParams.get("interviewId");
        Object pageState = customParams.get("pageState");
        IPageCache pageCache = view.getPageCache();
        pageCache.put("interviewId", String.valueOf(interviewId));
        pageCache.put("pageState", String.valueOf(pageState));
    }

    public void hideBtn(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Object pageState = formShowParameter.getCustomParams().get("pageState");
        if (InterviewTimeEntranceEnum.ENTRANCE_A.getName().equals(String.valueOf(pageState)) && formShowParameter.getStatus() == OperationStatus.VIEW) {
            view.setVisible(Boolean.TRUE, new String[]{"closeap"});
            view.setVisible(Boolean.FALSE, new String[]{"confirmap"});
            view.setVisible(Boolean.FALSE, new String[]{"arrangeintvap"});
        } else if (status == OperationStatus.VIEW) {
            view.setVisible(Boolean.FALSE, new String[]{"cancelap"});
            view.setVisible(Boolean.FALSE, new String[]{"confirmap"});
            view.setVisible(Boolean.TRUE, new String[]{"arrangeintvap"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"cancelap"});
            view.setVisible(Boolean.TRUE, new String[]{"confirmap"});
            view.setVisible(Boolean.FALSE, new String[]{"arrangeintvap"});
        }
    }

    public Tuple2<Long, String> getOpenPageParamToCache(IFormView view) {
        String pageState;
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object o1 = customParams.get("interviewId");
        Long interviewId = Long.parseLong(String.valueOf(o1));
        if (view.getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW)) {
            pageState = InterviewTimeEntranceEnum.ENTRANCE_C.getName();
        } else {
            Object obj = customParams.get("pageState");
            pageState = String.valueOf(obj);
        }
        return new Tuple2((Object)interviewId, (Object)pageState);
    }

    public String getAbleInterviewTimeJson(IFormView view, SetAbleInterviewTimeReqParam param) {
        String jsonStr;
        AbleInterviewTimeRootBean rootBean = new AbleInterviewTimeRootBean();
        this.setShowWeekTipValue(view, rootBean);
        rootBean.setSelected(Boolean.FALSE);
        Tuple2<Long, String> paramToCache = this.getOpenPageParamToCache(view);
        rootBean.setPageState((String)paramToCache.t2);
        DynamicObject mainData = SetAbleInterviewTimeHelper.getInterviewTimeMainData(param);
        Date date = mainData.getDate("tipendtime");
        LocalDateTime tipDate = DateUtils.getLocalDateTimeByDate((Date)date);
        rootBean.setNoPromptTipFlag(Boolean.valueOf(tipDate.isBefore(LocalDateTime.now())));
        rootBean.setPkId(Long.valueOf(mainData.getLong("id")));
        Object[] ableInterviewTime = SetAbleInterviewTimeHelper.getInterviewerAbleTimeOriginArray(param);
        Object[] unAbleInterviewTime = SetAbleInterviewTimeHelper.getInterviewerUnAbleTimeOriginArray(param);
        List<Object> oneInterviewerData = HRArrayUtils.isEmpty((Object[])ableInterviewTime) ? Lists.newArrayList() : this.getAbleInterviewTimeBeans((DynamicObject[])ableInterviewTime);
        List<Object> oneUnInterviewerData = HRArrayUtils.isEmpty((Object[])unAbleInterviewTime) ? Lists.newArrayList() : this.getUnAbleInterviewTimeBeans((DynamicObject[])unAbleInterviewTime);
        SetAbleInterviewTimeReqParam taskParam = SetAbleInterviewTimeFormHelper.getSetAbleInterviewTimeReqParam(oneInterviewerData, this.getOpenPageParamToCache(view), param);
        SetAbleInterviewTimeFormHelper.mergeAndSubtractData(oneInterviewerData, taskParam, oneUnInterviewerData, view);
        rootBean.setAbleInterviewTime((List)oneInterviewerData);
        rootBean.setUnableInterviewTime((List)oneUnInterviewerData);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            jsonStr = objectMapper.writeValueAsString((Object)rootBean);
        }
        catch (IOException e) {
            log.error("set interview time json parse error ", (Throwable)e);
            throw new KDException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return jsonStr;
    }

    private void setShowWeekTipValue(IFormView view, AbleInterviewTimeRootBean rootBean) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object sourceFromIdObj = customParams.get("sourceFormId");
        String srcFormId = String.valueOf(sourceFromIdObj);
        if (!HRStringUtils.equals((String)srcFormId, (String)"B")) {
            rootBean.setIsShowWeekTip(Boolean.FALSE);
        } else {
            Object pageState = customParams.get("pageState");
            String viewState = String.valueOf(pageState);
            boolean isLock = InterviewTimeEntranceEnum.ENTRANCE_A.getName().equals(String.valueOf(pageState)) && view.getFormShowParameter().getStatus() == OperationStatus.VIEW;
            Object interviewIdObj = customParams.get("interviewId");
            long interviewId = Long.parseLong(String.valueOf(interviewIdObj));
            boolean isShowWeekTip = SetAbleInterviewTimeFormHelper.isShowInterviewTimePage(interviewId);
            if ((isLock || InterviewTimeEntranceEnum.ENTRANCE_A.getName().equals(viewState)) && isShowWeekTip) {
                rootBean.setIsShowWeekTip(Boolean.TRUE);
            } else {
                rootBean.setIsShowWeekTip(Boolean.FALSE);
            }
        }
    }

    public void setJsonValueToObj(String jsonStr, DynamicObject dataEntity, IFormView view) {
        AbleInterviewTimeRootBean cast;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            cast = (AbleInterviewTimeRootBean)objectMapper.readValue(jsonStr, AbleInterviewTimeRootBean.class);
        }
        catch (IOException e) {
            log.error("parse AbleInterviewTimeRootBean json error ", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("500", ResManager.loadKDString((String)"\u8bbe\u7f6e\u53ef\u9762\u8bd5\u65f6\u95f4\u81ea\u5b9a\u4e49\u63a7\u4ef6Json\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", (String)"SetAbleInterviewTimeFormHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0])), new Object[0]);
        }
        if (Objects.isNull(cast)) {
            return;
        }
        SetAbleInterviewTimeReqParam taskParam = SetAbleInterviewTimeFormHelper.getSetAbleInterviewTimeReqParam(cast.getAbleInterviewTime(), this.getOpenPageParamToCache(view), null);
        Boolean noPromptTipFlag = cast.getNoPromptTipFlag();
        if (noPromptTipFlag.booleanValue()) {
            dataEntity.set("tipendtime", (Object)DateUtils.afterNowDate((int)7));
        }
        if (!cast.getSelected().booleanValue()) {
            boolean hasSet = SetAbleInterviewTimeHelper.nearWeekHasSet(taskParam.getInterviewerId());
            if (!hasSet) {
                this.nearTwoWeekTimeSet(dataEntity);
            }
        } else {
            DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("tsirm_canintventry");
            List ableInterviewTime = cast.getAbleInterviewTime();
            this.preSaveCleanDate(dataEntity, ableInterviewTime);
            this.setJsonToDynamicObject(entryCol, ableInterviewTime);
        }
        SetAbleInterviewTimeHelper.save(dataEntity);
        view.returnDataToParent((Object)"success");
        view.close();
    }

    private void setJsonToDynamicObject(DynamicObjectCollection entryCol, List<AbleInterviewTimeBean> ableInterviewTime) {
        for (AbleInterviewTimeBean timeBean : ableInterviewTime) {
            Date interviewDate = timeBean.getInterviewDate();
            List periodList = timeBean.getPeriodList();
            for (AbleInterviewTimePeriod oneDayTimeBean : periodList) {
                Tuple2<LocalDateTime, LocalDateTime> onePeriod = this.getOnePeriod(oneDayTimeBean);
                if (onePeriod == null) continue;
                DynamicObject object = entryCol.addNew();
                object.set("indexdate", (Object)HELPER.getDateNoTime(DateUtils.getLocalDateTimeByDate((Date)interviewDate)));
                object.set("starttime", (Object)DateUtils.getDateByLocalDateTime((LocalDateTime)((LocalDateTime)onePeriod.t1)));
                object.set("endtime", (Object)DateUtils.getDateByLocalDateTime((LocalDateTime)((LocalDateTime)onePeriod.t2)));
            }
        }
    }

    @Nullable
    private Tuple2<LocalDateTime, LocalDateTime> getOnePeriod(AbleInterviewTimePeriod oneDayTimeBean) {
        if (Objects.isNull(oneDayTimeBean)) {
            return null;
        }
        Date startTime = oneDayTimeBean.getStartTime();
        Date endTime = oneDayTimeBean.getEndTime();
        LocalDateTime startDate = DateUtils.getLocalDateTimeByDate((Date)startTime);
        LocalDateTime endDate = DateUtils.getLocalDateTimeByDate((Date)endTime);
        LocalDateTime eightPoint = SetAbleInterviewTimeFormHelper.getIntegralPoint(startDate, 8);
        LocalDateTime twentyTowPoint = SetAbleInterviewTimeFormHelper.getIntegralPoint(startDate, 22);
        if (startDate.isBefore(eightPoint)) {
            startDate = eightPoint;
        }
        if (endDate.isAfter(twentyTowPoint)) {
            endDate = twentyTowPoint;
        }
        if (startDate.isAfter(twentyTowPoint) || endDate.isBefore(eightPoint) || Objects.equals(startDate, endDate)) {
            return null;
        }
        return new Tuple2((Object)startDate, (Object)endDate);
    }

    public static LocalDateTime getIntegralPoint(LocalDateTime localDateTime, int integral) {
        return localDateTime.withHour(integral).withMinute(0).withSecond(0).withNano(0);
    }

    public static void mergeAndSubtractData(List<AbleInterviewTimeBean> oneInterviewerData, SetAbleInterviewTimeReqParam param, List<AbleInterviewTimeBean> oneUnInterviewerData, IFormView view) {
        List<TimePeriod> interviewTaskTime = SetAbleInterviewTimeFormHelper.getInterviewTaskTimePeriod(param);
        SetAbleInterviewTimeFormHelper.processUnAbleInterviewTime(oneUnInterviewerData, interviewTaskTime);
        if (view.getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            return;
        }
        List<TimePeriod> unAbleInterviewTimePeriod = SetAbleInterviewTimeFormHelper.getUnAbleInterviewTimePeriod(param);
        List unionUnTimePeriod = TimePeriodCalcUtils.unionTimePeriod(interviewTaskTime, unAbleInterviewTimePeriod);
        for (AbleInterviewTimeBean oneInterviewerDatum : oneInterviewerData) {
            List periodList = oneInterviewerDatum.getPeriodList();
            List<TimePeriod> timePeriods = SetAbleInterviewTimeFormHelper.convertTimePeriodList(periodList);
            List timePeriodsFilterNull = timePeriods.stream().filter(time -> !HRObjectUtils.isEmpty((Object)time)).collect(Collectors.toList());
            List timePeriodsFilterNullUnion = TimePeriodCalcUtils.unionTimePeriod(timePeriodsFilterNull);
            List unionUnTimePeriodFilterNull = unionUnTimePeriod.stream().filter(time -> !HRObjectUtils.isEmpty((Object)time)).collect(Collectors.toList());
            List mergeTime = TimePeriodCalcUtils.getTimePeriodListSubtract((List)timePeriodsFilterNullUnion, unionUnTimePeriodFilterNull);
            List<AbleInterviewTimePeriod> ableInterviewTimePeriods = SetAbleInterviewTimeFormHelper.convertInterviewTimePeriodList(mergeTime);
            oneInterviewerDatum.setPeriodList(ableInterviewTimePeriods);
        }
    }

    private static void processUnAbleInterviewTime(List<AbleInterviewTimeBean> oneUnInterviewerData, List<TimePeriod> interviewTaskTime) {
        Map<LocalDate, List<TimePeriod>> taskMapUnAbleTime = interviewTaskTime.stream().collect(Collectors.groupingBy(time -> DateUtils.getLocalDateTimeByDate((Date)time.getStartTime()).toLocalDate()));
        if (CollectionUtils.isNotEmpty(interviewTaskTime)) {
            Map<LocalDate, AbleInterviewTimeBean> unAbleTime = oneUnInterviewerData.stream().collect(Collectors.toMap(time -> DateUtils.getLocalDateTimeByDate((Date)time.getInterviewDate()).toLocalDate(), time -> time));
            taskMapUnAbleTime.forEach((key, val) -> {
                List<AbleInterviewTimePeriod> unAbleTimePeriodList = SetAbleInterviewTimeFormHelper.convertInterviewTimePeriodList(val);
                AbleInterviewTimeBean ableInterviewTimeBean = (AbleInterviewTimeBean)unAbleTime.get(key);
                if (Objects.isNull(ableInterviewTimeBean)) {
                    Date dateByLocalDateTime = DateUtils.getDateByLocalDateTime((LocalDateTime)LocalDateTime.of(key, LocalTime.of(0, 0)));
                    AbleInterviewTimeBean unAbleInterviewTimeBean = new AbleInterviewTimeBean();
                    unAbleInterviewTimeBean.setInterviewDate(dateByLocalDateTime);
                    unAbleInterviewTimeBean.setPeriodList(unAbleTimePeriodList);
                    oneUnInterviewerData.add(unAbleInterviewTimeBean);
                } else {
                    List periodList = ableInterviewTimeBean.getPeriodList();
                    periodList.addAll(unAbleTimePeriodList);
                }
            });
        }
    }

    @NotNull
    private static SetAbleInterviewTimeReqParam getSetAbleInterviewTimeReqParam(List<AbleInterviewTimeBean> oneInterviewerData, Tuple2<Long, String> paramCache, SetAbleInterviewTimeReqParam param) {
        Date endTime;
        Date startTime;
        if (Objects.isNull(param)) {
            startTime = oneInterviewerData.stream().map(AbleInterviewTimeBean::getPeriodList).flatMap(Collection::stream).map(AbleInterviewTimePeriod::getStartTime).min(Comparator.comparing(Date::getTime)).orElseGet(Date::new);
            endTime = oneInterviewerData.stream().map(AbleInterviewTimeBean::getPeriodList).flatMap(Collection::stream).map(AbleInterviewTimePeriod::getStartTime).max(Comparator.comparing(Date::getTime)).orElseGet(Date::new);
        } else {
            startTime = param.getStartTime();
            endTime = param.getEndTime();
        }
        Long interviewId = (Long)paramCache.t1;
        return new SetAbleInterviewTimeReqParam(interviewId.longValue(), startTime, endTime);
    }

    @NotNull
    public static List<TimePeriod> getInterviewTaskTimePeriod(SetAbleInterviewTimeReqParam param) {
        LocalDateTime startLocalDateTime = DateUtils.getLocalDateTimeByDate((Date)param.getStartTime()).plusHours(-4L);
        param.setStartTime(DateUtils.getDateByLocalDateTime((LocalDateTime)startLocalDateTime));
        LocalDateTime endLocalDateTime = DateUtils.getLocalDateTimeByDate((Date)param.getEndTime()).plusHours(4L);
        param.setEndTime(DateUtils.getDateByLocalDateTime((LocalDateTime)endLocalDateTime));
        DynamicObject[] interviewTask = IntvTaskHelper.getInstance().getIntverTaskGroupByTime(param.getStartTime(), param.getEndTime(), Lists.newArrayList((Object[])new Long[]{param.getInterviewerId()}));
        return GetAbleInterviewTimeHelper.getIntvTaskTimes(String.valueOf(param.getInterviewerId()), interviewTask);
    }

    public static List<TimePeriod> getUnAbleInterviewTimePeriod(SetAbleInterviewTimeReqParam param) {
        DynamicObject[] interviewerAbleTime = SetAbleInterviewTimeHelper.getInterviewerUnAbleTime(param);
        ArrayList unAbleInterviewTimePeriod = Lists.newArrayList();
        for (DynamicObject dynamicObject : interviewerAbleTime) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("tsirm_cannotintventry");
            for (DynamicObject entryObj : dynamicObjectCollection) {
                TimePeriod timePeriod = new TimePeriod();
                timePeriod.setStartTime(entryObj.getDate("ustarttime"));
                timePeriod.setEndTime(entryObj.getDate("uendtime"));
                unAbleInterviewTimePeriod.add(timePeriod);
            }
        }
        return unAbleInterviewTimePeriod;
    }

    public static List<TimePeriod> convertTimePeriodList(List<AbleInterviewTimePeriod> timePeriodList) {
        ArrayList res = Lists.newArrayListWithExpectedSize((int)timePeriodList.size());
        for (AbleInterviewTimePeriod ableInterviewTimePeriod : timePeriodList) {
            if (Objects.isNull(ableInterviewTimePeriod)) continue;
            TimePeriod timePeriod = new TimePeriod();
            timePeriod.setStartTime(ableInterviewTimePeriod.getStartTime());
            timePeriod.setEndTime(ableInterviewTimePeriod.getEndTime());
            res.add(timePeriod);
        }
        return res;
    }

    public static List<AbleInterviewTimePeriod> convertInterviewTimePeriodList(List<TimePeriod> timePeriodList) {
        ArrayList res = Lists.newArrayListWithExpectedSize((int)timePeriodList.size());
        for (TimePeriod ableInterviewTimePeriod : timePeriodList) {
            if (Objects.isNull(ableInterviewTimePeriod)) continue;
            AbleInterviewTimePeriod timePeriod = new AbleInterviewTimePeriod();
            timePeriod.setStartTime(ableInterviewTimePeriod.getStartTime());
            timePeriod.setEndTime(ableInterviewTimePeriod.getEndTime());
            res.add(timePeriod);
        }
        return res;
    }

    private void preSaveCleanDate(DynamicObject dataEntity, List<AbleInterviewTimeBean> ableInterviewTime) {
        HashSet<LocalDate> clearDate = new HashSet<LocalDate>();
        for (AbleInterviewTimeBean timeBean : ableInterviewTime) {
            if (Objects.isNull(timeBean)) continue;
            Date interviewDate = timeBean.getInterviewDate();
            LocalDateTime localDateTimeByDate = DateUtils.getLocalDateTimeByDate((Date)interviewDate);
            LocalDate from = LocalDate.from(localDateTimeByDate);
            clearDate.add(from);
        }
        SetAbleInterviewTimeHelper.clearData(dataEntity, clearDate);
    }

    private void nearTwoWeekTimeSet(DynamicObject dataEntity) {
        LocalDateTime curMonday = LocalDateTime.now().with(WeekFields.ISO.dayOfWeek(), 1L);
        LocalDateTime curMondayZeroPoint = SetAbleInterviewTimeFormHelper.getIntegralPoint(curMonday, 0);
        LocalDateTime nextWeekDay = DateUtils.getNextWeekSunday((LocalDateTime)curMondayZeroPoint);
        List<AbleInterviewTimePeriod> ableInterviewTimePeriod = SetAbleInterviewTimeHelper.getAbleInterviewTimePeriod(curMondayZeroPoint, nextWeekDay);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("tsirm_canintventry");
        List dates = ableInterviewTimePeriod.stream().map(time -> DateUtils.getLocalDateTimeByDate((Date)time.getDate())).collect(Collectors.toList());
        ArrayList rmvEle = Lists.newArrayList();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Date date = dynamicObject.getDate("indexdate");
            if (!dates.contains(DateUtils.getLocalDateTimeByDate((Date)date))) continue;
            rmvEle.add(dynamicObject);
        }
        dynamicObjectCollection.removeAll((Collection)rmvEle);
        for (AbleInterviewTimePeriod interviewTimePeriod : ableInterviewTimePeriod) {
            DynamicObject object = dynamicObjectCollection.addNew();
            Date date1 = interviewTimePeriod.getDate();
            object.set("indexdate", (Object)date1);
            object.set("starttime", (Object)interviewTimePeriod.getStartTime());
            object.set("endtime", (Object)interviewTimePeriod.getEndTime());
        }
    }

    public String getJsonDataByReqParam(IFormView view, String args) {
        SetAbleInterviewTimeReqParam param = this.getPram(view, args);
        return this.getAbleInterviewTimeJson(view, param);
    }

    private SetAbleInterviewTimeReqParam getPram(IFormView view, String argsJson) {
        try {
            SetAbleInterviewTimeReqParam cast = (SetAbleInterviewTimeReqParam)HRJSONUtils.cast((String)argsJson, SetAbleInterviewTimeReqParam.class);
            cast.setInterviewerId(((Long)this.getOpenPageParamToCache((IFormView)view).t1).longValue());
            return cast;
        }
        catch (IOException e) {
            log.error("SetAbleInterviewTimeReqParam parse error ", (Throwable)e);
            return null;
        }
    }

    private List<AbleInterviewTimeBean> getAbleInterviewTimeBeans(DynamicObject[] ableInterviewTime) {
        ArrayList<AbleInterviewTimeBean> oneInterviewerData = new ArrayList<AbleInterviewTimeBean>();
        HashMap tempMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyObj : ableInterviewTime) {
            LocalDateTime indexLocalDate;
            Date date = dyObj.getDate("indexdate");
            LocalDateTime now = LocalDateTime.now();
            LocalDate nowLocalDate = now.toLocalDate();
            if (nowLocalDate.isAfter((indexLocalDate = DateUtils.getLocalDateTimeByDate((Date)date)).toLocalDate())) continue;
            Date startTime = dyObj.getDate("starttime");
            Date endTime = dyObj.getDate("endtime");
            LocalDateTime startTimeDb = DateUtils.getLocalDateTimeByDate((Date)startTime);
            LocalDateTime endTimeDb = DateUtils.getLocalDateTimeByDate((Date)endTime);
            if (now.isAfter(endTimeDb)) continue;
            if (now.isAfter(startTimeDb)) {
                startTime = DateUtils.getDateByLocalDateTime((LocalDateTime)now);
            }
            AbleInterviewTimeBean ableInterviewTimeBean = this.createOneTimeBean(oneInterviewerData, tempMap, date);
            AbleInterviewTimePeriod period = new AbleInterviewTimePeriod();
            period.setStartTime(startTime);
            period.setEndTime(endTime);
            ArrayList periodList = ableInterviewTimeBean.getPeriodList();
            if (CollectionUtils.isEmpty((Collection)periodList)) {
                periodList = new ArrayList();
                ableInterviewTimeBean.setPeriodList(periodList);
            }
            ableInterviewTimeBean.getPeriodList().add(period);
        }
        return oneInterviewerData;
    }

    private List<AbleInterviewTimeBean> getUnAbleInterviewTimeBeans(DynamicObject[] ableInterviewTime) {
        ArrayList<AbleInterviewTimeBean> oneInterviewerData = new ArrayList<AbleInterviewTimeBean>();
        HashMap tempMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyObj : ableInterviewTime) {
            Date date = dyObj.getDate("uindexdate");
            AbleInterviewTimeBean ableInterviewTimeBean = this.createOneTimeBean(oneInterviewerData, tempMap, date);
            AbleInterviewTimePeriod period = new AbleInterviewTimePeriod();
            period.setDate(date);
            period.setStartTime(dyObj.getDate("ustarttime"));
            period.setEndTime(dyObj.getDate("uendtime"));
            ArrayList periodList = ableInterviewTimeBean.getPeriodList();
            if (CollectionUtils.isEmpty((Collection)periodList)) {
                periodList = new ArrayList();
                ableInterviewTimeBean.setPeriodList(periodList);
            }
            ableInterviewTimeBean.getPeriodList().add(period);
        }
        return oneInterviewerData;
    }

    @NotNull
    private AbleInterviewTimeBean createOneTimeBean(List<AbleInterviewTimeBean> oneInterviewerData, Map<Date, AbleInterviewTimeBean> tempMap, Date date) {
        AbleInterviewTimeBean ableInterviewTimeBean = tempMap.get(date);
        if (HRObjectUtils.isEmpty((Object)ableInterviewTimeBean)) {
            ableInterviewTimeBean = new AbleInterviewTimeBean();
            tempMap.put(date, ableInterviewTimeBean);
            ableInterviewTimeBean.setInterviewDate(date);
            oneInterviewerData.add(ableInterviewTimeBean);
        }
        return ableInterviewTimeBean;
    }

    public void renderJsonData(String eventArgs, IFormView view) {
        String json = this.getJsonDataByReqParam(view, eventArgs);
        this.setCustomData("customDataObj", json, view);
    }

    public void setCustomData(String key, String value, IFormView view) {
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)16);
        customParam.put(key, value);
        customcontrol.setData((Object)customParam);
    }

    public void setTitle(PreOpenFormEventArgs evt) {
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        formShowParameter.setCaption((String)formShowParameter.getCustomParam("page_caption"));
    }

    private SetAbleInterviewTimeFormHelper() {
    }

    public static SetAbleInterviewTimeFormHelper getInstance() {
        return SetAbleInterviewTimeFormHelperHolder.INSTANCE;
    }

    private static class SetAbleInterviewTimeFormHelperHolder {
        private static final SetAbleInterviewTimeFormHelper INSTANCE = new SetAbleInterviewTimeFormHelper();

        private SetAbleInterviewTimeFormHelperHolder() {
        }
    }
}

