/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.calendar;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.BosUserServiceHelper;
import kd.tsc.tsirm.common.entity.intv.calendar.AbleInterviewTimePeriod;
import kd.tsc.tsirm.common.entity.intv.calendar.Participants;
import kd.tsc.tsirm.common.entity.intv.calendar.SetAbleInterviewTimeReqParam;
import kd.tsc.tsirm.common.entity.intv.calendar.YzjTimeHelperDataDetailBean;
import kd.tsc.tsirm.common.entity.intv.calendar.YzjTimeHelperReturnBean;
import kd.tsc.tsrbd.business.domain.common.service.TscDispatchServiceHelper;
import kd.tsc.tsrbd.business.domain.intvfile.IntvFileHelper;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;
import org.apache.commons.lang3.StringUtils;

public class SetAbleInterviewTimeHelper {
    public static final Log log = LogFactory.getLog(SetAbleInterviewTimeHelper.class);
    private static final HRBaseServiceHelper INTERVIEW_CALENDAR_HELPER = new HRBaseServiceHelper("tsirm_intvcalendartpl");
    public static final int INT_EIGHT = 8;
    public static final int INT_TWENTY_TWO = 22;

    public static SetAbleInterviewTimeHelper getInstance() {
        return SetAbleInterviewTimeHelperHolder.INSTANCE;
    }

    public static DynamicObject[] queryIntvCalendar(String selectProperties, QFilter qFilter) {
        return INTERVIEW_CALENDAR_HELPER.query(selectProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject getEmptyInterviewCalendar(Object interviewId) {
        DynamicObject object = SetAbleInterviewTimeHelper.getEmptyInterviewCalendar();
        object.set("tipendtime", (Object)DateUtils.getDateByLocalDateTime((LocalDateTime)LocalDateTime.now().plusDays(-1L)));
        object.set("interviewer", interviewId);
        return object;
    }

    public static DynamicObject getEmptyInterviewCalendar() {
        return INTERVIEW_CALENDAR_HELPER.generateEmptyDynamicObject();
    }

    public static DynamicObject[] getSetAbleInterviewTime(long interviewId) {
        String queryStr = StringUtils.joinWith((String)".", (Object[])new Object[]{"interviewer", "id"});
        QFilter qFilter = new QFilter(queryStr, "=", (Object)interviewId);
        return INTERVIEW_CALENDAR_HELPER.query(qFilter.toArray());
    }

    public static long getAbleInterviewTimePagePkId(Long interviewId) {
        long pkId;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_intvcalendartpl");
        Object[] arrData = SetAbleInterviewTimeHelper.getSetAbleInterviewTime(interviewId);
        if (!HRArrayUtils.isEmpty((Object[])arrData)) {
            pkId = arrData[0].getLong("id");
        } else {
            DynamicObject emptyInterviewCalendar = SetAbleInterviewTimeHelper.getEmptyInterviewCalendar(interviewId);
            helper.saveOne(emptyInterviewCalendar);
            pkId = emptyInterviewCalendar.getLong("id");
        }
        return pkId;
    }

    public static DynamicObject[] getInterviewerAbleTime(SetAbleInterviewTimeReqParam param) {
        QFilter selQFilter = SetAbleInterviewTimeHelper.ableInterviewTimeQFilter(param);
        return INTERVIEW_CALENDAR_HELPER.query(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"interviewer", "tipendtime", "indexdate", TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_canintventry", "indexdate"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_canintventry", "starttime"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_canintventry", "endtime"})}), selQFilter.toArray());
    }

    private static QFilter ableInterviewTimeQFilter(SetAbleInterviewTimeReqParam param) {
        QFilter qFilter1 = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"interviewer", "id"}), "=", (Object)param.getInterviewerId());
        QFilter qFilter2 = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_canintventry", "indexdate"}), ">=", (Object)DateUtils.getDateByLocalDateTime((LocalDateTime)DateUtils.getLocalDateTimeByDate((Date)param.getStartTime())));
        QFilter qFilter3 = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_canintventry", "indexdate"}), "<=", (Object)DateUtils.getDateByLocalDateTime((LocalDateTime)DateUtils.getLocalDateTimeByDate((Date)param.getEndTime())));
        return qFilter1.and(qFilter2).and(qFilter3);
    }

    public static DynamicObject[] getInterviewerAbleTimeOriginArray(SetAbleInterviewTimeReqParam param) {
        QFilter selQFilter = SetAbleInterviewTimeHelper.ableInterviewTimeQFilter(param);
        return INTERVIEW_CALENDAR_HELPER.queryOriginalArray(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"interviewer", "tipendtime", "tsirm_canintventry.indexdate as indexdate", "tsirm_canintventry.starttime as starttime", "tsirm_canintventry.endtime as endtime"}), selQFilter.toArray());
    }

    public static DynamicObject[] getInterviewerUnAbleTime(SetAbleInterviewTimeReqParam param) {
        QFilter selQFilter = SetAbleInterviewTimeHelper.unAbleInterviewTimeQFilter(param);
        return INTERVIEW_CALENDAR_HELPER.query(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"interviewer", "tipendtime", TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_cannotintventry", "uindexdate"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_cannotintventry", "ustarttime"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_cannotintventry", "uendtime"})}), selQFilter.toArray());
    }

    public static DynamicObject[] getInterviewerUnAbleTimeOriginArray(SetAbleInterviewTimeReqParam param) {
        QFilter selQFilter = SetAbleInterviewTimeHelper.unAbleInterviewTimeQFilter(param);
        return INTERVIEW_CALENDAR_HELPER.queryOriginalArray(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"interviewer", "tipendtime", "tsirm_cannotintventry.uindexdate as uindexdate", "tsirm_cannotintventry.ustarttime as ustarttime", "tsirm_cannotintventry.uendtime as uendtime"}), selQFilter.toArray());
    }

    private static QFilter unAbleInterviewTimeQFilter(SetAbleInterviewTimeReqParam param) {
        QFilter qFilter1 = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"interviewer", "id"}), "=", (Object)param.getInterviewerId());
        QFilter qFilter2 = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_cannotintventry", "uindexdate"}), ">=", (Object)param.getStartTime());
        QFilter qFilter3 = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_cannotintventry", "uindexdate"}), "<=", (Object)param.getEndTime());
        return qFilter1.and(qFilter2).and(qFilter3);
    }

    public static DynamicObject[] getNearTwoWeekInterviewerAbleTime(Long interviewerId) {
        SetAbleInterviewTimeReqParam setAbleInterviewTimeReqParam = new SetAbleInterviewTimeReqParam();
        setAbleInterviewTimeReqParam.setInterviewerId(interviewerId.longValue());
        LocalDateTime now = LocalDateTime.now();
        setAbleInterviewTimeReqParam.setStartTime(DateUtils.getDateByLocalDateTime((LocalDateTime)now));
        setAbleInterviewTimeReqParam.setEndTime(DateUtils.getDateByLocalDateTime((LocalDateTime)DateUtils.getNextWeekSunday((LocalDateTime)now)));
        return SetAbleInterviewTimeHelper.getInterviewerAbleTimeOriginArray(setAbleInterviewTimeReqParam);
    }

    public static boolean nearWeekHasSet(Long interviewerId) {
        Object[] nearTwoWeekInterviewerAbleTime = SetAbleInterviewTimeHelper.getNearTwoWeekInterviewerAbleTime(interviewerId);
        return !HRArrayUtils.isEmpty((Object[])nearTwoWeekInterviewerAbleTime);
    }

    public DynamicObject getInterviewTimeMainData(Long interviewerId) {
        SetAbleInterviewTimeReqParam param = new SetAbleInterviewTimeReqParam();
        param.setInterviewerId(interviewerId.longValue());
        return SetAbleInterviewTimeHelper.getInterviewTimeMainData(param);
    }

    public static DynamicObject getInterviewTimeMainData(SetAbleInterviewTimeReqParam param) {
        QFilter qFilter = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"interviewer", "id"}), "=", (Object)param.getInterviewerId());
        return INTERVIEW_CALENDAR_HELPER.queryOne(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"interviewer", "tipendtime"}), qFilter.toArray());
    }

    public static void updateNoPromptForWeek(long currentUserId, LocalDateTime localDateTime) {
        QFilter qFilter = new QFilter(StringUtils.join((Object[])new String[]{".", "interviewer", "id"}), "=", (Object)currentUserId);
        DynamicObject object = INTERVIEW_CALENDAR_HELPER.loadDynamicObject(qFilter);
        object.set("tipendtime", (Object)DateUtils.getDateByLocalDateTime((LocalDateTime)localDateTime));
        INTERVIEW_CALENDAR_HELPER.save(new DynamicObject[]{object});
    }

    public static void save(DynamicObject dynamicObject) {
        INTERVIEW_CALENDAR_HELPER.save(new DynamicObject[]{dynamicObject});
    }

    public static void saveAll(DynamicObject[] dynamicObject) {
        INTERVIEW_CALENDAR_HELPER.save(dynamicObject);
    }

    public static void clearData(DynamicObject dataEntity, Set<LocalDate> cleanDate) {
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("tsirm_canintventry");
        ArrayList rmvObj = Lists.newArrayList();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Date date = dynamicObject.getDate("indexdate");
            LocalDateTime localDateTimeByDate = DateUtils.getLocalDateTimeByDate((Date)date);
            LocalDate from = LocalDate.from(localDateTimeByDate);
            if (!cleanDate.contains(from)) continue;
            rmvObj.add(dynamicObject);
        }
        dynamicObjectCollection.removeAll((Collection)rmvObj);
    }

    public static List<AbleInterviewTimePeriod> getAbleInterviewTimePeriod(LocalDateTime start, LocalDateTime end) {
        ArrayList list = Lists.newArrayListWithCapacity((int)(end.toLocalDate().compareTo(start.toLocalDate()) + 1));
        AbleInterviewTimePeriod period = new AbleInterviewTimePeriod();
        period.setDate(DateUtils.getDateByLocalDateTime((LocalDateTime)start.withHour(0).withMinute(0).withSecond(0).withNano(0)));
        period.setStartTime(DateUtils.getDateByLocalDateTime((LocalDateTime)start));
        period.setEndTime(DateUtils.getDateByLocalDateTime((LocalDateTime)start.withHour(22).withMinute(0).withSecond(0)));
        list.add(period);
        start = start.plusDays(1L);
        while (start.isBefore(end)) {
            AbleInterviewTimePeriod tempPeriod = new AbleInterviewTimePeriod();
            tempPeriod.setDate(DateUtils.getDateByLocalDateTime((LocalDateTime)start.withHour(0).withMinute(0).withSecond(0).withNano(0)));
            tempPeriod.setStartTime(DateUtils.getDateByLocalDateTime((LocalDateTime)start.withHour(8).withMinute(0).withSecond(0)));
            tempPeriod.setEndTime(DateUtils.getDateByLocalDateTime((LocalDateTime)start.withHour(22).withMinute(0).withSecond(0)));
            list.add(tempPeriod);
            start = start.plusDays(1L);
        }
        return list;
    }

    public void queryYzjDetailAndSetCantIntv(String id) {
        if (HRStringUtils.isEmpty((String)id)) {
            log.error("Yzj-> id is empty");
            return;
        }
        HashMap ids = Maps.newHashMapWithExpectedSize((int)4);
        ids.put("id", id);
        ids = TscDispatchServiceHelper.invokeBizServiceByMap((String)"getMeetingInfo", (Map)ids);
        if (ids.isEmpty() || ids.size() <= 1) {
            return;
        }
        YzjTimeHelperReturnBean resultObject = null;
        try {
            resultObject = (YzjTimeHelperReturnBean)JSON.parseObject((String)JSON.toJSONString((Object)ids), YzjTimeHelperReturnBean.class);
        }
        catch (Exception e) {
            log.error("Yzj->  json transform to  YzjTimeHelperReturnBean fail e: ", (Throwable)e);
            return;
        }
        boolean success = resultObject.isSuccess();
        if (success) {
            YzjTimeHelperDataDetailBean data = resultObject.getData();
            String channelId = data.getId();
            long startDate = data.getStartDate();
            long endDate = data.getEndDate();
            List<String> openIds = data.getParticipants().stream().map(Participants::getOpenid).collect(Collectors.toList());
            DynamicObject[] interviews = BosUserServiceHelper.queryUserIdByOpenIds(openIds);
            List<Long> Ids = Arrays.stream(interviews).map(interview -> interview.getLong("id")).collect(Collectors.toList());
            Object[] intvCalendars = this.getOrGenerateIntverCalendar(Ids);
            if (HRArrayUtils.isEmpty((Object[])intvCalendars)) {
                return;
            }
            this.generateCantIntvCalendar(channelId, startDate, endDate, (DynamicObject[])intvCalendars);
        }
    }

    public DynamicObject[] getOrGenerateIntverCalendar(List<Long> Ids) {
        ArrayList resList = Lists.newArrayListWithExpectedSize((int)Ids.size());
        DynamicObject[] intverFiles = IntvFileHelper.getInstance().getIntverFileByUserId(Ids);
        Collections.addAll(resList, intverFiles);
        List<Long> intverFileUser = Arrays.stream(intverFiles).map(file -> file.getLong("userid")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = SetAbleInterviewTimeHelper.queryExistInterviewer(Ids);
        List calendarUser = Arrays.stream(dynamicObjects).map(calendar -> calendar.getDynamicObject("interviewer").getLong("id")).collect(Collectors.toList());
        ArrayList newInterviewCalendar = Lists.newArrayList();
        for (Long intverFileId : intverFileUser) {
            if (calendarUser.contains(intverFileId)) continue;
            DynamicObject emptyInterviewCalendar = SetAbleInterviewTimeHelper.getEmptyInterviewCalendar(intverFileId);
            newInterviewCalendar.add(emptyInterviewCalendar);
        }
        SetAbleInterviewTimeHelper.saveAll(newInterviewCalendar.toArray(new DynamicObject[0]));
        return this.getInterviewCalendar(intverFileUser);
    }

    private DynamicObject[] getInterviewCalendar(List<Long> ids) {
        return INTERVIEW_CALENDAR_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("interviewer.id", "in", ids)});
    }

    public void deleteById(String meetingId) {
        DynamicObject[] objects;
        for (DynamicObject object : objects = INTERVIEW_CALENDAR_HELPER.loadDynamicObjectArray(QFilter.of((String)"tsirm_cannotintventry.channelid = ?", (Object[])new Object[]{meetingId}).toArray())) {
            DynamicObjectCollection dynamicObjectCollection = object.getDynamicObjectCollection("tsirm_cannotintventry");
            ArrayList rmvObjs = Lists.newArrayList();
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String channelId = dynamicObject.getString("channelid");
                if (!HRStringUtils.equals((String)channelId, (String)meetingId)) continue;
                rmvObjs.add(dynamicObject);
            }
            dynamicObjectCollection.removeAll((Collection)rmvObjs);
        }
        INTERVIEW_CALENDAR_HELPER.update(objects);
    }

    private void generateCantIntvCalendar(String channelId, long startDate, long endDate, DynamicObject[] intvCalendars) {
        for (int i = 0; i < intvCalendars.length; ++i) {
            LocalDateTime localEndTime;
            DynamicObject intvCalendar = intvCalendars[i];
            DynamicObjectCollection canNotIntvEntry = intvCalendar.getDynamicObjectCollection("tsirm_cannotintventry");
            LocalDateTime localStartTime = DateUtils.getLocalDateTimeByDate((Date)new Date(startDate));
            if (!Objects.equals(localStartTime, localEndTime = DateUtils.getLocalDateTimeByDate((Date)new Date(endDate)))) {
                DynamicObject newCannotIntvEntry = canNotIntvEntry.addNew();
                newCannotIntvEntry.set("channelid", (Object)channelId);
                newCannotIntvEntry.set("uindexdate", (Object)this.getDateNoTime(localStartTime));
                newCannotIntvEntry.set("ustarttime", (Object)new Date(startDate));
                newCannotIntvEntry.set("uendtime", (Object)new Date(endDate));
                newCannotIntvEntry.set("datasource", (Object)"0");
                continue;
            }
            List<AbleInterviewTimePeriod> ableInterviewTimePeriod = SetAbleInterviewTimeHelper.getAbleInterviewTimePeriod(localStartTime, localEndTime);
            for (AbleInterviewTimePeriod interviewTimePeriod : ableInterviewTimePeriod) {
                DynamicObject newCannotIntvEntry = canNotIntvEntry.addNew();
                newCannotIntvEntry.set("channelid", (Object)channelId);
                newCannotIntvEntry.set("uindexdate", (Object)interviewTimePeriod.getDate());
                newCannotIntvEntry.set("ustarttime", (Object)interviewTimePeriod.getStartTime());
                newCannotIntvEntry.set("uendtime", (Object)interviewTimePeriod.getEndTime());
                newCannotIntvEntry.set("datasource", (Object)"0");
            }
        }
        INTERVIEW_CALENDAR_HELPER.update(intvCalendars);
    }

    public Date getDateNoTime(LocalDateTime localDateTime) {
        LocalDateTime noTimeDate = localDateTime.withHour(0).withSecond(0).withMinute(0).withNano(0);
        return DateUtils.getDateByLocalDateTime((LocalDateTime)noTimeDate);
    }

    public static DynamicObject[] queryExistInterviewer(List<Long> interviewIds) {
        QFilter qFilter = new QFilter("interviewer", "in", interviewIds).and("enable", "=", (Object)"1");
        return INTERVIEW_CALENDAR_HELPER.query(new QFilter[]{qFilter});
    }

    public static DynamicObject[] getInterviewerTime(List<Long> interviewIds, Date dateIndex) {
        QFilter qFilter1 = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"interviewer", "id"}), "in", interviewIds);
        return INTERVIEW_CALENDAR_HELPER.query(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"interviewer", "tipendtime", TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_cannotintventry", "uindexdate"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_cannotintventry", "ustarttime"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_cannotintventry", "uendtime"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_canintventry", "indexdate"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_canintventry", "starttime"}), TSCBaseUtils.getSelPropDot((String[])new String[]{"tsirm_canintventry", "endtime"})}), qFilter1.toArray());
    }

    private static class SetAbleInterviewTimeHelperHolder {
        private static final SetAbleInterviewTimeHelper INSTANCE = new SetAbleInterviewTimeHelper();

        private SetAbleInterviewTimeHelperHolder() {
        }
    }
}

