/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.home;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.home.TssrmService;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.HrStringBuilder;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ArgIntvServiceImp
implements TssrmService {
    private HRBaseServiceHelper tsrbsArgIntvServiceHelper = new HRBaseServiceHelper("tsirm_argintv");

    public DynamicObjectCollection listArgIntv(String type, Date date) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        if (HRStringUtils.equals((String)type, (String)"myarrange")) {
            qFilters.add(new QFilter("interviewarranger", "=", (Object)TSCRequestContext.getUserId()));
        }
        if (HRStringUtils.equals((String)type, (String)"myresponsible")) {
            qFilters.add(new QFilter("id", "in", this.getArgIntvIdsOfIntver(TSCRequestContext.getUserId())));
        }
        HrStringBuilder intvDate = new HrStringBuilder(new StringBuilder());
        intvDate.multAppend(new String[]{"tsirm_intvroundentry", ".", "tsirm_intvgroupentry", ".", "intvdate"});
        qFilters.add(new QFilter(intvDate.toString(), "=", (Object)LocalDate.parse(DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd"), DateFormatConstants.NORM_DATE_FORM)));
        HrStringBuilder selects = new HrStringBuilder(new StringBuilder());
        selects.multAppend(new String[]{"id", ","});
        selects.multAppend(new String[]{"createtime", ","});
        selects.multAppend(new String[]{"interviewarranger", ","});
        selects.multAppend(new String[]{"interviewarranger.name", ","});
        selects.multAppend(new String[]{"interviewtitle", ","});
        selects.multAppend(new String[]{"intvorgfrm", ","});
        selects.multAppend(new String[]{"intvevlsts", ","});
        selects.multAppend(new String[]{"interviewstatus", ","});
        selects.multAppend(new String[]{"tsirm_intvroundentry", ".", "interviewmethod.name", ","});
        selects.multAppend(new String[]{"tsirm_intvroundentry", ".", "interviewtheme.name", ","});
        selects.multAppend(new String[]{"tsirm_intvroundentry", ".", "tsirm_intvgroupentry", ".", "id", ","});
        selects.multAppend(new String[]{"tsirm_intvroundentry", ".", "tsirm_intvgroupentry", ".", "intvstarttime", ","});
        selects.multAppend(new String[]{"tsirm_intvroundentry", ".", "tsirm_intvgroupentry", ".", "intver", ".", "fbasedataid", ".", "name"});
        HrStringBuilder orderBys = new HrStringBuilder(new StringBuilder());
        orderBys.multAppend(new String[]{"tsirm_intvroundentry", ".", "tsirm_intvgroupentry", ".", "intvstarttime", " asc", ","});
        orderBys.multAppend(new String[]{"createtime", " asc"});
        return this.tsrbsArgIntvServiceHelper.queryOriginalCollection(selects.toString(), qFilters.toArray(new QFilter[0]), orderBys.toString());
    }

    public DynamicObject[] listArgIntv(String type, String firstDate, String lastDay) {
        return this.tsrbsArgIntvServiceHelper.query("intvdate", this.commonQFilter(type, firstDate, lastDay).toArray(new QFilter[0]), null);
    }

    public List<String> listArgIntvDate(String type, String firstDate, String lastDay) {
        DynamicObject[] dynamicObjects = this.tsrbsArgIntvServiceHelper.queryOriginalArray("tsirm_intvroundentry.tsirm_intvgroupentry.intvdate", this.commonQFilter(type, firstDate, lastDay).toArray(new QFilter[0]), null);
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return Lists.newArrayList();
        }
        ArrayList dateList = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            String date = dynamicObject.getString("tsirm_intvroundentry.tsirm_intvgroupentry.intvdate");
            if (HRStringUtils.isBlank((CharSequence)date)) {
                return;
            }
            dateList.add(date);
        });
        return dateList;
    }

    private List<QFilter> commonQFilter(String type, String firstDate, String lastDay) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        if (HRStringUtils.equals((String)type, (String)"myarrange")) {
            qFilters.add(new QFilter("interviewarranger", "=", (Object)TSCRequestContext.getUserId()));
        }
        if (HRStringUtils.equals((String)type, (String)"myresponsible")) {
            qFilters.add(new QFilter("tsirm_intvroundentry.tsirm_intvgroupentry.intver.fbasedataid", "=", (Object)TSCRequestContext.getUserId()));
        }
        HrStringBuilder intvDate = new HrStringBuilder(new StringBuilder());
        intvDate.multAppend(new String[]{"tsirm_intvroundentry", ".", "tsirm_intvgroupentry", ".", "intvdate"});
        qFilters.add(new QFilter(intvDate.toString(), ">=", (Object)LocalDate.parse(firstDate, DateFormatConstants.NORM_DATE_FORM)));
        qFilters.add(new QFilter(intvDate.toString(), "<=", (Object)LocalDate.parse(lastDay, DateFormatConstants.NORM_DATE_FORM)));
        return qFilters;
    }

    private List<Long> getArgIntvIdsOfIntver(long id) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("tsirm_intvroundentry.tsirm_intvgroupentry.intver.fbasedataid", "=", (Object)id));
        DynamicObjectCollection intvColl = this.tsrbsArgIntvServiceHelper.queryOriginalCollection("id", qFilters.toArray(new QFilter[0]));
        ArrayList<Long> ids = new ArrayList<Long>(intvColl.size());
        for (DynamicObject dynamicObject : intvColl) {
            ids.add(dynamicObject.getLong("id"));
        }
        return ids;
    }
}

