/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.home;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.intv.service.home.TssrmService;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.HrStringBuilder;
import org.apache.commons.lang3.time.DateFormatUtils;

public class IntvEvlServiceImp
implements TssrmService {
    private HRBaseServiceHelper tsrbsIntvEvlServiceHelper = new HRBaseServiceHelper("tsirm_intvevl");
    public static final String HANDLE_STATUS_PENDING = "A";
    public static final String HANDLE_STATUS_FINISH = "B";

    public DynamicObject[] listTodayIntvEvl() {
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)4);
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("handlestatus", "in", (Object)new String[]{HANDLE_STATUS_PENDING, HANDLE_STATUS_FINISH}));
        qFilters.add(new QFilter("interviewer", "=", (Object)TSCRequestContext.getUserId()));
        qFilters.add(new QFilter("intvgroup.intvdate", "=", (Object)LocalDate.now()));
        HrStringBuilder selects = new HrStringBuilder(new StringBuilder());
        selects.multAppend(new String[]{"resume", ","});
        selects.multAppend(new String[]{"application", ","});
        selects.multAppend(new String[]{"application", ".", "appres", ","});
        selects.multAppend(new String[]{"argintv", ".", "interviewarranger", ","});
        selects.multAppend(new String[]{"interviewstatus", ","});
        selects.multAppend(new String[]{"handlestatus", ","});
        selects.multAppend(new String[]{"intvevlrslt", ","});
        selects.multAppend(new String[]{"intvtask", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "id", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "intvstarttime", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "addressdetail", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "interviewroom", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "interviewmethod", ","});
        selects.multAppend(new String[]{"round", ".", "interviewmethod", ","});
        selects.multAppend(new String[]{"resume", ".", "fullname", ","});
        selects.multAppend(new String[]{"application", ".", "position", ","});
        return this.tsrbsIntvEvlServiceHelper.query(selects.toString(), qFilters.toArray(new QFilter[0]), "intvgroup.intvstarttime asc");
    }

    public DynamicObject[] listIntvTask(String firstDate, String lastDate) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("handlestatus", "=", (Object)HANDLE_STATUS_PENDING));
        qFilters.add(new QFilter("intvtask.taskstatus", "in", (Object)new String[]{HANDLE_STATUS_PENDING, HANDLE_STATUS_FINISH}));
        qFilters.add(new QFilter("interviewer", "=", (Object)TSCRequestContext.getUserId()));
        HrStringBuilder intvDateQf = new HrStringBuilder(new StringBuilder());
        intvDateQf.multAppend(new String[]{"intvgroup", ".", "intvdate"});
        if (firstDate != null) {
            qFilters.add(new QFilter(intvDateQf.toString(), ">=", (Object)LocalDate.parse(firstDate, DateFormatConstants.NORM_DATE_FORM)));
        }
        if (lastDate != null) {
            qFilters.add(new QFilter(intvDateQf.toString(), "<=", (Object)LocalDate.parse(lastDate, DateFormatConstants.NORM_DATE_FORM)));
        }
        return this.tsrbsIntvEvlServiceHelper.query("resume", qFilters.toArray(new QFilter[0]));
    }

    public DynamicObject[] listIntvTask(Date date) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("intvtask.taskstatus", "in", (Object)new String[]{HANDLE_STATUS_PENDING, HANDLE_STATUS_FINISH}));
        qFilters.add(new QFilter("interviewer", "=", (Object)TSCRequestContext.getUserId()));
        qFilters.add(new QFilter("intvgroup.intvdate", "=", (Object)LocalDate.parse(DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd"), DateFormatConstants.NORM_DATE_FORM)));
        HrStringBuilder selects = new HrStringBuilder(new StringBuilder());
        selects.multAppend(new String[]{"resume", ","});
        selects.multAppend(new String[]{"application", ","});
        selects.multAppend(new String[]{"argintv", ".", "interviewtitle", ","});
        selects.multAppend(new String[]{"round", ".", "interviewmethod", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "id", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "intvstarttime", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "interviewlocation", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "interviewroom", ","});
        selects.multAppend(new String[]{"intvgroup", ".", "intvervedioaddress", ","});
        selects.multAppend(new String[]{"resume", ".", "fullname", ","});
        selects.multAppend(new String[]{"intvtask", ".", "taskstatus", ","});
        selects.multAppend(new String[]{"intvtask", ".", "id"});
        return this.tsrbsIntvEvlServiceHelper.query(selects.toString(), qFilters.toArray(new QFilter[0]), "intvgroup.intvstarttime asc");
    }
}

