/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.interveranswer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.GroupEntity;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.HandOverWorkflowAndMailEntity;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.InteRverAnswerStateEntity;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckResultEntity;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvVariableInfoHelper;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class InteRverAnswerHelper {
    private static final HRBaseServiceHelper HRBASE_SERVICEHELPER = new HRBaseServiceHelper("tsirm_intvtask");
    private static final Log logger = LogFactory.getLog(InteRverAnswerHelper.class);

    public static boolean checkRverAnswerAgreeState(GroupEntity groupObj, DynamicObject[] intvevlInfos) {
        boolean checkRes = false;
        InteRverAnswerStateEntity inteRverAnswerState = InteRverAnswerHelper.getGroupStates(groupObj, intvevlInfos);
        if ((inteRverAnswerState.getInteRverAnswerState().equals("A") || inteRverAnswerState.getInteRverAnswerState().equals("C")) && inteRverAnswerState.getTaskState().equals("A")) {
            checkRes = true;
        }
        return checkRes;
    }

    public static boolean checkAnswerState(GroupEntity groupObj, DynamicObject[] intvevlInfos) {
        boolean checkRes = false;
        InteRverAnswerStateEntity inteRverAnswerState = InteRverAnswerHelper.getGroupStates(groupObj, intvevlInfos);
        if (inteRverAnswerState.getTaskState().equals("A")) {
            checkRes = true;
        }
        return checkRes;
    }

    public static boolean rverAnswerRefuse(List<GroupEntity> groupObj) {
        DynamicObject[] intvTasks = InteRverAnswerHelper.getIntvTasks(groupObj);
        for (int i = 0; i < intvTasks.length; ++i) {
            intvTasks[i].set("interveranswer", (Object)"C");
        }
        HRBASE_SERVICEHELPER.update(intvTasks);
        boolean refuseRes = true;
        return refuseRes;
    }

    public static boolean checkRverAnswerRefuseState(GroupEntity groupObj, DynamicObject[] intvevlInfos) {
        boolean checkRes = false;
        InteRverAnswerStateEntity inteRverAnswerState = InteRverAnswerHelper.getGroupStates(groupObj, intvevlInfos);
        if ((inteRverAnswerState.getInteRverAnswerState().equals("A") || inteRverAnswerState.getInteRverAnswerState().equals("B")) && inteRverAnswerState.getTaskState().equals("A")) {
            checkRes = true;
        }
        return checkRes;
    }

    public static IntvCheckResultEntity checkRverAnswerTransferState(GroupEntity groupObj, Long transferId) {
        IntvCheckResultEntity checkRes = new IntvCheckResultEntity();
        checkRes.setCheckResult(true);
        DynamicObject[] intvevlInfos = InteRverAnswerHelper.getIntvevlInfos(groupObj);
        InteRverAnswerStateEntity inteRverAnswerState = InteRverAnswerHelper.getGroupStates(groupObj, intvevlInfos);
        if (inteRverAnswerState.getInteRverAnswerState().equals("D") || !inteRverAnswerState.getTaskState().equals("A") || inteRverAnswerState.isIntvevl()) {
            checkRes.setCheckResult(false);
            checkRes.setCheckMessage(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u8f6c\u4ea4", (String)"InteRverAnswerHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            return checkRes;
        }
        boolean checkRverAnswerTransfer = InteRverAnswerHelper.checkRverAnswerTransfer(transferId, groupObj);
        if (checkRverAnswerTransfer) {
            checkRes.setCheckResult(false);
            checkRes.setCheckMessage(ResManager.loadKDString((String)"\u8f6c\u4ea4\u7684\u9762\u8bd5\u5b98\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8f6c\u4ea4\uff01", (String)"InteRverAnswerHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            return checkRes;
        }
        return checkRes;
    }

    public static boolean checkRverAnswerTransfer(Long transfer, GroupEntity groupObj) {
        boolean checkRes = false;
        for (int i = 0; i < groupObj.getInterViewerIds().size(); ++i) {
            if (!transfer.equals(groupObj.getInterViewerIds().get(i))) continue;
            checkRes = true;
        }
        return checkRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rverAnswerTransfer(List<GroupEntity> transferGroups, DynamicObjectCollection intvTasks, DynamicObject transferId) {
        boolean transferRes = true;
        if (transferGroups.size() == 0 && intvTasks.size() == 0) {
            return false;
        }
        HandOverWorkflowAndMailEntity workflowAndMailParam = new HandOverWorkflowAndMailEntity();
        long transfer = transferId.getLong("id");
        try (TXHandle htx = null;){
            htx = TX.required((String)"fi_voucher_submit");
            InteRverAnswerHelper.updateOldIntvInfo(transferGroups, transfer);
            InteRverAnswerHelper.updateGropuIntver(transferGroups, transfer);
            workflowAndMailParam = ArgIntvHelper.INSTANCE.handOverTo(intvTasks, transferId);
        }
        if (!Objects.isNull(workflowAndMailParam)) {
            ArgIntvHelper.INSTANCE.handOverWorkflowAndMail(workflowAndMailParam);
        }
        return transferRes;
    }

    public static void updateOldIntvInfo(List<GroupEntity> transferGroups, Long transferId) {
        DynamicObject[] intvTasks = InteRverAnswerHelper.getIntvTasks(transferGroups);
        for (int i = 0; i < intvTasks.length; ++i) {
            intvTasks[i].set("passedperson", (Object)transferId);
            intvTasks[i].set("taskstatus", (Object)"D");
            intvTasks[i].set("interveranswer", (Object)"D");
            intvTasks[i].set("enable", (Object)"0");
        }
        HRBASE_SERVICEHELPER.update(intvTasks);
        DynamicObject[] intvevlInfos = InteRverAnswerHelper.getIntvevlInfosByGroups(transferGroups);
        for (int i = 0; i < intvevlInfos.length; ++i) {
            intvevlInfos[i].set("handlestatus", (Object)"D");
            intvevlInfos[i].set("enable", (Object)"0");
        }
        HRBASE_SERVICEHELPER.update(intvevlInfos);
    }

    public static void updateGropuIntver(List<GroupEntity> transferGroups, Long transferId) {
        HRBaseServiceHelper helperGroup = new HRBaseServiceHelper("tsirm_intvgroup");
        Long userId = TSCRequestContext.getUserId();
        ArrayList<Long> groupIds = new ArrayList<Long>(transferGroups.size());
        for (int i = 0; i < transferGroups.size(); ++i) {
            groupIds.add(transferGroups.get(i).getGroupId());
        }
        QFilter qFilter = new QFilter("id", "in", groupIds);
        DynamicObject[] groups = helperGroup.query("detailid,intver,intverhr", new QFilter[]{qFilter});
        for (int i = 0; i < groups.length; ++i) {
            DynamicObject curGroup = groups[i];
            DynamicObjectCollection interViewers = curGroup.getDynamicObjectCollection("intver");
            DynamicObjectCollection interViewerHrs = curGroup.getDynamicObjectCollection("intverhr");
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{userId});
            for (int n = 0; n < interViewers.size(); ++n) {
                Long intver = ((DynamicObject)interViewers.get(n)).getDynamicObject("fbasedataid").getLong("id");
                if (!intver.equals(userId)) continue;
                DynamicObject intverObj = (DynamicObject)interViewers.get(n);
                intverObj.set("fbasedataid", (Object)transferId);
            }
        }
        helperGroup.update(groups);
    }

    public static boolean rverAnswerAgree(List<GroupEntity> groupObjs) {
        DynamicObject[] intvTasks = InteRverAnswerHelper.getIntvTasks(groupObjs);
        for (int i = 0; i < intvTasks.length; ++i) {
            intvTasks[i].set("interveranswer", (Object)"B");
        }
        HRBASE_SERVICEHELPER.update(intvTasks);
        boolean agreeRes = true;
        return agreeRes;
    }

    public static InteRverAnswerStateEntity getGroupStates(GroupEntity groupObj, DynamicObject[] intvevlInfos) {
        InteRverAnswerStateEntity groupstates = new InteRverAnswerStateEntity();
        DynamicObject intvTask = InteRverAnswerHelper.getIntvTask(groupObj);
        if (intvTask != null) {
            groupstates.setInteRverAnswerState(intvTask.getString("interveranswer"));
            groupstates.setTaskState(intvTask.getString("taskstatus"));
            groupstates.setIntvevl(InteRverAnswerHelper.getIsIntvevlOrNot(intvevlInfos));
        }
        return groupstates;
    }

    public static DynamicObject getIntvTask(GroupEntity groupObj) {
        DynamicObject intvTask = null;
        QFilter qFilterTask = new QFilter("id", "=", (Object)groupObj.getIntvTaskId());
        intvTask = IntvTaskHelper.getInstance().getIntvTaskObj(qFilterTask);
        return intvTask;
    }

    public static DynamicObject[] getIntvTasks(List<GroupEntity> groupObjs) {
        DynamicObject[] intvTasks = null;
        ArrayList<Long> groupIds = new ArrayList<Long>(groupObjs.size());
        for (int i = 0; i < groupObjs.size(); ++i) {
            groupIds.add(groupObjs.get(i).getGroupId());
        }
        long userId = TSCRequestContext.getUserId();
        ImmutableList noStatus = ImmutableList.of((Object)"B", (Object)"C", (Object)"E");
        QFilter qFilterTask = new QFilter("intvgroup", "in", groupIds).and("interviewer", "=", (Object)userId).and("taskstatus", "not in", (Object)noStatus);
        intvTasks = IntvTaskHelper.getInstance().getIntvTaskObjs(qFilterTask);
        return intvTasks;
    }

    public static boolean getIntvTaskStates(List<Long> taskIds) {
        boolean taskStateRes = true;
        if (taskIds.size() == 0) {
            return taskStateRes;
        }
        QFilter qFilterTask = new QFilter("id", "in", taskIds);
        DynamicObject[] intvTasks = IntvTaskHelper.getInstance().getIntvTaskObjs(qFilterTask);
        int taskCount = 0;
        for (int i = 0; i < intvTasks.length; ++i) {
            if (!intvTasks[i].getString("taskstatus").equals("C")) continue;
            ++taskCount;
        }
        if (taskCount == intvTasks.length) {
            taskStateRes = false;
        }
        return taskStateRes;
    }

    public static List<GroupEntity> getIntvTaskByGroup(Long argIntvId, DynamicObject groupDO, DynamicObject roundDO) {
        long userId = TSCRequestContext.getUserId();
        Long groupId = groupDO.getLong("id");
        QFilter qFilterTask = new QFilter("intvgroup", "=", (Object)groupId).and("interviewer", "=", (Object)userId).and("taskstatus", "!=", (Object)"E");
        DynamicObject[] intvTasks = IntvTaskHelper.getInstance().getIntvTasksNoEnableFilter(qFilterTask);
        ArrayList<GroupEntity> groupObjList = new ArrayList<GroupEntity>(intvTasks.length);
        for (int i = 0; i < intvTasks.length; ++i) {
            DynamicObject intvTask = intvTasks[i];
            GroupEntity groupObj = InteRverAnswerHelper.setGroupEntity(argIntvId, groupDO, roundDO, intvTask);
            groupObjList.add(groupObj);
        }
        return groupObjList;
    }

    public static boolean getIsIntvevlOrNot(DynamicObject[] intvevlInfos) {
        boolean isIntvevlOrNot = false;
        if (intvevlInfos != null) {
            for (int i = 0; i < intvevlInfos.length; ++i) {
                String interviewstatus = intvevlInfos[i].getString("interviewstatus");
                if (!interviewstatus.equals("B") && !interviewstatus.equals("C")) continue;
                isIntvevlOrNot = true;
            }
        }
        return isIntvevlOrNot;
    }

    public static DynamicObject[] getIntvevlInfos(GroupEntity groupObj) {
        DynamicObject[] intvevlInfo = null;
        long userId = TSCRequestContext.getUserId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filters = new QFilter("intvgroup", "=", (Object)groupObj.getGroupId()).and("interviewer", "=", (Object)userId).and(enableFilter);
        String fields = String.join((CharSequence)",", "application", "interviewstatus", "handlestatus", "interviewer");
        intvevlInfo = IntvEvlHelper.getInstance().queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
        return intvevlInfo;
    }

    public static DynamicObject[] getIntvevlInfosByGroupId(DynamicObject[] intvelDOs, Long groupId) {
        ArrayList<DynamicObject> intvevlInfo = new ArrayList<DynamicObject>(intvelDOs.length);
        for (int i = 0; i < intvelDOs.length; ++i) {
            Long intvelDOGroupId = intvelDOs[i].getDynamicObject("intvgroup").getLong("id");
            if (!groupId.equals(intvelDOGroupId)) continue;
            intvevlInfo.add(intvelDOs[i]);
        }
        return intvevlInfo.toArray(new DynamicObject[intvevlInfo.size()]);
    }

    public static DynamicObject[] getAllIntvevlInfos(Long intvId) {
        DynamicObject[] intvevlInfo = null;
        long userId = TSCRequestContext.getUserId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filters = new QFilter("argintv", "=", (Object)intvId).and("interviewer", "=", (Object)userId).and(enableFilter);
        String fields = String.join((CharSequence)",", "application", "intvgroup", "interviewstatus", "handlestatus", "interviewer");
        intvevlInfo = IntvEvlHelper.getInstance().queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
        return intvevlInfo;
    }

    public static DynamicObject[] getIntvevlInfosByGroups(List<GroupEntity> groupObjs) {
        DynamicObject[] intvevlInfo = null;
        ArrayList<Long> groupIds = new ArrayList<Long>(groupObjs.size());
        for (int i = 0; i < groupObjs.size(); ++i) {
            groupIds.add(groupObjs.get(i).getGroupId());
        }
        long userId = TSCRequestContext.getUserId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filters = new QFilter("intvgroup", "in", groupIds).and("interviewer", "=", (Object)userId).and(enableFilter);
        String fields = String.join((CharSequence)",", "application", "interviewstatus", "handlestatus", "enable", "interviewer");
        intvevlInfo = IntvEvlHelper.getInstance().queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
        return intvevlInfo;
    }

    public static List<GroupEntity> getIntvGroupsByIntvId(Long argIntvId, Long intverId) {
        ArrayList groups = Lists.newArrayListWithCapacity((int)10);
        DynamicObjectCollection intvGroups = null;
        DynamicObject interview = ArgIntvHelper.selectById(argIntvId, "tsirm_argintv");
        DynamicObjectCollection intvRounds = interview.getDynamicObjectCollection("tsirm_intvroundentry");
        if (intvRounds == null || intvRounds.isEmpty()) {
            logger.error("rounds business object is null,argIntvId:{}", (Object)argIntvId);
            return groups;
        }
        for (int n = 0; n < intvRounds.size(); ++n) {
            DynamicObject roundDO = (DynamicObject)intvRounds.get(n);
            intvGroups = roundDO.getDynamicObjectCollection("tsirm_intvgroupentry");
            if (intvGroups == null || intvGroups.isEmpty()) {
                logger.error("group business object is null, roundInfo:{}", (Object)roundDO.toString());
                return groups;
            }
            for (int i = 0; i < intvGroups.size(); ++i) {
                DynamicObject groupDO = (DynamicObject)intvGroups.get(i);
                List<GroupEntity> groupObj = InteRverAnswerHelper.getIntvTaskByGroup(argIntvId, groupDO, roundDO);
                groups.addAll(groupObj);
            }
        }
        return groups;
    }

    public static GroupEntity setGroupEntity(Long argIntvId, DynamicObject groupDO, DynamicObject intvRoundDO, DynamicObject intvTaskDO) {
        DynamicObject addressDetail;
        GroupEntity groupObj = new GroupEntity();
        groupObj.setArgintvId(argIntvId);
        groupObj.setGroupId(groupDO.getLong("id"));
        groupObj.setIntvTaskId(intvTaskDO.getLong("id"));
        groupObj.setTaskState(intvTaskDO.getString("taskstatus"));
        DynamicObject persionDO = intvTaskDO.getDynamicObject("passedperson");
        groupObj.setPassPersonName(InteRverAnswerHelper.getPassPersionName(persionDO));
        groupObj.setInterViewMethodId(intvRoundDO.getDynamicObject("interviewmethod").getLong("id"));
        groupObj.setInterViewerName(InteRverAnswerHelper.getInterViewerNameByGroup(groupDO, intvTaskDO));
        Date intvDate = intvTaskDO.getDate("intvdate") == null ? groupDO.getDate("intvdate") : intvTaskDO.getDate("intvdate");
        groupObj.setIntvDate(HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)intvDate));
        groupObj.setIntvDateTypeDate(intvDate);
        long intvStartTime = intvTaskDO.getLong("intvstarttime") == 0L ? groupDO.getLong("intvstarttime") : intvTaskDO.getLong("intvstarttime");
        groupObj.setIntvStartTime(IntvDateUtil.formatTime((Long)intvStartTime, (String)"HH:mm"));
        groupObj.setIntvStartTimeTypeLong(intvStartTime);
        DynamicObject dynamicObject = addressDetail = intvTaskDO.getDynamicObject("addressdetail") == null ? groupDO.getDynamicObject("addressdetail") : intvTaskDO.getDynamicObject("addressdetail");
        if (!Objects.isNull(addressDetail)) {
            String country = addressDetail.getString("country.name");
            String city = addressDetail.getString("city.name");
            String detailaddr = addressDetail.getString("detailaddr.name");
            String room = intvTaskDO.getString("interviewroom");
            String interViewLocation = IntvVariableInfoHelper.handel(country) + IntvVariableInfoHelper.handel(city) + IntvVariableInfoHelper.handel(detailaddr) + IntvVariableInfoHelper.handel(room);
            groupObj.setInterViewLocation(interViewLocation);
        }
        groupObj.setIntvMethod(intvRoundDO.getDynamicObject("interviewmethod").getString("name"));
        groupObj.setIntvUrl(groupDO.getString("intvervedioaddress"));
        groupObj.setInterViewerIds(InteRverAnswerHelper.getInterViewerIdsByGroup(groupDO));
        groupObj.setAppLicationIds(InteRverAnswerHelper.getAppLicationIdsByGroup(groupDO));
        return groupObj;
    }

    public static String getPassPersionName(DynamicObject persionDO) {
        String passPersionName = "";
        if (null != persionDO) {
            passPersionName = persionDO.getString("name");
        }
        return passPersionName;
    }

    public static boolean checkGoupIntvRver(DynamicObject group, Long intverId) {
        boolean checkGoupIntvRverRes = false;
        List<Long> interViewerIds = InteRverAnswerHelper.getInterViewerIdsByGroup(group);
        if (interViewerIds.indexOf(intverId) > -1) {
            checkGoupIntvRverRes = true;
        }
        return checkGoupIntvRverRes;
    }

    public static String getInterViewerNameByGroup(DynamicObject group, DynamicObject intvTaskDO) {
        String interViewerName = "";
        String passfromPerson = "";
        boolean isPassTask = false;
        DynamicObject passfromPersonDO = intvTaskDO.getDynamicObject("passedpersonfrom");
        if (passfromPersonDO != null) {
            String passfromPersonName = passfromPersonDO.getString("name");
            passfromPerson = String.format(Locale.ROOT, ResManager.loadKDString((String)"(\u6765\u81ea%s\u8f6c\u4ea4\u7684\u9762\u8bd5\u4efb\u52a1)", (String)"IntvPassFrom_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]), passfromPersonName);
            isPassTask = true;
        }
        DynamicObjectCollection interViewers = group.getDynamicObjectCollection("intver");
        for (int i = 0; i < interViewers.size(); ++i) {
            DynamicObject baseData;
            DynamicObject dynamicObject = (DynamicObject)interViewers.get(i);
            if (null == dynamicObject || null == (baseData = dynamicObject.getDynamicObject("fbasedataid"))) continue;
            Long interViewerId = baseData.getLong("id");
            interViewerName = interViewerId.equals(TSCRequestContext.getUserId()) && isPassTask ? interViewerName.concat(baseData.getString("name").concat(passfromPerson).concat(",")) : interViewerName.concat(baseData.getString("name").concat(","));
        }
        interViewerName = interViewerName.substring(0, interViewerName.length() - 1);
        return interViewerName;
    }

    public static List<Long> getInterViewerIdsByGroup(DynamicObject group) {
        DynamicObjectCollection interViewers = group.getDynamicObjectCollection("intver");
        ArrayList<Long> interViewerIds = new ArrayList<Long>(interViewers.size());
        for (DynamicObject interViewer : interViewers) {
            DynamicObject dynamicObject;
            Object objectId;
            if (interViewer == null || null == interViewer.getDynamicObject("fbasedataid") || !((objectId = (dynamicObject = interViewer.getDynamicObject("fbasedataid")).get("id")) instanceof Long)) continue;
            interViewerIds.add((Long)objectId);
        }
        return interViewerIds;
    }

    public static List<Long> getAppLicationIdsByGroup(DynamicObject group) {
        DynamicObjectCollection appfiles = group.getDynamicObjectCollection("groupcandate");
        ArrayList<Long> appLicationIds = new ArrayList<Long>(appfiles.size());
        for (int i = 0; i < appfiles.size(); ++i) {
            if (((DynamicObject)appfiles.get(i)).getDynamicObject("fbasedataid") == null) continue;
            appLicationIds.add(((DynamicObject)appfiles.get(i)).getDynamicObject("fbasedataid").getLong("id"));
        }
        return appLicationIds;
    }

    public static String getGenderDesc(String gender) {
        switch (gender) {
            case "0": {
                return ResManager.loadKDString((String)"\u7537", (String)"resscr_sex_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\u5973", (String)"resscr_sex_1", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u672a\u77e5", (String)"resscr_sex_2", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            }
        }
        return null;
    }
}

