/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.ai.AiConfigHelper;
import kd.tsc.tsirm.business.domain.intv.service.ai.InterviewAiService;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.InterviewAiHtml;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvVariableInfoHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tsirm.business.domain.position.service.PositionHelper;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewCancelModel;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailAddrParam;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailParam;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tsirm.common.enums.TSIRMPreDataEnum;
import kd.tsc.tsirm.common.enums.intv.InterviewMailType;
import kd.tsc.tsirm.common.util.IntvMailUtils;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InterviewEmailHelper {
    private static final Log LOG = LogFactory.getLog(InterviewEmailHelper.class);
    private static final InterviewEmailHelper INTERVIEW_EMAIL_HELPER = new InterviewEmailHelper();

    private InterviewEmailHelper() {
    }

    public static InterviewEmailHelper getInstance() {
        return INTERVIEW_EMAIL_HELPER;
    }

    public void generateForCancel(Map<String, Object> conMap) {
        String htmlTitle = InterviewAiHtml.HTML_TITLE.getHtml();
        String titleLabel = " <div class=\"title-content\">\u53d6\u6d88\u9762\u8bd5\u901a\u77e5</div>";
        String title = String.format(htmlTitle, ResManager.loadKDString((String)titleLabel, (String)"InterviewEmailHelper_35", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        conMap.put("interviewertitle", title);
        conMap.put("interviewdashedline", InterviewAiHtml.HTML_DASHED_LINE.getHtml());
    }

    public void generateFirstLineForUpdateObj(Map<String, Object> conMap) {
        String htmlTitle = InterviewAiHtml.HTML_TITLE.getHtml();
        String titleLabel = String.format(" <div class=\"title-content\">\u9762\u8bd5\u5b89\u6392\u4fee\u6539\u901a\u77e5-%s</div>", conMap.get("interviewcandiname"));
        String title = String.format(htmlTitle, titleLabel);
        conMap.put("interviewertitle", title);
        conMap.put("interviewdashedline", InterviewAiHtml.HTML_DASHED_LINE.getHtml());
    }

    public void generateFirstLineForUpdate(Map<String, String> conMap) {
        String htmlTitle = InterviewAiHtml.HTML_TITLE.getHtml();
        String titleLabel = String.format(" <div class=\"title-content\">\u9762\u8bd5\u5b89\u6392\u4fee\u6539\u901a\u77e5-%s</div>", conMap.get("interviewcandiname"));
        String title = String.format(htmlTitle, titleLabel);
        conMap.put("interviewertitle", title);
        conMap.put("interviewdashedline", InterviewAiHtml.HTML_DASHED_LINE.getHtml());
    }

    public void generateFirstLineForArrangeObj(Map<String, Object> conMap) {
        String htmlTitle = InterviewAiHtml.HTML_TITLE.getHtml();
        boolean ccFlag = conMap.get("ccFlag") != null && (conMap.get("ccFlag") instanceof Boolean ? (Boolean)conMap.get("ccFlag") != false : Boolean.parseBoolean(conMap.get("ccFlag").toString()));
        String titleLabel = ccFlag ? String.format("<div class=\"title-content\">\u6284\u9001-\u5019\u9009\u4eba<span class=\"interview-name\">\u3010%s\u3011</span>\u7684\u9762\u8bd5\u4efb\u52a1\u9080\u7ea6</div>", conMap.get("interviewcandiname")) : String.format("<div class=\"title-content\">\u5019\u9009\u4eba<span class=\"interview-name\">\u3010%s\u3011</span>\u7684\u9762\u8bd5\u4efb\u52a1\u9080\u7ea6</div>", conMap.get("interviewcandiname"));
        String title = String.format(htmlTitle, titleLabel);
        conMap.put("interviewertitle", title);
        conMap.put("interviewdashedline", InterviewAiHtml.HTML_DASHED_LINE.getHtml());
    }

    public void generateFirstLineForArrange(Map<String, String> conMap) {
        String htmlTitle = InterviewAiHtml.HTML_TITLE.getHtml();
        boolean ccFlag = conMap.get("ccFlag") != null && Boolean.parseBoolean(conMap.get("ccFlag"));
        String titleLabel = ccFlag ? String.format("<div class=\"title-content\">\u6284\u9001-\u5019\u9009\u4eba<span class=\"interview-name\">\u3010%s\u3011</span>\u7684\u9762\u8bd5\u4efb\u52a1\u9080\u7ea6</div>", conMap.get("interviewcandiname")) : String.format("<div class=\"title-content\">\u5019\u9009\u4eba<span class=\"interview-name\">\u3010%s\u3011</span>\u7684\u9762\u8bd5\u4efb\u52a1\u9080\u7ea6</div>", conMap.get("interviewcandiname"));
        String title = String.format(htmlTitle, titleLabel);
        conMap.put("interviewertitle", title);
        conMap.put("interviewdashedline", InterviewAiHtml.HTML_DASHED_LINE.getHtml());
    }

    public static String generateTable(DynamicObject dataEntity, InterviewNoticeModel interviewNoticeModel, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, InterviewNoticeModel editTypeNoticeModel) {
        DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
        Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
        DynamicObject[] candidateDbList = IntvMailHelper.getCandidateDbArray(dataEntity);
        InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, editTypeNoticeModel);
        return InterviewEmailHelper.generateTableParam(param, candidateDbList, null, groupUpdateMap, null);
    }

    public static String generateTable(DynamicObject dataEntity, InterviewNoticeModel interviewNoticeModel, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, InterviewNoticeModel editTypeNoticeModel, List<Long> interviewerId, List<DynamicObject> intvTaskList) {
        DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
        Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
        DynamicObject[] candidateDbList = IntvMailHelper.getCandidateDbArray(dataEntity);
        InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, editTypeNoticeModel);
        param.setIntvTaskList(intvTaskList);
        return InterviewEmailHelper.generateTableParam(param, candidateDbList, null, groupUpdateMap, null, interviewerId);
    }

    public static String generateTableParam(InterviewMailParam mailParam, DynamicObject[] candidateDbList, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels, List<Long> interviewerId) {
        DynamicObject dataEntity = mailParam.getDataEntity();
        DynamicObject[] interviewDbjList = mailParam.getInterviewDbjList();
        InterviewNoticeModel noticeType = mailParam.getNoticeType();
        InterviewNoticeModel editNoticeType = mailParam.getEditNoticeType();
        DynamicObjectCollection groupEntry = IntvMailCommonHelper.getInterviewGroupByEntity(dataEntity);
        LinkedHashMap interviewerMailContentMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        InterviewMailType editType = IntvMailCommonHelper.getInterviewMailType(noticeType, editNoticeType);
        InterviewNoticeModel editorModel = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, editType);
        InterviewMailParam interviewTableParam = new InterviewMailParam(interviewDbjList, noticeType, editorModel);
        boolean isUpdateCancel = IntvMailCommonHelper.getIsUpdateCancel(noticeType, editNoticeType);
        interviewTableParam.setUpdateCancel(isUpdateCancel);
        interviewTableParam.setIntvTaskList(mailParam.getIntvTaskList());
        interviewTableParam.setDataEntity(mailParam.getDataEntity());
        return InterviewEmailHelper.getInterviewTableByCfgMsg(interviewTableParam, candidateDbList, groupEntry, interviewerMailContentMap, candidateCancelIds, groupUpdateEntity, cancelModels, interviewerId);
    }

    public static String getInterviewTableByCfgMsg(InterviewMailParam mailType, DynamicObject[] candidateDbList, DynamicObjectCollection groupEntry, Map<Long, String> interviewerMailContentMap, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels, List<Long> interviewerId) {
        return InterviewEmailHelper.commonInterviewTable(mailType, candidateDbList, groupEntry, interviewerMailContentMap, candidateCancelIds, groupUpdateEntity, cancelModels, interviewerId);
    }

    public static String generateTableParam(InterviewMailParam mailParam, DynamicObject[] candidateDbList, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels) {
        DynamicObject dataEntity = mailParam.getDataEntity();
        DynamicObject[] interviewDbjList = mailParam.getInterviewDbjList();
        InterviewNoticeModel noticeType = mailParam.getNoticeType();
        InterviewNoticeModel editNoticeType = mailParam.getEditNoticeType();
        DynamicObjectCollection groupEntry = IntvMailCommonHelper.getInterviewGroupByEntity(dataEntity);
        LinkedHashMap interviewerMailContentMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        InterviewMailType editType = IntvMailCommonHelper.getInterviewMailType(noticeType, editNoticeType);
        InterviewNoticeModel editorModel = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, editType);
        InterviewMailParam interviewTableParam = new InterviewMailParam(interviewDbjList, noticeType, editorModel);
        boolean isUpdateCancel = IntvMailCommonHelper.getIsUpdateCancel(noticeType, editNoticeType);
        interviewTableParam.setUpdateCancel(isUpdateCancel);
        return InterviewEmailHelper.getInterviewTableByCfgMsg(interviewTableParam, candidateDbList, groupEntry, interviewerMailContentMap, candidateCancelIds, groupUpdateEntity, cancelModels);
    }

    public static String getInterviewTableByCfgMsg(InterviewMailParam mailType, DynamicObject[] candidateDbList, DynamicObjectCollection groupEntry, Map<Long, String> interviewerMailContentMap, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels) {
        return InterviewEmailHelper.commonInterviewTable(mailType, candidateDbList, groupEntry, interviewerMailContentMap, candidateCancelIds, groupUpdateEntity, cancelModels, Lists.newArrayListWithCapacity((int)0));
    }

    private static String commonInterviewTable(InterviewMailParam mailType, DynamicObject[] candidateDbList, DynamicObjectCollection groupEntry, Map<Long, String> interviewerMailContentMap, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels, List<Long> interviewerId) {
        InterviewNoticeModel addType = mailType.getNoticeType();
        InterviewMailType editType = mailType.getEditNoticeType().getInterviewMailType();
        List intvTaskList = mailType.getIntvTaskList();
        StringBuilder ccTable = new StringBuilder(5200);
        ccTable.append("<ul class=\"interviewInf\">");
        for (DynamicObject group : groupEntry) {
            List<DynamicObject> groupList;
            String curGroupTable;
            long groupId = group.getLong("id");
            if (addType.getInterviewMailType() == InterviewMailType.EDIT && IntvMailHelper.editorInterviewProcess(groupUpdateEntity, editType, groupId) || HRStringUtils.isEmpty((String)(curGroupTable = InterviewEmailHelper.assemblyOneInterviewerTable(groupList = IntvMailHelper.getGroupList(candidateDbList, group), candidateCancelIds, addType.getInterviewMailType(), editType, interviewerId, intvTaskList)))) continue;
            boolean isEditorUpdate = IntvMailHelper.getIsUpdate(addType, editType);
            String interviewMethod = addType.getInterviewMethodName();
            ccTable.append(String.format(InterviewAiHtml.HTML_TABLE.getHtml(), ResManager.loadKDString((String)"\u9762\u8bd5\u5f62\u5f0f\uff1a", (String)"InterviewEmailHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), interviewMethod));
            String interviewPositionName = candidateDbList[0].getString("position.name");
            ccTable.append(String.format(InterviewAiHtml.HTML_TABLE.getHtml(), ResManager.loadKDString((String)"\u9762\u8bd5\u804c\u4f4d\uff1a", (String)"InterviewEmailHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]), interviewPositionName));
            long positionId = candidateDbList[0].getLong("position.id");
            DynamicObject position = PositionHelper.queryOne(positionId);
            Optional.ofNullable(position).ifPresent(p -> {
                String useDept = IntvVariableInfoHelper.getUseDeptOrgName(position);
                ccTable.append(String.format(InterviewAiHtml.HTML_TABLE.getHtml(), ResManager.loadKDString((String)"\u7528\u4eba\u7ec4\u7ec7\uff1a", (String)"InterviewEmailHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), useDept));
            });
            String formatInterviewTime = IntvMailCommonHelper.getFormatIntvTime(group);
            InterviewEmailHelper.getInterviewTime(groupUpdateEntity, groupId, ccTable, isEditorUpdate, formatInterviewTime);
            Long interviewMethodId = addType.getInterviewMethodId();
            if (TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId) || TSIRMPreDataEnum.KEY_1040.getId().equals(interviewMethodId)) {
                boolean intvAddrChange = IntvMailHelper.getIntvAddrChange(groupUpdateEntity, group);
                String formatInterviewAddr = IntvMailHelper.getLineAddress(addType, editType, group, groupUpdateEntity, null, new InterviewMailAddrParam("intvervedioaddress", "<li><span class=\"interview-left\">\u9762\u8bd5\u5730\u70b9\uff1a</span>%s </li>", "<li><span class=\"interview-left\">\u9762\u8bd5\u5730\u70b9\uff1a</span>%s \uff08\u539f\u9762\u8bd5\u5730\u70b9\uff1a<s style=\" text-decoration: line-through;\"> %s\uff09</s></li>"), intvAddrChange);
                ccTable.append(formatInterviewAddr);
            }
            ccTable.append("</ul>");
            ccTable.append(curGroupTable);
            if (addType.getFromCancel() != null && addType.getFromCancel().booleanValue()) {
                return ccTable.toString();
            }
            boolean interviewerAIOpen = AiConfigHelper.getInstance().getIfOpen("intervieweraiemail");
            if (!interviewerAIOpen) {
                return ccTable.toString();
            }
            DynamicObject argIntv = mailType.getDataEntity();
            Optional.ofNullable(argIntv).ifPresent(dynamicObject -> {
                if (argIntv.getBoolean("interviewerai")) {
                    ccTable.append("{").append(((DynamicObject)groupList.get(0)).getLong("id")).append("}");
                }
            });
        }
        return ccTable.toString();
    }

    public static String assemblyOneInterviewerTable4Preview(DynamicObject appfile, Map<String, Object> mailMap, boolean isIntverMsg, DynamicObject dataEntity) {
        StringBuilder ccTable = new StringBuilder(5200);
        ccTable.append("<ul class=\"interviewInf\">");
        ccTable.append(String.format(InterviewAiHtml.HTML_TABLE.getHtml(), ResManager.loadKDString((String)"\u9762\u8bd5\u5f62\u5f0f\uff1a", (String)"InterviewEmailHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), mailMap.get("interviewmethod") == null ? "{\u9762\u8bd5\u5f62\u5f0f}" : mailMap.get("interviewmethod")));
        Object interviewPositionName = mailMap.get("interviewpositionname");
        ccTable.append(String.format(InterviewAiHtml.HTML_TABLE.getHtml(), ResManager.loadKDString((String)"\u9762\u8bd5\u804c\u4f4d\uff1a", (String)"InterviewEmailHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]), interviewPositionName == null ? "{\u9762\u8bd5\u804c\u4f4d}" : interviewPositionName));
        Object useDept = mailMap.get("adminorgsdpt");
        ccTable.append(String.format(InterviewAiHtml.HTML_TABLE.getHtml(), ResManager.loadKDString((String)"\u7528\u4eba\u7ec4\u7ec7\uff1a", (String)"InterviewEmailHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), useDept == null ? "{\u7528\u4eba\u7ec4\u7ec7}" : useDept));
        Object formatInterviewTime = mailMap.get("interviewtime");
        if (CfgMsgScenes.ARRANGE_INTERVIEW.getBaseDataId().equals(mailMap.get("msgSceneType"))) {
            ccTable.append(String.format("<li><span class=\"interview-left\">\u9762\u8bd5\u65f6\u95f4\uff1a</span>%s</li>", formatInterviewTime == null ? "{\u9762\u8bd5\u65f6\u95f4}" : formatInterviewTime));
            if (!ResManager.loadKDString((String)"\u7535\u8bdd\u9762\u8bd5", (String)"InterviewEmailHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0]).equals(mailMap.get("interviewmethod"))) {
                Object interviewLocation = StringUtils.isEmpty((CharSequence)((String)mailMap.get("interviewlocation"))) ? (mailMap.get("interviewvediolocation") == null ? "" : mailMap.get("interviewvediolocation")) : mailMap.get("interviewlocation");
                ccTable.append(String.format(Locale.ROOT, "<li><span class=\"interview-left\">\u9762\u8bd5\u5730\u70b9\uff1a</span>%s </li>", HRObjectUtils.isEmpty((Object)interviewLocation) ? "{\u9762\u8bd5\u5730\u5740}" : interviewLocation));
            }
        } else if (CfgMsgScenes.CANCEL_INTERVIEW.getBaseDataId().equals(mailMap.get("msgSceneType"))) {
            ccTable.append(String.format(Locale.ROOT, "<li><span class=\"interview-left\">\u9762\u8bd5\u65f6\u95f4\uff1a</span>%s \uff08\u539f\u9762\u8bd5\u65f6\u95f4\uff1a<s style=\" text-decoration: line-through;\"> %s\uff09</s></li>", HRObjectUtils.isEmpty((Object)formatInterviewTime) ? "{\u9762\u8bd5\u65f6\u95f4}" : formatInterviewTime, ResManager.loadKDString((String)"\u539f\u9762\u8bd5\u65f6\u95f4", (String)"InterviewEmailHelper_11", (String)"tsc-tsirm-business", (Object[])new Object[0])));
            if (!"\u7535\u8bdd\u9762\u8bd5".equals(mailMap.get("interviewmethod"))) {
                Object interviewlocation = StringUtils.isEmpty((CharSequence)((String)mailMap.get("interviewlocation"))) ? (mailMap.get("interviewvediolocation") == null ? "" : mailMap.get("interviewvediolocation")) : mailMap.get("interviewlocation");
                ccTable.append(String.format(Locale.ROOT, "<li><span class=\"interview-left\">\u9762\u8bd5\u5730\u70b9\uff1a</span>%s \uff08\u539f\u9762\u8bd5\u5730\u70b9\uff1a<s style=\" text-decoration: line-through;\"> %s\uff09</s></li>", HRObjectUtils.isEmpty((Object)interviewlocation) ? "{\u9762\u8bd5\u5730\u70b9}" : interviewlocation, ResManager.loadKDString((String)"\u539f\u9762\u8bd5\u5730\u70b9", (String)"InterviewEmailHelper_14", (String)"tsc-tsirm-business", (Object[])new Object[0])));
            }
        }
        ccTable.append("</ul>");
        ccTable.append(InterviewEmailHelper.assemblyEmailContent(appfile, isIntverMsg));
        boolean interviewerAIOpen = AiConfigHelper.getInstance().getIfOpen("intervieweraiemail");
        if (!interviewerAIOpen) {
            return ccTable.toString();
        }
        Optional.ofNullable(dataEntity).ifPresent(dynamicObject -> {
            if (dataEntity.getBoolean("interviewerai")) {
                ccTable.append(InterviewEmailHelper.appendAiQuestion(appfile, true));
            }
        });
        return ccTable.toString();
    }

    private static String assemblyOneInterviewerTable(List<DynamicObject> dynamicObjects, List<Long> candidateCancelIds, InterviewMailType type, InterviewMailType editType, List<Long> interviewerId, List<DynamicObject> intvTaskList) {
        return InterviewEmailHelper.commonAssemblyOneInterviewerTable(dynamicObjects, candidateCancelIds, type, editType, interviewerId, intvTaskList);
    }

    private static String commonAssemblyOneInterviewerTable(List<DynamicObject> dynamicObjects, List<Long> candidateCancelIds, InterviewMailType type, InterviewMailType editType, List<Long> interviewerId, List<DynamicObject> intvTaskList) {
        StringBuilder interviewerTable = new StringBuilder(5200);
        boolean hasText = false;
        for (DynamicObject dynamicObject : dynamicObjects) {
            long aLong = dynamicObject.getLong("id");
            if (type == InterviewMailType.CANCEL_SINGLE && !candidateCancelIds.contains(aLong)) continue;
            hasText = true;
            interviewerTable.append(InterviewEmailHelper.assemblyEmailContent(dynamicObject, interviewerId, intvTaskList));
        }
        if (InterviewMailType.CANCEL_SINGLE == type) {
            return hasText ? interviewerTable.toString() : "";
        }
        return interviewerTable.toString();
    }

    private static String assemblyEmailContent(DynamicObject obj, List<Long> interviewerId, List<DynamicObject> intvTaskList) {
        return InterviewEmailHelper.commonAssemblyEmailContent(obj, interviewerId, true, true, intvTaskList);
    }

    private static String assemblyEmailContent(DynamicObject obj, boolean isIntverMsg) {
        return InterviewEmailHelper.commonAssemblyEmailContent(obj, Lists.newArrayListWithCapacity((int)0), isIntverMsg, false, Lists.newArrayList());
    }

    private static String commonAssemblyEmailContent(DynamicObject obj, List<Long> interviewerId, boolean isIntverMsg, boolean isRealSend, List<DynamicObject> intvTaskList) {
        String personWrapper = InterviewAiHtml.PERSON_WRAPPER.getHtml();
        String appId = String.valueOf(obj.getLong("id"));
        String resumeId = IntvMailCommonHelper.getValue(obj, "appres.id");
        DynamicObject appFileFromDb = AppFileHelper.queryOne(obj.getLong("id"), "appres");
        DynamicObject resume = appFileFromDb.getDynamicObject("appres");
        String personImage = "";
        if (null != resume) {
            String photoUrl = resume.getString("photo");
            personImage = ObjectUtils.isEmpty((Object)photoUrl) ? "/images/pc/emotion/default_person_82_82.png" : photoUrl;
        }
        personImage = System.getProperty("imageServer.url") + personImage;
        String imgBase64Str = "data:image/png;base64," + InterviewEmailHelper.getImgBase64Str(personImage);
        String detailUrl = "";
        if (CollectionUtils.isNotEmpty(interviewerId) && isRealSend) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)2);
            param.put("app_id", appId);
            param.put("resume_id", resumeId);
            List interStrIdList = interviewerId.stream().map(String::valueOf).collect(Collectors.toList());
            String interStr = String.join((CharSequence)",", interStrIdList);
            param.put("interviewers", interStr);
            if (CollectionUtils.isNotEmpty(intvTaskList)) {
                intvTaskList.stream().filter(intv -> intv.getDynamicObject("interviewer").getLong("id") == ((Long)interviewerId.get(0)).longValue()).map(intv -> intv.getLong("id")).findFirst().ifPresent(interviewTaskId -> param.put("interviewtaskid", String.valueOf(interviewTaskId)));
            }
            detailUrl = IntvMailUtils.getFormDetailUrl((String)"tsirm_intvevaltaskir", (Map)param);
        }
        if (!isRealSend) {
            personWrapper = personWrapper.replace("href", "");
        }
        String candidateName = IntvMailCommonHelper.getValue(obj, "appres.fullname");
        String gender = "";
        if (!Objects.isNull(obj.get("appres.gender")) && obj.get("appres.gender") instanceof DynamicObject) {
            gender = obj.getDynamicObject("appres.gender").getString("name");
        }
        if (!Objects.isNull(obj.get("appres.gender")) && obj.get("appres.gender") instanceof Long) {
            gender = IntvMailCommonHelper.getGender(obj.getLong("appres.gender"));
        }
        String highEducation = IntvMailCommonHelper.getValue(obj, "appres.highesteducation.name");
        String graduateSchool = IntvMailCommonHelper.getValue(obj, "appres.highesteduschool.name");
        String graduateSchoolLabel = String.format(" <div class=\"school\">\u6bd5\u4e1a\u9662\u6821\uff1a%s</div>", graduateSchool);
        String specialty = IntvMailCommonHelper.getValue(obj, "appres.highestspecialty");
        int workYears = obj.getInt("appres.workingyears");
        String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workYears);
        String workYearShowLabel = String.format("<div class=\"time\" style=\"margin-left:12px;\">\u5de5\u4f5c\u5e74\u9650\uff1a%s</div>", workYearShow);
        String info = ResManager.loadKDString((String)"\u83b7\u53d6\u5019\u9009\u4eba\u66f4\u591a\u4fe1\u606f\u3001\u5f55\u5165\u9762\u8bd5\u8bc4\u4ef7", (String)"InterviewEmailHelper_17", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        return String.format(personWrapper, imgBase64Str, candidateName, gender, highEducation, specialty, graduateSchoolLabel + workYearShowLabel, detailUrl, info);
    }

    private static void appendSuffix(Map<Long, String> interviewerMailContentMap, StringBuilder ccTable) {
        for (Map.Entry<Long, String> longStringEntry : interviewerMailContentMap.entrySet()) {
            String value = longStringEntry.getValue();
            longStringEntry.setValue(value + "</div>");
        }
        ccTable.append("</div>");
    }

    private static void assembleInterviewTable(Map<Long, String> interviewerMailContentMap, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, InterviewMailType editType, long groupId, List<DynamicObject> interviewerDbObj, StringBuilder interviewTable, Map<Long, InterviewCancelModel> cancelModels, boolean isUpdateCancel) {
        for (DynamicObject next : interviewerDbObj) {
            List<Long> interViewerIdAdd;
            ArgIntvUpdateResultEntity argIntvUpdateResultEntity;
            long curInterviewId = next.getLong("id");
            boolean cancelInterviewerTask = IntvMailHelper.getInstance().isCancelInterviewerTaskFlag(cancelModels, groupId, curInterviewId);
            if (isUpdateCancel && cancelInterviewerTask) continue;
            if (InterviewMailType.EDIT_ADD_INTERVIEW == editType) {
                argIntvUpdateResultEntity = groupUpdateEntity.get(groupId);
                interViewerIdAdd = argIntvUpdateResultEntity.getInterViewerIdAdd();
                if (!interViewerIdAdd.contains(curInterviewId)) {
                    continue;
                }
            } else if (InterviewMailType.EDIT_CANCEL_INTERVIEW == editType) {
                if (MapUtils.isNotEmpty(groupUpdateEntity) && !(interViewerIdAdd = (argIntvUpdateResultEntity = groupUpdateEntity.get(groupId)).getInterViewerIdDelete()).contains(curInterviewId)) {
                    continue;
                }
            } else if (InterviewMailType.EDIT_UPDATE == editType) {
                argIntvUpdateResultEntity = groupUpdateEntity.get(groupId);
                interViewerIdAdd = argIntvUpdateResultEntity.getInterViewerIdNoChange();
                boolean isChange = IntvMailHelper.getInterviewerTimeOrAddrChange(argIntvUpdateResultEntity);
                if (!interViewerIdAdd.contains(curInterviewId) || !isChange) continue;
            }
            InterviewEmailHelper.addToInterviewerMap(interviewerMailContentMap, interviewTable, curInterviewId);
        }
    }

    private static void addToInterviewerMap(Map<Long, String> interviewerMailContentMap, StringBuilder interviewTable, long curInterviewId) {
        String interviewTables = interviewerMailContentMap.get(curInterviewId);
        if (HRStringUtils.isNotEmpty((String)interviewTables)) {
            interviewTables = interviewTables + interviewTable;
            interviewerMailContentMap.put(curInterviewId, interviewTables);
        } else {
            String tableTitleContent = "<div class='interview_table'>";
            interviewerMailContentMap.put(curInterviewId, tableTitleContent + interviewTable);
        }
    }

    private static void getInterviewTime(Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, long groupId, StringBuilder oneTableTitleContent, boolean isEditorUpdate, String formatInterviewTime) {
        ArgIntvUpdateResultEntity argIntvUpdateResultEntity;
        boolean timeValue = true;
        if (isEditorUpdate && (argIntvUpdateResultEntity = groupUpdateEntity.get(groupId)).isGroupIntvTimeChange()) {
            oneTableTitleContent.append(String.format("<li><span class=\"interview-left\">\u9762\u8bd5\u65f6\u95f4\uff1a</span>%s \uff08\u539f\u9762\u8bd5\u65f6\u95f4\uff1a<s style=\" text-decoration: line-through;\"> %s\uff09</s></li>", formatInterviewTime, IntvMailCommonHelper.getFormatIntvTime(argIntvUpdateResultEntity.getOldGroupDO())));
            timeValue = false;
        }
        if (timeValue) {
            oneTableTitleContent.append(String.format("<li><span class=\"interview-left\">\u9762\u8bd5\u65f6\u95f4\uff1a</span>%s</li>", formatInterviewTime));
        }
    }

    public static String appendAiQuestion(DynamicObject appFile, boolean fromPreview) {
        String questionTable;
        String answerWrapper = InterviewAiHtml.ANSWER_WRAPPER.getHtml();
        String answerHeader = InterviewAiHtml.ANSWER_HEADER.getHtml();
        String answerInfo = ResManager.loadKDString((String)"\u6839\u636e\u5019\u9009\u4eba\u4fe1\u606f\u548c\u5e94\u8058\u804c\u4f4d\u4fe1\u606f\u4e3a\u60a8\u63a8\u8350\u4ee5\u4e0b\u9762\u8bd5\u95ee\u9898\uff1a", (String)"InterviewEmailHelper_20", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        answerHeader = String.format(answerHeader, answerInfo);
        if (fromPreview) {
            questionTable = InterviewAiHtml.DEFAULT_ANSWER.getHtml();
        } else {
            DynamicObject dynamicObject = AppFileHelper.queryOne(appFile.getLong("id"));
            String aiQuestion = InterviewAiService.getInstance().getAiQuestion(dynamicObject);
            if (HRStringUtils.isNotEmpty((String)aiQuestion)) {
                AppFileHelper.updateInterviewerQuestion(dynamicObject, aiQuestion);
            }
            aiQuestion = InterviewAiService.getInstance().formatResult(aiQuestion, true);
            questionTable = String.format("<p>%s<p>", aiQuestion);
        }
        return answerWrapper + answerHeader + questionTable + "</div>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImgBase64Str(String imgUrl) {
        InputStream inputStream = null;
        byte[] data = null;
        try {
            int ch;
            URL url = new URL(imgUrl);
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((ch = inputStream.read()) != -1) {
                outputStream.write(ch);
            }
            data = outputStream.toByteArray();
            inputStream.close();
        }
        catch (IOException e) {
            LOG.error("getImgBase64Str error:{}", (Object)e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error("inputStream.close() error:{}", (Object)e.getMessage());
                }
            }
        }
        String rlt = "";
        try {
            rlt = new String(Base64.getEncoder().encode(data), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("getImgBase64Str UnsupportedEncodingException:{}", (Object)e.getMessage());
        }
        return rlt;
    }
}

