/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvupdate.ArgIntvUpdateIntvTaskEntity;
import kd.tsc.tsirm.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewCancelModel;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailParam;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tsirm.common.enums.intv.InterviewMailType;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.common.constants.IntvCfgMsgTempfdConstants;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import org.apache.commons.collections.CollectionUtils;

public class IntvMailCancelHelper {
    private IntvMailCancelHelper() {
    }

    public static IntvMailCancelHelper getInstance() {
        return IntvMailCancelHelperHolder.INSTANCE;
    }

    public List<InterviewMailSendBean> processCancel(List<DynamicObject> dataEntityList, List<Long> delInterviewIds, InterviewNoticeModel type, List<ArgIntvUpdateResultEntity> updateDataEntityList) {
        DynamicObject dataEntity = dataEntityList.get(0);
        List<Long> collect = dataEntityList.stream().map(task -> task.getLong("id")).collect(Collectors.toList());
        Map<Long, InterviewCancelModel> cancelModels = this.getCancelModels(collect, updateDataEntityList);
        DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
        Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
        DynamicObject[] candidateDbList = IntvMailHelper.getCandidateDbArray(dataEntity);
        InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.CANCEL);
        InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, type);
        HashMap groupUpdateMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty(updateDataEntityList)) {
            for (ArgIntvUpdateResultEntity updateDataEntity : updateDataEntityList) {
                groupUpdateMap.put(updateDataEntity.getGroupId(), updateDataEntity);
            }
        }
        List<InterviewMailSendBean> interviewerMailSendBeans = IntvMailCommonHelper.getInstance().processInterviewerMail(param, Lists.newArrayList(), candidateDbList, null, groupUpdateMap, cancelModels);
        InterviewMailParam mailParam = new InterviewMailParam(dataEntity, variableInfo, interviewNoticeModel, null);
        Map candidateResult = CfgMsgTemplateHelper.queryCfgMsgTemplateByPushSceneAndReceiver2IntvMail((Long)Long.valueOf(CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId()), (Long)Long.valueOf(CfgMsgRecvType.CANDIDATE.getBaseDataId()), (Long)IntvCfgMsgTempfdConstants.CANCEL_APPFILE_ID);
        String emailTheme = (String)candidateResult.get("emailtheme");
        String emailRichText = (String)candidateResult.get("emailrichtext");
        List<InterviewMailSendBean> candidateMailSendBeans = IntvMailHelper.getInstance().processCandidateMail(mailParam, Lists.newArrayList(), candidateDbList, emailRichText, emailTheme, null, null);
        Map receptionResult = CfgMsgTemplateHelper.queryCfgMsgTemplateByPushSceneAndReceiver2IntvMail((Long)Long.valueOf(CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId()), (Long)Long.valueOf(CfgMsgRecvType.RECEIVER.getBaseDataId()), (Long)IntvCfgMsgTempfdConstants.CANCEL_RECEPTION_ID);
        String emailThemeOfReception = (String)receptionResult.get("emailtheme");
        String emailRichTextOfReception = (String)receptionResult.get("emailrichtext");
        List<InterviewMailSendBean> receptionMailSendBeans = IntvMailHelper.getInstance().processReceptionistMail(param, candidateDbList, emailRichTextOfReception, emailThemeOfReception, Collections.emptyMap());
        LinkedList<InterviewMailSendBean> sendMailBeanList = new LinkedList<InterviewMailSendBean>();
        sendMailBeanList.addAll(interviewerMailSendBeans);
        sendMailBeanList.addAll(candidateMailSendBeans);
        sendMailBeanList.addAll(receptionMailSendBeans);
        String tag = ResManager.loadKDString((String)"\u53d6\u6d88\u9762\u8bd5\u901a\u77e5", (String)"IntvMailCancelHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String content = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u53d6\u6d88\u4e86\u60a8\u7684\u9762\u8bd5\u4efb\u52a1\uff0c\u5173\u6ce8\u6700\u65b0\u9762\u8bd5\u65e5\u5386", (String)"IntvMailCancelHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]), UserServiceHelper.getCurrentUser((String)"name").getString("name"));
        List<Long> interviewerIds = Arrays.stream(interviewDbjList).map(intr -> intr.getLong("id")).collect(Collectors.toList());
        if (!Objects.isNull(type) && InterviewMailType.EDIT_CANCEL_INTERVIEW != type.getInterviewMailType()) {
            IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
            IntvMailCommonHelper.getInstance().sendMessage(interviewerIds, tag, content);
        } else {
            ArrayList editorSendList = Lists.newArrayListWithExpectedSize((int)10);
            for (Long interviewerId : interviewerIds) {
                if (!delInterviewIds.contains(interviewerId)) continue;
                editorSendList.add(interviewerId);
            }
            IntvMailCommonHelper.getInstance().sendMessage(editorSendList, tag, content);
        }
        return sendMailBeanList;
    }

    private Map<Long, InterviewCancelModel> getCancelModels(Iterable<Long> longs, List<ArgIntvUpdateResultEntity> updateDataEntityList) {
        DynamicObject[] taskObjects;
        HashMap cancelModels = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty(updateDataEntityList)) {
            for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
                Long groupId = argIntvUpdateResultEntity.getGroupId();
                List<ArgIntvUpdateIntvTaskEntity> argInterviewerTasks = argIntvUpdateResultEntity.getArgInterviewerTasks();
                for (ArgIntvUpdateIntvTaskEntity argInterviewerTask : argInterviewerTasks) {
                    if (HRObjectUtils.isEmpty((Object)argInterviewerTask) || !HRStringUtils.equals((String)"Delete", (String)argInterviewerTask.getChangeType())) continue;
                    InterviewCancelModel interviewCancelModel = new InterviewCancelModel();
                    interviewCancelModel.setInterviewerId(argInterviewerTask.getInterviewerId());
                    interviewCancelModel.setInterviewerTaskId(argInterviewerTask.getIntvTaskId());
                    interviewCancelModel.setGroupId(groupId);
                    interviewCancelModel.setTaskStatus("C");
                    cancelModels.put(argInterviewerTask.getIntvTaskId(), interviewCancelModel);
                }
            }
            return cancelModels;
        }
        for (DynamicObject taskObject : taskObjects = IntvTaskHelper.getInstance().getIntvTaskObjs(new QFilter("argintv.id", "in", longs))) {
            InterviewCancelModel interviewCancelModel = new InterviewCancelModel();
            interviewCancelModel.setInterviewerId(Long.valueOf(taskObject.getLong("INTERVIEWER.id")));
            interviewCancelModel.setInterviewerTaskId(Long.valueOf(taskObject.getLong("id")));
            interviewCancelModel.setGroupId(Long.valueOf(taskObject.getLong("INTVGROUP.id")));
            interviewCancelModel.setTaskStatus(taskObject.getString("taskstatus"));
            cancelModels.put(taskObject.getLong("id"), interviewCancelModel);
        }
        return cancelModels;
    }

    private static class IntvMailCancelHelperHolder {
        private static final IntvMailCancelHelper INSTANCE = new IntvMailCancelHelper();

        private IntvMailCancelHelperHolder() {
        }
    }
}

