/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCancelHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tsirm.common.enums.intv.InterviewMailRol;
import kd.tsc.tsirm.common.enums.intv.InterviewMailType;
import org.apache.commons.collections.CollectionUtils;

public class IntvMailEditorHelper {
    public static final Log log = LogFactory.getLog(IntvMailEditorHelper.class);

    private IntvMailEditorHelper() {
    }

    public static IntvMailEditorHelper getInstance() {
        return IntvMailEditorHelperHolder.INSTANCE;
    }

    public void processEditor(DynamicObject dataEntity, List<DynamicObject> intvTaskList, List<ArgIntvUpdateResultEntity> updateDataEntityList) {
        HashMap groupUpdateMap = Maps.newHashMapWithExpectedSize((int)16);
        for (ArgIntvUpdateResultEntity updateDataEntity : updateDataEntityList) {
            groupUpdateMap.put(updateDataEntity.getGroupId(), updateDataEntity);
        }
        ArrayList<InterviewMailSendBean> sendMailBeanList = new ArrayList<InterviewMailSendBean>();
        ArrayList<Long> delInterviewIds = new ArrayList<Long>();
        ArrayList<Long> addInterviewIds = new ArrayList<Long>();
        ArrayList<Long> noChangeInterviewIds = new ArrayList<Long>();
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            addInterviewIds.addAll(argIntvUpdateResultEntity.getInterViewerIdAdd());
            noChangeInterviewIds.addAll(argIntvUpdateResultEntity.getInterViewerIdNoChange());
        }
        long interviewId = dataEntity.getLong("id");
        DynamicObject oldDataEntity = ArgIntvHelper.INSTANCE.getIntvDataEntiry(interviewId);
        Object[] interviewTaskIds = intvTaskList.toArray(new DynamicObject[0]);
        Object[] candidateTaskId = IntvAppfileTaskHelper.getInstance().findCandidateTaskByArgIntvId(interviewId);
        InterviewNoticeModel type = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT);
        boolean timeOrAddressChange = false;
        if (timeOrAddressChange = this.isTimeOrAddressChange(updateDataEntityList, timeOrAddressChange)) {
            InterviewNoticeModel editType = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT_UPDATE);
            List<InterviewMailSendBean> interviewMailSendBeans = IntvMailHelper.getInstance().processAddNew(dataEntity, Lists.newArrayList((Object[])interviewTaskIds), Lists.newArrayList((Object[])candidateTaskId), false, type, groupUpdateMap, editType);
            this.processAddrOrTime(sendMailBeanList, noChangeInterviewIds, interviewMailSendBeans);
        }
        boolean addInterviewer = false;
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            if (!CollectionUtils.isNotEmpty(argIntvUpdateResultEntity.getInterViewerIdAdd())) continue;
            addInterviewer = true;
            break;
        }
        if (addInterviewer) {
            this.processEditorAddInterview(dataEntity, groupUpdateMap, sendMailBeanList, addInterviewIds, oldDataEntity, (DynamicObject[])interviewTaskIds, (DynamicObject[])candidateTaskId);
        }
        boolean delInterviewer = false;
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            if (!CollectionUtils.isNotEmpty(argIntvUpdateResultEntity.getInterViewerIdDelete())) continue;
            delInterviewer = true;
            break;
        }
        if (delInterviewer) {
            InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT_CANCEL_INTERVIEW);
            IntvMailEditorHelper.processEditorDelInterview(oldDataEntity, sendMailBeanList, delInterviewIds, interviewNoticeModel, updateDataEntityList);
        }
        IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
    }

    private boolean isTimeOrAddressChange(List<ArgIntvUpdateResultEntity> updateDataEntityList, boolean timeOrAddressChange) {
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            boolean time = argIntvUpdateResultEntity.isGroupIntvTimeChange();
            boolean groupAddressChange = argIntvUpdateResultEntity.isGroupAddressChange();
            boolean groupAppAddressChange = argIntvUpdateResultEntity.isGroupAppAddressChange();
            boolean groupInterviewerAddressChange = argIntvUpdateResultEntity.isGroupInterviewerAddressChange();
            if (!groupAddressChange && !time && !groupAppAddressChange && !groupInterviewerAddressChange) continue;
            timeOrAddressChange = true;
            break;
        }
        return timeOrAddressChange;
    }

    public static void processEditorDelInterview(DynamicObject dataEntity, List<InterviewMailSendBean> sendMailBeanList, List<Long> delInterviewIds, InterviewNoticeModel type, List<ArgIntvUpdateResultEntity> updateDataEntityList) {
        List<InterviewMailSendBean> interviewMailSendBeans = IntvMailCancelHelper.getInstance().processCancel(Lists.newArrayList((Object[])new DynamicObject[]{dataEntity}), delInterviewIds, type, updateDataEntityList);
        for (InterviewMailSendBean interviewMailSendBean : interviewMailSendBeans) {
            if (interviewMailSendBean.getInterviewMailRol() != InterviewMailRol.INTERVIEWER || !delInterviewIds.contains(interviewMailSendBean.getId())) continue;
            sendMailBeanList.add(interviewMailSendBean);
        }
    }

    private void processEditorAddInterview(DynamicObject dataEntity, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, List<InterviewMailSendBean> sendMailBeanList, List<Long> addInterviewIds, DynamicObject oldDataEntity, DynamicObject[] interviewTaskIds, DynamicObject[] candidateTaskId) {
        InterviewNoticeModel type = IntvMailCommonHelper.getInterviewNoticeModel(oldDataEntity, InterviewMailType.ADD);
        InterviewNoticeModel editType = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT_ADD_INTERVIEW);
        List<InterviewMailSendBean> interviewMailSendBeans = IntvMailHelper.getInstance().processAddNew(dataEntity, Lists.newArrayList((Object[])interviewTaskIds), Lists.newArrayList((Object[])candidateTaskId), false, type, groupUpdateMap, editType);
        for (InterviewMailSendBean interviewMailSendBean : interviewMailSendBeans) {
            if (interviewMailSendBean.getInterviewMailRol() != InterviewMailRol.INTERVIEWER || !addInterviewIds.contains(interviewMailSendBean.getId())) continue;
            sendMailBeanList.add(interviewMailSendBean);
        }
    }

    private void processAddrOrTime(List<InterviewMailSendBean> sendMailBeanList, List<Long> noChangeInterviewIds, List<InterviewMailSendBean> interviewMailSendBeans) {
        for (InterviewMailSendBean interviewMailSendBean : interviewMailSendBeans) {
            if (InterviewMailRol.INTERVIEWER == interviewMailSendBean.getInterviewMailRol()) {
                if (!noChangeInterviewIds.contains(interviewMailSendBean.getId())) continue;
                sendMailBeanList.add(interviewMailSendBean);
                continue;
            }
            sendMailBeanList.add(interviewMailSendBean);
        }
    }

    private static class IntvMailEditorHelperHolder {
        private static final IntvMailEditorHelper INSTANCE = new IntvMailEditorHelper();

        private IntvMailEditorHelperHolder() {
        }
    }
}

