/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailPreviewHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tsirm.common.constants.intv.IntvMailConstants;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewCancelModel;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailAddrParam;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailParam;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tsirm.common.enums.TSIRMPreDataEnum;
import kd.tsc.tsirm.common.enums.intv.EmailTemplateTag;
import kd.tsc.tsirm.common.enums.intv.InterviewMailRol;
import kd.tsc.tsirm.common.enums.intv.InterviewMailType;
import kd.tsc.tsirm.common.util.IntvMailUtils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.common.constants.IntvCfgMsgTempfdConstants;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;
import kd.tsc.tsrbs.common.utils.Num2ChUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class IntvMailHelper {
    public static final Log log = LogFactory.getLog(IntvMailHelper.class);
    public static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("haos_adminorghr");
    public static final HRBaseServiceHelper USER_HELPER = new HRBaseServiceHelper("bos_user");

    private IntvMailHelper() {
    }

    public static IntvMailHelper getInstance() {
        IntvMailConstants.VARIABLE_INFO_NAME.put("workingYears", "{\u5de5\u4f5c\u5e74\u9650}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("gender", "{\u6027\u522b}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("school", "{\u6bd5\u4e1a\u9662\u6821}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("specialty", "{\u4e13\u4e1a}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("highestdegree", "{\u5b66\u4f4d}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("highesteducation", "{\u5b66\u5386}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("compName", "{\u516c\u53f8\u540d\u79f0}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("deptName", "{\u90e8\u95e8\u540d\u79f0}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("intvName", "{\u9762\u8bd5\u5b98\u59d3\u540d}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("intvMail", "{\u9762\u8bd5\u5b98\u90ae\u7bb1}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("groupCandateName", "{\u5019\u9009\u4eba\u59d3\u540d}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("groupCandateMail", "{\u5019\u9009\u4eba\u90ae\u7bb1}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("intvtime", "{\u9762\u8bd5\u65f6\u95f4}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("intvAddress", "{\u9762\u8bd5\u5730\u5740}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("intvVideoAddress", "{\u89c6\u9891\u9762\u8bd5\u5730\u5740}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("interviewtitle", "{\u9762\u8bd5\u6807\u9898}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("name", "{\u5e94\u8058\u804c\u4f4d}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("jobTitle", "{\u804c\u4f4d\u540d\u79f0}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("currentDate", "{\u5f53\u524d\u65e5\u671f}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("hrName", "{\u9762\u8bd5\u5b89\u6392\u4eba}");
        IntvMailConstants.VARIABLE_INFO_NAME.put("hrPhone", "{\u9762\u8bd5\u5b89\u6392\u4eba\u624b\u673a}");
        return IntvMailHelperHolder.INSTANCE;
    }

    public List<InterviewMailSendBean> processAddNew(DynamicObject dataEntity, List<DynamicObject> interviewerTaskList, List<DynamicObject> candidateTaskList, boolean send, InterviewNoticeModel interviewNoticeModel, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, InterviewNoticeModel editTypeNoticeModel) {
        InterviewMailParam mailParam;
        DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
        Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
        DynamicObject[] candidateDbList = IntvMailHelper.getCandidateDbArray(dataEntity);
        LinkedList<InterviewMailSendBean> sendMailBeanList = new LinkedList<InterviewMailSendBean>();
        if (interviewNoticeModel.isNoticeInterviewer()) {
            InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, editTypeNoticeModel);
            List<InterviewMailSendBean> interviewerMailSendBeans = IntvMailCommonHelper.getInstance().processInterviewerMail(param, interviewerTaskList, candidateDbList, null, groupUpdateMap, null);
            sendMailBeanList.addAll(interviewerMailSendBeans);
        }
        if (interviewNoticeModel.isNoticeCandidate()) {
            String candidateRichText = dataEntity.getString("txtmailcandidate_tag");
            String candidateTheme = dataEntity.getString("copitheme");
            mailParam = new InterviewMailParam(dataEntity, variableInfo, interviewNoticeModel, editTypeNoticeModel);
            List<InterviewMailSendBean> candidateMailSendBeans = this.processCandidateMail(mailParam, candidateTaskList, candidateDbList, candidateRichText, candidateTheme, null, groupUpdateMap);
            sendMailBeanList.addAll(candidateMailSendBeans);
        }
        if (interviewNoticeModel.isNoticeReceiver() && interviewNoticeModel.isEmailReceiver()) {
            String richText = dataEntity.getString("txtmailunawares_tag");
            String interviewTheme = dataEntity.getString("recptheme");
            mailParam = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, editTypeNoticeModel);
            List<InterviewMailSendBean> receptionMailSendBeans = this.processReceptionistMail(mailParam, candidateDbList, richText, interviewTheme, groupUpdateMap);
            sendMailBeanList.addAll(receptionMailSendBeans);
        }
        if (send) {
            IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
        }
        return sendMailBeanList;
    }

    public static DynamicObject[] getCandidateDbArray(DynamicObject dataEntity) {
        List appFileIds = dataEntity.getDynamicObjectCollection("intvcandate").stream().map(af -> af.getLong("fbasedataid_id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", appFileIds);
        return IntvMailCommonHelper.RESUME_HELPER.queryOriginalArray(String.join((CharSequence)",", IntvMailCommonHelper.APP_FILE_FIELDS), filter.toArray());
    }

    public String getSmsContent(String largeText, Map<String, String> variableInfo, Map<String, String> dynamicVariable) {
        for (Map.Entry<String, String> dynamicVar : dynamicVariable.entrySet()) {
            String key = dynamicVar.getKey();
            String value = dynamicVar.getValue();
            if (!HRStringUtils.isNotEmpty((String)key) || !HRStringUtils.isNotEmpty((String)value)) continue;
            value = value.replaceAll("\\$", "RDS_CHAR_DOLLAR");
            largeText = largeText.replaceAll("\\{" + key + "}", value);
            largeText = largeText.replaceAll("RDS_CHAR_DOLLAR", "\\$");
        }
        return IntvMailCommonHelper.replaceVariable(largeText, variableInfo);
    }

    public static String getInterviewTableByCfgMsg(InterviewMailParam mailType, DynamicObject[] candidateDbList, DynamicObjectCollection groupEntry, Map<Long, String> interviewerMailContentMap, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels) {
        return IntvMailHelper.commonInterviewTable(mailType, candidateDbList, groupEntry, interviewerMailContentMap, candidateCancelIds, groupUpdateEntity, cancelModels, Lists.newArrayListWithCapacity((int)0));
    }

    private static String commonInterviewTable(InterviewMailParam mailType, DynamicObject[] candidateDbList, DynamicObjectCollection groupEntry, Map<Long, String> interviewerMailContentMap, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels, List<Long> interviewerId) {
        DynamicObject[] interviewDbjList = mailType.getInterviewDbjList();
        InterviewNoticeModel addType = mailType.getNoticeType();
        InterviewMailType editType = mailType.getEditNoticeType().getInterviewMailType();
        boolean isUpdateCancel = mailType.isUpdateCancel();
        Map<Long, DynamicObject> interviewDbMap = IntvMailCommonHelper.getInstance().getInterviewerDbMap(interviewDbjList);
        StringBuilder ccTable = new StringBuilder(5200);
        int ccTableIsAppendCount = 0;
        ccTable.append("<div class='interview_table'>");
        int len = groupEntry.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject group = (DynamicObject)groupEntry.get(i);
            long groupId = group.getLong("id");
            if (addType.getInterviewMailType() == InterviewMailType.EDIT && IntvMailHelper.editorInterviewProcess(groupUpdateEntity, editType, groupId)) continue;
            List<DynamicObject> groupList = IntvMailHelper.getGroupList(candidateDbList, group);
            List<DynamicObject> interviewerDbObj = IntvMailHelper.getGroupInterviewer(interviewDbMap, group);
            String interviewerNames = interviewerDbObj.stream().map(intv -> intv.getString("name")).collect(Collectors.joining(","));
            boolean isCancel = IntvMailHelper.getIsCancel(addType.getInterviewMailType());
            String curGroupTable = IntvMailCommonHelper.getInstance().assemblyOneInterviewerTable(groupList, candidateCancelIds, addType.getInterviewMailType(), editType, interviewerId);
            if (HRStringUtils.isEmpty((String)curGroupTable)) continue;
            StringBuilder interviewTable = new StringBuilder(5200);
            interviewTable.append("<div class='interview_table_onetable'>");
            StringBuilder oneTableTitleContent = new StringBuilder(5200);
            oneTableTitleContent.append("<div>");
            boolean isEditorUpdate = IntvMailHelper.getIsUpdate(addType, editType);
            ArrayList cancelCandidateNames = Lists.newArrayListWithCapacity((int)10);
            String cancelTitleTxt = null;
            if (isCancel) {
                cancelTitleTxt = IntvMailHelper.getCancelTitleTxt(candidateCancelIds, addType, cancelModels, groupId, groupList, cancelCandidateNames);
            }
            String tableHeaderMethodLine = IntvMailHelper.getTableFirstLine(addType, i + 1, cancelTitleTxt);
            oneTableTitleContent.append(tableHeaderMethodLine);
            oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u804c\u4f4d\u540d\u79f0\uff1a<span class=\"emphasis_black\">%s</span></div>", (String)"IntvMailConstant_15", (String)"tsc-tsirm-business", (Object[])new Object[0]), candidateDbList[0].getString("position.name")));
            String formatInterviewTime = IntvMailCommonHelper.getFormatIntvTime(group);
            IntvMailHelper.getInterviewTime(groupUpdateEntity, groupId, oneTableTitleContent, isEditorUpdate, formatInterviewTime);
            Long interviewMethodId = addType.getInterviewMethodId();
            if (TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId) || TSIRMPreDataEnum.KEY_1040.getId().equals(interviewMethodId)) {
                boolean intvAddrChange = IntvMailHelper.getIntvAddrChange(groupUpdateEntity, group);
                String formatInterviewAddr = IntvMailHelper.getLineAddress(addType, editType, group, groupUpdateEntity, null, new InterviewMailAddrParam("intvervedioaddress", ResManager.loadKDString((String)"<div>\u9762\u8bd5\u5730\u5740\uff1a<span class=\"emphasis_black\">%s</span></div>", (String)"IntvMailConstant_19", (String)"tsc-tsirm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"<div>\u6700\u65b0\u9762\u8bd5\u5730\u5740\uff1a <span class=\"emphasis_red\">%s</span>\uff08\u539f\u9762\u8bd5\u5730\u5740\u4e3a\uff1a <s class=\"emphasis_black\">%s</s>\uff09</div>", (String)"IntvMailConstant_20", (String)"tsc-tsirm-business", (Object[])new Object[0])), intvAddrChange);
                oneTableTitleContent.append(formatInterviewAddr);
            }
            oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u9762\u8bd5\u5b98\uff1a%s</div>", (String)"IntvMailConstant_22", (String)"tsc-tsirm-business", (Object[])new Object[0]), interviewerNames));
            if (isCancel) {
                oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u5019\u9009\u4eba\uff1a%s</div>", (String)"IntvMailConstant_23", (String)"tsc-tsirm-business", (Object[])new Object[0]), String.join((CharSequence)",", cancelCandidateNames)));
            }
            interviewTable.append((CharSequence)oneTableTitleContent);
            interviewTable.append(curGroupTable);
            interviewTable.append("</div>");
            IntvMailHelper.assembleInterviewTable(interviewerMailContentMap, groupUpdateEntity, editType, groupId, interviewerDbObj, interviewTable, cancelModels, isUpdateCancel);
            boolean cancelTypeFlag = IntvMailHelper.isCancelInterviewerTaskFlag(cancelModels, groupId);
            ccTableIsAppendCount += IntvMailHelper.appendInterviewerTableToCC(ccTable, interviewTable, cancelTypeFlag, isCancel);
        }
        if (MapUtils.isEmpty(interviewerMailContentMap)) {
            return null;
        }
        IntvMailHelper.appendSuffix(interviewerMailContentMap, ccTable);
        return ccTableIsAppendCount == 0 ? "" : IntvMailHelper.appendHeader(Jsoup.parse((String)ccTable.toString()));
    }

    public static String getInterviewTableByCfgMsg(InterviewMailParam mailType, DynamicObject[] candidateDbList, DynamicObjectCollection groupEntry, Map<Long, String> interviewerMailContentMap, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels, List<Long> interviewerId) {
        return IntvMailHelper.commonInterviewTable(mailType, candidateDbList, groupEntry, interviewerMailContentMap, candidateCancelIds, groupUpdateEntity, cancelModels, interviewerId);
    }

    public static String getInterviewTable(InterviewMailParam mailType, DynamicObject[] candidateDbList, DynamicObjectCollection groupEntry, Map<Long, String> interviewerMailContentMap, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels) {
        DynamicObject[] interviewDbjList = mailType.getInterviewDbjList();
        InterviewNoticeModel addType = mailType.getNoticeType();
        InterviewMailType editType = mailType.getEditNoticeType().getInterviewMailType();
        boolean isUpdateCancel = mailType.isUpdateCancel();
        Map<Long, DynamicObject> interviewDbMap = IntvMailCommonHelper.getInstance().getInterviewerDbMap(interviewDbjList);
        StringBuilder ccTable = new StringBuilder(5200);
        int ccTableIsAppendCount = 0;
        ccTable.append("<div class='interview_table'>");
        int len = groupEntry.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject group = (DynamicObject)groupEntry.get(i);
            long groupId = group.getLong("id");
            if (addType.getInterviewMailType() == InterviewMailType.EDIT && IntvMailHelper.editorInterviewProcess(groupUpdateEntity, editType, groupId)) continue;
            List<DynamicObject> groupList = IntvMailHelper.getGroupList(candidateDbList, group);
            List<DynamicObject> interviewerDbObj = IntvMailHelper.getGroupInterviewer(interviewDbMap, group);
            String interviewerNames = interviewerDbObj.stream().map(intv -> intv.getString("name")).collect(Collectors.joining(","));
            List<Long> interviewIdList = interviewerDbObj.stream().map(intv -> intv.getLong("id")).collect(Collectors.toList());
            boolean isCancel = IntvMailHelper.getIsCancel(addType.getInterviewMailType());
            String curGroupTable = IntvMailCommonHelper.getInstance().assemblyOneInterviewerTable(groupList, candidateCancelIds, addType.getInterviewMailType(), editType, interviewIdList);
            if (HRStringUtils.isEmpty((String)curGroupTable)) continue;
            StringBuilder interviewTable = new StringBuilder(5200);
            interviewTable.append("<div class='interview_table_onetable'>");
            StringBuilder oneTableTitleContent = new StringBuilder(5200);
            oneTableTitleContent.append("<div>");
            boolean isEditorUpdate = IntvMailHelper.getIsUpdate(addType, editType);
            ArrayList cancelCandidateNames = Lists.newArrayListWithCapacity((int)10);
            String cancelTitleTxt = null;
            if (isCancel) {
                cancelTitleTxt = IntvMailHelper.getCancelTitleTxt(candidateCancelIds, addType, cancelModels, groupId, groupList, cancelCandidateNames);
            }
            String tableHeaderMethodLine = IntvMailHelper.getTableFirstLine(addType, i + 1, cancelTitleTxt);
            oneTableTitleContent.append(tableHeaderMethodLine);
            oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u804c\u4f4d\u540d\u79f0\uff1a<span class=\"emphasis_black\">%s</span></div>", (String)"IntvMailConstant_15", (String)"tsc-tsirm-business", (Object[])new Object[0]), candidateDbList[0].getString("position.name")));
            String formatInterviewTime = IntvMailCommonHelper.getFormatIntvTime(group);
            IntvMailHelper.getInterviewTime(groupUpdateEntity, groupId, oneTableTitleContent, isEditorUpdate, formatInterviewTime);
            Long interviewMethodId = addType.getInterviewMethodId();
            if (TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId) || TSIRMPreDataEnum.KEY_1040.getId().equals(interviewMethodId)) {
                boolean intvAddrChange = IntvMailHelper.getIntvAddrChange(groupUpdateEntity, group);
                String formatInterviewAddr = IntvMailHelper.getLineAddress(addType, editType, group, groupUpdateEntity, null, new InterviewMailAddrParam("intvervedioaddress", ResManager.loadKDString((String)"<div>\u9762\u8bd5\u5730\u5740\uff1a<span class=\"emphasis_black\">%s</span></div>", (String)"IntvMailConstant_19", (String)"tsc-tsirm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"<div>\u6700\u65b0\u9762\u8bd5\u5730\u5740\uff1a <span class=\"emphasis_red\">%s</span>\uff08\u539f\u9762\u8bd5\u5730\u5740\u4e3a\uff1a <s class=\"emphasis_black\">%s</s>\uff09</div>", (String)"IntvMailConstant_20", (String)"tsc-tsirm-business", (Object[])new Object[0])), intvAddrChange);
                oneTableTitleContent.append(formatInterviewAddr);
            }
            oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u9762\u8bd5\u5b98\uff1a%s</div>", (String)"IntvMailConstant_22", (String)"tsc-tsirm-business", (Object[])new Object[0]), interviewerNames));
            if (isCancel) {
                oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u5019\u9009\u4eba\uff1a%s</div>", (String)"IntvMailConstant_23", (String)"tsc-tsirm-business", (Object[])new Object[0]), String.join((CharSequence)",", cancelCandidateNames)));
            }
            interviewTable.append((CharSequence)oneTableTitleContent);
            interviewTable.append(curGroupTable);
            interviewTable.append("</div>");
            IntvMailHelper.assembleInterviewTable(interviewerMailContentMap, groupUpdateEntity, editType, groupId, interviewerDbObj, interviewTable, cancelModels, isUpdateCancel);
            boolean cancelTypeFlag = IntvMailHelper.isCancelInterviewerTaskFlag(cancelModels, groupId);
            ccTableIsAppendCount += IntvMailHelper.appendInterviewerTableToCC(ccTable, interviewTable, cancelTypeFlag, isCancel);
        }
        if (MapUtils.isEmpty(interviewerMailContentMap)) {
            return null;
        }
        IntvMailHelper.appendSuffix(interviewerMailContentMap, ccTable);
        return ccTableIsAppendCount == 0 ? "" : ccTable.toString();
    }

    public static int appendInterviewerTableToCC(StringBuilder ccTable, StringBuilder interviewTable, boolean cancelTypeFlag, boolean typeFlag) {
        if (typeFlag && !cancelTypeFlag) {
            return 0;
        }
        ccTable.append((CharSequence)interviewTable);
        return 1;
    }

    public static List<DynamicObject> getGroupInterviewer(Map<Long, DynamicObject> interviewDbMap, DynamicObject group) {
        DynamicObjectCollection interviewerMulBase = group.getDynamicObjectCollection("intver");
        return IntvMailCommonHelper.getInstance().getGroupInterviewList(interviewDbMap, interviewerMulBase);
    }

    public static List<DynamicObject> getGroupList(DynamicObject[] candidateDbList, DynamicObject group) {
        DynamicObjectCollection candidateEntry = group.getDynamicObjectCollection("groupcandate");
        return IntvMailCommonHelper.getInstance().getGroupCandidateIds(candidateDbList, candidateEntry);
    }

    public static boolean getIntvAddrChange(Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, DynamicObject group) {
        ArgIntvUpdateResultEntity argIntvUpdateResultEntity;
        boolean changeFlag = false;
        if (MapUtils.isNotEmpty(groupUpdateEntity) && ((argIntvUpdateResultEntity = groupUpdateEntity.get(group.getLong("id"))).isGroupAddressChange() || argIntvUpdateResultEntity.isGroupInterviewerAddressChange())) {
            changeFlag = true;
        }
        return changeFlag;
    }

    public boolean getCandiAddrChange(Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, DynamicObject group) {
        ArgIntvUpdateResultEntity argIntvUpdateResultEntity;
        boolean changeFlag = false;
        if (!Objects.isNull(groupUpdateEntity) && ((argIntvUpdateResultEntity = groupUpdateEntity.get(group.getLong("id"))).isGroupAddressChange() || argIntvUpdateResultEntity.isGroupAppAddressChange())) {
            changeFlag = true;
        }
        return changeFlag;
    }

    public static boolean getIsUpdate(InterviewNoticeModel addType, InterviewMailType editType) {
        return InterviewMailType.EDIT == addType.getInterviewMailType() && InterviewMailType.EDIT_UPDATE == editType;
    }

    public static boolean getIsCancel(InterviewMailType addType) {
        return InterviewMailType.CANCEL == addType || InterviewMailType.CANCEL_SINGLE == addType;
    }

    public static String getCancelTitleTxt(List<Long> candidateCancelIds, InterviewNoticeModel addType, Map<Long, InterviewCancelModel> cancelModels, long groupId, List<DynamicObject> groupList, List<String> cancelCandidateNames) {
        boolean cancelTypeFlag = IntvMailHelper.isCancelInterviewerTaskFlag(cancelModels, groupId);
        IntvMailHelper.assembleCancelCandidateNames(candidateCancelIds, addType, groupList, cancelCandidateNames);
        String cancelType = ResManager.loadKDString((String)"\u53d6\u6d88\u672c\u573a\u9762\u8bd5", (String)"IntvMailHelper_37", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        if (!cancelTypeFlag) {
            cancelType = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53d6\u6d88\u672c\u573a %s \u540d\u5019\u9009\u4eba\u9762\u8bd5", (String)"IntvMailHelper_38", (String)"tsc-tsirm-business", (Object[])new Object[0]), cancelCandidateNames.size());
        }
        return cancelType;
    }

    private static void getInterviewTime(Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, long groupId, StringBuilder oneTableTitleContent, boolean isEditorUpdate, String formatInterviewTime) {
        ArgIntvUpdateResultEntity argIntvUpdateResultEntity;
        boolean timeValue = true;
        if (isEditorUpdate && (argIntvUpdateResultEntity = groupUpdateEntity.get(groupId)).isGroupIntvTimeChange()) {
            oneTableTitleContent.append(String.format(ResManager.loadKDString((String)"<div>\u6700\u65b0\u9762\u8bd5\u65f6\u95f4\uff1a<span class=\"emphasis_red\">%s</span>\uff08\u539f\u9762\u8bd5\u65f6\u95f4\u4e3a\uff1a <s class=\"emphasis_black\">%s</s>\uff09</div>", (String)"IntvMailConstant_17", (String)"tsc-tsirm-business", (Object[])new Object[0]), formatInterviewTime, IntvMailCommonHelper.getFormatIntvTime(argIntvUpdateResultEntity.getOldGroupDO())));
            timeValue = false;
        }
        if (timeValue) {
            oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u9762\u8bd5\u65f6\u95f4\uff1a<span class=\"emphasis_black\">%s</span></div>", (String)"IntvMailConstant_16", (String)"tsc-tsirm-business", (Object[])new Object[0]), formatInterviewTime));
        }
    }

    public static boolean editorInterviewProcess(Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, InterviewMailType editType, long groupId) {
        if (null == groupUpdateEntity) {
            return false;
        }
        ArgIntvUpdateResultEntity argIntvUpdateResultEntity = groupUpdateEntity.get(groupId);
        if (InterviewMailType.EDIT_UPDATE == editType) {
            boolean isChange = IntvMailHelper.getInterviewerTimeOrAddrChange(argIntvUpdateResultEntity);
            return !isChange;
        }
        if (InterviewMailType.EDIT_ADD_INTERVIEW == editType) {
            List<Long> interViewerIdAdd = argIntvUpdateResultEntity.getInterViewerIdAdd();
            return CollectionUtils.isEmpty(interViewerIdAdd);
        }
        if (InterviewMailType.EDIT_CANCEL_INTERVIEW == editType) {
            List<Long> interViewerIdAdd = argIntvUpdateResultEntity.getInterViewerIdDelete();
            return CollectionUtils.isEmpty(interViewerIdAdd);
        }
        return false;
    }

    private static void assembleCancelCandidateNames(List<Long> candidateCancelIds, InterviewNoticeModel addType, List<DynamicObject> groupList, List<String> cancelCandidateNames) {
        for (DynamicObject dynamicObject : groupList) {
            long aLong = dynamicObject.getLong("id");
            String string = dynamicObject.getString("appres.fullname");
            if (InterviewMailType.CANCEL_SINGLE == addType.getInterviewMailType()) {
                if (!candidateCancelIds.contains(aLong)) continue;
                cancelCandidateNames.add(string);
                continue;
            }
            cancelCandidateNames.add(string);
        }
    }

    public static boolean isCancelInterviewerTaskFlag(Map<Long, InterviewCancelModel> cancelModels, long groupId) {
        boolean cancelTask = false;
        if (MapUtils.isNotEmpty(cancelModels)) {
            for (InterviewCancelModel value : cancelModels.values()) {
                String taskStatus;
                if (!value.getGroupId().equals(groupId) || !(taskStatus = value.getTaskStatus()).equals("C") && !taskStatus.equals("E")) continue;
                cancelTask = true;
                break;
            }
        }
        return cancelTask;
    }

    public boolean isCancelInterviewerTaskFlag(Map<Long, InterviewCancelModel> cancelModels, long groupId, long interviewerId) {
        boolean cancelTask = false;
        if (MapUtils.isNotEmpty(cancelModels)) {
            for (InterviewCancelModel value : cancelModels.values()) {
                String taskStatus;
                if (!value.getGroupId().equals(groupId) || value.getInterviewerId() != interviewerId || !(taskStatus = value.getTaskStatus()).equals("A")) continue;
                cancelTask = true;
                break;
            }
        }
        return cancelTask;
    }

    private static void assembleInterviewTable(Map<Long, String> interviewerMailContentMap, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, InterviewMailType editType, long groupId, List<DynamicObject> interviewerDbObj, StringBuilder interviewTable, Map<Long, InterviewCancelModel> cancelModels, boolean isUpdateCancel) {
        for (DynamicObject next : interviewerDbObj) {
            List<Long> interViewerIdAdd;
            ArgIntvUpdateResultEntity argIntvUpdateResultEntity;
            long curInterviewId = next.getLong("id");
            boolean cancelInterviewerTask = IntvMailHelper.getInstance().isCancelInterviewerTaskFlag(cancelModels, groupId, curInterviewId);
            if (isUpdateCancel && cancelInterviewerTask) continue;
            if (InterviewMailType.EDIT_ADD_INTERVIEW == editType) {
                argIntvUpdateResultEntity = groupUpdateEntity.get(groupId);
                interViewerIdAdd = argIntvUpdateResultEntity.getInterViewerIdAdd();
                if (!interViewerIdAdd.contains(curInterviewId)) {
                    continue;
                }
            } else if (InterviewMailType.EDIT_CANCEL_INTERVIEW == editType) {
                if (MapUtils.isNotEmpty(groupUpdateEntity) && !(interViewerIdAdd = (argIntvUpdateResultEntity = groupUpdateEntity.get(groupId)).getInterViewerIdDelete()).contains(curInterviewId)) {
                    continue;
                }
            } else if (InterviewMailType.EDIT_UPDATE == editType) {
                argIntvUpdateResultEntity = groupUpdateEntity.get(groupId);
                interViewerIdAdd = argIntvUpdateResultEntity.getInterViewerIdNoChange();
                boolean isChange = IntvMailHelper.getInterviewerTimeOrAddrChange(argIntvUpdateResultEntity);
                if (!interViewerIdAdd.contains(curInterviewId) || !isChange) continue;
            }
            IntvMailHelper.addToInterviewerMap(interviewerMailContentMap, interviewTable, curInterviewId);
        }
    }

    private static void addToInterviewerMap(Map<Long, String> interviewerMailContentMap, StringBuilder interviewTable, long curInterviewId) {
        String interviewTables = interviewerMailContentMap.get(curInterviewId);
        if (HRStringUtils.isNotEmpty((String)interviewTables)) {
            interviewTables = interviewTables + interviewTable;
            interviewerMailContentMap.put(curInterviewId, interviewTables);
        } else {
            String tableTitleContent = "<div class='interview_table'>";
            interviewerMailContentMap.put(curInterviewId, tableTitleContent + interviewTable);
        }
    }

    private static void appendSuffix(Map<Long, String> interviewerMailContentMap, StringBuilder ccTable) {
        for (Map.Entry<Long, String> longStringEntry : interviewerMailContentMap.entrySet()) {
            String value = longStringEntry.getValue();
            longStringEntry.setValue(value + "</div>");
        }
        ccTable.append("</div>");
    }

    public static String getLineAddress(InterviewNoticeModel addType, InterviewMailType editType, DynamicObject group, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<String, String> dynamicVariable, InterviewMailAddrParam interviewMailAddrParam, boolean intvAddrChange) {
        String videoAddKey = interviewMailAddrParam.getVideoKey();
        String updateTemplate = interviewMailAddrParam.getTemplate2();
        String res = null;
        Long interviewMethodId = addType.getInterviewMethodId();
        String smsAddress = null;
        boolean isUpdate = addType.getInterviewMailType() == InterviewMailType.EDIT && editType == InterviewMailType.EDIT_UPDATE;
        boolean haveValue = false;
        if (isUpdate && !Objects.isNull(groupUpdateEntity)) {
            ArgIntvUpdateResultEntity argIntvUpdateResultEntity = groupUpdateEntity.get(group.getLong("id"));
            if (intvAddrChange) {
                if (TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId) && argIntvUpdateResultEntity.isGroupAddressChange()) {
                    res = String.format(updateTemplate, IntvMailCommonHelper.getFormatIntvAddress(group), IntvMailCommonHelper.getFormatIntvAddress(argIntvUpdateResultEntity.getOldGroupDO()));
                    smsAddress = IntvMailCommonHelper.getFormatIntvAddress(group);
                } else {
                    res = String.format(updateTemplate, group.getString(videoAddKey), argIntvUpdateResultEntity.getOldGroupDO().getString(videoAddKey));
                    smsAddress = group.getString(videoAddKey);
                }
            } else {
                haveValue = true;
            }
        } else {
            haveValue = true;
        }
        res = IntvMailHelper.processAdd(group, dynamicVariable, interviewMailAddrParam, res, interviewMethodId, smsAddress, haveValue);
        return res;
    }

    private static String processAdd(DynamicObject group, Map<String, String> dynamicVariable, InterviewMailAddrParam param, String res, Long interviewMethodId, String smsAddress, boolean haveValue) {
        if (haveValue) {
            if (TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId)) {
                res = String.format(Locale.ROOT, param.getTemplate1(), IntvMailCommonHelper.getFormatIntvAddress(group));
                smsAddress = IntvMailCommonHelper.getFormatIntvAddress(group);
            } else {
                res = String.format(Locale.ROOT, param.getTemplate1(), group.getString(param.getVideoKey()));
                smsAddress = group.getString(param.getVideoKey());
            }
        }
        if (!Objects.isNull(dynamicVariable)) {
            dynamicVariable.put(ResManager.loadKDString((String)"\u9762\u8bd5\u5730\u5740", (String)"IntvMailHelper_49", (String)"tsc-tsirm-business", (Object[])new Object[0]), smsAddress);
            dynamicVariable.put(ResManager.loadKDString((String)"\u89c6\u9891\u9762\u8bd5\u5730\u5740", (String)"IntvMailHelper_53", (String)"tsc-tsirm-business", (Object[])new Object[0]), smsAddress);
        }
        return res;
    }

    public static String getTableFirstLine(InterviewNoticeModel type, int num, String cancelType) {
        StringBuilder res = new StringBuilder(5200);
        InterviewMailType addType = type.getInterviewMailType();
        String interviewTitle = type.getInterviewTitle();
        String interviewOrgForm = type.getInterviewOrganizationalForm();
        if (addType == InterviewMailType.CANCEL || addType == InterviewMailType.CANCEL_SINGLE) {
            res.append("-").append(interviewTitle);
        }
        if ("B".equals(interviewOrgForm)) {
            String groupName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u7ec4", (String)"IntvBatchGroupEdit_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), Num2ChUtils.toCH((int)num));
            res.append("-").append(groupName);
        }
        if (addType == InterviewMailType.CANCEL || addType == InterviewMailType.CANCEL_SINGLE) {
            res.append("-").append(cancelType);
        } else {
            res.append("-").append(type.getInterviewMethodName());
        }
        return res.substring(1);
    }

    public static boolean getInterviewerTimeOrAddrChange(ArgIntvUpdateResultEntity argIntvUpdateResultEntity) {
        boolean groupIntvTimeChange = argIntvUpdateResultEntity.isGroupIntvTimeChange();
        boolean groupAddressChange = argIntvUpdateResultEntity.isGroupAddressChange();
        boolean groupInterviewerAddressChange = argIntvUpdateResultEntity.isGroupInterviewerAddressChange();
        return groupIntvTimeChange || groupAddressChange || groupInterviewerAddressChange;
    }

    private boolean getCandiTimeOrAddrChange(ArgIntvUpdateResultEntity argIntvUpdateResultEntity) {
        boolean groupIntvTimeChange = argIntvUpdateResultEntity.isGroupIntvTimeChange();
        boolean groupAddressChange = argIntvUpdateResultEntity.isGroupAddressChange();
        boolean groupAppAddressChange = argIntvUpdateResultEntity.isGroupAppAddressChange();
        return groupIntvTimeChange || groupAddressChange || groupAppAddressChange;
    }

    public String getMailContent(Document parse, String richText, Map<String, String> variableInfo, String mailContent, String intvNames) {
        String s1 = IntvMailCommonHelper.replaceVariable(richText, variableInfo);
        mailContent = mailContent.replaceAll("\\$", "RDS_CHAR_DOLLAR");
        String s2 = s1.replaceAll("\\{\u9762\u8bd5\u5b89\u6392\u8868}", mailContent);
        s2 = s2.replaceAll("RDS_CHAR_DOLLAR", "\\$");
        String s3 = s2.replaceAll("\\{\u9762\u8bd5\u5b98\u59d3\u540d}", intvNames);
        Objects.requireNonNull(parse.getElementById("main_content")).html(s3);
        parse.getElementsByClass(EmailTemplateTag.USER_NAME.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.USER_NAME.getDesc(), (String)"IntvMailHelper_5", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.POSITION_NAME_TAG.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.POSITION_NAME_TAG.getDesc(), (String)"IntvMailHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.SEX.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.SEX.getDesc(), (String)"IntvMailHelper_7", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.EDUCATION.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.EDUCATION.getDesc(), (String)"IntvMailHelper_8", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.UNIVERSITY.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.UNIVERSITY.getDesc(), (String)"IntvMailHelper_9", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.MAJOR.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.MAJOR.getDesc(), (String)"IntvMailHelper_10", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.WORK_YEARS.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.WORK_YEARS.getDesc(), (String)"IntvMailHelper_11", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.OPT.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.OPT.getDesc(), (String)"IntvMailHelper_12", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        return parse.toString();
    }

    private String getMailContent(Document parse, String richText, Map<String, String> variableInfo) {
        String s1 = IntvMailCommonHelper.replaceVariable(richText, variableInfo);
        Objects.requireNonNull(parse.getElementById("main_content")).html(s1);
        return parse.toString();
    }

    public List<InterviewMailSendBean> processCandidateMail(InterviewMailParam mailParam, List<DynamicObject> appFileTask, DynamicObject[] candidateDbList, String richText, String interviewTheme, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap) {
        DynamicObject dataEntity = mailParam.getDataEntity();
        Map variableInfo = mailParam.getVariableInfo();
        InterviewNoticeModel noticeType = mailParam.getNoticeType();
        InterviewNoticeModel editNoticeType = mailParam.getEditNoticeType();
        InterviewMailType type = noticeType.getInterviewMailType();
        InterviewMailType editType = null;
        if (editNoticeType != null) {
            editType = editNoticeType.getInterviewMailType();
        }
        LinkedList<InterviewMailSendBean> candidateMailSendBeanList = new LinkedList<InterviewMailSendBean>();
        DynamicObject roundEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
        DynamicObjectCollection groupEntry = roundEntry.getDynamicObjectCollection("tsirm_intvgroupentry");
        Map<Long, Long> candidateTaskMap = IntvMailHelper.getCandidateTaskMap(appFileTask);
        for (DynamicObject group : groupEntry) {
            if (this.isUpdateNoChange(groupUpdateMap, type, editType, group)) continue;
            List<DynamicObject> gList = IntvMailHelper.getGroupList(candidateDbList, group);
            LinkedHashMap dynamicVariable = Maps.newLinkedHashMapWithExpectedSize((int)16);
            boolean isEditorUpdate = IntvMailHelper.getIsUpdate(noticeType, editType);
            this.processCandidateTime(groupUpdateMap, group, dynamicVariable, isEditorUpdate);
            Long interviewMethodId = noticeType.getInterviewMethodId();
            this.processInterviewAddr(groupUpdateMap, variableInfo, noticeType, editType, group, interviewMethodId, dynamicVariable);
            for (DynamicObject candidate : gList) {
                long candidateId = candidate.getLong("id");
                if (InterviewMailType.CANCEL_SINGLE == type && !candidateCancelIds.contains(candidateId)) continue;
                InterviewMailType trueType = IntvMailCommonHelper.getInterviewTrueType(noticeType.getInterviewMailType(), editType);
                String businessType = IntvMailCommonHelper.getBusinessType(trueType);
                InterviewMailType trueTypeUrl = IntvMailCommonHelper.getInterviewTrueType(type, editType);
                dynamicVariable.put("intverviewanswer", IntvMailHelper.getReplyUrl(candidateTaskMap, candidate, trueTypeUrl));
                dynamicVariable.put("interviewcandiname", candidate.getString("appres.fullname"));
                dynamicVariable.put(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u59d3\u540d", (String)"IntvMailHelper_39", (String)"tsc-tsirm-business", (Object[])new Object[0]), candidate.getString("appres.fullname"));
                Document commonParse = IntvMailUtils.getCommonHtml();
                Objects.requireNonNull(commonParse.getElementById("business_type")).appendText(businessType);
                this.processVideoInterviewAddress(roundEntry, dynamicVariable, variableInfo);
                String replaceTimeAndAddress = IntvMailCommonHelper.replaceVariable(richText, dynamicVariable);
                String htmlContent = this.getMailContent(commonParse, replaceTimeAndAddress, variableInfo);
                Document mailContentParse = Jsoup.parse((String)htmlContent);
                String largeText = this.processMailHeader(dataEntity, type, candidateTaskMap, candidate, candidateId, mailContentParse, editType);
                String smsContent = this.getSmsContent(largeText, variableInfo, dynamicVariable);
                String email = candidate.getString("email");
                String phone = candidate.getString("phone");
                InterviewMailSendBean interviewMailSendBean = IntvMailPreviewHelper.getInterviewMailSendBean(interviewTheme, noticeType, candidateId, mailContentParse, smsContent, email, phone);
                candidateMailSendBeanList.add(interviewMailSendBean);
            }
        }
        return candidateMailSendBeanList;
    }

    private void processVideoInterviewAddress(DynamicObject roundEntry, Map<String, String> dynamicVariable, Map<String, String> variableInfo) {
        DynamicObject interviewMethod = roundEntry.getDynamicObject("interviewmethod");
        long id = interviewMethod.getLong("id");
        if (id == 1040L) {
            dynamicVariable.put("intvVideoAddress", variableInfo.get("intvAddress"));
            dynamicVariable.put("interviewvediolocation", variableInfo.get("intvAddress"));
        }
    }

    private void processInterviewAddr(Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, Map<String, String> variableInfo, InterviewNoticeModel noticeType, InterviewMailType editType, DynamicObject group, Long interviewMethodId, Map<String, String> dynamicVariable) {
        if (TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId) || TSIRMPreDataEnum.KEY_1040.getId().equals(interviewMethodId)) {
            boolean intvAddrChange = this.getCandiAddrChange(groupUpdateMap, group);
            String formatInterviewAddr = IntvMailHelper.getLineAddress(noticeType, editType, group, groupUpdateMap, dynamicVariable, new InterviewMailAddrParam("candatevedioaddress", "<span class=\"emphasis_black\">%s</span>", ResManager.loadKDString((String)"<span class=\"emphasis_red\">%s</span>\uff08\u539f\u9762\u8bd5\u5730\u5740\u4e3a\uff1a <s class=\"emphasis_black\">%s</s>\uff09", (String)"IntvMailConstant_21", (String)"tsc-tsirm-business", (Object[])new Object[0])), intvAddrChange);
            variableInfo.put("intvAddress", formatInterviewAddr);
            if (TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId)) {
                variableInfo.put("interviewvediolocation", formatInterviewAddr);
            } else if (TSIRMPreDataEnum.KEY_1040.getId().equals(interviewMethodId)) {
                variableInfo.put("interviewvediolocation", formatInterviewAddr);
            }
        }
        String jobName = String.format(Locale.ROOT, "<span class=\"emphasis_black\">%s</span>", variableInfo.get("jobTitle"));
        dynamicVariable.put("jobTitle", jobName);
        dynamicVariable.put("interviewpositionname", jobName);
    }

    private String processMailHeader(DynamicObject dataEntity, InterviewMailType type, Map<Long, Long> candidateTaskMap, DynamicObject candidate, long candidateId, Document mailContentParse, InterviewMailType editType) {
        String largeText;
        boolean isUpdate;
        InterviewMailType trueType = IntvMailCommonHelper.getInterviewTrueType(type, editType);
        mailContentParse.getElementsByClass("remove_intvname").remove();
        boolean bl = isUpdate = InterviewMailType.EDIT == type && InterviewMailType.EDIT_UPDATE == editType;
        if (InterviewMailType.ADD == type || isUpdate) {
            largeText = dataEntity.getString("sms_cand_richtext");
        } else if (InterviewMailType.CANCEL == trueType) {
            Map candidateResult = CfgMsgTemplateHelper.queryCfgMsgTemplateByPushSceneAndReceiver2IntvMail((Long)Long.valueOf(CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId()), (Long)Long.valueOf(CfgMsgRecvType.CANDIDATE.getBaseDataId()), (Long)IntvCfgMsgTempfdConstants.CANCEL_APPFILE_ID);
            largeText = (String)candidateResult.get("smstemplate");
        } else {
            largeText = "";
        }
        return largeText;
    }

    public static String getReplyUrl(Map<Long, Long> candidateTaskMap, DynamicObject candidate, InterviewMailType trueType) {
        Long candidateId = candidate.getLong("id");
        String phone = candidate.getString("phone");
        if (InterviewMailType.ADD == trueType || InterviewMailType.EDIT == trueType) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)16);
            param.put("userId", "Guest");
            param.put("phone", EncryptionDecryptUtil.getEncryptStr((Object)phone));
            param.put("appfileTaskId", String.valueOf(candidateTaskMap.get(candidateId)));
            return IntvMailUtils.getFormDetailUrl((String)"tsirm_answer", (Map)param);
        }
        return "";
    }

    private void processCandidateTime(Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, DynamicObject group, Map<String, String> dynamicVariable, boolean isEditorUpdate) {
        ArgIntvUpdateResultEntity argIntvUpdateResultEntity;
        String intvFormatTime = IntvMailCommonHelper.getFormatIntvTime(group);
        boolean timeValue = true;
        if (isEditorUpdate && (argIntvUpdateResultEntity = groupUpdateMap.get(group.getLong("id"))).isGroupIntvTimeChange()) {
            String format = String.format(ResManager.loadKDString((String)"<span class=\"emphasis_red\">%s</span>\uff08\u539f\u9762\u8bd5\u65f6\u95f4\u4e3a\uff1a <s class=\"emphasis_black\">%s</s>\uff09", (String)"IntvMailConstant_18", (String)"tsc-tsirm-business", (Object[])new Object[0]), intvFormatTime, IntvMailCommonHelper.getFormatIntvTime(argIntvUpdateResultEntity.getOldGroupDO()));
            dynamicVariable.put("intvtime", format);
            dynamicVariable.put("interviewtime", format);
            timeValue = false;
        }
        if (timeValue) {
            dynamicVariable.put("intvtime", String.format(Locale.ROOT, "<span class=\"emphasis_black\">%s</span>", intvFormatTime));
            dynamicVariable.put("interviewtime", String.format(Locale.ROOT, "<span class=\"emphasis_black\">%s</span>", intvFormatTime));
        }
        dynamicVariable.put(ResManager.loadKDString((String)"\u9762\u8bd5\u65f6\u95f4", (String)"IntvMailHelper_48", (String)"tsc-tsirm-business", (Object[])new Object[0]), intvFormatTime);
    }

    private boolean isUpdateNoChange(Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, InterviewMailType type, InterviewMailType editType, DynamicObject group) {
        if (InterviewMailType.EDIT == type && InterviewMailType.EDIT_UPDATE == editType) {
            ArgIntvUpdateResultEntity argIntvUpdateResultEntity = groupUpdateMap.get(group.getLong("id"));
            return !this.getCandiTimeOrAddrChange(argIntvUpdateResultEntity);
        }
        return false;
    }

    @NotNull
    public static Map<Long, Long> getCandidateTaskMap(List<DynamicObject> appFileTask) {
        LinkedHashMap candidateTaskMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : appFileTask) {
            candidateTaskMap.put(dynamicObject.getDynamicObject("application").getLong("id"), dynamicObject.getLong("id"));
        }
        return candidateTaskMap;
    }

    public List<InterviewMailSendBean> processReceptionistMail(InterviewMailParam mailParam, DynamicObject[] candidateDbList, String richText, String interviewTheme, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap) {
        DynamicObject dataEntity = mailParam.getDataEntity();
        DynamicObject[] interviewDbjList = mailParam.getInterviewDbjList();
        Map variableInfo = mailParam.getVariableInfo();
        InterviewNoticeModel addType = mailParam.getNoticeType();
        InterviewNoticeModel editorNoticeModel = mailParam.getEditNoticeType();
        InterviewMailType editorType = editorNoticeModel.getInterviewMailType();
        if (!this.getIsNoChangeEditorUpdate(groupUpdateMap) && MapUtils.isNotEmpty(groupUpdateMap)) {
            return Collections.emptyList();
        }
        LinkedList<InterviewMailSendBean> receptionMailSendBeanList = new LinkedList<InterviewMailSendBean>();
        LinkedHashMap interviewDbMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject interviewObj : interviewDbjList) {
            interviewDbMap.put(interviewObj.getLong("id"), interviewObj);
        }
        String interviewALLNames = Arrays.stream(interviewDbjList).map(object -> object.getString("name")).collect(Collectors.joining(","));
        StringBuilder candidateTable = this.getCandidateTable(dataEntity, candidateDbList, interviewDbMap, addType, editorType);
        String reception = dataEntity.getString("receptionist");
        InterviewMailType trueType = IntvMailCommonHelper.getInterviewTrueType(addType.getInterviewMailType(), editorType);
        String businessType = IntvMailCommonHelper.getBusinessType(trueType);
        Document parse = IntvMailUtils.getCommonHtml();
        Objects.requireNonNull(parse.getElementById("business_type")).appendText(businessType);
        String ccHtmlContent = this.getMailContent(parse, richText, variableInfo, candidateTable.toString(), interviewALLNames);
        Document resParse = Jsoup.parse((String)ccHtmlContent);
        resParse.getElementsByClass("remove_ele").remove();
        resParse.getElementsByClass("to_evaluate").remove();
        InterviewMailSendBean ccMailSendBean = new InterviewMailSendBean(interviewTheme, resParse.toString(), (List)Lists.newArrayList((Object[])new String[]{reception}));
        ccMailSendBean.setInterviewMailRol(InterviewMailRol.RECEPTIONIST);
        receptionMailSendBeanList.add(ccMailSendBean);
        return receptionMailSendBeanList;
    }

    private boolean getIsNoChangeEditorUpdate(Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap) {
        boolean key = false;
        if (MapUtils.isNotEmpty(groupUpdateMap)) {
            for (Map.Entry<Long, ArgIntvUpdateResultEntity> entry : groupUpdateMap.entrySet()) {
                ArgIntvUpdateResultEntity value = entry.getValue();
                if (!value.isGroupInterviewerAddressChange() && !value.isGroupAddressChange()) continue;
                key = true;
                break;
            }
        }
        return key;
    }

    private StringBuilder getCandidateTable(DynamicObject dataEntity, DynamicObject[] candidateDbList, Map<Long, DynamicObject> interviewDbMap, InterviewNoticeModel addType, InterviewMailType editorType) {
        DynamicObject roundEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
        DynamicObjectCollection groupEntry = roundEntry.getDynamicObjectCollection("tsirm_intvgroupentry");
        StringBuilder candidateList = new StringBuilder(5200);
        for (int i = 0; i < groupEntry.size(); ++i) {
            DynamicObject group = (DynamicObject)groupEntry.get(i);
            List<DynamicObject> groupCandidateList = IntvMailHelper.getGroupList(candidateDbList, group);
            List<DynamicObject> interviewerDbObj = IntvMailHelper.getGroupInterviewer(interviewDbMap, group);
            String nameJoin = interviewerDbObj.stream().map(intv -> intv.getString("name")).collect(Collectors.joining(","));
            String oneTable = IntvMailCommonHelper.getInstance().assemblyOneInterviewerTable(groupCandidateList, Lists.newArrayListWithCapacity((int)0), addType.getInterviewMailType(), null);
            StringBuilder oneTableTitleContent = new StringBuilder(5200);
            String tableHeaderMethodLine = IntvMailHelper.getTableFirstLine(addType, i + 1, null);
            oneTableTitleContent.append(tableHeaderMethodLine);
            oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u804c\u4f4d\u540d\u79f0\uff1a<span class=\"emphasis_black\">%s</span></div>", (String)"IntvMailConstant_15", (String)"tsc-tsirm-business", (Object[])new Object[0]), candidateDbList[0].getString("position.name")));
            String formatInterviewTime = IntvMailCommonHelper.getFormatIntvTime(group);
            oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u9762\u8bd5\u65f6\u95f4\uff1a<span class=\"emphasis_black\">%s</span></div>", (String)"IntvMailConstant_16", (String)"tsc-tsirm-business", (Object[])new Object[0]), formatInterviewTime));
            Long interviewMethodId = addType.getInterviewMethodId();
            if (TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId) || TSIRMPreDataEnum.KEY_1040.getId().equals(interviewMethodId)) {
                boolean intvAddrChange = IntvMailHelper.getIntvAddrChange(Maps.newHashMapWithExpectedSize((int)16), group);
                String formatInterviewAddr = IntvMailHelper.getLineAddress(addType, editorType, group, null, null, new InterviewMailAddrParam("intvervedioaddress", ResManager.loadKDString((String)"<div>\u9762\u8bd5\u5730\u5740\uff1a<span class=\"emphasis_black\">%s</span></div>", (String)"IntvMailConstant_19", (String)"tsc-tsirm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"<div>\u6700\u65b0\u9762\u8bd5\u5730\u5740\uff1a <span class=\"emphasis_red\">%s</span>\uff08\u539f\u9762\u8bd5\u5730\u5740\u4e3a\uff1a <s class=\"emphasis_black\">%s</s>\uff09</div>", (String)"IntvMailConstant_20", (String)"tsc-tsirm-business", (Object[])new Object[0])), intvAddrChange);
                oneTableTitleContent.append(formatInterviewAddr);
            }
            oneTableTitleContent.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"<div>\u9762\u8bd5\u5b98\uff1a%s</div>", (String)"IntvMailConstant_22", (String)"tsc-tsirm-business", (Object[])new Object[0]), nameJoin));
            String interviewTable = "<div>" + oneTableTitleContent + oneTable + "</div>";
            candidateList.append(interviewTable);
        }
        return candidateList;
    }

    public static String generateTable(DynamicObject dataEntity, InterviewNoticeModel interviewNoticeModel, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, InterviewNoticeModel editTypeNoticeModel) {
        DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
        Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
        DynamicObject[] candidateDbList = IntvMailHelper.getCandidateDbArray(dataEntity);
        InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, editTypeNoticeModel);
        return IntvMailCommonHelper.generateTableParam(param, candidateDbList, null, groupUpdateMap, null);
    }

    public static String generateTable(DynamicObject dataEntity, InterviewNoticeModel interviewNoticeModel, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, InterviewNoticeModel editTypeNoticeModel, List<Long> interviewerId) {
        DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
        Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
        DynamicObject[] candidateDbList = IntvMailHelper.getCandidateDbArray(dataEntity);
        InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, editTypeNoticeModel);
        return IntvMailCommonHelper.generateTableParam(param, candidateDbList, null, groupUpdateMap, null, interviewerId);
    }

    public static String appendHeader(Document parse) {
        parse.getElementsByClass(EmailTemplateTag.USER_NAME.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.USER_NAME.getDesc(), (String)"IntvMailHelper_5", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.POSITION_NAME_TAG.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.POSITION_NAME_TAG.getDesc(), (String)"IntvMailHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.SEX.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.SEX.getDesc(), (String)"IntvMailHelper_7", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.EDUCATION.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.EDUCATION.getDesc(), (String)"IntvMailHelper_8", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.UNIVERSITY.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.UNIVERSITY.getDesc(), (String)"IntvMailHelper_9", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.MAJOR.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.MAJOR.getDesc(), (String)"IntvMailHelper_10", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.WORK_YEARS.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.WORK_YEARS.getDesc(), (String)"IntvMailHelper_11", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.OPT.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.OPT.getDesc(), (String)"IntvMailHelper_12", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        return parse.body().html();
    }

    private static class IntvMailHelperHolder {
        private static final IntvMailHelper INSTANCE = new IntvMailHelper();

        private IntvMailHelperHolder() {
        }
    }
}

