/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tsirm.common.enums.intv.InterviewMailRol;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

public class IntvMailPreviewHelper {
    public static final Log log = LogFactory.getLog(IntvMailPreviewHelper.class);

    @NotNull
    public static InterviewMailSendBean getInterviewMailSendBean(String interviewTheme, InterviewNoticeModel noticeType, long candidateId, Document mailContentParse, String smsContent, String email, String phone) {
        InterviewMailSendBean interviewMailSendBean = new InterviewMailSendBean();
        interviewMailSendBean.setId(Long.valueOf(candidateId));
        interviewMailSendBean.setInterviewMailRol(InterviewMailRol.CANDIDATE);
        if (noticeType.isEmailCandidate()) {
            interviewMailSendBean.setMailTheme(interviewTheme);
            interviewMailSendBean.setMailContent(mailContentParse.toString());
            interviewMailSendBean.setReceiver((List)Lists.newArrayList((Object[])new String[]{email}));
        }
        if (noticeType.isSmsCandidate()) {
            interviewMailSendBean.setSmsContent(smsContent);
            interviewMailSendBean.setPhone(phone);
        }
        return interviewMailSendBean;
    }

    private IntvMailPreviewHelper() {
    }

    public static IntvMailPreviewHelper getInstance() {
        return IntvMailPreviewHelperHolder.INSTANCE;
    }

    private static class IntvMailPreviewHelperHolder {
        private static final IntvMailPreviewHelper INSTANCE = new IntvMailPreviewHelper();

        private IntvMailPreviewHelperHolder() {
        }
    }
}

