/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.sdk.tsc.common.vo.CustomMessageParamBo;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.BosUserServiceHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.InterviewEmailHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvVariableInfoHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tsirm.business.domain.intv.service.util.IntvDetailUtil;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tsirm.common.enums.intv.ArgIntvReceiverTypeEnum;
import kd.tsc.tsirm.common.enums.intv.InterviewMailType;
import kd.tsc.tsirm.common.util.IntvMailUtils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.business.domain.message.MessageParamService;
import kd.tsc.tsrbd.common.constants.IntvCfgMsgTempfdConstants;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class IntvMsgArrangementHelper {
    private static final Log logger = LogFactory.getLog(IntvMsgArrangementHelper.class);

    public static void generateArrangementMsgParam(DynamicObject dataEntity, Map<String, Object> variableInfoMap, List<DynamicObject> intvTaskList, List<DynamicObject> appfileTaskList, boolean isProcessNew, List<Long> modifyAddInterviewIds, InterviewNoticeModel interviewNoticeModel, Map<String, List<Map<String, String>>> result) {
        long argIntvId = dataEntity.getLong("id");
        boolean noticeInterviewer = dataEntity.getBoolean("noticeinterviewer");
        String ccPersonEmail = dataEntity.getString("ccperson");
        List<Map<String, String>> noticeInterviewerList = result.get(CfgMsgRecvType.INTERVIEWER.getBaseDataId());
        boolean noticeCopiedPerson = dataEntity.getBoolean("noticecopiedperson");
        List<Map<String, String>> noticeCopiedPersonList = result.get(CfgMsgRecvType.CANDIDATE.getBaseDataId());
        boolean noticeReceiver = dataEntity.getBoolean("noticereceptionist");
        List<Map<String, String>> noticeReceiverList = result.get(CfgMsgRecvType.RECEIVER.getBaseDataId());
        DynamicObject roundEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
        long interviewmethodId = roundEntry.getLong("interviewmethod.id");
        String receptionist = dataEntity.getString("receptionist");
        DynamicObjectCollection groupEntry = roundEntry.getDynamicObjectCollection("tsirm_intvgroupentry");
        for (DynamicObject entry : groupEntry) {
            String vedioIntvAddress = "";
            String vedioAppfileAddress = "";
            if (interviewmethodId == 1010L) {
                DynamicObject addressDetail = entry.getDynamicObject("addressdetail");
                if (!Objects.isNull(addressDetail)) {
                    String country = addressDetail.getString("country.name");
                    String city = addressDetail.getString("city.name");
                    String detailaddr = addressDetail.getString("detailaddr.name");
                    String room = entry.getString("interviewroom");
                    variableInfoMap.put("interviewlocation", IntvMsgArrangementHelper.handel(country) + IntvMsgArrangementHelper.handel(city) + IntvMsgArrangementHelper.handel(detailaddr) + IntvMsgArrangementHelper.handel(room));
                }
            } else if (interviewmethodId == 1040L) {
                vedioIntvAddress = entry.getString("intvervedioaddress");
                vedioAppfileAddress = entry.getString("candatevedioaddress");
            }
            Date intvDate = entry.getDate("intvdate");
            int startTime = entry.getInt("intvstarttime");
            int endTime = entry.getInt("intvendtime");
            DynamicObjectCollection intvInterviewers = entry.getDynamicObjectCollection("intver");
            DynamicObjectCollection groupCandates = entry.getDynamicObjectCollection("groupcandate");
            List appfileNames = groupCandates.stream().map(candate -> candate.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
            String appfileStringNames = String.join((CharSequence)",", appfileNames);
            variableInfoMap.put("interviewcandiname", appfileStringNames);
            variableInfoMap.put("interviewtime", IntvVariableInfoHelper.getInterviewFormatTime(intvDate, startTime, endTime));
            if (!isProcessNew) {
                for (DynamicObject intvInterviewer : intvInterviewers) {
                    Iterator bosUserObj = intvInterviewer.getDynamicObject("fbasedataid");
                    DynamicObject bosUser = BosUserServiceHelper.getInstance().getUser(bosUserObj.getLong("id"));
                    if (modifyAddInterviewIds == null || !modifyAddInterviewIds.contains(bosUser.getLong("id"))) continue;
                    Map<String, String> interviewMap = IntvMsgArrangementHelper.noticeInterviewByCfgMsg(dataEntity, variableInfoMap, intvTaskList, isProcessNew, argIntvId, bosUser, interviewNoticeModel);
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vedioIntvAddress})) {
                        interviewMap.put("interviewlocation", vedioIntvAddress);
                    }
                    interviewMap.put("cfgmsgtemplateid", String.valueOf(IntvCfgMsgTempfdConstants.ARRANGEMENT_TEMPLETE_ID));
                    noticeInterviewerList.add(interviewMap);
                }
                result.put(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), noticeInterviewerList);
                continue;
            }
            if (noticeInterviewer) {
                HashMap ccMap = Maps.newHashMapWithExpectedSize((int)16);
                StringBuilder interviewNames = new StringBuilder();
                for (DynamicObject intvInterviewer : intvInterviewers) {
                    DynamicObject bosUserObj = intvInterviewer.getDynamicObject("fbasedataid");
                    DynamicObject bosUser = BosUserServiceHelper.getInstance().getUser(bosUserObj.getLong("id"));
                    interviewNames.append(bosUser.getString("name")).append(",");
                    Map<String, String> interviewMap = IntvMsgArrangementHelper.noticeInterviewByCfgMsg(dataEntity, variableInfoMap, intvTaskList, isProcessNew, argIntvId, bosUser, interviewNoticeModel);
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vedioIntvAddress})) {
                        interviewMap.put("interviewlocation", vedioIntvAddress);
                    }
                    InterviewEmailHelper.getInstance().generateFirstLineForArrange(interviewMap);
                    ccMap.putAll(interviewMap);
                    noticeInterviewerList.add(interviewMap);
                }
                if (StringUtils.isNotEmpty((CharSequence)ccPersonEmail)) {
                    HashMap ccPersonMap = Maps.newHashMapWithExpectedSize((int)16);
                    ccMap.put("interviewername", interviewNames.deleteCharAt(interviewNames.length() - 1).toString());
                    ccMap.put("ccFlag", "true");
                    IntvMsgArrangementHelper.generateCcPersonEmail(ccPersonEmail, ccMap, ccPersonMap);
                    noticeInterviewerList.add(ccPersonMap);
                }
                result.put(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), noticeInterviewerList);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{receptionist}) && noticeReceiver) {
                Map<String, String> receptionistMap = IntvMsgArrangementHelper.noticeReceiverByCfgMsg(dataEntity, interviewNoticeModel, receptionist, CfgMsgScenes.ARRANGE_INTERVIEW.getBaseDataId(), variableInfoMap);
                noticeReceiverList.add(receptionistMap);
                result.put(CfgMsgRecvType.RECEIVER.getBaseDataId(), noticeReceiverList);
            }
            if (!noticeCopiedPerson) continue;
            for (DynamicObject groupCandate : groupCandates) {
                Map<String, String> candateMap = IntvMsgArrangementHelper.noticeCopiePersonByCfgMsg(groupCandate, appfileTaskList, CfgMsgScenes.ARRANGE_INTERVIEW.getBaseDataId(), variableInfoMap);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vedioAppfileAddress})) {
                    candateMap.put("interviewvediolocation", vedioAppfileAddress);
                }
                noticeCopiedPersonList.add(candateMap);
            }
            result.put(CfgMsgRecvType.CANDIDATE.getBaseDataId(), noticeCopiedPersonList);
        }
    }

    public static void modifyArrangementMsgParam(DynamicObject dataEntity, List<DynamicObject> intvTaskList, List<DynamicObject> appfileTaskList, Map<String, Object> variableInfoMap, List<ArgIntvUpdateResultEntity> updateDataEntityList, Map<String, List<Map<String, String>>> result) {
        long argIntvId = dataEntity.getLong("id");
        boolean noticeInterviewer = dataEntity.getBoolean("noticeinterviewer");
        String ccPersonEmail = dataEntity.getString("ccperson");
        List<Map<String, String>> noticeInterviewerList = result.get(CfgMsgRecvType.INTERVIEWER.getBaseDataId());
        boolean noticeCopiedPerson = dataEntity.getBoolean("noticecopiedperson");
        List<Map<String, String>> noticeCopiedPersonList = result.get(CfgMsgRecvType.CANDIDATE.getBaseDataId());
        boolean noticeReceiver = dataEntity.getBoolean("noticereceptionist");
        List<Map<String, String>> noticeReceiverList = result.get(CfgMsgRecvType.RECEIVER.getBaseDataId());
        DynamicObject roundEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
        long interviewmethodId = roundEntry.getLong("interviewmethod.id");
        String receptionist = dataEntity.getString("receptionist");
        DynamicObjectCollection groupEntry = roundEntry.getDynamicObjectCollection("tsirm_intvgroupentry");
        ArrayList addInterviewIds = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList noChangeInterviewIds = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList delInterviewIds = Lists.newArrayListWithExpectedSize((int)10);
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            delInterviewIds.addAll(argIntvUpdateResultEntity.getInterViewerIdDelete());
            addInterviewIds.addAll(argIntvUpdateResultEntity.getInterViewerIdAdd());
            noChangeInterviewIds.addAll(argIntvUpdateResultEntity.getInterViewerIdNoChange());
        }
        for (DynamicObject entry : groupEntry) {
            long groupId = entry.getLong("id");
            ArgIntvUpdateResultEntity argIntvUpdateResultEntity = updateDataEntityList.stream().filter(updateDataEntity -> updateDataEntity.getGroupId() == groupId).findFirst().get();
            boolean groupIntvTimeChange = argIntvUpdateResultEntity.isGroupIntvTimeChange();
            boolean groupAddressChange = argIntvUpdateResultEntity.isGroupAddressChange();
            boolean groupAppAddressChange = argIntvUpdateResultEntity.isGroupAppAddressChange();
            boolean groupInterviewerAddressChange = argIntvUpdateResultEntity.isGroupInterviewerAddressChange();
            String vedioIntvAddress = "";
            String vedioAppfileAddress = "";
            boolean addressChange = false;
            if (interviewmethodId == 1010L) {
                DynamicObject addressDetail = entry.getDynamicObject("addressdetail");
                if (!Objects.isNull(addressDetail)) {
                    String country = addressDetail.getString("country.name");
                    String city = addressDetail.getString("city.name");
                    String detailaddr = addressDetail.getString("detailaddr.name");
                    String room = entry.getString("interviewroom");
                    variableInfoMap.put("interviewlocation", IntvMsgArrangementHelper.handel(country) + IntvMsgArrangementHelper.handel(city) + IntvMsgArrangementHelper.handel(detailaddr) + IntvMsgArrangementHelper.handel(room));
                    addressChange = groupAddressChange;
                }
            } else if (interviewmethodId == 1040L) {
                vedioIntvAddress = entry.getString("intvervedioaddress");
                vedioAppfileAddress = entry.getString("candatevedioaddress");
            }
            Date intvDate = entry.getDate("intvdate");
            int startTime = entry.getInt("intvstarttime");
            int endTime = entry.getInt("intvendtime");
            DynamicObjectCollection intvInterviewers = entry.getDynamicObjectCollection("intver");
            DynamicObjectCollection groupCandates = entry.getDynamicObjectCollection("groupcandate");
            List appfileNames = groupCandates.stream().map(candate -> candate.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
            String appfileStringNames = String.join((CharSequence)",", appfileNames);
            variableInfoMap.put("interviewcandiname", appfileStringNames);
            variableInfoMap.put("interviewtime", IntvVariableInfoHelper.getInterviewFormatTime(intvDate, startTime, endTime));
            if (!delInterviewIds.isEmpty()) {
                Map<String, List<Map<String, Object>>> cancel = IntvMsgArrangementHelper.cancel(dataEntity, true, delInterviewIds);
                CfgMessageService.sendMessage(cancel);
                IntvDetailUtil.sendNotice(cancel);
            }
            if (noticeInterviewer) {
                DynamicObject bosUser;
                addressChange = addressChange || groupInterviewerAddressChange;
                StringBuilder interviewNames = new StringBuilder();
                HashMap ccMap = Maps.newHashMapWithExpectedSize((int)16);
                for (DynamicObject intvInterviewer : intvInterviewers) {
                    bosUser = intvInterviewer.getDynamicObject("fbasedataid");
                    interviewNames.append(bosUser.getString("name")).append(",");
                    long userId = bosUser.getLong("id");
                    if (IntvMsgArrangementHelper.isModifyNeedMail(addInterviewIds, delInterviewIds, noChangeInterviewIds, userId, groupIntvTimeChange, addressChange)) continue;
                    Map<String, String> interviewMap = IntvMsgArrangementHelper.noticeInterviewByCfgMsgWhenModify(dataEntity, intvTaskList, variableInfoMap, bosUser, argIntvId, updateDataEntityList, vedioIntvAddress, addInterviewIds, delInterviewIds);
                    InterviewEmailHelper.getInstance().generateFirstLineForUpdate(interviewMap);
                    if (interviewMap.isEmpty()) continue;
                    ccMap.putAll(interviewMap);
                    noticeInterviewerList.add(interviewMap);
                }
                if (StringUtils.isNotEmpty((CharSequence)ccPersonEmail)) {
                    HashMap ccPersonMap = Maps.newHashMapWithExpectedSize((int)16);
                    if (ccMap.isEmpty()) {
                        InterviewNoticeModel interviewNoticeModel;
                        DynamicObject intvInterviewer;
                        intvInterviewer = (DynamicObject)intvInterviewers.get(0);
                        bosUser = BosUserServiceHelper.getInstance().getUser(intvInterviewer.getDynamicObject("fbasedataid").getLong("id"));
                        Map<String, String> interviewMap = IntvMsgArrangementHelper.noticeInterviewByCfgMsg(dataEntity, variableInfoMap, intvTaskList, false, argIntvId, bosUser, interviewNoticeModel = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.ADD));
                        if (!interviewMap.isEmpty()) {
                            ccMap.putAll(interviewMap);
                        }
                    }
                    ccMap.put("interviewername", interviewNames.deleteCharAt(interviewNames.length() - 1).toString());
                    ccMap.put("ccFlag", "true");
                    IntvMsgArrangementHelper.generateCcPersonEmail(ccPersonEmail, ccMap, ccPersonMap);
                    noticeInterviewerList.add(ccPersonMap);
                }
            }
            if (!addInterviewIds.isEmpty() && noticeInterviewer) {
                QFilter qFilter = new QFilter("argintv", "=", (Object)dataEntity.getLong("id"));
                qFilter.and(new QFilter("receivertype", "=", (Object)ArgIntvReceiverTypeEnum.INTERVIEWER.getNumber()));
                List<DynamicObject> list = TsrbsHelper.selectByFilter("content_tag,emailtheme,channel", qFilter.toArray(), "tsirm_argintvmtpl");
                if (!CollectionUtils.isEmpty(list)) {
                    list.forEach(dynamicObject -> {
                        long channel = dynamicObject.getLong("channel");
                        String content = dynamicObject.getString("content_tag");
                        String emailTheme = dynamicObject.getString("emailtheme");
                        if ("475773782250774528".equals(String.valueOf(channel))) {
                            dataEntity.set("intvchkmailsend", (Object)true);
                            dataEntity.set("noticeinterviewer", (Object)true);
                            dataEntity.set("intetheme", (Object)emailTheme);
                            dataEntity.set("txtmailinterviewer_tag", (Object)content);
                        }
                        if ("475773159430184960".equals(String.valueOf(channel))) {
                            dataEntity.set("intvchksmssend", (Object)true);
                            dataEntity.set("noticeinterviewer", (Object)true);
                            dataEntity.set("sms_intv_richtext", (Object)content);
                        }
                    });
                }
                InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.ADD);
                IntvMsgArrangementHelper.setAddNewInterviewerContent(dataEntity, variableInfoMap, intvTaskList, addInterviewIds, interviewNoticeModel, result);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{receptionist}) && noticeReceiver) {
                boolean bl = addressChange = addressChange || groupInterviewerAddressChange;
                if (groupIntvTimeChange || addressChange) {
                    InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT);
                    Map<String, String> receptionistMap = IntvMsgArrangementHelper.noticeReceiverByCfgMsg(dataEntity, interviewNoticeModel, variableInfoMap, receptionist);
                    noticeReceiverList.add(receptionistMap);
                }
            }
            if (!noticeCopiedPerson) continue;
            boolean bl = addressChange = addressChange || groupAppAddressChange;
            if (groupIntvTimeChange || addressChange) {
                IntvMsgArrangementHelper.handleCandate(appfileTaskList, variableInfoMap, noticeCopiedPersonList, groupIntvTimeChange, vedioAppfileAddress, addressChange, groupCandates);
                continue;
            }
            noticeCopiedPersonList.clear();
        }
        result.put(CfgMsgRecvType.CANDIDATE.getBaseDataId(), noticeCopiedPersonList);
        result.put(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), noticeInterviewerList);
        result.put(CfgMsgRecvType.RECEIVER.getBaseDataId(), noticeReceiverList);
    }

    private static void setAddNewInterviewerContent(DynamicObject dataEntity, Map<String, Object> variableInfoMap, List<DynamicObject> intvTaskList, List<Long> modifyAddInterviewIds, InterviewNoticeModel interviewNoticeModel, Map<String, List<Map<String, String>>> result) {
        if (null == dataEntity) {
            return;
        }
        long argIntvId = dataEntity.getLong("id");
        boolean noticeInterviewer = dataEntity.getBoolean("noticeinterviewer");
        List<Map<String, String>> noticeInterviewerList = result.get(CfgMsgRecvType.INTERVIEWER.getBaseDataId());
        DynamicObject roundEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
        DynamicObjectCollection groupEntry = roundEntry.getDynamicObjectCollection("tsirm_intvgroupentry");
        long interviewmethodId = roundEntry.getLong("interviewmethod.id");
        for (DynamicObject entry : groupEntry) {
            String vedioIntvAddress = "";
            Date intvDate = entry.getDate("intvdate");
            int startTime = entry.getInt("intvstarttime");
            int endTime = entry.getInt("intvendtime");
            if (interviewmethodId == 1010L) {
                DynamicObject addressDetail = entry.getDynamicObject("addressdetail");
                if (!Objects.isNull(addressDetail)) {
                    String country = addressDetail.getString("country.name");
                    String city = addressDetail.getString("city.name");
                    String detailaddr = addressDetail.getString("detailaddr.name");
                    String room = entry.getString("interviewroom");
                    variableInfoMap.put("interviewlocation", IntvMsgArrangementHelper.handel(country) + IntvMsgArrangementHelper.handel(city) + IntvMsgArrangementHelper.handel(detailaddr) + IntvMsgArrangementHelper.handel(room));
                }
            } else if (interviewmethodId == 1040L) {
                vedioIntvAddress = entry.getString("intvervedioaddress");
            }
            DynamicObjectCollection intvInterviewers = entry.getDynamicObjectCollection("intver");
            DynamicObjectCollection groupCandates = entry.getDynamicObjectCollection("groupcandate");
            List appfileNames = groupCandates.stream().map(candate -> candate.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
            String appfileStringNames = String.join((CharSequence)",", appfileNames);
            variableInfoMap.put("interviewcandiname", appfileStringNames);
            variableInfoMap.put("interviewtime", IntvVariableInfoHelper.getInterviewFormatTime(intvDate, startTime, endTime));
            if (!noticeInterviewer) continue;
            for (DynamicObject intvInterviewer : intvInterviewers) {
                DynamicObject bosUserObj = intvInterviewer.getDynamicObject("fbasedataid");
                DynamicObject bosUser = BosUserServiceHelper.getInstance().getUser(bosUserObj.getLong("id"));
                if (!modifyAddInterviewIds.contains(bosUser.getLong("id"))) continue;
                Map<String, String> interviewMap = IntvMsgArrangementHelper.noticeInterviewByCfgMsg(dataEntity, variableInfoMap, intvTaskList, true, argIntvId, bosUser, interviewNoticeModel);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vedioIntvAddress})) {
                    interviewMap.put("interviewlocation", vedioIntvAddress);
                }
                interviewMap.put("updateAdd", "1");
                interviewMap.put("updateAddEmail", interviewNoticeModel.getInterviewerMailContent());
                interviewMap.put("updateAddEmailTheme", interviewNoticeModel.getInterviewerMailTheme());
                interviewMap.put("updateAddSmsContent", interviewNoticeModel.getInterviewerSmsContent());
                noticeInterviewerList.add(interviewMap);
            }
            result.put(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), noticeInterviewerList);
        }
    }

    private static boolean isModifyNeedMail(List<Long> addInterviewIds, List<Long> delInterviewIds, List<Long> noChangeInterviewIds, Long userId, boolean groupIntvTimeChange, boolean addressChange) {
        if (addInterviewIds.contains(userId) || delInterviewIds.contains(userId)) {
            return true;
        }
        return noChangeInterviewIds.contains(userId) && !groupIntvTimeChange && !addressChange;
    }

    private static void handleCandate(List<DynamicObject> appfileTaskList, Map<String, Object> variableInfoMap, List<Map<String, String>> noticeCopiedPersonList, boolean groupIntvTimeChange, String vedioAppfileAddress, boolean addressChange, DynamicObjectCollection groupCandates) {
        for (DynamicObject groupCandate : groupCandates) {
            if (!addressChange && !groupIntvTimeChange) continue;
            Map<String, String> copiedPersonMap = IntvMsgArrangementHelper.noticeCopiedPersonByCfgMsg(appfileTaskList, variableInfoMap, groupCandate);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vedioAppfileAddress})) {
                copiedPersonMap.put("interviewvediolocation", vedioAppfileAddress);
            }
            noticeCopiedPersonList.add(copiedPersonMap);
        }
    }

    private static void generateCcPersonEmail(String ccPersonEmail, Map<String, String> interviewMap, Map<String, String> ccPersonMap) {
        ccPersonMap.putAll(interviewMap);
        String tableString = ccPersonMap.get("interviewarrangelist");
        if (StringUtils.isNotBlank((CharSequence)tableString)) {
            ccPersonMap.put("interviewarrangelist", tableString);
        }
        ccPersonMap.put("intverviewanswer", ResManager.loadKDString((String)"\u7b54\u590d", (String)"IntvMailHelper_28", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        ccPersonMap.put("logintsivpurl", ResManager.loadKDString((String)"\u767b\u5f55\u4eba\u4eba\u9762\u8bd5\u5b98", (String)"IntvMailHelper_55", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        ccPersonMap.remove("phone");
        ccPersonMap.put("email", ccPersonEmail);
    }

    private static void generateCancelCcPersonEmail(String ccPersonEmail, Map<String, Object> interviewMap, Map<String, Object> ccPersonMap) {
        ccPersonMap.putAll(interviewMap);
        String tableString = (String)ccPersonMap.get("interviewarrangelist");
        if (StringUtils.isNotBlank((CharSequence)tableString)) {
            String tableC = IntvMsgArrangementHelper.removeEvalute(tableString);
            ccPersonMap.put("interviewarrangelist", tableC);
        }
        ccPersonMap.remove("phone");
        ccPersonMap.put("email", ccPersonEmail);
    }

    public static Map<String, List<Map<String, Object>>> cancel(DynamicObject dataEntity, boolean isCancelByUpdateInterview, List<Long> delInterviewIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList noticeInterviewerList = Lists.newArrayListWithExpectedSize((int)10);
        String ccPersonEmail = dataEntity.getString("ccperson");
        ArrayList noticeCopiedPersonList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList noticeReceiverList = Lists.newArrayListWithExpectedSize((int)10);
        Map<String, Object> variableInfo = IntvVariableInfoHelper.getVariableInfo(dataEntity);
        DynamicObject roundEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
        String receptionist = dataEntity.getString("receptionist");
        DynamicObject entry = (DynamicObject)roundEntry.getDynamicObjectCollection("tsirm_intvgroupentry").get(0);
        Date intvDate = entry.getDate("intvdate");
        int startTime = entry.getInt("intvstarttime");
        int endTime = entry.getInt("intvendtime");
        if (isCancelByUpdateInterview) {
            DynamicObject intvDataEntiry = ArgIntvHelper.getInstance().getIntvDataEntiry(dataEntity.getLong("id"));
            DynamicObject roundEntry1 = (DynamicObject)intvDataEntiry.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
            DynamicObject entry1 = (DynamicObject)roundEntry1.getDynamicObjectCollection("tsirm_intvgroupentry").get(0);
            Date intvDate1 = entry1.getDate("intvdate");
            int startTime1 = entry1.getInt("intvstarttime");
            int endTime1 = entry1.getInt("intvendtime");
            InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInterviewNoticeModel(intvDataEntiry, InterviewMailType.ADD);
            interviewNoticeModel.setFromCancel(Boolean.valueOf(true));
            String tableC = InterviewEmailHelper.generateTable(intvDataEntiry, interviewNoticeModel, null, new InterviewNoticeModel());
            Map<String, Object> variableInfoOfCancel = IntvVariableInfoHelper.getVariableInfo(intvDataEntiry);
            Map<String, Object> interviewResultMap = IntvMsgArrangementHelper.cancelInterviewMailMap(variableInfoOfCancel, intvDate1, startTime1, endTime1, tableC, CfgMsgRecvType.INTERVIEWER, IntvCfgMsgTempfdConstants.CANCEL_INTERVIEWER_ID);
            for (DynamicObject intver : entry1.getDynamicObjectCollection("intver")) {
                HashMap conMap = Maps.newHashMapWithExpectedSize((int)4);
                IntvMsgArrangementHelper.generateCancelMap(interviewResultMap, intver, conMap, delInterviewIds, isCancelByUpdateInterview);
                InterviewEmailHelper.getInstance().generateForCancel(conMap);
                if (conMap.isEmpty()) continue;
                conMap.put("businessId", dataEntity.getString("id"));
                conMap.put("interviewertemplate", true);
                InterviewEmailHelper.getInstance().generateForCancel(conMap);
                noticeInterviewerList.add(conMap);
                result.put(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), noticeInterviewerList);
            }
            return result;
        }
        Map<String, Object> appfileResultMap = IntvMsgArrangementHelper.cancelInterviewMailMap(variableInfo, intvDate, startTime, endTime, "", CfgMsgRecvType.CANDIDATE, IntvCfgMsgTempfdConstants.CANCEL_APPFILE_ID);
        for (DynamicObject appfile : entry.getDynamicObjectCollection("groupcandate")) {
            HashMap conMap = Maps.newHashMapWithExpectedSize((int)4);
            DynamicObject appfileObj = appfile.getDynamicObject("fbasedataid");
            conMap.put("phone", appfileObj.getString("phone"));
            conMap.put("email", appfileObj.getString("email"));
            conMap.put("msgSceneType", CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId());
            conMap.put("msgReceiverType", CfgMsgRecvType.CANDIDATE.getBaseDataId());
            conMap.put("interviewcandiname", appfileObj.getString("name"));
            appfileResultMap.forEach(conMap::putIfAbsent);
            conMap.put("businessId", dataEntity.getString("id"));
            noticeCopiedPersonList.add(conMap);
        }
        InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.ADD);
        interviewNoticeModel.setFromCancel(Boolean.valueOf(true));
        String tableC = InterviewEmailHelper.generateTable(dataEntity, interviewNoticeModel, null, new InterviewNoticeModel());
        Map<String, Object> interviewResultMap = IntvMsgArrangementHelper.cancelInterviewMailMap(variableInfo, intvDate, startTime, endTime, tableC, CfgMsgRecvType.INTERVIEWER, IntvCfgMsgTempfdConstants.CANCEL_INTERVIEWER_ID);
        StringBuilder interviewNames = new StringBuilder();
        HashMap ccMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject intver : entry.getDynamicObjectCollection("intver")) {
            HashMap conMap = Maps.newHashMapWithExpectedSize((int)4);
            IntvMsgArrangementHelper.generateCancelMap(interviewResultMap, intver, conMap, delInterviewIds, isCancelByUpdateInterview);
            DynamicObject bosUser = intver.getDynamicObject("fbasedataid");
            String interviewerName = bosUser.getString("name");
            interviewNames.append(interviewerName).append(",");
            if (conMap.isEmpty()) continue;
            conMap.put("interviewertemplate", true);
            InterviewEmailHelper.getInstance().generateForCancel(conMap);
            conMap.put("businessId", dataEntity.getString("id"));
            InterviewEmailHelper.getInstance().generateForCancel(conMap);
            ccMap.putAll(conMap);
            noticeInterviewerList.add(conMap);
        }
        if (StringUtils.isNotEmpty((CharSequence)ccPersonEmail) && !noticeInterviewerList.isEmpty() && interviewNames.length() > 0) {
            HashMap ccPersonMap = Maps.newHashMapWithExpectedSize((int)16);
            ccMap.put("interviewername", interviewNames.deleteCharAt(interviewNames.length() - 1).toString());
            ccMap.put("ccFlag", "true");
            IntvMsgArrangementHelper.generateCancelCcPersonEmail(ccPersonEmail, ccMap, ccPersonMap);
            ccPersonMap.put("id", CfgMsgTemplateHelper.queryCfgMsgTemplateIdByPushSceneAndReceiver((Long)Long.valueOf(CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId()), (Long)Long.valueOf(CfgMsgRecvType.INTERVIEWER.getBaseDataId()), (Long)IntvCfgMsgTempfdConstants.CANCEL_INTERVIEWER_ID));
            InterviewEmailHelper.getInstance().generateForCancel(ccPersonMap);
            logger.info("cancel cc map :{}", (Object)ccPersonMap);
            noticeInterviewerList.add(ccPersonMap);
        }
        result.put(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), noticeInterviewerList);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{receptionist})) {
            Map<String, Object> receptionistResultMap = variableInfo;
            String templateId = CfgMsgTemplateHelper.queryCfgMsgTemplateIdByPushSceneAndReceiver((Long)Long.valueOf(CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId()), (Long)Long.valueOf(CfgMsgRecvType.RECEIVER.getBaseDataId()), (Long)IntvCfgMsgTempfdConstants.CANCEL_RECEPTION_ID);
            receptionistResultMap.put("id", templateId);
            receptionistResultMap.put("interviewarrangelist", tableC);
            receptionistResultMap.put("email", receptionist);
            receptionistResultMap.put("msgSceneType", CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId());
            receptionistResultMap.put("msgReceiverType", CfgMsgRecvType.RECEIVER.getBaseDataId());
            receptionistResultMap.put("businessId", dataEntity.getString("id"));
            noticeReceiverList.add(receptionistResultMap);
            IntvMsgArrangementHelper.cancelExtCustomParam(noticeReceiverList);
            result.put(CfgMsgRecvType.RECEIVER.getBaseDataId(), noticeReceiverList);
        }
        IntvMsgArrangementHelper.cancelExtCustomParam(noticeCopiedPersonList);
        IntvMsgArrangementHelper.cancelExtCustomParam(noticeInterviewerList);
        result.put(CfgMsgRecvType.CANDIDATE.getBaseDataId(), noticeCopiedPersonList);
        result.put(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), noticeInterviewerList);
        return result;
    }

    private static void cancelExtCustomParam(List<Map<String, Object>> mapList) {
        if (CollectionUtils.isEmpty(mapList)) {
            return;
        }
        String msgTplId = (String)mapList.get(0).get("id");
        DynamicObject msgTplDy = CfgMsgTemplateHelper.findQuestionnaireById((Object)msgTplId);
        if (null == msgTplDy) {
            return;
        }
        CustomMessageParamBo customParamBo = new CustomMessageParamBo(Long.valueOf(Long.parseLong(msgTplId)), mapList, "4");
        MessageParamService.getInstance().setCustomParam(customParamBo);
    }

    private static void generateCancelMap(Map<String, Object> interviewResultMap, DynamicObject intver, Map<String, Object> conMap, List<Long> delInterviewIds, boolean isCancelByUpdateInterview) {
        DynamicObject bosUser = intver.getDynamicObject("fbasedataid");
        String interviewerName = bosUser.getString("name");
        String email = bosUser.getString("email");
        long userId = bosUser.getLong("id");
        String phone = bosUser.containsProperty("phone") ? bosUser.getString("phone") : BosUserServiceHelper.getInstance().getUser(userId).getString("phone");
        if (!isCancelByUpdateInterview || delInterviewIds.contains(userId)) {
            conMap.put("phone", phone);
            conMap.put("email", email);
            conMap.put("msgSceneType", CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId());
            conMap.put("msgReceiverType", CfgMsgRecvType.INTERVIEWER.getBaseDataId());
            conMap.put("interviewername", interviewerName);
            conMap.put("interviewerId", bosUser.getLong("id"));
            interviewResultMap.forEach(conMap::putIfAbsent);
        }
    }

    private static Map<String, Object> cancelInterviewMailMap(Map<String, Object> variableInfo, Date intvDate, int startTime, int endTime, String tableString, CfgMsgRecvType interviewer, Long cancelInterviewerId) {
        Map<String, Object> interviewResultMap = variableInfo;
        interviewResultMap.put("interviewtime", IntvVariableInfoHelper.getInterviewFormatTime(intvDate, startTime, endTime));
        interviewResultMap.put("interviewarrangelist", tableString);
        interviewResultMap.put("id", CfgMsgTemplateHelper.queryCfgMsgTemplateIdByPushSceneAndReceiver((Long)Long.valueOf(CfgMsgScenes.UPDATE_INTERVIEW.getBaseDataId()), (Long)Long.valueOf(interviewer.getBaseDataId()), (Long)cancelInterviewerId));
        return interviewResultMap;
    }

    private static Map<String, String> noticeInterviewByCfgMsg(DynamicObject dataEntity, Map<String, Object> variableInfoMap, List<DynamicObject> intvTaskList, boolean isProcessNew, long argIntvId, DynamicObject bosUser, InterviewNoticeModel interviewNoticeModel) {
        String interviewerName = bosUser.getString("name");
        String email = bosUser.getString("email");
        String phone = bosUser.getString("phone");
        HashMap interviewMap = Maps.newHashMapWithExpectedSize((int)16);
        interviewMap.put("phone", phone);
        interviewMap.put("email", email);
        interviewMap.put("msgSceneType", isProcessNew ? CfgMsgScenes.ARRANGE_INTERVIEW.getBaseDataId() : CfgMsgScenes.CANCEL_INTERVIEW.getBaseDataId());
        interviewMap.put("msgReceiverType", CfgMsgRecvType.INTERVIEWER.getBaseDataId());
        interviewMap.put("interviewername", interviewerName);
        List interviewerId = intvTaskList.stream().filter(intv -> intv.getDynamicObject("interviewer").getLong("id") == bosUser.getLong("id")).map(intv -> intv.getLong("id")).collect(Collectors.toList());
        if (!interviewerId.isEmpty()) {
            String taskId = String.valueOf(interviewerId.get(0));
            String formDetailUrl = IntvMsgArrangementHelper.getInterviewReplyUrl(dataEntity, bosUser, taskId);
            interviewMap.put("intverviewanswer", formDetailUrl);
            interviewMap.put("logintsivpurl", IntvVariableInfoHelper.getFormParam(argIntvId, bosUser.getLong("id"), taskId, "tsirm_intvevlir"));
        }
        interviewMap.put("intverviewanswername", ResManager.loadKDString((String)"\u7b54\u590d", (String)"IntvMailHelper_28", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        interviewMap.put("logintsivpurlname", ResManager.loadKDString((String)"\u767b\u5f55\u4eba\u4eba\u9762\u8bd5\u5b98", (String)"IntvMailHelper_55", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        String tableString = InterviewEmailHelper.generateTable(dataEntity, interviewNoticeModel, null, new InterviewNoticeModel(), Lists.newArrayList((Object[])new Long[]{bosUser.getLong("id")}), intvTaskList);
        interviewMap.put("interviewarrangelist", tableString);
        variableInfoMap.entrySet().stream().filter(variable -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{String.valueOf(variable.getValue())})).forEach(variable -> interviewMap.put(variable.getKey(), String.valueOf(variable.getValue())));
        return interviewMap;
    }

    private static Map<String, String> noticeReceiverByCfgMsg(DynamicObject dataEntity, InterviewNoticeModel interviewNoticeModel, String receptionist, String msgSenceTypeParam, Map<String, Object> variableInfoMap) {
        HashMap receptionistMap = Maps.newHashMapWithExpectedSize((int)16);
        receptionistMap.put("email", receptionist);
        receptionistMap.put("msgSceneType", msgSenceTypeParam);
        receptionistMap.put("msgReceiverType", CfgMsgRecvType.RECEIVER.getBaseDataId());
        interviewNoticeModel.setEmailReceiver(true);
        String tableString = IntvMailHelper.generateTable(dataEntity, interviewNoticeModel, null, new InterviewNoticeModel());
        String tableC = IntvMsgArrangementHelper.removeEvalute(tableString);
        receptionistMap.put("interviewarrangelist", tableC);
        variableInfoMap.entrySet().stream().filter(variable -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{String.valueOf(variable.getValue())})).forEach(variable -> receptionistMap.put(variable.getKey(), String.valueOf(variable.getValue())));
        return receptionistMap;
    }

    @NotNull
    private static String removeEvalute(String tableString) {
        Document resParse = Jsoup.parse((String)tableString);
        resParse.getElementsByClass("remove_ele").remove();
        resParse.getElementsByClass("to_evaluate").remove();
        return resParse.toString();
    }

    private static Map<String, String> noticeCopiePersonByCfgMsg(DynamicObject groupCandate, List<DynamicObject> appfileTaskList, String msgSenceTypeParam, Map<String, Object> variableInfoMap) {
        HashMap candateMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject appfile = groupCandate.getDynamicObject("fbasedataid");
        String phone = appfile.getString("phone");
        String email = appfile.getString("email");
        String appfileName = appfile.getString("name");
        candateMap.put("phone", phone);
        candateMap.put("email", email);
        if (!appfileTaskList.isEmpty()) {
            long taskId = appfileTaskList.get(0).getLong("id");
            candateMap.put("intverviewanswer", IntvVariableInfoHelper.getReplyUrl(phone, String.valueOf(taskId)));
            candateMap.put("intverviewanswername", ResManager.loadKDString((String)"\u7b54\u590d", (String)"IntvMailHelper_28", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        candateMap.put("interviewcandiname", appfileName);
        candateMap.put("msgSceneType", msgSenceTypeParam);
        candateMap.put("msgReceiverType", CfgMsgRecvType.RECEIVER.getBaseDataId());
        candateMap.put("interviewlocation", "");
        variableInfoMap.entrySet().stream().filter(variable -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{String.valueOf(variable.getValue())})).forEach(variable -> candateMap.put(variable.getKey(), String.valueOf(variable.getValue())));
        return candateMap;
    }

    private static Map<String, String> noticeReceiverByCfgMsg(DynamicObject dataEntity, InterviewNoticeModel interviewNoticeModel, Map<String, Object> variableInfoMap, String receptionist) {
        return IntvMsgArrangementHelper.noticeReceiverByCfgMsg(dataEntity, interviewNoticeModel, receptionist, CfgMsgScenes.CANCEL_INTERVIEW.getBaseDataId(), variableInfoMap);
    }

    private static Map<String, String> noticeInterviewByCfgMsgWhenModify(DynamicObject dataEntity, List<DynamicObject> intvTaskList, Map<String, Object> variableInfoMap, DynamicObject bosUser, Long argIntvId, List<ArgIntvUpdateResultEntity> updateDataEntityList, String vedioIntvAddress, List<Long> addInterviewIds, List<Long> delInterviewIds) {
        String phone;
        HashMap interviewMap = Maps.newHashMapWithExpectedSize((int)16);
        String interviewerName = bosUser.getString("name");
        String email = bosUser.getString("email");
        long userId = bosUser.getLong("id");
        if (bosUser.containsProperty("phone")) {
            phone = bosUser.getString("phone");
        } else {
            bosUser = BosUserServiceHelper.getInstance().getUser(userId);
            phone = bosUser.getString("phone");
        }
        if (!addInterviewIds.contains(userId) && !delInterviewIds.contains(userId)) {
            interviewMap.put("phone", phone);
            interviewMap.put("email", email);
            interviewMap.put("msgSceneType", CfgMsgScenes.CANCEL_INTERVIEW.getBaseDataId());
            interviewMap.put("msgReceiverType", CfgMsgRecvType.INTERVIEWER.getBaseDataId());
            interviewMap.put("interviewername", interviewerName);
            DynamicObject finalBosUser = bosUser;
            List interviewerId = intvTaskList.stream().filter(intv -> intv.getDynamicObject("interviewer").getLong("id") == finalBosUser.getLong("id")).map(intv -> intv.getLong("id")).collect(Collectors.toList());
            if (!interviewerId.isEmpty()) {
                String taskId = String.valueOf(interviewerId.get(0));
                String formDetailUrl = IntvMsgArrangementHelper.getInterviewReplyUrl(dataEntity, bosUser, taskId);
                interviewMap.put("intverviewanswer", formDetailUrl);
                interviewMap.put("logintsivpurl", IntvVariableInfoHelper.getFormParam(argIntvId, userId, taskId, "tsirm_intvevlir"));
            }
            interviewMap.put("intverviewanswername", ResManager.loadKDString((String)"\u7b54\u590d", (String)"IntvMailHelper_28", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            interviewMap.put("logintsivpurlname", ResManager.loadKDString((String)"\u767b\u5f55\u4eba\u4eba\u9762\u8bd5\u5b98", (String)"IntvMailHelper_55", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            Map groupUpdateMap = updateDataEntityList.stream().collect(Collectors.toMap(ArgIntvUpdateResultEntity::getGroupId, updateDataEntity -> updateDataEntity, (aKey, bValue) -> bValue, () -> Maps.newHashMapWithExpectedSize((int)16)));
            InterviewNoticeModel type = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT);
            InterviewNoticeModel editType = IntvMailCommonHelper.getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT_UPDATE);
            String tableString = InterviewEmailHelper.generateTable(dataEntity, type, groupUpdateMap, editType, Lists.newArrayList((Object[])new Long[]{bosUser.getLong("id")}), intvTaskList);
            interviewMap.put("interviewarrangelist", tableString);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vedioIntvAddress})) {
                interviewMap.put("interviewlocation", vedioIntvAddress);
            }
            variableInfoMap.entrySet().stream().filter(variable -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{String.valueOf(variable.getValue())})).forEach(variable -> interviewMap.put(variable.getKey(), String.valueOf(variable.getValue())));
            return interviewMap;
        }
        return Maps.newHashMapWithExpectedSize((int)16);
    }

    public static String getInterviewReplyUrl(DynamicObject dataEntity, DynamicObject bosUser, String taskId) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        param.put("argintvid", String.valueOf(dataEntity.getLong("id")));
        String md5Str = EncryptionDecryptUtil.getEncryptStr((Object)bosUser.getLong("id"));
        param.put("interviewerIdSecretStr", md5Str);
        param.put("taskids", taskId);
        String formDetailUrl = IntvMailUtils.getFormDetailUrl((String)"tsirm_interveranswer", (Map)param);
        return formDetailUrl;
    }

    private static Map<String, String> noticeCopiedPersonByCfgMsg(List<DynamicObject> appfileTaskList, Map<String, Object> variableInfoMap, DynamicObject groupCandate) {
        return IntvMsgArrangementHelper.noticeCopiePersonByCfgMsg(groupCandate, appfileTaskList, CfgMsgScenes.CANCEL_INTERVIEW.getBaseDataId(), variableInfoMap);
    }

    private static String handel(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return str;
        }
        return "";
    }
}

