/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.intvmail;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHelper;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsirm.common.util.IntvMailUtils;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IntvVariableInfoHelper {
    public static Map<String, Object> getVariableInfo(DynamicObject intvObj) {
        HashMap variableInfoMap = Maps.newHashMapWithExpectedSize((int)32);
        IntvVariableInfoHelper.setNullValue(variableInfoMap);
        String hrName = UserServiceHelper.getCurrentUser((String)"name").getString("name");
        variableInfoMap.put("interviewarrangeperson", hrName);
        String hrPhone = UserServiceHelper.getCurrentUser((String)"phone").getString("phone");
        variableInfoMap.put("interviewarrangephone", hrPhone);
        variableInfoMap.put("currentdaytime", LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE));
        if (!HRObjectUtils.isEmpty((Object)intvObj)) {
            IntvVariableInfoHelper.setVariableInfoByArgIntv(variableInfoMap, intvObj);
        }
        long aLong = ((DynamicObject)intvObj.getDynamicObjectCollection("intvcandate").get(0)).getLong("fbasedataid_id");
        DynamicObject appFile = ArgIntvHelper.getInstance().getAppFile(aLong);
        DynamicObject position = appFile.getDynamicObject("position");
        Optional.ofNullable(position).ifPresent(dynamicObject -> {
            DynamicObject positionDynamicObject = PositionHelper.queryOne(dynamicObject.getPkValue());
            Optional.ofNullable(positionDynamicObject).ifPresent(p -> IntvVariableInfoHelper.setVariableInfoByPosition(variableInfoMap, p));
        });
        return variableInfoMap;
    }

    static void setNullValue(Map<String, Object> variableInfoMap) {
        variableInfoMap.put("interviewername", " ");
        variableInfoMap.put("interviewarrangelist", " ");
        variableInfoMap.put("companyname", " ");
        variableInfoMap.put("currentdaytime", " ");
        variableInfoMap.put("interviewcandiname", " ");
        variableInfoMap.put("interviewpositionname", " ");
        variableInfoMap.put("interviewtime", " ");
        variableInfoMap.put("interviewlocation", " ");
        variableInfoMap.put("interviewvediolocation", " ");
        variableInfoMap.put("interviewarrangeperson", " ");
        variableInfoMap.put("interviewarrangephone", " ");
        variableInfoMap.put("intverviewanswer", " ");
        variableInfoMap.put("logintsivpurl", " ");
        variableInfoMap.put("adminorgsdpt", " ");
    }

    public static void setVariableInfoByArgIntv(Map<String, Object> variableInfo, DynamicObject intvObj) {
        DynamicObjectCollection roundCollection = intvObj.getDynamicObjectCollection("tsirm_intvroundentry");
        if (CollectionUtils.isEmpty((Collection)roundCollection)) {
            return;
        }
        DynamicObjectCollection groupCollection = ((DynamicObject)roundCollection.get(0)).getDynamicObjectCollection("tsirm_intvgroupentry");
        if (CollectionUtils.isEmpty((Collection)groupCollection)) {
            return;
        }
        DynamicObject groupSubEntry = (DynamicObject)groupCollection.get(0);
        Date intvDate = groupSubEntry.getDate("intvdate");
        int startTime = groupSubEntry.getInt("intvstarttime");
        int endTime = groupSubEntry.getInt("intvendtime");
        variableInfo.put("interviewtime", IntvVariableInfoHelper.getInterviewFormatTime(intvDate, startTime, endTime));
        DynamicObject addressDetail = groupSubEntry.getDynamicObject("addressdetail");
        if (!Objects.isNull(addressDetail)) {
            String country = addressDetail.getString("country.name");
            String city = addressDetail.getString("city.name");
            String detailaddr = addressDetail.getString("detailaddr.name");
            String room = groupSubEntry.getString("interviewroom");
            variableInfo.put("interviewlocation", IntvVariableInfoHelper.handel(country) + IntvVariableInfoHelper.handel(city) + IntvVariableInfoHelper.handel(detailaddr) + IntvVariableInfoHelper.handel(room));
        }
    }

    public static String handel(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return str;
        }
        return "";
    }

    public static String getInterviewFormatTime(Date date, int startTime, int endTime) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (endTime > IntvDateUtil.MAX_SECOND_OF_DAY) {
            endTime -= IntvDateUtil.MAX_SECOND_OF_DAY.intValue();
        }
        LocalTime localTimeStart = LocalTime.ofSecondOfDay(startTime);
        LocalTime localTimeEnd = LocalTime.ofSecondOfDay(endTime);
        String strDate = localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        String strStartTime = localTimeStart.format(DateTimeFormatter.ofPattern("HH:mm"));
        String strEndTime = localTimeEnd.format(DateTimeFormatter.ofPattern("HH:mm"));
        int value = localDate.getDayOfWeek().getValue();
        if (localTimeStart.isAfter(localTimeEnd)) {
            String strEndDate = localDate.plusDays(1L).format(DateTimeFormatter.ISO_LOCAL_DATE);
            return String.format(ResManager.loadKDString((String)"%1$s %2$s\uff08%3$s\uff09 - %4$s %5$s", (String)"IntvMailHelper_40", (String)"tsc-tsirm-business", (Object[])new Object[0]), strDate, strStartTime, IntvDateUtil.weekDayCh((int)value), strEndDate, strEndTime);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09 %3$s-%4$s", (String)"IntvMailHelper_41", (String)"tsc-tsirm-business", (Object[])new Object[0]), strDate, IntvDateUtil.weekDayCh((int)value), strStartTime, strEndTime);
    }

    public static void setVariableInfoByPosition(Map<String, Object> variableInfo, DynamicObject position) {
        String name = position.getString("name");
        variableInfo.put("interviewpositionname", name);
        Object recruscene = position.get("recruscene");
        if (recruscene instanceof Long) {
            variableInfo.put("recruscene", position.getLong("recruscene"));
        } else if (recruscene instanceof DynamicObject) {
            variableInfo.put("recruscene", position.getDynamicObject("recruscene").getLong("id"));
        }
        Object adminorgObj = position.get("adminorg");
        if (adminorgObj instanceof Long) {
            Map<String, String> adminOrgInfo = IntvVariableInfoHelper.getAdminOrgInfo((Long)adminorgObj);
            variableInfo.put("companyname", adminOrgInfo.get("companyname"));
        }
        if (adminorgObj instanceof DynamicObject) {
            DynamicObject adminorg = position.getDynamicObject("adminorg");
            Map<String, String> adminOrgInfo = IntvVariableInfoHelper.getAdminOrgInfo(adminorg.getLong("id"));
            variableInfo.put("companyname", adminOrgInfo.get("companyname"));
        }
        variableInfo.put("adminorgsdpt", IntvVariableInfoHelper.getUseDeptOrgName(position));
    }

    public static String getUseDeptOrgName(DynamicObject position) {
        DynamicObjectCollection adminOrgCollection = position.getDynamicObjectCollection("adminorgsdpt");
        StringBuilder adminOrgNameBuilder = new StringBuilder();
        Optional.ofNullable(adminOrgCollection).filter(collection -> !collection.isEmpty()).ifPresent(adminOrgCol -> adminOrgCol.forEach(adminOrg -> {
            DynamicObject baseData = adminOrg.getDynamicObject("fbasedataid");
            Optional.ofNullable(baseData).ifPresent(data -> adminOrgNameBuilder.append(data.getString("name")).append(";"));
        }));
        String adminOrgNameStr = adminOrgNameBuilder.toString();
        StringBuilder stringBuilder = new StringBuilder();
        Optional.of(adminOrgNameStr).filter(HRStringUtils::isNotEmpty).ifPresent(adminNameStr -> stringBuilder.append(adminOrgNameStr, 0, adminOrgNameStr.lastIndexOf(";")));
        return stringBuilder.toString();
    }

    public static Map<String, String> getAdminOrgInfo(Long adminOrg) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            map.put("companyname", "");
            return map;
        }
        String name = IntvVariableInfoHelper.getCompanyName(adminOrg);
        map.put("companyname", name);
        return map;
    }

    public static String getCompanyName(Long id) {
        DynamicObject companyFromOrgId = IntvVariableInfoHelper.getCompanyFromOrgId(id);
        if (HRObjectUtils.isEmpty((Object)companyFromOrgId)) {
            companyFromOrgId = IntvMailHelper.SERVICE_HELPER.queryOne(QFilter.of((String)"parent.id = 0", (Object[])new Object[0]).toArray());
        }
        String deptName = null;
        if (HRObjectUtils.isEmpty((Object)companyFromOrgId)) {
            deptName = "";
        }
        if (companyFromOrgId != null && HRStringUtils.isNotEmpty((String)companyFromOrgId.getString("name"))) {
            deptName = companyFromOrgId.getString("name");
        }
        return deptName;
    }

    @CheckForNull
    public static DynamicObject getCompanyFromOrgId(Long orgId) {
        DynamicObject parentOrgByOrgId = IntvVariableInfoHelper.getParentOrgByOrgId(orgId);
        if (HRObjectUtils.isEmpty((Object)parentOrgByOrgId)) {
            return null;
        }
        DynamicObject adminOrgType = parentOrgByOrgId.getDynamicObject("orgtype");
        if (HRObjectUtils.isEmpty((Object)adminOrgType)) {
            return null;
        }
        String number = adminOrgType.getString("number");
        if (HRStringUtils.isNotEmpty((String)number) && ("1010_S".equals(number) || "1020_S".equals(number))) {
            return parentOrgByOrgId;
        }
        long parentOrgId = parentOrgByOrgId.getLong("parent.id");
        if (parentOrgId == orgId) {
            return null;
        }
        return IntvVariableInfoHelper.getCompanyFromOrgId(parentOrgId);
    }

    private static DynamicObject getParentOrgByOrgId(Long orgId) {
        return IntvMailHelper.SERVICE_HELPER.queryOne("orgtype,parent.id", (Object)orgId);
    }

    public static String getReplyUrl(String phone, String appfileTaskId) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        param.put("userId", "Guest");
        param.put("phone", EncryptionDecryptUtil.getEncryptStr((Object)phone));
        param.put("appfileTaskId", appfileTaskId);
        return IntvMailUtils.getFormDetailUrl((String)"tsirm_answer", (Map)param);
    }

    public static String getFormParam(Long argIntvId, Long key, String interviewTaskId, String pageKey) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        param.put("argintvid", String.valueOf(argIntvId));
        String md5Str = EncryptionDecryptUtil.getEncryptStr((Object)key);
        param.put("interviewerIdSecretStr", md5Str);
        param.put("taskids", interviewTaskId);
        return IntvMailUtils.getListUrl((String)pageKey, (Map)param);
    }
}

