/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.intvsignin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.tsc.tsirm.business.domain.intv.service.intvsignin.IntvMethodHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvsignin.SignInEntity;
import kd.tsc.tsirm.business.domain.intv.service.oprecord.IntvOpRecordService;
import kd.tsc.tsirm.common.util.IntvDateUtil;

public class SignInStatusHelper {
    public static final String SIGNINSTATUS_SIGNINTIME = "argintv,round,intvgroup,signinstatus,signintime,application";
    public static final String SIGNINTIME = "signintime";
    private static HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_appfiletask");

    public static String getVideoInterview() {
        return ResManager.loadKDString((String)"\u89c6\u9891\u9762\u8bd5", (String)"SignInStatusHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
    }

    public static String getCurrentInterview() {
        return ResManager.loadKDString((String)"\u73b0\u573a\u9762\u8bd5", (String)"SignInStatusHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
    }

    public static String getPhoneInterview() {
        return ResManager.loadKDString((String)"\u7535\u8bdd\u9762\u8bd5", (String)"SignInStatusHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]);
    }

    public void updateSignInStatus(Long appfile, int candidateFlag) {
        Object appfileTask;
        QFilter filter = new QFilter("application", "=", (Object)appfile);
        Object[] query = hrBaseServiceHelper.query(SIGNINSTATUS_SIGNINTIME, filter.toArray());
        if (!HRArrayUtils.isEmpty((Object[])query) && !"B".equals((appfileTask = query[candidateFlag]).getString("signinstatus"))) {
            appfileTask.set("signinstatus", (Object)"B");
            appfileTask.set(SIGNINTIME, (Object)new Date());
            SaveServiceHelper.update((DynamicObject[])query);
            String interviewTitle = appfileTask.getDynamicObject("argintv").getString("interviewtitle");
            String applicationName = appfileTask.getDynamicObject("application").getString("name");
            DynamicObject interviewarranger = appfileTask.getDynamicObject("argintv").getDynamicObject("interviewarranger");
            DynamicObject group = appfileTask.getDynamicObject("intvgroup");
            String interviewlocation = group.getString("interviewlocation");
            String interviewroom = group.getString("interviewroom");
            Date intvdate = group.getDate("intvdate");
            long startInterviewTime = group.getLong("intvstarttime");
            DynamicObjectCollection intvers = group.getDynamicObjectCollection("intver");
            SignInEntity signInEntity = new SignInEntity(HRInteDateTimeUtil.formatDate((String)"tsirm_appfiletask", (String)"intvtime", (Date)IntvDateUtil.getIntvDateTime((Date)intvdate, (Long)startInterviewTime)), interviewarranger, applicationName);
            this.sendIntverMessage(intvers, signInEntity, appfile);
            this.sendHrMessage(intvers, signInEntity, appfile);
            IntvOpRecordService.getInstance().signInOR(appfileTask.getDynamicObject("application"), interviewTitle, ResManager.loadKDString((String)"\u5df2\u7b7e\u5230", (String)"SignInStatusHelper_5", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
    }

    private Long sendIntverMessage(DynamicObjectCollection intvers, SignInEntity signInEntity, Long appfile) {
        MessageInfo message = new MessageInfo();
        message.setType("notice");
        String intvTitle = new IntvMethodHelper().getInterviewtitle(appfile);
        message.setTitle(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u5019\u9009\u4eba\u5df2\u5230\u573a", (String)"SignInStatusHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0]), intvTitle));
        List receivers = intvers.stream().mapToLong(intver -> intver.getLong("fbasedataid_id")).boxed().collect(Collectors.toList());
        message.setUserIds(receivers);
        message.setSenderId(Long.valueOf(0L));
        message.setTag(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u5019\u9009\u4eba\u5df2\u5230\u573a", (String)"SignInStatusHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0]), intvTitle));
        String addressStr = "";
        String intvMethod = new IntvMethodHelper().getIntvMethod(appfile);
        addressStr = this.getAddress(appfile, addressStr, intvMethod);
        message.setContent(String.format(ResManager.loadKDString((String)"%s \u5df2\u7b7e\u5230\uff0c\u8bf7\u4e8e %s \u524d\uff0c%s", (String)"SignInStatusHelper_7", (String)"tsc-tsirm-business", (Object[])new Object[0]), signInEntity.getApplicationName(), signInEntity.getIntvDate(), addressStr));
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public String getAddress(Long appfile, String addressStr, String intvMethod) {
        if (SignInStatusHelper.getVideoInterview().equals(intvMethod)) {
            addressStr = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u524d\u5f80 %s \u63d0\u524d\u51c6\u5907\u9762\u8bd5", (String)"SignInStatusHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0]), new IntvMethodHelper().getIntvervedioaddress(appfile));
        } else if (SignInStatusHelper.getCurrentInterview().equals(intvMethod)) {
            addressStr = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u524d\u5f80 %s \u63d0\u524d\u51c6\u5907\u9762\u8bd5", (String)"SignInStatusHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0]), new IntvMethodHelper().getAddress(appfile));
        } else if (SignInStatusHelper.getPhoneInterview().equals(intvMethod)) {
            addressStr = ResManager.loadKDString((String)"\u63d0\u524d\u51c6\u5907\u9762\u8bd5", (String)"SignInStatusHelper_4", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        return addressStr;
    }

    private Long sendHrMessage(DynamicObjectCollection intvers, SignInEntity signInEntity, Long appfile) {
        MessageInfo message = new MessageInfo();
        message.setType("notice");
        String intvTitle = new IntvMethodHelper().getInterviewtitle(appfile);
        message.setTitle(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u5019\u9009\u4eba\u5df2\u5230\u573a", (String)"SignInStatusHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0]), intvTitle));
        ArrayList receivers = Lists.newArrayList();
        receivers.add(signInEntity.getInterviewarranger().getLong("id"));
        message.setUserIds((List)receivers);
        message.setSenderId(Long.valueOf(0L));
        message.setTag(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u5019\u9009\u4eba\u5df2\u5230\u573a", (String)"SignInStatusHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0]), intvTitle));
        StringBuilder sb = new StringBuilder();
        for (DynamicObject intver : intvers) {
            sb.append(intver.getDynamicObject("fbasedataid").getString("name")).append(",");
        }
        String addressStr = "";
        String intvMethod = new IntvMethodHelper().getIntvMethod(appfile);
        addressStr = this.getAddress(appfile, addressStr, intvMethod);
        message.setContent(String.format(ResManager.loadKDString((String)"%s \u5df2\u7b7e\u5230\uff0c\u8bf7\u63d0\u524d\u4e0e %s \u6c9f\u901a\uff0c\u4e8e %s \u524d\uff0c%s", (String)"SignInStatusHelper_8", (String)"tsc-tsirm-business", (Object[])new Object[0]), signInEntity.getApplicationName(), sb.deleteCharAt(sb.length() - 1), signInEntity.getIntvDate(), addressStr));
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }
}

