/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.jurisdiction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.AppFileTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;

public class IntvJurisdictionService {
    public static IntvJurisdictionService getInstance() {
        return Instance.INTV_JURISDICTION;
    }

    private IntvJurisdictionService() {
    }

    public Boolean isHasIntvJur(Long primaryKey, String type) {
        QFilter qFilter = new QFilter("id", "=", (Object)primaryKey);
        Long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (superUser) {
            return true;
        }
        ArrayList hasJurIds = Lists.newArrayListWithExpectedSize((int)16);
        Long arrId = null;
        if (type.equals("argintv")) {
            DynamicObject intvArg = ArgIntvHelper.getInstance().getArgIntv(qFilter);
            arrId = intvArg.getDynamicObject("interviewarranger").getLong("id");
            hasJurIds.addAll(this.getHasIntvArgJurIds());
        }
        if (type.equals("appfiletask")) {
            DynamicObject appFileTask = AppFileTaskHelper.getInstance().getAppFileTask(qFilter);
            arrId = appFileTask.getDynamicObject("argintv").getDynamicObject("interviewarranger").getLong("id");
            hasJurIds.addAll(this.getHasAppFileTaskJurIds());
        }
        if (null == arrId) {
            return false;
        }
        return currUserId.equals(arrId) || hasJurIds.contains(primaryKey);
    }

    public List<Long> getHasIntvArgJurIds() {
        List<Long> hashPermPositionIds = PositionDataHelper.getHashPermPositionIds();
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles("id", new QFilter("position.id", "in", hashPermPositionIds).toArray());
        List appFileIds = Arrays.stream(appFiles).map(dys -> dys.getLong("id")).collect(Collectors.toList());
        DynamicObject[] argIntvs = ArgIntvHelper.getInstance().getArgIntvs("id", new QFilter("intvcandate.fbasedataid.id", "in", appFileIds).toArray());
        return Arrays.stream(argIntvs).map(dys -> dys.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getHasAppFileJurIds() {
        List<Long> hashPermPositionIds = PositionDataHelper.getHashPermPositionIds();
        DataSet dataSet = AppFileHelper.queryAppFilesId("id", new QFilter("position.id", "in", hashPermPositionIds).toArray());
        ArrayList<Long> appfileIdList = new ArrayList<Long>(100);
        for (Row row : dataSet) {
            appfileIdList.add(row.getLong("id"));
        }
        return appfileIdList;
    }

    public List<Long> getHasAppFileTaskJurIds() {
        List<Long> hashPermPositionIds = PositionDataHelper.getHashPermPositionIds();
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles("id", new QFilter("position.id", "in", hashPermPositionIds).toArray());
        List appFileIds = Arrays.stream(appFiles).map(dys -> dys.getLong("id")).collect(Collectors.toList());
        DynamicObject[] appFileTasks = AppFileTaskHelper.getInstance().getAppFileTasks("id", new QFilter("application", "in", appFileIds).toArray());
        return Arrays.stream(appFileTasks).map(dys -> dys.getLong("id")).collect(Collectors.toList());
    }

    public static class Instance {
        private static final IntvJurisdictionService INTV_JURISDICTION = new IntvJurisdictionService();
    }
}

