/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.oprecord;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.tsc.tsirm.business.domain.intv.service.oprecord.IntvORBasicService;
import kd.tsc.tsirm.common.constants.oprecord.ORStructText;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.EvalResultEnum;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class IntvOpRecordService {
    private final IntvORBasicService intvORBasicService = IntvORBasicService.getInstance();

    public static IntvOpRecordService getInstance() {
        return Instance.INTV_OP_RECORD_SERVICE;
    }

    private IntvOpRecordService() {
    }

    public void intvCommonOR(List<DynamicObject> candates, OpDefEnum opDefEnum, ORStructText orStructText, String title) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject candate : candates) {
            String candateName = candate.getString("name");
            String opText = this.intvORBasicService.getORStructText(orStructText, RequestContext.get().getUserName(), candateName, title);
            modelList.add(this.intvORBasicService.getOpRecordModel(RequestContext.get().getUserName(), candate, opDefEnum, opText));
        }
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void cancelIntvOR(List<DynamicObject> appFileTaskList, OpDefEnum opDefEnum, ORStructText orStructText) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : appFileTaskList) {
            DynamicObject application = dynamicObject.getDynamicObject("application");
            String candateName = application.getString("name");
            String interviewtitle = dynamicObject.getDynamicObject("argintv").getString("interviewtitle");
            String opText = this.intvORBasicService.getORStructText(orStructText, RequestContext.get().getUserName(), candateName, interviewtitle);
            modelList.add(this.intvORBasicService.getOpRecordModel(RequestContext.get().getUserName(), application, opDefEnum, opText));
        }
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public OprecordMessageModel getHastenReplyOM(DynamicObject appFile, String title) {
        String candateName = appFile.getString("name");
        String opText = this.intvORBasicService.getORStructText(ORStructText.HASTEN_REPLY_INTV, RequestContext.get().getUserName(), candateName, title);
        return this.intvORBasicService.getOpRecordModel(RequestContext.get().getUserName(), appFile, OpDefEnum.TSIRM_HASTEN_REPLY_INTV, opText);
    }

    public void signInOR(DynamicObject dynamicObject, String title, String status) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String opText = this.intvORBasicService.getORStructText(ORStructText.SIGN_IN_INTV, dynamicObject.getString("name"), title, status);
        modelList.add(this.intvORBasicService.getOpRecordModel(dynamicObject.getString("name"), dynamicObject, OpDefEnum.TSIRM_SIGN_IN_INTV, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void modifyCommonOR(DynamicObject dynamicObject, String status, OpDefEnum opDefEnum, ORStructText orStructText, String title) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String candateName = dynamicObject.getString("name");
        String opText = this.intvORBasicService.getORStructText(orStructText, RequestContext.get().getUserName(), candateName, title, status);
        modelList.add(this.intvORBasicService.getOpRecordModel(RequestContext.get().getUserName(), dynamicObject, opDefEnum, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void autoPathOR(DynamicObject dynamicObject, String status, String title) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String candateName = dynamicObject.getString("name");
        String opText = this.intvORBasicService.getORStructText(ORStructText.GENERAL_EVA_INTV_AUTO, candateName, title, status);
        modelList.add(this.intvORBasicService.getOpRecordModel(ResManager.loadKDString((String)"\u7cfb\u7edf", (String)"IntvOpRecordService_1", (String)"tsc-tsirm-business", (Object[])new Object[0]), dynamicObject, OpDefEnum.TSIRM_GENERAL_EVA_INTV, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void replyAcceptOR(DynamicObject dynamicObject, String title) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String candateName = dynamicObject.getString("name");
        String opText = this.intvORBasicService.getORStructText(ORStructText.REPLY_INTV, candateName, title, ResManager.loadKDString((String)"\u53c2\u52a0", (String)"IntvOpRecordService_2", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        modelList.add(this.intvORBasicService.getOpRecordModel(candateName, dynamicObject, OpDefEnum.TSIRM_REPLY_INTV, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void replyRefuseOR(DynamicObject dynamicObject, DynamicObjectCollection refusereson, String refusalcause, String title, IFormView view) {
        String reasons;
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String candateName = dynamicObject.getString("name");
        StringBuilder stringBuilder = new StringBuilder();
        if (null == refusalcause || refusalcause.length() == 0) {
            for (DynamicObject rdy : refusereson) {
                DynamicObject reasonObj = rdy.getDynamicObject("fbasedataid");
                if (Objects.isNull(reasonObj)) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5", (String)"IntvOpRecordService_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                String reason = reasonObj.getString("description");
                stringBuilder.append(reason);
                stringBuilder.append("\uff1b");
            }
            reasons = stringBuilder.substring(0, stringBuilder.toString().length() - 1);
        } else {
            for (DynamicObject rdy : refusereson) {
                DynamicObject reasonObj = rdy.getDynamicObject("fbasedataid");
                if (Objects.isNull(reasonObj)) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"IntvOpRecordService_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                String reason = reasonObj.getString("description");
                if (ResManager.loadKDString((String)"\u5176\u4ed6\u539f\u56e0\u4e0d\u80fd\u53c2\u52a0", (String)"IntvOpRecordService_3", (String)"tsc-tsirm-business", (Object[])new Object[0]).equals(reason)) continue;
                stringBuilder.append(reason);
                stringBuilder.append("\uff1b");
            }
            stringBuilder.append(ResManager.loadKDString((String)"\u5176\u4ed6\u539f\u56e0\u4e0d\u80fd\u53c2\u52a0", (String)"IntvOpRecordService_3", (String)"tsc-tsirm-business", (Object[])new Object[0])).append("\uff0c");
            stringBuilder.append(refusalcause);
            reasons = stringBuilder.toString();
        }
        String opText = this.intvORBasicService.getORStructText(ORStructText.REPLY_INTV_OTHER, candateName, title, ResManager.loadKDString((String)"\u4e0d\u53c2\u52a0", (String)"IntvOpRecordService_4", (String)"tsc-tsirm-business", (Object[])new Object[0]), reasons);
        modelList.add(this.intvORBasicService.getOpRecordModel(candateName, dynamicObject, OpDefEnum.TSIRM_REPLY_INTV, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void intvOp(List<DynamicObject> objectList) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)objectList.size());
        objectList.forEach(intvevl -> {
            DynamicObject affFile = intvevl.getDynamicObject("application");
            String appFileName = affFile.getString("name");
            String evaluator = TSCRequestContext.getUserName();
            String interviewerName = intvevl.getDynamicObject("interviewer").getString("name");
            String intvRsl = EvalResultEnum.valuesOf((String)intvevl.getString("intvevlrslt"));
            String intvTitle = intvevl.getDynamicObject("argintv").getString("interviewtitle");
            long interviewerID = intvevl.getDynamicObject("interviewer").getLong("id");
            String opText = "";
            opText = TSCRequestContext.getUserId() == interviewerID ? this.intvORBasicService.getORStructText(ORStructText.EVALUATE_INTV, interviewerName, appFileName, intvTitle, intvRsl) : this.intvORBasicService.getORStructText(ORStructText.ALTERNATIVE_EVA_INTV, evaluator, interviewerName, appFileName, intvTitle, intvRsl);
            modelList.add(this.intvORBasicService.getOpRecordModel(evaluator, affFile, OpDefEnum.TSIRM_EVALUATE_INTV, opText));
        });
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    private static class Instance {
        private static final IntvOpRecordService INTV_OP_RECORD_SERVICE = new IntvOpRecordService();

        private Instance() {
        }
    }
}

