/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFParticipantEntity;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsrbd.business.domain.config.service.ConfigSysCfgParamHelper;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFAuditInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFProcessInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFUserInfo;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowImpl;

public class ArgIntvFreeFlowTask {
    private static final Log logger = LogFactory.getLog(ArgIntvFreeFlowTask.class);
    private static final String AGENTEVALUATE = "agentEvaluate";
    private static final String EVALUATE = "evaluate";

    public static void completeTask(String businessKey, Long interviewerId, String evlContent, String status) {
        if (!"A".equals(status) && !"B".equals(status)) {
            return;
        }
        DynamicObject intvTask = TsrbsHelper.selectById(Long.valueOf(businessKey), "tsirm_intvtask");
        if ("A".equals(Objects.requireNonNull(intvTask).getString("taskstatus"))) {
            return;
        }
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)interviewerId);
        String decOptionNumber = "A".equals(status) ? EVALUATE : AGENTEVALUATE;
        long currentUserId = UserServiceHelper.getCurrentUserId();
        try {
            WorkflowServiceHelper.completeTask((Long)taskId, (Long)currentUserId, (String)decOptionNumber, (String)evlContent);
        }
        catch (Exception e) {
            logger.error("intv complete task failed businessKey {}", (Object)businessKey, (Object)e);
        }
    }

    public static void abandon(DynamicObject[] tasks) {
        if (HRArrayUtils.isEmpty((Object[])tasks)) {
            return;
        }
        for (DynamicObject task : tasks) {
            ArgIntvFreeFlowTask.abandon(task.getString("id"));
        }
    }

    public static void abandon(DynamicObjectCollection tasks) {
        if (tasks.size() == 0) {
            return;
        }
        for (DynamicObject task : tasks) {
            ArgIntvFreeFlowTask.abandon(task.getString("id"));
        }
    }

    public static void abandon(String businessKey) {
        try {
            WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
        }
        catch (Exception e) {
            logger.error("intv  task abandon failed businessKey {}", (Object)businessKey, (Object)e);
        }
    }

    public static void buildFreeFlowTask(DynamicObject arrangerIntv) {
        Long argIntvId = arrangerIntv.getLong("id");
        Object[] tasks = ArgIntvHelper.findIntvTaskByArgIntvId(argIntvId);
        DynamicObject[] allDisTasks = ArgIntvHelper.findAllDisIntvTaskByArgIntvId(argIntvId);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.addAll((Collection)Arrays.stream(allDisTasks).collect(Collectors.toList()));
        ArgIntvFreeFlowTask.abandon(collection);
        if (HRArrayUtils.isEmpty((Object[])tasks)) {
            return;
        }
        try {
            for (Object task : tasks) {
                ArgIntvFreeFlowTask.doBuildFreeFlowTask((DynamicObject)task, arrangerIntv);
            }
        }
        catch (Exception ex) {
            logger.error("build free flow exception argIntvId: {}", (Object)argIntvId, (Object)ex);
        }
    }

    public static void doBuildFreeFlowTask(DynamicObject task, DynamicObject arrangerIntv) {
        ArgIntvFreeFlowTask.doBuildFreeFlowTask(task, arrangerIntv, "");
    }

    public static void doBuildFreeFlowTask(DynamicObject task, DynamicObject arrangerIntv, String wayType) {
        DynamicObject interviewer = task.getDynamicObject("interviewer");
        DynamicObject arrgIntvUser = arrangerIntv.getDynamicObject("interviewarranger");
        ArgIntvFreeFlowTask.doBuildFreeFlowOneTask(task, interviewer, arrgIntvUser, wayType);
    }

    public static void doBuildFreeFlowOneTask(DynamicObject task, DynamicObject interviewer, DynamicObject arrgIntvUser, String wayType) {
        WFProcess wfProcess = ArgIntvFreeFlowTask.createWFProcess(task.getString("number"), task.getString("id"), task.getString("name"));
        String arrgName = arrgIntvUser.getString("name");
        arrgName = HRStringUtils.isBlank((CharSequence)arrgName) ? "" : arrgIntvUser.getString("name");
        arrgName = ArgIntvFreeFlowTask.nameSubString(arrgName);
        String userTaskInfo = ResManager.loadKDString((String)"{0}\u5b89\u6392\u4e86\u4e00\u4e2a\u9762\u8bd5\u4efb\u52a1", (String)"ArgIntvFreeFlowTask_0", (String)"tsc-tsirm-business", (Object[])new Object[]{arrgName});
        WFUserTask wfUserTask = ArgIntvFreeFlowTask.createWFUserTask(wfProcess, new LocaleString(userTaskInfo), arrgIntvUser.getString("id"), "tsirm_intvmestips");
        if (!HRStringUtils.equals((String)"transfer", (String)wayType)) {
            wfUserTask.getExtProps().put("hidetaskincenter", Boolean.TRUE);
        }
        String interviewerName = HRStringUtils.isBlank((CharSequence)interviewer.getString("name")) ? "" : interviewer.getString("name");
        interviewerName = ArgIntvFreeFlowTask.nameSubString(interviewerName);
        String auditTaskInfo = ResManager.loadKDString((String)"{0}\u7684\u9762\u8bd5\u4efb\u52a1\u5f85\u8bc4\u4ef7", (String)"ArgIntvFreeFlowTask_1", (String)"tsc-tsirm-business", (Object[])new Object[]{interviewerName});
        ArgIntvFreeFlowTask.createWFAuditTask(wfProcess, wfUserTask, new LocaleString(auditTaskInfo), interviewer.getString("id"), "tsirm_interveranswer");
        WorkflowServiceHelper.createProcessAndStart((String)String.valueOf(task.getPkValue()), (String)"submit", (String)"tsirm_intvtask", new HashMap(), (WFProcess)wfProcess);
    }

    private static String nameSubString(String name) {
        return name.length() > 30 ? name.substring(0, 30) + "..." : name;
    }

    private static WFProcess createWFProcess(String number, String billId, String name) {
        WFProcessInfo wfProcessInfo = WFProcessInfo.init().setEntraBill(number).setEntraBillId(billId).setEntraBillName(name);
        return FreeFlowImpl.freeFlowImpl.initProcess(wfProcessInfo);
    }

    private static WFUserTask createWFUserTask(WFProcess wfProcess, LocaleString nodeName, String argIntverId, String jumpPageKey) {
        WFUserInfo wfUserInfo = WFUserInfo.init().setName(nodeName).setParticipant(ArgIntvFreeFlowTask.getParticipant(argIntverId));
        WFUserTask wfUserTask = FreeFlowImpl.freeFlowImpl.initWFUserTask(wfProcess, wfUserInfo);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("processingPage", jumpPageKey);
        String check = (String)ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)"taskradiogroup");
        if (!HRStringUtils.isEmpty((String)check)) {
            map.put("endType", check);
        }
        wfUserTask.setExtProps(map);
        wfProcess.addNextNode((WFFlowNode)wfUserTask);
        return wfUserTask;
    }

    private static void createWFAuditTask(WFProcess wfProcess, WFUserTask wfUserTask, LocaleString nodeName, String interviewerId, String jumpPageKey) {
        WFAuditInfo wfAuditInfo = WFAuditInfo.init().setName(nodeName).setParticipant(ArgIntvFreeFlowTask.getParticipant(interviewerId)).setDecisionOptions(ArgIntvFreeFlowTask.initWFDecisionOptions());
        WFAuditTask wfAuditTask = FreeFlowImpl.freeFlowImpl.initWFAuditTask(wfProcess, wfAuditInfo);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("processingPage", jumpPageKey);
        String check = (String)ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)"taskradiogroup");
        if (!HRStringUtils.isEmpty((String)check)) {
            map.put("endType", check);
        }
        HashMap<String, Object> batchApproveMap = new HashMap<String, Object>();
        batchApproveMap.put("batchApprove", Boolean.FALSE);
        batchApproveMap.put("batchApproveDec", "Consent");
        map.put("batchApprove", batchApproveMap);
        wfAuditTask.setExtProps(map);
        wfUserTask.addNextNode((WFFlowNode)wfAuditTask);
    }

    private static List<WFParticipantEntity> getParticipant(String pkValue) {
        ArrayList<WFParticipantEntity> wfParticipantEntities = new ArrayList<WFParticipantEntity>();
        wfParticipantEntities.add(ArgIntvFreeFlowTask.doGetPersonParticipant(pkValue));
        return wfParticipantEntities;
    }

    private static WFParticipantEntity doGetPersonParticipant(String pkValue) {
        WFParticipantEntity participantEntity = new WFParticipantEntity();
        participantEntity.setType("person");
        participantEntity.setValue(pkValue);
        return participantEntity;
    }

    private static List<WFDecisionOption> initWFDecisionOptions() {
        ArrayList<WFDecisionOption> decisionOptions = new ArrayList<WFDecisionOption>();
        WFDecisionOption evlDecisionOption = new WFDecisionOption();
        evlDecisionOption.setAuditType("approve");
        evlDecisionOption.setDefaultDecision(true);
        evlDecisionOption.setNumber(EVALUATE);
        String evl = ResManager.loadKDString((String)"\u8bc4\u4ef7", (String)"ArgIntvFreeFlowTask_2", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        evlDecisionOption.setName(new LocaleString(evl));
        decisionOptions.add(evlDecisionOption);
        WFDecisionOption agentEvlDecisionOption = new WFDecisionOption();
        agentEvlDecisionOption.setAuditType("approve");
        agentEvlDecisionOption.setDefaultDecision(true);
        agentEvlDecisionOption.setNumber(AGENTEVALUATE);
        String agentEvl = ResManager.loadKDString((String)"\u4ee3\u8bc4\u4ef7", (String)"ArgIntvFreeFlowTask_3", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        agentEvlDecisionOption.setName(new LocaleString(agentEvl));
        decisionOptions.add(agentEvlDecisionOption);
        return decisionOptions;
    }
}

