/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.urge;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailUrgedHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvVariableInfoHelper;
import kd.tsc.tsirm.business.domain.intv.service.oprecord.IntvORBasicService;
import kd.tsc.tsirm.business.domain.intv.service.oprecord.IntvOpRecordService;
import kd.tsc.tsirm.business.domain.intv.service.urge.IntvUrgeAppAnswerEntity;
import kd.tsc.tsirm.business.domain.intv.service.urge.IntvUrgeIntvevlEntity;
import kd.tsc.tsirm.business.domain.intv.service.urge.IntvUrgeResultEntity;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbd.business.domain.workaddress.service.HbssAddressDetailDataHelper;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IntvUrgeHelper {
    private static final Log LOG = LogFactory.getLog(IntvUrgeHelper.class);

    public static IntvUrgeResultEntity urgeIntvevl(List<Long> appfileTaskIds, DynamicObject intvtask) {
        IntvUrgeResultEntity urgRes = new IntvUrgeResultEntity();
        ArrayList<Long> urgeAppfileTaskIds = new ArrayList<Long>();
        ArrayList intvTaskIdList = Lists.newArrayListWithExpectedSize((int)0);
        urgRes = IntvUrgeHelper.checkUrgeNum(appfileTaskIds, 100);
        if (!urgRes.isUtgeCheckRes()) {
            return urgRes;
        }
        String properties = "application.name,intvevlstatus,taskstatus,intvgroup.intvdate,intvgroup.intvstarttime";
        DynamicObject[] appfileTasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks(properties, appfileTaskIds);
        Map<Long, List<DynamicObject>> intvTaskMapList = IntvUrgeHelper.getIntvTaskList(appfileTaskIds);
        if (null == appfileTasks || appfileTasks.length == 0 || intvTaskMapList.isEmpty()) {
            urgRes.setUtgeCheckRes(false);
            urgRes.showMessages.add(ResManager.loadKDString((String)"\u5e94\u8058\u8005\u4efb\u52a1\u6216\u8005\u9762\u8bd5\u8bc4\u4ef7\u4e3a\u7a7a", (String)"IntvUrgeHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            return urgRes;
        }
        int notStart = 0;
        int alreadyUrge = 0;
        int alreadyProcess = 0;
        int errorAppFileTaskCount = 0;
        for (DynamicObject appfileTask : appfileTasks) {
            DynamicObject application = appfileTask.getDynamicObject("application");
            String applicationName = application.getString("name");
            if (StringUtils.isNotEmpty((CharSequence)appfileTask.getString("intvevlstatus")) || !"A".equals(appfileTask.getString("taskstatus"))) {
                ++alreadyProcess;
                ++errorAppFileTaskCount;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(ResManager.loadKDString((String)"\u50ac\u4fc3\u5931\u8d25\uff0c{0}\u9762\u8bd5\u5df2\u7ed3\u675f\u3002", (String)"IntvUrgeHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[]{applicationName}));
                continue;
            }
            if (IntvUrgeHelper.checkIntvTimeEqNow(appfileTask)) {
                ++notStart;
                ++errorAppFileTaskCount;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u7684\u9762\u8bd5\u5c1a\u672a\u5f00\u59cb\uff0c\u4e0d\u53ef\u50ac\u4fc3\u8bc4\u4ef7\u3002", (String)"IntvUrgeHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[]{applicationName}));
                continue;
            }
            int errorIntvTaskCount = 0;
            if (Objects.isNull(intvtask)) {
                List<DynamicObject> intvTaskList = intvTaskMapList.get(appfileTask.getLong("id"));
                List<Long> taskIdList = intvTaskList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                Map<Long, List<DynamicObject>> taskIdMapInTv = IntvUrgeHelper.checkEvlStatus(taskIdList);
                for (DynamicObject selIntvTask : intvTaskList) {
                    if (!IntvUrgeHelper.checkUrgeDayCount("urgeintvevltime", selIntvTask)) {
                        ++alreadyUrge;
                        ++errorIntvTaskCount;
                        urgRes.utgeCheckFailName.add(selIntvTask.getString("interviewer.name"));
                        urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u4eca\u5929\u5df2\u50ac\u4fc3\u8bc4\u4ef7\u3002", (String)"IntvUrgeHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[]{selIntvTask.getString("interviewer.name")}));
                        continue;
                    }
                    if (null != taskIdMapInTv && kd.bos.util.CollectionUtils.isNotEmpty((Collection)taskIdMapInTv.get(selIntvTask.getLong("id")))) {
                        ++alreadyProcess;
                        ++errorIntvTaskCount;
                        urgRes.utgeCheckFailName.add(selIntvTask.getString("interviewer.name"));
                        urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u5df2\u5904\u7406\u8bc4\u4ef7\u3002", (String)"IntvUrgeHelper_4", (String)"tsc-tsirm-business", (Object[])new Object[]{selIntvTask.getString("interviewer.name")}));
                        continue;
                    }
                    intvTaskIdList.add(selIntvTask.getLong("id"));
                    urgeAppfileTaskIds.add(appfileTask.getLong("id"));
                }
                if (errorIntvTaskCount != 0 && errorIntvTaskCount == intvTaskList.size()) {
                    ++errorAppFileTaskCount;
                }
            } else {
                if (!IntvUrgeHelper.checkUrgeDayCount("urgeintvevltime", intvtask)) {
                    ++alreadyUrge;
                    ++errorAppFileTaskCount;
                    urgRes.utgeCheckFailName.add(intvtask.getString("interviewer.name"));
                    urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u4eca\u5929\u5df2\u50ac\u4fc3\u8bc4\u4ef7\u3002", (String)"IntvUrgeHelper_5", (String)"tsc-tsirm-business", (Object[])new Object[]{intvtask.getString("interviewer.name")}));
                    continue;
                }
                if (!IntvUrgeHelper.checkEvlStatus(intvtask)) {
                    ++alreadyProcess;
                    ++errorAppFileTaskCount;
                    urgRes.utgeCheckFailName.add(intvtask.getString("interviewer.name"));
                    urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u5df2\u5904\u7406\u8bc4\u4ef7\u3002", (String)"IntvUrgeHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[]{intvtask.getString("interviewer.name")}));
                    continue;
                }
                intvTaskIdList.add(intvtask.getLong("id"));
                urgeAppfileTaskIds.add(appfileTask.getLong("id"));
            }
            urgRes.utgeCheckSuccessName.add(applicationName);
        }
        if (errorAppFileTaskCount == appfileTaskIds.size()) {
            urgRes.setUtgeCheckRes(false);
            urgRes.setShowTitileMessage(IntvUrgeHelper.setShowTitileMessage(notStart, alreadyUrge, alreadyProcess));
            return urgRes;
        }
        List<IntvUrgeIntvevlEntity> urgeIntvevlObj = IntvUrgeHelper.getUrgeInterviewerIds(intvTaskIdList);
        long start = System.currentTimeMillis();
        IntvUrgeHelper.sendUrgeIntvevlMaile(urgeIntvevlObj);
        IntvUrgeHelper.sendUrgeIntvevlSysMessage(urgeIntvevlObj);
        Date date = new Date();
        IntvUrgeHelper.updateUrgeTime("urgeintvevltime", urgeAppfileTaskIds, date);
        IntvUrgeHelper.updateIntvTaskUrgeTime(intvTaskIdList, date);
        LOG.info("IntvUrgeHelper  other operate cost  " + (System.currentTimeMillis() - start));
        return urgRes;
    }

    private static boolean checkEvlStatus(DynamicObject intvTask) {
        ArrayList<String> intvStatusList = new ArrayList<String>();
        intvStatusList.add("B");
        intvStatusList.add("C");
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("handlestatus", "=", (Object)"B").and("interviewstatus", "in", intvStatusList).and("intvtask", "=", (Object)intvTask.getLong("id"));
        return 0 == BaseHelper.count((QFilter[])filter.toArray(), (String)"tsirm_intvevl");
    }

    private static Map<Long, List<DynamicObject>> checkEvlStatus(List<Long> intvTaskIdList) {
        ArrayList<String> intvStatusList = new ArrayList<String>();
        intvStatusList.add("B");
        intvStatusList.add("C");
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("handlestatus", "=", (Object)"B").and("interviewstatus", "in", intvStatusList).and("intvtask", "in", intvTaskIdList);
        List<DynamicObject> intvEvlList = TsrbsHelper.selectByFilter("id,intvtask.id", filter.toArray(), "tsirm_intvevl");
        return intvEvlList.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("intvtask.id")));
    }

    public static void updateIntvTaskUrgeTime(List<Long> intvTaskIdList, Date date) {
        List intvTaskList = BaseHelper.selectByIdList(intvTaskIdList, (String)"tsirm_intvtasktpl");
        intvTaskList.forEach(intvTask -> intvTask.set("urgeintvevltime", (Object)date));
        BaseHelper.update((DynamicObject[])intvTaskList.toArray(new DynamicObject[0]), (String)"tsirm_intvtasktpl");
    }

    public static List<DynamicObject> getIntvTaskList(long appFileTaskId) {
        QFilter qFilter = new QFilter("appfiletask", "=", (Object)appFileTaskId).and("enable", "=", (Object)"1");
        List<DynamicObject> intvEvlList = TsrbsHelper.selectByFilter("intvtask.id,intvtask.enable,intvtask.urgeintvevltime", qFilter.toArray(), "tsirm_intvevl");
        return intvEvlList.stream().map(intvEvl -> intvEvl.getDynamicObject("intvtask")).filter(intvTask -> intvTask.getBoolean("enable")).distinct().collect(Collectors.toList());
    }

    public static Map<Long, List<DynamicObject>> getIntvTaskList(List<Long> appFileTaskIds) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        QFilter qFilter = new QFilter("appfiletask", "in", appFileTaskIds).and("enable", "=", (Object)"1");
        List<DynamicObject> intvEvlList = TsrbsHelper.selectByFilter("appfiletask.id,intvtask.id,intvtask.enable,intvtask.urgeintvevltime", qFilter.toArray(), "tsirm_intvevl");
        intvEvlList.forEach(intv -> {
            DynamicObject intvTask = intv.getDynamicObject("intvtask");
            if (null == intvTask) {
                return;
            }
            long appFileTaskId = intv.getLong("appfiletask.id");
            ArrayList<DynamicObject> intvTaskList = (ArrayList<DynamicObject>)result.get(appFileTaskId);
            if (kd.bos.util.CollectionUtils.isEmpty((Collection)intvTaskList)) {
                intvTaskList = new ArrayList<DynamicObject>();
            }
            if (intvTaskList.contains(intvTask)) {
                return;
            }
            intvTaskList.add(intvTask);
            result.put(appFileTaskId, intvTaskList);
        });
        return result;
    }

    private static String setShowTitileMessage(int notStart, int alreadyUrge, int alreadyProcess) {
        ArrayList<String> messageList = new ArrayList<String>();
        if (0 != notStart) {
            messageList.add(ResManager.loadKDString((String)"{0}\u4eba\u7684\u9762\u8bd5\u5c1a\u672a\u5f00\u59cb", (String)"IntvUrgeHelper_7", (String)"tsc-tsirm-business", (Object[])new Object[]{String.valueOf(notStart)}));
        }
        if (0 != alreadyUrge) {
            messageList.add(ResManager.loadKDString((String)"{0}\u4eba\u4eca\u5929\u5df2\u50ac\u4fc3\u8fc7\u9762\u8bd5\u5b98\u8bc4\u4ef7", (String)"IntvUrgeHelper_8", (String)"tsc-tsirm-business", (Object[])new Object[]{String.valueOf(alreadyUrge)}));
        }
        if (0 != alreadyProcess) {
            messageList.add(ResManager.loadKDString((String)"{0}\u4eba\u9762\u8bd5\u5b98\u5df2\u5904\u7406\u8bc4\u4ef7", (String)"IntvUrgeHelper_9", (String)"tsc-tsirm-business", (Object[])new Object[]{String.valueOf(alreadyProcess)}));
        }
        return Joiner.on((String)",").join(messageList);
    }

    public static void sendUrgeIntvevlMaile(List<IntvUrgeIntvevlEntity> intvUrgeIntvevls) {
        IntvMailUrgedHelper.getInstance().processInterviewEval(intvUrgeIntvevls);
    }

    public static void sendUrgeIntvevlSysMessage(List<IntvUrgeIntvevlEntity> intvUrgeIntvevls) {
        String tag = ResManager.loadKDString((String)"\u9762\u8bd5\u8bc4\u4ef7\u50ac\u4fc3", (String)"IntvAnswerEdit_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        List<IntvUrgeIntvevlEntity> convertMessageObjs = IntvUrgeHelper.convertMessageObj(intvUrgeIntvevls);
        for (IntvUrgeIntvevlEntity intvUrgeIntvevl : convertMessageObjs) {
            String content = ResManager.loadKDString((String)"\u60a8\u7684{0}\u9762\u8bd5\u5c1a\u672a\u8bc4\u4ef7\uff0c\u8bf7\u5173\u6ce8\u4efb\u52a1\u5217\u8868\uff0c\u53ca\u65f6\u5904\u7406", (String)"IntvUrgeHelper_10", (String)"tsc-tsrbs-formplugin", (Object[])new Object[]{intvUrgeIntvevl.getAppfileName()});
            IntvMailCommonHelper.getInstance().sendMessage(Lists.newArrayList((Object[])new Long[]{intvUrgeIntvevl.getInterViewerId()}), tag, content);
        }
    }

    public static List<IntvUrgeIntvevlEntity> convertMessageObj(List<IntvUrgeIntvevlEntity> intvUrgeIntvevls) {
        List<IntvUrgeIntvevlEntity> convertMessageObjs = new ArrayList<IntvUrgeIntvevlEntity>(10);
        for (IntvUrgeIntvevlEntity intvUrgeIntvevl : intvUrgeIntvevls) {
            Long interViewerId = intvUrgeIntvevl.getInterViewerId();
            boolean checkConvertMessageObjHaveOrNot = IntvUrgeHelper.checkConvertMessageObjHaveOrNot(interViewerId, convertMessageObjs);
            convertMessageObjs = IntvUrgeHelper.convertMessageObjs(checkConvertMessageObjHaveOrNot, intvUrgeIntvevl, convertMessageObjs);
        }
        return convertMessageObjs;
    }

    public static boolean checkConvertMessageObjHaveOrNot(Long interViewerId, List<IntvUrgeIntvevlEntity> convertMessageObjs) {
        boolean res = false;
        for (IntvUrgeIntvevlEntity convertMessageObj : convertMessageObjs) {
            if (!convertMessageObj.getInterViewerId().equals(interViewerId)) continue;
            res = true;
            break;
        }
        return res;
    }

    public static List<IntvUrgeIntvevlEntity> convertMessageObjs(boolean haveOrNot, IntvUrgeIntvevlEntity intvUrgeIntvevl, List<IntvUrgeIntvevlEntity> convertMessageObjs) {
        if (haveOrNot) {
            for (IntvUrgeIntvevlEntity convertMessageObj : convertMessageObjs) {
                if (!convertMessageObj.getInterViewerId().equals(intvUrgeIntvevl.getInterViewerId())) continue;
                String appfileName = convertMessageObj.getAppfileName() + "," + intvUrgeIntvevl.getAppfileName();
                convertMessageObj.setAppfileName(appfileName);
            }
        } else {
            convertMessageObjs.add(intvUrgeIntvevl);
        }
        return convertMessageObjs;
    }

    public static List<IntvUrgeIntvevlEntity> getUrgeInterviewerIds(DynamicObject appfileTask, DynamicObject intvTask) {
        ArrayList<IntvUrgeIntvevlEntity> intvUrgeIntvevls = new ArrayList<IntvUrgeIntvevlEntity>();
        DynamicObject application = appfileTask.getDynamicObject("application");
        Long applicationId = application.getLong("id");
        DynamicObject group = appfileTask.getDynamicObject("intvgroup");
        Long groupId = group.getLong("id");
        DynamicObject argIntv = appfileTask.getDynamicObject("argintv");
        Long argIntvId = argIntv.getLong("id");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filters = new QFilter("intvgroup", "=", (Object)groupId).and("application", "=", (Object)applicationId).and(enableFilter).and("handlestatus", "=", (Object)"A");
        if (Objects.nonNull(intvTask)) {
            filters.and("intvtask", "=", (Object)intvTask.getLong("id"));
        }
        String fields = String.join((CharSequence)",", "application", "interviewstatus", "handlestatus", "interviewer");
        DynamicObject[] intvevlInfos = IntvEvlHelper.getInstance().queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
        if (intvevlInfos.length > 0) {
            for (int i = 0; i < intvevlInfos.length; ++i) {
                IntvUrgeIntvevlEntity intvUrgeIntvevl = new IntvUrgeIntvevlEntity();
                intvUrgeIntvevl.setAppfileTaskId(appfileTask.getLong("id"));
                intvUrgeIntvevl.setAppfileId(applicationId);
                intvUrgeIntvevl.setAppfileName(application.getString("name"));
                intvUrgeIntvevl.setInterViewerId(intvevlInfos[i].getDynamicObject("interviewer").getLong("id"));
                intvUrgeIntvevl.setIntvevlId(intvevlInfos[i].getLong("id"));
                intvUrgeIntvevl.setArgIntvId(argIntvId);
                intvUrgeIntvevl.setGroupId(groupId);
                intvUrgeIntvevls.add(intvUrgeIntvevl);
            }
        }
        return intvUrgeIntvevls;
    }

    public static List<IntvUrgeIntvevlEntity> getUrgeInterviewerIds(List<Long> intvTaskIdList) {
        ArrayList<IntvUrgeIntvevlEntity> intvUrgeIntvevls = new ArrayList<IntvUrgeIntvevlEntity>();
        String fields = "appfiletask.id,application.id,application.name,interviewer.id,id,argintv.id,intvgroup.id";
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("handlestatus", "=", (Object)"A").and("intvtask", "in", intvTaskIdList);
        List intvEvlList = BaseHelper.selectByFilter((String)fields, (QFilter[])filter.toArray(), (String)"tsirm_intvevl");
        if (CollectionUtils.isNotEmpty((Collection)intvEvlList)) {
            intvEvlList.forEach(intvEvl -> {
                IntvUrgeIntvevlEntity intvUrgeIntvevl = new IntvUrgeIntvevlEntity();
                intvUrgeIntvevl.setAppfileTaskId(intvEvl.getLong("appfiletask.id"));
                intvUrgeIntvevl.setAppfileId(intvEvl.getLong("application.id"));
                intvUrgeIntvevl.setAppfileName(intvEvl.getString("application.name"));
                intvUrgeIntvevl.setInterViewerId(intvEvl.getDynamicObject("interviewer").getLong("id"));
                intvUrgeIntvevl.setIntvevlId(intvEvl.getLong("id"));
                intvUrgeIntvevl.setArgIntvId(intvEvl.getLong("argintv.id"));
                intvUrgeIntvevl.setGroupId(intvEvl.getLong("intvgroup.id"));
                intvUrgeIntvevls.add(intvUrgeIntvevl);
            });
        }
        return intvUrgeIntvevls;
    }

    public static IntvUrgeResultEntity urgeAppAnswer(List<Long> appfileTaskIds) {
        IntvUrgeResultEntity urgRes = new IntvUrgeResultEntity();
        ArrayList<IntvUrgeAppAnswerEntity> intvUrgeAppAnswers = new ArrayList<IntvUrgeAppAnswerEntity>();
        ArrayList<Long> urgeAppfileTaskIds = new ArrayList<Long>();
        urgRes = IntvUrgeHelper.checkUrgeNum(appfileTaskIds, 100);
        if (!urgRes.isUtgeCheckRes()) {
            return urgRes;
        }
        DynamicObject[] appfileTasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks(appfileTaskIds);
        DynamicObject[] appfilePoitions = IntvUrgeHelper.getAppfilePostions(appfileTasks);
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        int endIntv = 0;
        int alreadyApply = 0;
        int notProcessing = 0;
        int alreadyUrge = 0;
        for (int i = 0; i < appfileTasks.length; ++i) {
            DynamicObject appfileTask = appfileTasks[i];
            DynamicObject application = appfileTask.getDynamicObject("application");
            String applicationName = application.getString("name");
            if (!IntvUrgeHelper.checkIntvTimeEqNow(appfileTask)) {
                ++endIntv;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u7684\u9762\u8bd5\u5df2\u7ed3\u675f\uff0c\u4e0d\u53ef\u50ac\u4fc3\u3002", (String)"IntvUrgeHelper_11", (String)"tsc-tsirm-business", (Object[])new Object[]{applicationName}));
                continue;
            }
            if (!IntvUrgeHelper.checkAppAnswerState(appfileTask)) {
                ++alreadyApply;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u5df2\u7b54\u590d\u3002", (String)"IntvUrgeHelper_12", (String)"tsc-tsirm-business", (Object[])new Object[]{applicationName}));
                continue;
            }
            if (!IntvUrgeHelper.checkAppTaskState(appfileTask)) {
                ++notProcessing;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u9762\u8bd5\u8fdb\u5ea6\u4e0d\u5728\u8fdb\u884c\u4e2d\u3002", (String)"IntvUrgeHelper_13", (String)"tsc-tsirm-business", (Object[])new Object[]{applicationName}));
                continue;
            }
            if (!IntvUrgeHelper.checkUrgeDayCount("urgeanswertime", appfileTask)) {
                ++alreadyUrge;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(ResManager.loadKDString((String)"{0}\u4eca\u5929\u5df2\u50ac\u4fc3\u7b54\u590d\u3002", (String)"IntvUrgeHelper_14", (String)"tsc-tsirm-business", (Object[])new Object[]{applicationName}));
                continue;
            }
            urgRes.utgeCheckSuccessName.add(applicationName);
            intvUrgeAppAnswers.add(IntvUrgeHelper.getIntvUrgeAppAnswerObj(appfileTask, appfilePoitions));
            urgeAppfileTaskIds.add(appfileTask.getLong("id"));
            modelList.add(IntvOpRecordService.getInstance().getHastenReplyOM(application, appfileTask.getDynamicObject("argintv").getString("interviewtitle")));
        }
        if (urgRes.utgeCheckFailName.size() == appfileTaskIds.size()) {
            urgRes.setUtgeCheckRes(false);
            urgRes.setShowTitileMessage(IntvUrgeHelper.setShowTitileMessage(endIntv, alreadyApply, notProcessing, alreadyUrge));
            return urgRes;
        }
        IntvUrgeHelper.sendUrgeAppAnswerMaile(intvUrgeAppAnswers);
        Date date = new Date();
        IntvUrgeHelper.updateUrgeTime("urgeanswertime", urgeAppfileTaskIds, date);
        IntvORBasicService.getInstance().sendStdRsmOpRecord(modelList);
        return urgRes;
    }

    private static String setShowTitileMessage(int endIntv, int alreadyApply, int notProcessing, int alreadyUrge) {
        ArrayList<String> messageList = new ArrayList<String>();
        if (0 != endIntv) {
            messageList.add(ResManager.loadKDString((String)"{0}\u4eba\u9762\u8bd5\u5df2\u7ed3\u675f", (String)"IntvUrgeHelper_15", (String)"tsc-tsirm-business", (Object[])new Object[]{String.valueOf(endIntv)}));
        }
        if (0 != alreadyApply) {
            messageList.add(ResManager.loadKDString((String)"{0}\u4eba\u5df2\u7b54\u590d", (String)"IntvUrgeHelper_16", (String)"tsc-tsirm-business", (Object[])new Object[]{String.valueOf(alreadyApply)}));
        }
        if (0 != notProcessing) {
            messageList.add(ResManager.loadKDString((String)"{0}\u4eba\u9762\u8bd5\u8fdb\u5ea6\u4e0d\u5728\u8fdb\u884c\u4e2d", (String)"IntvUrgeHelper_17", (String)"tsc-tsirm-business", (Object[])new Object[]{String.valueOf(notProcessing)}));
        }
        if (0 != alreadyUrge) {
            messageList.add(ResManager.loadKDString((String)"{0}\u4eba\u4eca\u5929\u5df2\u50ac\u4fc3\u7b54\u590d", (String)"IntvUrgeHelper_18", (String)"tsc-tsirm-business", (Object[])new Object[]{String.valueOf(alreadyUrge)}));
        }
        return Joiner.on((String)",").join(messageList);
    }

    public static DynamicObject[] getAppfilePostions(DynamicObject[] appfileTasks) {
        DynamicObject[] appfilePostions = null;
        ArrayList<Long> positionIds = new ArrayList<Long>(appfileTasks.length);
        for (int i = 0; i < appfileTasks.length; ++i) {
            Long positionId = appfileTasks[i].getDynamicObject("application").getDynamicObject("position").getLong("id");
            positionIds.add(positionId);
        }
        appfilePostions = IntvAppfileTaskHelper.getInstance().getPositions(positionIds);
        return appfilePostions;
    }

    public static void sendUrgeAppAnswerMaile(List<IntvUrgeAppAnswerEntity> intvUrgeAppAnswers) {
        IntvMailUrgedHelper.getInstance().processCandidateReply(intvUrgeAppAnswers);
    }

    public static void updateUrgeTime(String upField, List<Long> urgeAppfileTaskIds, Date date) {
        DynamicObject[] appfileTasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks(urgeAppfileTaskIds);
        for (int i = 0; i < appfileTasks.length; ++i) {
            appfileTasks[i].set(upField, (Object)date);
        }
        IntvAppfileTaskHelper.getInstance().updateTasks(appfileTasks);
    }

    public static IntvUrgeAppAnswerEntity getIntvUrgeAppAnswerObj(DynamicObject appfileTask, DynamicObject[] appfilePositions) {
        IntvUrgeAppAnswerEntity intvUrgeAppAnswer = new IntvUrgeAppAnswerEntity();
        DynamicObject application = appfileTask.getDynamicObject("application");
        DynamicObject group = appfileTask.getDynamicObject("intvgroup");
        DynamicObject argIntv = appfileTask.getDynamicObject("argintv");
        DynamicObject appPosition = null;
        Long intvMethod = 0L;
        Long interviewArrangerId = 0L;
        String interviewArrangerName = "";
        String interviewArrangerContact = "";
        String interViewLocation = "";
        Long applicationId = 0L;
        String applicationName = "";
        String positionName = "";
        String intvTime = "";
        String applicationPhone = "";
        String applicationEmail = "";
        String companyName = "";
        DynamicObject argintvDb = null;
        if (null != argIntv) {
            argintvDb = ArgIntvHelper.getInstance().getIntvDataEntiry(argIntv.getLong("id"));
            interviewArrangerId = argIntv.getDynamicObject("interviewarranger").getLong("id");
            interviewArrangerName = argIntv.getDynamicObject("interviewarranger").getString("name");
            interviewArrangerContact = UserServiceHelper.getUserInfoByID((long)interviewArrangerId).get("phone").toString();
        }
        if (group != null) {
            intvTime = HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)group.getDate("intvdate")) + " " + IntvDateUtil.formatTime((Long)group.getLong("intvstarttime"), (String)"HH:mm");
            DynamicObject addressDetail = group.getDynamicObject("addressdetail");
            if (!Objects.isNull(addressDetail)) {
                if (!(addressDetail.containsProperty("country") && addressDetail.containsProperty("city") && addressDetail.containsProperty("detailaddr"))) {
                    addressDetail = HbssAddressDetailDataHelper.getInstance().loadSingle((Object)addressDetail.getLong("id"));
                }
                String country = addressDetail.getString("country.name");
                String city = addressDetail.getString("city.name");
                String detailaddr = addressDetail.getString("detailaddr.name");
                String room = group.getString("interviewroom");
                interViewLocation = IntvVariableInfoHelper.handel(country) + IntvVariableInfoHelper.handel(city) + IntvVariableInfoHelper.handel(detailaddr) + IntvVariableInfoHelper.handel(room);
            }
            if (null != argintvDb) {
                intvMethod = ((DynamicObject)argintvDb.getDynamicObjectCollection("tsirm_intvroundentry").get(0)).getDynamicObject("interviewmethod").getLong("id");
                DynamicObject interviewMethod = ((DynamicObject)argintvDb.getDynamicObjectCollection("tsirm_intvroundentry").get(0)).getDynamicObject("interviewmethod");
                long id = interviewMethod.getLong("id");
                if (id == 1040L) {
                    interViewLocation = group.getString("candatevedioaddress");
                }
            }
        }
        if (application != null) {
            applicationId = application.getLong("id");
            applicationName = application.getString("name");
            appPosition = application.getDynamicObject("position");
            applicationPhone = application.getString("phone");
            applicationEmail = application.getString("email");
        }
        if (appPosition != null) {
            positionName = appPosition.getString("name");
            companyName = IntvUrgeHelper.getCompanyName(appPosition.getLong("id"), appfilePositions);
        }
        intvUrgeAppAnswer.setAppfileTaskId(appfileTask.getString("id"));
        intvUrgeAppAnswer.setAppfileId(applicationId);
        intvUrgeAppAnswer.setAppfileName(applicationName);
        intvUrgeAppAnswer.setAppfilePhone(applicationPhone);
        intvUrgeAppAnswer.setAppfileEmail(applicationEmail);
        intvUrgeAppAnswer.setCompanyName(companyName);
        intvUrgeAppAnswer.setPositionName(positionName);
        intvUrgeAppAnswer.setIntvTime(intvTime);
        intvUrgeAppAnswer.setIntvMethod(intvMethod);
        intvUrgeAppAnswer.setIntvLocation(interViewLocation);
        intvUrgeAppAnswer.setInterviewArrangerId(interviewArrangerId);
        intvUrgeAppAnswer.setInterviewArrangerName(interviewArrangerName);
        intvUrgeAppAnswer.setInterviewArrangerContact(interviewArrangerContact);
        return intvUrgeAppAnswer;
    }

    public static String getCompanyName(Long positionId, DynamicObject[] appfilePosition) {
        String companyName = "";
        for (int i = 0; i < appfilePosition.length; ++i) {
            if (appfilePosition[i].getLong("id") != positionId.longValue() || appfilePosition[i].getDynamicObject("adminorg") == null) continue;
            Long adminOrgId = appfilePosition[i].getDynamicObject("adminorg").getLong("id");
            companyName = IntvMailCommonHelper.getCompanyName(adminOrgId);
        }
        return companyName;
    }

    public static boolean checkUrgeDayCount(String checkField, DynamicObject appfileTask) {
        boolean res = false;
        Date urgeAnswerTime = appfileTask.getDate(checkField);
        if (urgeAnswerTime == null) {
            return true;
        }
        String urgeAnswerTimes = HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)urgeAnswerTime);
        String dateNow = HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)new Date());
        if (!dateNow.equals(urgeAnswerTimes)) {
            res = true;
        }
        return res;
    }

    public static boolean checkIntvTimeEqNow(DynamicObject appfileTask) {
        boolean res = false;
        DynamicObject group = appfileTask.getDynamicObject("intvgroup");
        if (group != null) {
            Long intvStartTimeLong;
            Date intvStartTime = group.getDate("intvdate");
            boolean checktime = IntvDateUtil.intvTimeIsBeforeNow((Date)intvStartTime, (Long)(intvStartTimeLong = Long.valueOf(group.getLong("intvstarttime"))));
            res = !checktime;
        }
        return res;
    }

    public static boolean checkAppAnswerState(DynamicObject appfileTask) {
        boolean res = false;
        if ("A".equals(appfileTask.getString("applicationanswer"))) {
            res = true;
        }
        return res;
    }

    public static boolean checkAppTaskState(DynamicObject appfileTask) {
        boolean res = false;
        if ("A".equals(appfileTask.getString("taskstatus"))) {
            res = true;
        }
        return res;
    }

    public static IntvUrgeResultEntity checkUrgeNum(List<Long> appfiletaskIds, int count) {
        IntvUrgeResultEntity urgRes = new IntvUrgeResultEntity();
        if (appfiletaskIds.size() > count) {
            urgRes.setUtgeCheckRes(false);
            urgRes.showMessages.add(ResManager.loadKDString((String)"\u6761\u6570\u4e0d\u80fd\u5927\u4e8e100", (String)"IntvUrgeHelper_19", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        return urgRes;
    }
}

