/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.intv.service.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCancelHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMsgArrangementHelper;
import kd.tsc.tsirm.business.domain.intv.service.oprecord.IntvOpRecordService;
import kd.tsc.tsirm.business.domain.intv.service.task.ArgIntvFreeFlowTask;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.constants.oprecord.ORStructText;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageService;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tsrbs.common.enums.SignStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class IntvDetailUtil {
    private static final Log log = LogFactory.getLog(IntvDetailUtil.class);
    public static final IntvMailCancelHelper MAIL_HELPER = IntvMailCancelHelper.getInstance();
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"IntvDetailUtil", (int)5, (int)1000);

    public static Object updateSignInStatus(DynamicObject appFileTask, String signInStatus) {
        if (IntvDetailUtil.isValidate(appFileTask, signInStatus).booleanValue()) {
            return null;
        }
        appFileTask.set("signinstatus", (Object)signInStatus);
        String status = "";
        status = HRStringUtils.equals((String)signInStatus, (String)"A") ? SignStatusEnum.UN_SIGN.getValue() : (HRStringUtils.equals((String)signInStatus, (String)"B") ? SignStatusEnum.SIGN_COMPLETE.getValue() : SignStatusEnum.UN_READY.getValue());
        DynamicObject appFile = appFileTask.getDynamicObject("application");
        String interviewtitle = appFileTask.getDynamicObject("argintv").getString("interviewtitle");
        IntvOpRecordService.getInstance().modifyCommonOR(appFile, status, OpDefEnum.TSIRM_SIGN_IN_INTV, ORStructText.MODIFY_SIGN_IN_INTV, interviewtitle);
        return TsrbsHelper.update(appFileTask, "tsirm_appfiletask");
    }

    public static Object updateReplyStatus(DynamicObject appFileTask, String applyStatus) {
        if (IntvDetailUtil.isValidate(appFileTask, applyStatus).booleanValue()) {
            return null;
        }
        appFileTask.set("applicationanswer", (Object)applyStatus);
        appFileTask.set("recrursn", null);
        appFileTask.set("refusalcause", null);
        String status = "";
        status = HRStringUtils.equals((String)applyStatus, (String)"A") ? ResManager.loadKDString((String)"\u672a\u7b54\u590d", (String)"IntvDetailUtil_3", (String)"tsc-tsirm-business", (Object[])new Object[0]) : (HRStringUtils.equals((String)applyStatus, (String)"B") ? ResManager.loadKDString((String)"\u53c2\u52a0", (String)"IntvDetailUtil_4", (String)"tsc-tsirm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u53c2\u52a0", (String)"IntvDetailUtil_5", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        DynamicObject appFile = appFileTask.getDynamicObject("application");
        String interviewtitle = appFileTask.getDynamicObject("argintv").getString("interviewtitle");
        IntvOpRecordService.getInstance().modifyCommonOR(appFile, status, OpDefEnum.TSIRM_REPLY_INTV, ORStructText.MODIFY_REPLY_INTV, interviewtitle);
        return TsrbsHelper.update(appFileTask, "tsirm_appfiletask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTotalResult(DynamicObject appFileTask, String totalResult) {
        if (IntvDetailUtil.isValidate(appFileTask, totalResult).booleanValue()) {
            log.info("IntvDetailUtil.updateTotalResult.appFileTask.id -> {}, totalResult -> {}", (Object)appFileTask.getLong("id"), (Object)totalResult);
            return;
        }
        TXHandle txHandle = null;
        try {
            txHandle = TX.required((String)"tsirm_total_result");
            appFileTask.set("intvevlstatus", (Object)totalResult);
            IntvDetailUtil.updateAppFileTask(Collections.singletonList(appFileTask), "C");
            log.info("IntvDetailUtil.updateTotalResult.appFileTask.taskStatus -> {}, totalResult -> {}", (Object)appFileTask.getString("taskstatus"), (Object)totalResult);
            List<DynamicObject> intvEvlList = IntvDetailUtil.getIntvEvlListByAppFileTask(appFileTask);
            if (CollectionUtils.isEmpty(intvEvlList)) {
                log.warn("IntvDetailUtil.updateTotalResult.intvEvlList is empty");
                throw new RuntimeException("intvEvlList is empty!");
            }
            IntvDetailUtil.updateIntvEvl(intvEvlList, "B");
            String status = "";
            status = HRStringUtils.equals((String)totalResult, (String)"A") ? ResManager.loadKDString((String)"\u901a\u8fc7", (String)"IntvDetailUtil_6", (String)"tsc-tsirm-business", (Object[])new Object[0]) : (HRStringUtils.equals((String)totalResult, (String)"B") ? ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"IntvDetailUtil_7", (String)"tsc-tsirm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f85\u5b9a", (String)"IntvDetailUtil_8", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            DynamicObject appFile = appFileTask.getDynamicObject("application");
            String interviewtitle = appFileTask.getDynamicObject("argintv").getString("interviewtitle");
            IntvOpRecordService.getInstance().modifyCommonOR(appFile, status, OpDefEnum.TSIRM_GENERAL_EVA_INTV, ORStructText.GENERAL_EVA_INTV, interviewtitle);
            QFilter qFilter = new QFilter("argintv.id", "=", (Object)appFileTask.getLong("argintv.id"));
            List<DynamicObject> appFileTaskList = TsrbsHelper.selectByFilter("id, taskstatus", qFilter.toArray(), "tsirm_appfiletask");
            if (appFileTaskList.stream().noneMatch(IntvDetailUtil::isUnFinishTask)) {
                DynamicObject argIntv = TsrbsHelper.selectById(appFileTask.getLong("argintv.id"), "tsirm_argintv");
                log.info("IntvDetailUtil.updateTotalResult.argIntv.id -> {}", (Object)argIntv.getLong("id"));
                List<DynamicObject> intvTaskList = TsrbsHelper.selectByFilter("id, taskstatus", qFilter.toArray(), "tsirm_intvtask");
                log.info("IntvDetailUtil.updateTotalResult.intvTaskList.size -> {}", (Object)intvTaskList.size());
                IntvDetailUtil.updateIntvTask(intvTaskList, "B");
                DynamicObjectCollection collection = new DynamicObjectCollection();
                collection.addAll(intvTaskList);
                threadPool.execute(() -> ArgIntvFreeFlowTask.abandon(collection));
            }
        }
        catch (Exception e) {
            log.error("update totalResult error -> ", (Throwable)e);
            Optional.ofNullable(txHandle).ifPresent(TXHandle::markRollback);
        }
        finally {
            Optional.ofNullable(txHandle).ifPresent(TXHandle::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean cancelIntv(List<DynamicObject> argIntvList, List<DynamicObject> appFileTaskList, Boolean isAppFile) {
        if (Objects.isNull(isAppFile)) {
            return Boolean.FALSE;
        }
        TXHandle txHandle = null;
        try {
            txHandle = TX.required((String)"cancelIntv");
            if (isAppFile.booleanValue()) {
                Optional.ofNullable(appFileTaskList).ifPresent(IntvDetailUtil::cancelSingleIntv);
            } else {
                Optional.ofNullable(argIntvList).ifPresent(IntvDetailUtil::cancelTotalIntv);
            }
        }
        catch (Throwable e) {
            log.error("cancelIntv error info is -> ", e);
            Optional.ofNullable(txHandle).ifPresent(TXHandle::markRollback);
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            Optional.ofNullable(txHandle).ifPresent(TXHandle::close);
        }
        ThreadPools.executeOnce((String)"cancelIntvOR", () -> {
            if (CollectionUtils.isEmpty((Collection)appFileTaskList)) {
                return;
            }
            IntvOpRecordService.getInstance().cancelIntvOR(appFileTaskList, OpDefEnum.TSIRM_CANCEL_INTV, ORStructText.CANCEL_INTV);
        });
        return Boolean.TRUE;
    }

    private static void cancelTotalIntv(List<DynamicObject> argIntvList) {
        ArgIntvHelper argIntvHelper = new ArgIntvHelper();
        argIntvHelper.setCancelStatus(argIntvList);
    }

    private static void cancelSingleIntv(List<DynamicObject> appFileTaskList) {
        if (CollectionUtils.isEmpty(appFileTaskList)) {
            throw new RuntimeException("cancel single interview appFileTaskList is null!");
        }
        List<Long> argIntvIdList = IntvDetailUtil.getDistinctArgIntvIdList(appFileTaskList);
        IntvDetailUtil.updateAppFileTask(appFileTaskList, "B");
        List<DynamicObject> argIntvList = TsrbsHelper.selectByIdList(argIntvIdList, "tsirm_argintv");
        if (CollectionUtils.isEmpty(argIntvList)) {
            throw new RuntimeException("cancel single interview argIntvList is empty!");
        }
        QFilter argIntvIdFilter = new QFilter("argintv.id", "in", argIntvIdList);
        List<DynamicObject> intvEvlList = IntvDetailUtil.getIntvEvlList(argIntvIdFilter, appFileTaskList);
        if (IntvDetailUtil.isAlreadyEvlExists(intvEvlList)) {
            throw new RuntimeException("cancel single interview already evaluation exists!");
        }
        List<DynamicObject> allAppFileTaskList = TsrbsHelper.selectByFilter("taskstatus", argIntvIdFilter.toArray(), "tsirm_appfiletask");
        List<DynamicObject> intvTaskList = TsrbsHelper.selectByFilter(argIntvIdFilter.toArray(), "tsirm_intvtask");
        IntvDetailUtil.updateIntvEvl(intvEvlList, "C");
        if (!IntvDetailUtil.isNotCancelStatusExists(allAppFileTaskList)) {
            ArgIntvHelper.INTV_THREAD_POOL.execute(() -> {
                IntvDetailUtil.updateIntvTask(intvTaskList, "C");
                IntvDetailUtil.updateArgIntv(argIntvList, "C");
                IntvDetailUtil.sendMessage(argIntvList, Lists.newArrayListWithCapacity((int)1), Boolean.FALSE);
            });
        } else {
            Map<Long, List<DynamicObject>> allAppFileTaskMap = allAppFileTaskList.stream().collect(Collectors.groupingBy(allAppFileTask -> allAppFileTask.getLong("intvgroup.id")));
            allAppFileTaskMap.forEach((intvGroupId, groupAppFileTaskList) -> ArgIntvHelper.INTV_THREAD_POOL.execute(() -> IntvDetailUtil.handle(intvGroupId, groupAppFileTaskList, intvTaskList, appFileTaskList)));
        }
    }

    public static void sendMessage(List<DynamicObject> argIntvList, List<DynamicObject> appFileList, Boolean isSingle) {
        if (isSingle.booleanValue()) {
            DynamicObject[] interviews;
            if (CollectionUtils.isEmpty(appFileList)) {
                return;
            }
            HashMap map = new HashMap(16);
            List<Long> argIntvIds = appFileList.stream().map(appFile -> appFile.getLong("argintv.id")).collect(Collectors.toList());
            for (DynamicObject dataEntity : interviews = ArgIntvHelper.getInterviews(argIntvIds)) {
                CfgMessageService.sendMessage(IntvMsgArrangementHelper.cancel(dataEntity, false, Lists.newArrayListWithCapacity((int)10)));
            }
        } else {
            if (CollectionUtils.isEmpty(argIntvList)) {
                return;
            }
            for (DynamicObject dataEntity : argIntvList) {
                Map<String, List<Map<String, Object>>> messageParamMap = IntvMsgArrangementHelper.cancel(dataEntity, false, Lists.newArrayListWithCapacity((int)10));
                CfgMessageService.sendMessage(messageParamMap);
                IntvDetailUtil.sendNotice(messageParamMap);
            }
        }
    }

    public static void sendNotice(Map<String, List<Map<String, Object>>> messageParamMap) {
        if (messageParamMap == null || messageParamMap.size() == 0) {
            return;
        }
        List<Map<String, Object>> interviewerList = messageParamMap.get(CfgMsgRecvType.INTERVIEWER.getBaseDataId());
        List<Map<String, Object>> candidateList = messageParamMap.get(CfgMsgRecvType.CANDIDATE.getBaseDataId());
        ArrayList candidateNameList = new ArrayList();
        Optional.ofNullable(candidateList).ifPresent(candidates -> candidates.forEach(candidate -> {
            Object candidateName = candidate.get("interviewcandiname");
            if (null == candidateName) {
                return;
            }
            candidateNameList.add(candidateName.toString());
        }));
        String title = ResManager.loadKDString((String)"\u53d6\u6d88\u9762\u8bd5\u901a\u77e5", (String)"IntvDetailUtil_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String tag = ResManager.loadKDString((String)"\u5185\u90e8\u62db\u8058", (String)"IntvDetailUtil_2", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        Optional.ofNullable(interviewerList).ifPresent(interviewers -> interviewers.forEach(interviewer -> {
            boolean ccFlag = false;
            if (interviewer.get("ccFlag") instanceof Boolean) {
                ccFlag = (Boolean)interviewer.get("ccFlag");
            }
            if (ccFlag) {
                return;
            }
            Object interviewerNameObj = interviewer.get("interviewername");
            Object interviewTimeObj = interviewer.get("interviewtime");
            Object interviewPositionNameObj = interviewer.get("interviewpositionname");
            Object interviewArrangePersonNameObj = interviewer.get("interviewarrangeperson");
            Object interviewArrangePersonPhoneObj = interviewer.get("interviewarrangephone");
            Object interviewerId = interviewer.get("interviewerId");
            ArrayList<Long> interviewIdList = new ArrayList<Long>();
            interviewIdList.add(Long.parseLong(interviewerId.toString()));
            String interviewerName = interviewerNameObj == null ? "" : interviewerNameObj.toString();
            String interviewTime = interviewTimeObj == null ? "" : interviewTimeObj.toString();
            String interviewPositionName = interviewPositionNameObj == null ? "" : interviewPositionNameObj.toString();
            String interviewArrangePersonName = interviewArrangePersonNameObj == null ? "" : interviewArrangePersonNameObj.toString();
            String interviewArrangePersonPhone = interviewArrangePersonPhoneObj == null ? "" : interviewArrangePersonPhoneObj.toString();
            String content = ResManager.loadKDString((String)"{0}\u60a8\u597d\uff0c \u5341\u5206\u62b1\u6b49\u7684\u901a\u77e5\u60a8\u539f\u5b9a\u4e8e{1}{2}\u7684 {3} \u7684\u9762\u8bd5\u5df2\u53d6\u6d88\uff0c\u611f\u8c22\u60a8\u7684\u5173\u6ce8\u3002\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb{4}\uff1a{5}", (String)"IntvDetailUtil_0", (String)"tsc-tsirm-business", (Object[])new Object[]{interviewerName, interviewTime, String.join((CharSequence)",", candidateNameList), interviewPositionName, interviewArrangePersonName, interviewArrangePersonPhone});
            IntvDetailUtil.sendMessage(title, content, interviewIdList, tag);
        }));
    }

    private static void sendMessage(String title, String content, List<Long> userIds, String tag) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setTitle(title);
        messageInfo.setContent(content);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        messageInfo.setSendTime(new Date());
        messageInfo.setTag(tag);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private static void handle(Long intvGroupId, List<DynamicObject> groupAppFileTaskList, List<DynamicObject> intvTaskList, List<DynamicObject> appFileTaskList) {
        if (Objects.isNull(intvGroupId) || CollectionUtils.isEmpty(groupAppFileTaskList) || CollectionUtils.isEmpty(intvTaskList) || CollectionUtils.isEmpty(appFileTaskList)) {
            return;
        }
        if (IntvDetailUtil.isNotCancelGroup(intvGroupId, appFileTaskList)) {
            return;
        }
        List<DynamicObject> groupIntvTaskList = intvTaskList.stream().filter(intvTask -> intvGroupId.equals(intvTask.getLong("intvgroup.id"))).collect(Collectors.toList());
        if (!IntvDetailUtil.isNotCancelStatusExists(groupAppFileTaskList)) {
            IntvDetailUtil.updateIntvTask(groupIntvTaskList, "C");
        } else if (!IntvDetailUtil.isProcessingStatusExists(groupAppFileTaskList)) {
            IntvDetailUtil.updateIntvTask(groupIntvTaskList, "B");
        }
        IntvDetailUtil.sendMessage(null, appFileTaskList, Boolean.TRUE);
    }

    private static Boolean isValidate(DynamicObject appFileTask, String validateStr) {
        return Objects.isNull(appFileTask) || StringUtils.isEmpty((CharSequence)validateStr) || !"A".equals(appFileTask.getString("taskstatus"));
    }

    private static List<DynamicObject> getIntvEvlListByAppFileTask(DynamicObject appFileTask) {
        QFilter qFilter = new QFilter("appfiletask", "=", (Object)appFileTask.getLong("id")).and("enable", "=", (Object)"1");
        return TsrbsHelper.selectByFilter(qFilter.toArray(), "tsirm_intvevl");
    }

    private static List<DynamicObject> getIntvEvlList(QFilter intvIdFilter, List<DynamicObject> appFileTaskList) {
        List<Long> appIdList = IntvDetailUtil.getAppIdListByAppFileTaskList(appFileTaskList);
        QFilter appIdFilter = intvIdFilter.and(new QFilter("application.id", "in", appIdList));
        return TsrbsHelper.selectByFilter(appIdFilter.toArray(), "tsirm_intvevl");
    }

    private static List<Long> getAppIdListByAppFileTaskList(List<DynamicObject> appFileTaskList) {
        return appFileTaskList.stream().map(appFileTask -> appFileTask.getLong("application.id")).collect(Collectors.toList());
    }

    private static List<Long> getDistinctArgIntvIdList(List<DynamicObject> appFileTaskList) {
        return appFileTaskList.stream().map(argAppFile -> argAppFile.getLong("argintv.id")).distinct().collect(Collectors.toList());
    }

    private static boolean isNotCancelGroup(Long intvGroupId, List<DynamicObject> appFileTaskList) {
        return appFileTaskList.stream().anyMatch(appFileTask -> !intvGroupId.equals(appFileTask.getLong("intvgroup.id")));
    }

    private static boolean isNotCancelStatusExists(List<DynamicObject> allAppFileTaskList) {
        return allAppFileTaskList.stream().anyMatch(appFileTask -> !"B".equals(appFileTask.getString("taskstatus")));
    }

    private static boolean isAlreadyEvlExists(List<DynamicObject> evlList) {
        return evlList.stream().anyMatch(evl -> !"A".equals(evl.getString("handlestatus")) && !"A".equals(evl.getString("interviewstatus")));
    }

    private static boolean isProcessingStatusExists(List<DynamicObject> appFileTaskList) {
        return appFileTaskList.stream().anyMatch(appFileTask -> "A".equals(appFileTask.getString("taskstatus")));
    }

    private static boolean isUnFinishTask(DynamicObject appFileTask) {
        return "A".equals(StringUtils.isEmpty((CharSequence)appFileTask.getString("taskstatus")) ? "A" : appFileTask.getString("taskstatus"));
    }

    private static void updateAppFileTask(List<DynamicObject> appFileTaskList, String taskStatus) {
        List<DynamicObject> updateAppFileTaskList = appFileTaskList.stream().map(appFileTask -> IntvDetailUtil.setAppFileTaskStatus(appFileTask, taskStatus)).collect(Collectors.toList());
        IntvAppfileTaskHelper.getInstance().updateAppfileTaskAndAppfile(updateAppFileTaskList.toArray(new DynamicObject[0]));
    }

    private static void updateArgIntv(List<DynamicObject> argIntvList, String status) {
        List<DynamicObject> updateArgIntvList = argIntvList.stream().map(argIntv -> IntvDetailUtil.setIntvStatus(argIntv, status)).collect(Collectors.toList());
        TsrbsHelper.update(updateArgIntvList.toArray(new DynamicObject[0]), "tsirm_argintv");
    }

    public static void updateIntvEvl(List<DynamicObject> intvEvlList, String status) {
        List<DynamicObject> updateIntvEvlList = intvEvlList.stream().map(intvEvl -> IntvDetailUtil.setIntvEvlStatus(intvEvl, status)).collect(Collectors.toList());
        TsrbsHelper.update(updateIntvEvlList.toArray(new DynamicObject[0]), "tsirm_intvevl");
    }

    private static void updateIntvTask(List<DynamicObject> intvTaskList, String status) {
        List<DynamicObject> updateIntvTaskList = intvTaskList.stream().map(intvTask -> IntvDetailUtil.setIntvTaskStatus(intvTask, status)).collect(Collectors.toList());
        TsrbsHelper.update(updateIntvTaskList.toArray(new DynamicObject[0]), "tsirm_intvtask");
    }

    private static DynamicObject setIntvTaskStatus(DynamicObject intvTask, String status) {
        intvTask.set("taskstatus", (Object)status);
        return intvTask;
    }

    private static DynamicObject setIntvStatus(DynamicObject argIntv, String status) {
        argIntv.set("interviewstatus", (Object)status);
        return argIntv;
    }

    private static DynamicObject setIntvEvlStatus(DynamicObject intvEvl, String status) {
        intvEvl.set("handlestatus", (Object)status);
        return intvEvl;
    }

    private static DynamicObject setAppFileTaskStatus(DynamicObject appFileTask, String taskStatus) {
        appFileTask.set("taskstatus", (Object)taskStatus);
        return appFileTask;
    }
}

