/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.lock.service;

import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.lock.entity.LockInfo;

public class LockService {
    private static final DistributeSessionlessCache FLOWLOCK_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("tsc_region");
    private String CACHE_KEY_FIX;
    private int OUT_SECONDS = 600;

    public LockService(String cacheKeyFix) {
        this.CACHE_KEY_FIX = cacheKeyFix;
    }

    private LockService() {
    }

    public boolean getLock(Long objId, String operateKey) {
        String key = this.genCacheKey(objId, operateKey);
        LockInfo lockInfo = this.getLockVal(objId, operateKey);
        if (lockInfo == null) {
            FLOWLOCK_CACHE.put(key, (Object)this.genCacheVal(), this.OUT_SECONDS);
            return true;
        }
        String globalSessionId = lockInfo.getGlobalSessionId();
        if (HRStringUtils.equals((String)globalSessionId, (String)RequestContext.get().getGlobalSessionId())) {
            FLOWLOCK_CACHE.remove(this.genCacheKey(objId, operateKey));
            FLOWLOCK_CACHE.put(this.genCacheKey(objId, operateKey), (Object)this.genCacheVal(), this.OUT_SECONDS);
            return true;
        }
        Date invalidTime = lockInfo.getInvalidTime();
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (now.after(invalidTime)) {
            FLOWLOCK_CACHE.remove(this.genCacheKey(objId, operateKey));
            FLOWLOCK_CACHE.put(this.genCacheKey(objId, operateKey), (Object)this.genCacheVal(), this.OUT_SECONDS);
            return true;
        }
        return false;
    }

    public void releaseLock(Long objId, String operateKey) {
        FLOWLOCK_CACHE.remove(this.genCacheKey(objId, operateKey));
    }

    private String genCacheKey(Long positionId, String operateKey) {
        return this.CACHE_KEY_FIX + positionId + operateKey;
    }

    private LockInfo getLockVal(Long objId, String operateKey) {
        String key = this.genCacheKey(objId, operateKey);
        String val = (String)FLOWLOCK_CACHE.get(key);
        if (HRStringUtils.isEmpty((String)val)) {
            return null;
        }
        return (LockInfo)JSON.parseObject((String)val, LockInfo.class);
    }

    private String genCacheVal() {
        LockInfo lockInfo = new LockInfo();
        lockInfo.setGlobalSessionId(RequestContext.get().getGlobalSessionId());
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date invalidTime = HRDateTimeUtils.addSecond((Date)now, (long)this.OUT_SECONDS);
        lockInfo.setInvalidTime(invalidTime);
        return JSON.toJSONString((Object)lockInfo);
    }
}

