/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.operate.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsrbs.business.domain.oprecord.service.OpRecordTextParser;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import org.apache.commons.beanutils.BeanUtils;

public class AppfileOpRecordService {
    private static final Log LOGGER = LogFactory.getLog(AppfileOpRecordService.class);
    private int MAX_THREADS = 2 * Runtime.getRuntime().availableProcessors() + 1;
    private ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)(this.getClass().getName() + "_threadPool"), (int)this.MAX_THREADS);
    private OpRecordTextParser parser = OpRecordTextParser.getInstance();

    public static AppfileOpRecordService getInstance() {
        return Instance.INSTANCE;
    }

    public void addResumeFilter(DynamicObject[] resumeFilterTasks, List<Long> presenteeIdList) {
        ArrayList modelList = new ArrayList();
        this.THREAD_POOL.execute(() -> {
            try {
                DynamicObject[] taskList = this.searchTaskByIds(resumeFilterTasks);
                Map<Long, DynamicObject> candidateMap = ResumeFilterHelper.getInstance().getCandidateMap(taskList);
                HashSet<Long> appfileSet = new HashSet<Long>();
                for (DynamicObject resumeFilterTask : taskList) {
                    DynamicObject appfile = resumeFilterTask.getDynamicObject("appfile");
                    Long appfileId = appfile.getLong("id");
                    if (appfileSet.contains(appfileId)) continue;
                    appfileSet.add(appfileId);
                    DynamicObject candidate = candidateMap.get(resumeFilterTask.getLong("candidate"));
                    String candidateName = candidate.getString("fullname");
                    OprecordMessageModel message = this.genAppFileDataForMsg(ResManager.loadKDString((String)"\u62db\u8058\u4e13\u5458", (String)"AppfileOpRecordService_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), OpDefEnum.TSIRM_RESUME_FILTER, appfileId, candidateName);
                    Map param = BeanUtils.describe((Object)message);
                    List users = UserServiceHelper.get((List)presenteeIdList, (String[])new String[]{"name"}, (String[])new String[]{"seq"});
                    List userNames = users.stream().map(un -> ((OrmLocaleValue)un.get("name")).getDefaultItem()).collect(Collectors.toList());
                    String nameText = String.join((CharSequence)"\uff0c", userNames);
                    param.put("presentee", nameText);
                    param.put("positionname", appfile.getString("position.name"));
                    String oprText = this.parser.parseOprText(param, OpDefEnum.TSIRM_RESUME_FILTER);
                    message.setOprtext(oprText);
                    modelList.add(message);
                }
                OprecordMQ.sendOpRecordChangeMessage((List)modelList);
            }
            catch (Exception e) {
                LOGGER.error("\u6dfb\u52a0\u63a8\u8350\u7b5b\u9009\u7684\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private DynamicObject[] searchTaskByIds(DynamicObject[] resumeFilterTasks) {
        List<Long> resumeFilterIdList = Arrays.stream(resumeFilterTasks).map(rf -> rf.getLong("id")).collect(Collectors.toList());
        DynamicObject[] taskList = ResumeFilterHelper.queryResumeFilterTasks(resumeFilterIdList, "candidate", "id", "filterhandlepeople", "appfile");
        return taskList;
    }

    private OprecordMessageModel genAppFileDataForMsg(String roleName, OpDefEnum opDefEnum, Long bizObjId, String bizObjName) {
        OprecordMessageModel message = new OprecordMessageModel();
        message.setBizentry("tsirm_appfilemdl");
        message.setOperatorrole(roleName);
        message.setOperator(Long.valueOf(RequestContext.get().getCurrUserId()));
        message.setOperatorname(RequestContext.get().getUserName());
        message.setBizobj(bizObjId.longValue());
        message.setBizobjrole("\u5019\u9009\u4eba");
        message.setBizobjname(bizObjName);
        message.setOptime(new Date());
        message.setOpnumber(opDefEnum.getCode());
        return message;
    }

    public void addResumeFilterFeedback(List<DynamicObject> resumeFilterList) {
        this.THREAD_POOL.execute(() -> {
            ArrayList<OprecordMessageModel> modelList = new ArrayList<OprecordMessageModel>();
            DynamicObject[] taskList = this.searchTaskByIds(resumeFilterList.toArray(new DynamicObject[resumeFilterList.size()]));
            Map<Long, DynamicObject> candidateMap = ResumeFilterHelper.getInstance().getCandidateMap(taskList);
            try {
                for (DynamicObject resumeFilterTask : taskList) {
                    DynamicObject appfile = resumeFilterTask.getDynamicObject("appfile");
                    Long appfileId = appfile.getLong("id");
                    DynamicObject candidate = candidateMap.get(resumeFilterTask.getLong("candidate"));
                    String candidateName = candidate.getString("fullname");
                    OprecordMessageModel message = this.genAppFileDataForMsg(ResManager.loadKDString((String)"\u9762\u8bd5\u5b98", (String)"AppfileOpRecordService_1", (String)"tsc-tsirm-business", (Object[])new Object[0]), OpDefEnum.TSIRM_RESUME_FILTER_FEEDBACK, appfileId, candidateName);
                    Map param = BeanUtils.describe((Object)message);
                    param.put("opnumber", OpDefEnum.TSIRM_RESUME_FILTER_FEEDBACK.getName());
                    param.put("positionname", appfile.getString("position.name"));
                    String oprText = this.parser.parseOprText(param, OpDefEnum.TSIRM_RESUME_FILTER_FEEDBACK);
                    message.setOprtext(oprText);
                    modelList.add(message);
                }
                OprecordMQ.sendOpRecordChangeMessage(modelList);
            }
            catch (Exception e) {
                LOGGER.error("\u6dfb\u52a0\u7b5b\u9009\u53cd\u9988\u7684\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private static class Instance {
        private static AppfileOpRecordService INSTANCE = new AppfileOpRecordService();

        private Instance() {
        }
    }
}

