/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.operationmanage;

import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageRecordServiceHelper;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageServiceHelper;
import kd.tsc.tsirm.common.enums.operationmanage.ActivationStatus;
import kd.tsc.tsirm.common.enums.operationmanage.OperatevalEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.exception.TSCBizException;

public class CreateOperationManageService {
    private static final Log LOG = LogFactory.getLog(CreateOperationManageService.class);
    private static final OperationManageRecordServiceHelper MANAGE_RECORD_SERVICE_HELPER = OperationManageRecordServiceHelper.Singleton.INSTANCE.getInstance();
    private static final OperationManageServiceHelper MANAGE_SERVICE_HELPER = OperationManageServiceHelper.Singleton.INSTANCE.getInstance();

    private CreateOperationManageService() {
    }

    public DynamicObject addOperationManage(Long employeeId) {
        LOG.info("CreateOperationManageService.addOperationManage param employeeId : {}", (Object)employeeId);
        Objects.nonNull(employeeId);
        DynamicObject operationManageObj = MANAGE_SERVICE_HELPER.getDynamicObjectOneByEmployeeId(employeeId);
        if (operationManageObj != null) {
            LOG.info("CreateOperationManageService.addOperationManage has exit data employeeId : {}", (Object)employeeId);
            operationManageObj.set("lastlogintime", (Object)DateUtils.nowDateTime());
            MANAGE_SERVICE_HELPER.updateOne(operationManageObj);
            return operationManageObj;
        }
        operationManageObj = this.buillOperationMangeObj(employeeId, ActivationStatus.A);
        this.doSaveDb(operationManageObj);
        return operationManageObj;
    }

    private void doSaveDb(DynamicObject operationManageObj) {
        try (TXHandle tx = TX.required();){
            try {
                MANAGE_SERVICE_HELPER.saveOne(operationManageObj);
                DynamicObject operationmanagerdObj = this.buildOperationmanagerd(operationManageObj, ActivationStatus.A, OperatevalEnum.A);
                MANAGE_RECORD_SERVICE_HELPER.saveOne(operationmanagerdObj);
            }
            catch (Exception ex) {
                LOG.error("CreateOperationManageService.doSaveDb error ", (Throwable)ex);
                tx.markRollback();
                throw new TSCBizException((Throwable)ex);
            }
        }
    }

    public void cancelToUpdateOperationManage(Long employeeId) {
        LOG.info("CreateOperationManageService.cancelToUpdateOperationManage employeeId : {}", (Object)employeeId);
        DynamicObject operationMangeObj = MANAGE_SERVICE_HELPER.loadDynamicObject(new QFilter("employee", "=", (Object)employeeId));
        if (operationMangeObj == null) {
            return;
        }
        if (ActivationStatus.B.code.equals(operationMangeObj.getString("activationstatus"))) {
            LOG.info("CreateOperationManageService.cancelToUpdateOperationManage start");
            operationMangeObj.set("activationstatus", (Object)ActivationStatus.D.code);
            operationMangeObj.set("activationtime", (Object)DateUtils.nowDateTime());
            operationMangeObj.set("user", (Object)RequestContext.get().getCurrUserId());
            DynamicObject operationmanagerdObj = this.buildOperationmanagerd(operationMangeObj, ActivationStatus.D, OperatevalEnum.D);
            try (TXHandle tx = TX.nested();){
                try {
                    MANAGE_SERVICE_HELPER.updateOne(operationMangeObj);
                    MANAGE_RECORD_SERVICE_HELPER.saveOne(operationmanagerdObj);
                }
                catch (Exception e) {
                    LOG.error("CreateOperationManageService.cancelToUpdateOperationManage error :", (Throwable)e);
                    tx.markRollback();
                    throw new KDBizException("CreateOperationManageService.cancelToUpdateOperationManage error");
                }
            }
        }
    }

    public DynamicObject buildOperationmanagerd(DynamicObject operationManageObj, ActivationStatus activationStatus, OperatevalEnum operatevalEnum) {
        DynamicObject operationManagerdObj = BusinessDataServiceHelper.newDynamicObject((String)"tsirm_operationmanagerd");
        operationManagerdObj.set("operationmanage", operationManageObj.get("id"));
        operationManagerdObj.set("activationstatus", (Object)activationStatus.code);
        operationManagerdObj.set("user", (Object)RequestContext.get().getCurrUserId());
        operationManagerdObj.set("activationtime", (Object)DateUtils.nowDateTime());
        operationManagerdObj.set("operateval", (Object)operatevalEnum.code);
        return operationManagerdObj;
    }

    public DynamicObject buillOperationMangeObj(Long employeeId, ActivationStatus activationStatus) {
        DynamicObject operationManageObj = BusinessDataServiceHelper.newDynamicObject((String)"tsirm_operationmanage");
        operationManageObj.set("employee", (Object)employeeId);
        operationManageObj.set("activationstatus", (Object)activationStatus.code);
        operationManageObj.set("activationtime", (Object)DateUtils.nowDateTime());
        operationManageObj.set("lastlogintime", (Object)DateUtils.nowDateTime());
        operationManageObj.set("firstlogintime", (Object)DateUtils.nowDateTime());
        operationManageObj.set("user", (Object)RequestContext.get().getCurrUserId());
        return operationManageObj;
    }

    public static enum Singleton {
        INSTANCE;

        private final CreateOperationManageService instance = new CreateOperationManageService();

        public CreateOperationManageService getInstance() {
            return this.instance;
        }
    }
}

