/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.operationmanage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class SelectedEmployeeService {
    public static final String CLOSECALLBACK_ACTIONID_ADD = "addHrEmployee";

    private SelectedEmployeeService() {
    }

    public static SelectedEmployeeService getInstance() {
        return Instance.SELECTEDAPPFILE_INSTANCE;
    }

    public void initAppFileInfo(IFormView formView) {
        CardEntry cardEntry;
        List<Map<String, Object>> appFileInfos = this.getAppFileInfos(formView);
        if (appFileInfos == null || appFileInfos.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)formView.getModel();
        int showNumber = appFileInfos.size();
        if (showNumber == 1) {
            cardEntry = (CardEntry)formView.getControl("entryentity");
            cardEntry.setChildVisible(false, 0, new String[]{"deleteap"});
        } else {
            cardEntry = (CardEntry)formView.getControl("entryentity");
            cardEntry.setChildVisible(true, 0, new String[]{"deleteap"});
        }
        if (HRStringUtils.equals((String)"tsirm_selectedappfile", (String)formView.getEntityId())) {
            showNumber = 10;
        }
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("picturefield", new Object[0]);
        tableValueSetter.addField("name", new Object[0]);
        tableValueSetter.addField("id", new Object[0]);
        for (int i = 0; i < appFileInfos.size() && i < showNumber; ++i) {
            Map<String, Object> appFileInfo = appFileInfos.get(i);
            tableValueSetter.addRow(new Object[]{appFileInfo.get("headsculpture"), appFileInfo.get("name"), appFileInfo.get("id")});
        }
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        formView.updateView("entryentity");
    }

    public String getSelectedAppFileIdListStr(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String AppFileIdListStr = formView.getPageCache().get(CLOSECALLBACK_ACTIONID_ADD);
        if (HRStringUtils.isEmpty((String)AppFileIdListStr)) {
            Object customParam = formShowParameter.getCustomParam(CLOSECALLBACK_ACTIONID_ADD);
            AppFileIdListStr = Objects.isNull(customParam) ? "" : customParam.toString();
        }
        return AppFileIdListStr;
    }

    public List<Long> getSelectedAppFileIds(IFormView formView) {
        String appFileIdListStr = this.getSelectedAppFileIdListStr(formView);
        if (HRStringUtils.isEmpty((String)appFileIdListStr)) {
            return Collections.emptyList();
        }
        return SerializationUtils.fromJsonStringToList((String)appFileIdListStr, Long.class);
    }

    public List<Map<String, Object>> getAppFileInfos(IFormView formView) {
        List<Long> appFileIds = this.getSelectedAppFileIds(formView);
        HRBaseServiceHelper employeeService = new HRBaseServiceHelper("hrpi_employee");
        DynamicObject[] peoples = employeeService.query("person", new QFilter("id", "in", appFileIds).toArray());
        List peopleLists = Arrays.stream(peoples).map(people -> people.getLong("person.id")).collect(Collectors.toList());
        HRBaseServiceHelper personService = new HRBaseServiceHelper("hrpi_person");
        DynamicObject[] persons = personService.query("id,name,headsculpture", new QFilter("id", "in", peopleLists).toArray());
        ArrayList result = Lists.newArrayListWithCapacity((int)persons.length);
        for (DynamicObject people2 : peoples) {
            long employee = people2.getLong("id");
            long peopleId = people2.getLong("person.id");
            for (DynamicObject person : persons) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                long personId = person.getLong("id");
                if (peopleId != personId) continue;
                map.put("id", employee);
                String name = person.getString("name");
                map.put("name", name);
                String headSculpture = person.getString("headsculpture");
                map.put("headsculpture", headSculpture);
                result.add(map);
            }
        }
        return result;
    }

    public void deleteAppFiles(IFormView formView) {
        EntryGrid entryGrid = (EntryGrid)formView.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        Long removeAppFileId = dataEntitys[selectRows[0]].getLong("id");
        formView.getModel().deleteEntryRows("entryentity", selectRows);
        List<Long> appFileIds = this.getSelectedAppFileIds(formView);
        appFileIds.remove(removeAppFileId);
        formView.getPageCache().put(CLOSECALLBACK_ACTIONID_ADD, SerializationUtils.toJsonString(appFileIds));
        formView.setStatus(OperationStatus.EDIT);
        formView.invokeOperation("refresh");
    }

    private static class Instance {
        private static SelectedEmployeeService SELECTEDAPPFILE_INSTANCE = new SelectedEmployeeService();

        private Instance() {
        }
    }
}

