/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.operationmanage.bizperm.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tsc.tsirm.business.domain.operationmanage.CreateOperationManageService;
import kd.tsc.tsirm.business.domain.operationmanage.bizperm.IBizPermValidateService;
import kd.tsc.tsrbd.business.domain.config.service.BizConfigParamHelper;

public class BizPermValidateServiceImpl
implements IBizPermValidateService {
    private static final Log logger = LogFactory.getLog(BizPermValidateServiceImpl.class);
    Long LABREL_STATUS_PRD_ING = 1010L;

    private BizPermValidateServiceImpl() {
    }

    public static BizPermValidateServiceImpl getInstance() {
        return Instance.INSTANCE;
    }

    @Override
    public Boolean hasBizPerm(Long userId) {
        return this.hasBizPerm(userId, Boolean.FALSE);
    }

    @Override
    public Boolean hasBizPermInLaborrelTypeConf(Long userId) {
        return this.hasBizPerm(userId, Boolean.TRUE);
    }

    @Override
    public Boolean hasBizPerm(Long userId, Boolean inConf) {
        try {
            Long laborreltype;
            Long empId = this.getEmpId(userId);
            if (empId == null || empId.equals(0L)) {
                return Boolean.FALSE;
            }
            Map<String, Object> empentrel = this.getEmpentrel(empId);
            logger.info("BizPermValidateServiceImpl empentrel {}", empentrel);
            Long labrelstatusprd_id = (Long)empentrel.get("labrelstatusprd_id");
            if (!this.LABREL_STATUS_PRD_ING.equals(labrelstatusprd_id)) {
                return Boolean.FALSE;
            }
            if (inConf.booleanValue() && (laborreltype = (Long)empentrel.get("laborreltype_id")) != null) {
                List<Long> idList = this.getBizPermConf();
                if (!idList.contains(laborreltype)) {
                    return Boolean.FALSE;
                }
                CreateOperationManageService.Singleton.INSTANCE.getInstance().addOperationManage(empId);
            }
        }
        catch (Exception exception) {
            logger.error("getEmpEntrel Error");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Map<String, Object> getEmpentrel(Long empId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmpentrel", (Object[])new Object[]{empId});
    }

    private Long getEmpId(Long userId) {
        Map<String, Long> personModelIdMap = this.getPersonModelIdByUserId(userId);
        if (personModelIdMap != null && personModelIdMap.containsKey("employee")) {
            return personModelIdMap.get("employee");
        }
        return 0L;
    }

    private Map<String, Long> getPersonModelIdByUserId(Long userId) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{userId});
        if (result != null && result.get("data") != null) {
            return (Map)result.get("data");
        }
        return null;
    }

    public List<Long> getBizPermConf() {
        BizConfigParamHelper paramHelper = new BizConfigParamHelper();
        Object[] ids = (Object[])paramHelper.get("tsrbd_bizpermconfig", "laborreltypecls");
        List clsIds = Arrays.stream(ids).map(id -> Long.valueOf(id.toString())).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_laborreltype");
        QFilter qFilter = new QFilter("laborreltypecls", "in", clsIds);
        DynamicObject[] types = serviceHelper.queryOriginalArray("id", new QFilter[]{qFilter});
        return Arrays.stream(types).map(type -> type.getLong("id")).collect(Collectors.toList());
    }

    private static class Instance {
        private static BizPermValidateServiceImpl INSTANCE = new BizPermValidateServiceImpl();

        private Instance() {
        }
    }
}

