/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.factory;

import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;
import kd.tsc.tsirm.business.domain.pc.service.DefEmpCVService;
import kd.tsc.tsirm.business.domain.pc.service.IPersonInfoService;
import kd.tsc.tsirm.business.domain.pc.service.PersonInfoService;

public class PCServiceFactory {
    private static final Log logger = LogFactory.getLog(PCServiceFactory.class);
    private static final String REIGON = "PCservice";
    private static ExtensionFactory<AbstractEmpCVService> empCVServiceFactory = ExtensionFactory.getExtensionFacotry(AbstractEmpCVService.class);
    private static ExtensionFactory<IPersonInfoService> personInfoServiceFactory = ExtensionFactory.getExtensionFacotry(IPersonInfoService.class);

    public static AbstractEmpCVService getEmpCVService() {
        try {
            AbstractEmpCVService service = (AbstractEmpCVService)empCVServiceFactory.getExtension(REIGON);
            return service == null ? new DefEmpCVService() : service;
        }
        catch (Exception exception) {
            logger.error("getExtension error");
            return new DefEmpCVService();
        }
    }

    public static IPersonInfoService getPersonInfoService() {
        try {
            IPersonInfoService service = (IPersonInfoService)personInfoServiceFactory.getExtension(REIGON);
            return service == null ? new PersonInfoService() : service;
        }
        catch (Exception exception) {
            logger.error("getExtension error");
            return new PersonInfoService();
        }
    }
}

