/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.helper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.id.ID;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.tsc.common.vo.KResumeBO;
import kd.sdk.tsc.tsirm.extpoint.cv.DeliveryParam;
import kd.sdk.tsc.tsirm.extpoint.cv.EmpDeliveryTypeEnum;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.pc.helper.PersonInfoHelper;
import kd.tsc.tsirm.business.domain.pc.helper.RsmPubScopeHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.PositionMService;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import org.apache.commons.lang3.ObjectUtils;

public class AddCandidateHelper {
    public static void setRsmEntry(AppResumeBo appResumeBo, Map<String, DynamicObjectCollection> dynCollMap) {
        ImmutableSet ignoreSet = ImmutableSet.of((Object)"id", (Object)"number", (Object)"creator", (Object)"createtime", (Object)"modifytime", (Object)"modifier", (Object[])new String[0]);
        Map entryKeyMap = ResumeMetadataService.getEntryKeyMap((String)"tsirm_delivcv", (String)"tsirm_srrsm");
        for (Map.Entry<String, DynamicObjectCollection> entry : dynCollMap.entrySet()) {
            String sourceEntityKey = entry.getKey();
            DynamicObjectCollection value = entry.getValue();
            String targetEntityKey = (String)entryKeyMap.get(sourceEntityKey);
            ArrayList<DynamicObject> expList = new ArrayList<DynamicObject>();
            for (DynamicObject sourceExpDy : value) {
                DynamicObject targetExpDy = ResumeUtilsHelper.getServiceHelper(targetEntityKey).generateEmptyDynamicObject();
                expList.add(AddCandidateHelper.clone(sourceExpDy, targetExpDy, (Set<String>)ignoreSet));
                targetExpDy.set("rsm", (Object)appResumeBo.getRsm().getLong("id"));
            }
            appResumeBo.setEntry(targetEntityKey, expList);
        }
    }

    public static DynamicObject clone(DynamicObject sourceDy, DynamicObject targetDy, Set<String> ignoreSet) {
        AddCandidateHelper.setDefaultValue(targetDy);
        Set sourceDyFieldSet = sourceDy.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        Set targetDyFieldSet = targetDy.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        Sets.SetView commRsmFields = Sets.intersection(sourceDyFieldSet, targetDyFieldSet);
        for (String fieldName : commRsmFields) {
            Object obj;
            if (ignoreSet.contains(fieldName) || !ObjectUtils.isNotEmpty((Object)(obj = sourceDy.get(fieldName)))) continue;
            targetDy.set(fieldName, obj);
        }
        return targetDy;
    }

    public static AppResumeBo getAppResumeBo(DeliveryParam param, KResumeBO KResumeBO2) {
        DynamicObject rsmDy = AddCandidateHelper.getRsmDy(KResumeBO2.getData());
        DynamicObject deliveryDy = AddCandidateHelper.getDelivery(param);
        AppResumeBo appResumeBo = new AppResumeBo(rsmDy, deliveryDy);
        AddCandidateHelper.setRsmEntry(appResumeBo, KResumeBO2.getDynCollMap());
        return appResumeBo;
    }

    public static void setAppResumeBoInfo(AppResumeBo appResumeBo, DeliveryParam param) {
        DynamicObject empCVRelDy = EmpCVHelper.queryEmpCVRel("entryentity.cvid", param.getCVId());
        Long empId = empCVRelDy.getLong("empid");
        appResumeBo.setEmpId(empId);
        appResumeBo.getRsm().set("type", (Object)"A");
        HRBaseServiceHelper empCVHelper = EmpCVHelper.getServiceHelper("tsirm_empcv");
        DynamicObject empCVDy = empCVHelper.loadSingle((Object)param.getCVId());
        String rsmPubScope = empCVDy.getString("rsmpubscope");
        appResumeBo.setRsmPubScope(rsmPubScope);
        if ("A".equals(rsmPubScope)) {
            boolean isShldCtOrg = empCVDy.getBoolean("isshldctorg");
            if (isShldCtOrg) {
                appResumeBo.setCurrDepartment(PersonInfoHelper.getPersonMainOrgId());
            } else {
                appResumeBo.setCurrDepartment(Long.valueOf(0L));
            }
        } else if ("B".equals(rsmPubScope)) {
            List<DynamicObject> rsmPubScopeDyList = RsmPubScopeHelper.selectRsmPubScopeListByEmpCvId(param.getCVId());
            List adminOrgIdList = rsmPubScopeDyList.stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
            appResumeBo.setAdminOrgList(adminOrgIdList);
        }
    }

    public static DynamicObject getPosition(DeliveryParam param) {
        Long positionId = param.getPositionId();
        if (positionId == null || positionId.equals(0L)) {
            return null;
        }
        DynamicObject positionDy = PositionMService.queryOneByPositionId(positionId);
        return positionDy;
    }

    private static DynamicObject getRsmDy(DynamicObject deliveryCvDy) {
        ImmutableSet ignoreSet = ImmutableSet.of((Object)"id", (Object)"number", (Object)"creator", (Object)"createtime", (Object)"modifytime", (Object)"modifier", (Object[])new String[0]);
        DynamicObject rsmDy = ResumeUtilsHelper.getServiceHelper("tsirm_srrsm").generateEmptyDynamicObject();
        DynamicObject resultDy = AddCandidateHelper.clone(deliveryCvDy, rsmDy, (Set<String>)ignoreSet);
        resultDy.set("resumestoadd", (Object)deliveryCvDy.getString("id"));
        resultDy.set("id", (Object)ID.genLongId());
        return resultDy;
    }

    private static DynamicObject getDelivery(DeliveryParam param) {
        Long media = 1050L;
        Long appmthd = 0L;
        Long resacqMthd = 1050L;
        Long recruchnlnm = 1160L;
        Long positionId = param.getPositionId();
        Long advertId = param.getAdvertId();
        DynamicObject deliveryDy = null;
        EmpDeliveryTypeEnum deliveryType = param.getDeliveryType();
        if ("A".equals(deliveryType.getDelivType())) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_advertpublish");
            DynamicObject advertDy = serviceHelper.loadSingle((Object)advertId);
            DynamicObject channel = advertDy.getDynamicObject("channel");
            if (channel != null) {
                recruchnlnm = channel.getLong("id");
                resacqMthd = channel.getLong("resacqmthd.id");
            }
            appmthd = 1010L;
        } else {
            appmthd = "D".equals(deliveryType.getDelivType()) ? Long.valueOf(1010L) : Long.valueOf(1055L);
        }
        deliveryDy = AddResumeService.generateDeliveryDt(media, appmthd, resacqMthd, recruchnlnm);
        deliveryDy.set("position", (Object)positionId);
        return deliveryDy;
    }

    private static void setDefaultValue(DynamicObject dy) {
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String className;
            Object obj = dy.get(property.getName());
            if (!Objects.isNull(obj)) continue;
            switch (className = property.getPropertyType().getSimpleName()) {
                case "String": {
                    dy.set(property.getName(), (Object)"");
                    break;
                }
                case "DynamicObject": 
                case "Long": {
                    dy.set(property.getName(), (Object)0L);
                    break;
                }
                case "Integer": {
                    dy.set(property.getName(), (Object)0);
                    break;
                }
            }
        }
    }
}

